#ifndef _XMLCONF_H
#define _XMLCONF_H

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

typedef struct _langim
{
    char *lang;
    char *path;
    struct _imnodes *first;
    struct _imnodes *last;
} langim;

typedef struct _imnodes
{
    char *id;
    char *name;
    char *file;
    int n_preedit;
    struct _langim *parent;
    struct _imnodes *next;
} imnodes;

void debugPrintLangIM (langim *);
void parseIMSingle (xmlDocPtr, xmlNodePtr, langim *);
void parseIMs (xmlDocPtr, xmlNodePtr, langim *);
imnodes* fetchIMpos (langim *, int);
void parseConf (langim *);
void freeConf(langim *);

#endif
