/*
 * Copyright (C) 1999 by   XCIN TEAM
 * Copyright (C) 2004 by   Leon Ho <llch@redhat.com>
 *                         Lawrence Lim <llim@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "xcin.h"


static unsigned int total_char;

static ccode_t charcode[WCH_SIZE];  /* charcode.c (Cinput/im_comm)*/
static byte_t highest_idx;          /* charcode.c (Cinput/im_comm)*/

void
ccode_init(charcode_t *ccp, int n)
{
    int i, j, idx;
                                    
    for (i=0; i<WCH_SIZE && i<n && ccp[i].n; i++) {
    idx = charcode[i].n = ccp[i].n;
    charcode[i].total_num = 0;        // TODO: added to fix the static charcode at line 58. do something smart later
    
    for (j=0; j<idx; j++) {
        charcode[i].begin[j] = ccp[i].begin[j];
        charcode[i].end[j] = ccp[i].end[j];
        charcode[i].num[j] = charcode[i].end[j] - charcode[i].begin[j] + 1;
        charcode[i].total_num += charcode[i].num[j];
        if (j > 0)
        charcode[i].ac_num[j] =
            charcode[i].ac_num[j-1] + charcode[i].num[j-1];
    }
    if (i == 0)
        charcode[i].base = 1;
    else
        charcode[i].base = charcode[i-1].total_num * charcode[i-1].base;
    }
    total_char = charcode[i-1].total_num * charcode[i-1].base;
    highest_idx = i - 1;
}

void ccode_info( ccode_info_t* info )
{
    int i, j;

    info->total_char = total_char;
    info->n_ch_encoding = highest_idx + 1;

    for ( i = 0; i <= highest_idx; i++ )
    {
        memset(info->ccode + i, 0, sizeof(charcode_t));
        info->ccode[i].n = charcode[i].n;

        for ( j = 0; j < charcode[i].n; j++ )
        {       
            info->ccode[i].begin[j] = charcode[i].begin[j];
            info->ccode[i].end[j] = charcode[i].end[j];
        }
    }
}


int ccode_to_char(int idx, unsigned char *mbs, int mbs_size)
{
    ccode_t *ccp = charcode + highest_idx;
    int i, j, n;
    int idx_tmp = idx;
    ubyte_t ch;
                                                                                                                            
    /*ccp->base = 2304;    HARDCODED: to be fixed in v0.2; deleted, no effect */ 
/*
printf("\n entering function\n");
printf("ccode_to_char(): total_char:<%u> \t highest_idx:<%d> \t mbs_size:<%d> \t ccp->base:<%lu> \n", total_char, highest_idx, mbs_size, ccp->base);
printf("ccode_to_char(): ccp:<%d>\n", ccp);
*/
    if (idx < 0 || idx >= total_char || highest_idx >= mbs_size)
    {
        /*printf("\n*** ccode_to_char(): die here\n\n"); */
        return 0;
    }
  
    memset(mbs, 0, mbs_size);
    for (i=highest_idx; i >= 0; i--, ccp--) 
    {
        ch = (ubyte_t)(idx_tmp / ccp->base);
        idx_tmp -= ch * ccp->base;
        n = ccp->n;
        for (j=1; j<n && ch>=ccp->ac_num[j]; j++);
            mbs[i] = ch - ccp->ac_num[j-1] + ccp->begin[j-1];
    }
    return 1;
}


void load_syscin(const char *path)
{
    FILE *fp_syscin;
    int len;
    char buf[40], truefn[256];
    char inpn_english[CIN_CNAME_LENGTH];
    char inpn_sbyte[CIN_CNAME_LENGTH];
    char inpn_2bytes[CIN_CNAME_LENGTH];
    wch_t ascii[N_ASCII_KEY];
    charcode_t ccp[WCH_SIZE];
    char filename[256];
    
    sprintf(filename, "%s/sys.tab", path);

    fp_syscin = fopen( filename, "r" );

    if (fread(buf, sizeof(char), MODULE_ID_SIZE, fp_syscin) != MODULE_ID_SIZE || strcmp(buf, "syscin"))
        printf("invalid tab file\n");
    
    len = sizeof(SYSCIN_VERSION);
    
    if (fread(buf, len, 1, fp_syscin) != 1 )
        printf("invalid sys.tab\n");

    if (fread(inpn_english, sizeof(char), CIN_CNAME_LENGTH, fp_syscin)
         != CIN_CNAME_LENGTH ||
    fread(inpn_sbyte, sizeof(char), CIN_CNAME_LENGTH, fp_syscin)
        != CIN_CNAME_LENGTH ||
    fread(inpn_2bytes, sizeof(char), CIN_CNAME_LENGTH, fp_syscin)
        != CIN_CNAME_LENGTH ||
    fread(ascii, sizeof(wch_t), N_ASCII_KEY, fp_syscin) != N_ASCII_KEY ||
    fread(ccp, sizeof(charcode_t), WCH_SIZE, fp_syscin) != WCH_SIZE)
        printf("sys.tab reading error\n");

    fclose(fp_syscin);

    ccode_init(ccp, WCH_SIZE);

}

int isBigEndian()
{
    long i = 1;
    return !(*((char *)(&i)));
}

wchar_t endianConversion(wchar_t in, int size)
{
    wchar_t out = 0;
    char *p_in = (char *) &in;
    char *p_out = (char *) &out;
    int i = 0;
    int index = size;

    if (isBigEndian()) return;

    for ( i = 0 ; i < size; i ++ )
    {
        p_out[i] = p_in[index - 1];
        index--;
    }

#ifdef DEBUG
    printf("out:<%x>", out ); 
#endif
    return out;
}

wchar_t UTF8toUnicode( wchar_t input )
{
    wchar_t fst = 0;
    wchar_t out;
    wchar_t wcout = input;
    int count;
    int i;

#ifdef DEBUG
    printf("initial wc: %x %x\n", input, wcout);
#endif

    /* shift accordingly if it is under a limit */
    if(wcout <= 0xFF)
        fst = wcout;
    else if(wcout >> 8 <= 0xFF && wcout >> 8 != 0x00){
        wcout = endianConversion (wcout, 2);
        fst = wcout >> 8;
    }
    else if (wcout >> 16 <= 0xFF && wcout >> 16 != 0x00){
        wcout = endianConversion (wcout, 3);
        fst = wcout >> 16;
    }
#ifdef LARGE_WCHAR
    else if (wcout >> 24 <= 0xFF && wcout >> 24 != 0x00){
        wcout = endianConversion (wcout, 4);
        fst = wcout >> 24;
    }
    else if (wcout >> 32 <= 0xFF && wcout >> 32 != 0x00){
        wcout = endianConversion (wcout, 5);
        fst = wcout >> 32;
    }
    else if (wcout >> 40 <= 0xFF && wcout >> 40 != 0x00){    
        wcout = endianConversion (wcout, 6);
        fst = wcout >> 40;
    }
#endif

    /* test if it is 0xxxxxxx */
    if(fst >= 0x00 && fst <= 0x7F){
        out = fst;
        count = 0;
    }
    /* test if it is 110xxxxx 10xxxxxx */
    else if (fst >= 0xC0 && fst <= 0xDF){
        out = fst & 0x1F;
        count = 1;
    }
    /* test 1110xxxx 10xxxxxx 10xxxxxx */
    else if (fst >= 0xE0 && fst <= 0xEF){
        out = fst & 0xF;
        count = 2;
    }
    /* test 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx */
    else if (fst >= 0xF0 && fst <= 0xF7){
        out = fst & 0x7;
        count = 3;
    }
    /* test 111110xx 10xxxxxx 10xxxxxx 10xxxxxx 10xxxxxx */
    else if (fst >= 0xF8 && fst <= 0xFB){
        out = fst & 0x3;
        count = 4;
    }
    /* test 1111110x 10xxxxxx 10xxxxxx 10xxxxxx 10xxxxxx 10xxxxxx */
    else if (fst >= 0xFC && fst <= 0xFD){
        out = fst & 0x1;
        count = 5;
    }
    else
        return 0;

    out = out << RESTBIT * count;


    /* finally use the count to add up all the remaining bits
       shift the bits, mask it, mask 6 bits, then shift it back */
    for(i=0; i<count; i++)
        out += (wcout >> (i*8) & 0xFF & 0x3F) << (i*6);

    if (out == 0x0) return 0;

#ifdef DEBUG
    printf("final result: %x\n", out);
#endif

    return out;
}

/*
 * Determine the lenght of UTFCHAR
 */ 
int UTFCHARLen( UTFCHAR* p )
{
    int i;

#ifdef  DEBUG
    printf("\n### UTFCHARLen( ) ###\n\n");
    printf("    p=[%d]\n", p);
#endif

    for (i = 0; *p; i++)
        p++;

#ifdef  DEBUG
    printf("    Lenght of UTFCHAR i=[%d]\n", i);
#endif
    return i;
}

int UTFCHARCpy( UTFCHAR * dest, UTFCHAR * original )
{
    int i;

#ifdef  DEBUG
    printf("\n### UTFCHARCpy( ) ###\n");
    printf("    dest=[%s]\n", dest);
    printf("    orig=[%s]\n", original);
#endif
    for (i = 0; *original; i++) 
    {
        *dest++ = *original++;
    }
    *dest = 0;
    return i;
}

int utf8_to_utf16(char *input, char *output, int n_char)
{
    const char *inptr = input;
    int i;
    size_t inbytesleft = n_char;
    size_t outbytesleft = BUFSIZE;

    char *outptr = output;

    iconv_t cd;
    cd = iconv_open("UTF-16", "UTF-8");
    i = iconv (cd, (char **)&inptr, &inbytesleft, (char **)&outptr, &outbytesleft);
    iconv_close(cd);

    if (i == -1) {
        output[0] = 0;
    } else {
            output[BUFSIZE - outbytesleft] = 0;
            output[BUFSIZE - outbytesleft +1] = 0;
    }

    if (0xFEFF == *(CARD16 *) output)
        memmove(output, output + 2, BUFSIZE - 3);

    return i;
}

