/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "support.h"
#include "iiim-properties.h"

void util_activate (GtkWidget *, gchar *);
void util_deactivate (GtkWidget *, gchar *);
GSList *util_store_to_list (GtkListStore *);
GSList *util_store_to_lang_id_list (GtkListStore *);
GSList *util_get_use_engine_list (gchar *, GSList *);

GSList *setget_get_available_engine_list (gchar *);
gchar *setget_lang_to_id (gchar *);

GSList *cf_get_supported_langs ();
GSList *cf_get_engines (gchar *);
GSList *cf_get_engine_desc_with_ui (gchar *);
GSList *sendlayout_get_use_layout_list ();

static GHashTable *default_engine_table;
static GHashTable *engine_table;

void lang_initialize (IIIMProps *iiim_props)
{
  /* engine_table needs to be initialized here */
  GSList *lp;
  GSList *availableLangs = cf_get_supported_langs ();
  iiim_props->l_language_engine = g_new0 (EngineList, 1);
  engine_table = iiim_props->l_language_engine->engine_table
    = g_hash_table_new (g_str_hash, g_str_equal);
  default_engine_table = g_hash_table_new (g_str_hash, g_str_equal);

  for (lp = availableLangs; lp; lp = g_slist_next (lp))
    {
      gchar *lang_id = (gchar *)lp->data;
      GSList *engines = cf_get_engines (lang_id);
      g_hash_table_insert (default_engine_table, lang_id, engines);
    }

  for (lp = iiim_props->l_languages->langs; lp; lp = g_slist_next (lp))
    {
      LanguageID *lid = (LanguageID *)lp->data;
      GSList *engines = lid->engines;
      if (engines != NULL)
	{
	  g_hash_table_insert (engine_table, lid->id, engines);
	}
    }
}

GtkListStore *init_get_lang_model ();

static void set_engine_info_to_langid (GSList *langs)
{
  GSList *lp;

  for (lp = langs; lp; lp = g_slist_next (lp))
    {
      LanguageID *lid = (LanguageID *)lp->data;
      GSList *engine_list = (GSList *)g_hash_table_lookup (engine_table, lid->id);
      if (engine_list == NULL)
	{
	  engine_list = (GSList *)g_hash_table_lookup (default_engine_table, lid->id);
	}
      lid->engines = engine_list;
    }
}

static gint my_strcmp (gconstpointer a, gconstpointer b)
{
  LanguageID *lid = (LanguageID *)a;
  gchar *name = (gchar *)b;
  
  return (gint)strcmp(lid->id, (const char *)b);
}

void lang_update_properties (IIIMProps *iiim_props)
{
  iiim_props->l_languages->langs = util_store_to_lang_id_list (init_get_lang_model ());
  /* engine table is already updated with GUI operation */
  set_engine_info_to_langid (iiim_props->l_languages->langs);

  /* update user defined non use list */
  {
    GSList *user_defined = sendlayout_get_use_layout_list ();
    GSList *lp, *non_use = NULL;

    for (lp = user_defined; lp; lp = g_slist_next (lp))
      {
	CustomLayout *cl = (CustomLayout *)lp->data;
	if (!g_slist_find_custom (iiim_props->l_languages->langs,
				 cl->id, my_strcmp))
	  {
	    /* this means this user defined layout was deleted from use list */
	    non_use = g_slist_append (non_use, cl->name);
	  }
      }
    g_slist_free (iiim_props->l_user_defined_non_use);
    iiim_props->l_user_defined_non_use = non_use;
  }
}

/**
 * Language / Scripts tab callbacks
 */
static GtkWidget *availableLangList;
static GtkWidget *useLangList;
static GtkWidget *availableEngineList;
static GtkWidget *useEngineList;
static gchar *current_lang_in_available_list;
static GdkPixbuf *current_icon_in_available_list;
static gchar *current_lang_in_use_list;
static GdkPixbuf *current_icon_in_use_list;
static gchar *current_engine_in_available_list;
static gchar *current_engine_in_use_list;

static gchar *get_selected_str (GtkTreeView *treeview)
{
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *lang;

  model = gtk_tree_view_get_model (treeview);
  gtk_tree_view_get_cursor (treeview, &path, &focus_column);
  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 0, &lang, -1);

  return lang;
}

static GdkPixbuf *get_selected_icon (GtkTreeView *treeview)
{
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkTreeModel *model;
  GtkTreeIter iter;
  GdkPixbuf *pixbuf;

  model = gtk_tree_view_get_model (treeview);
  gtk_tree_view_get_cursor (treeview, &path, &focus_column);
  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 1, &pixbuf, -1);

  return pixbuf;
}

void lang_available_lang_list_clicked (GtkTreeView *treeview, gpointer user_data)
{
  GtkWidget *list;
  GtkWidget *button;
  GtkTreeSelection *selection;
  gchar *new_lang;

  /* clear useLang list selection if current selected language is changed */
  if (current_lang_in_available_list) {
    g_free (current_lang_in_available_list);
  }
  current_lang_in_available_list = get_selected_str (treeview);

  if (current_icon_in_available_list) {
    g_object_unref (current_icon_in_available_list);
  }
  current_icon_in_available_list = get_selected_icon (treeview);

  list = lookup_widget (GTK_WIDGET (treeview), "useLangList");
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
  gtk_tree_selection_unselect_all (selection);

  /* button sensitivity setting */
  util_activate (GTK_WIDGET (treeview), "addLangButton");
  util_deactivate (GTK_WIDGET (treeview), "delLangButton");
  util_deactivate (GTK_WIDGET (treeview), "upLangButton");
  util_deactivate (GTK_WIDGET (treeview), "downLangButton");
}

void lang_add_lang_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreeModel *store;
  GtkTreeIter iter;
  gint lang_count;
  gboolean valid;

  if (current_lang_in_available_list == NULL) {
    return;
  }
    
  list = lookup_widget (GTK_WIDGET (button), "useLangList");
  store = gtk_tree_view_get_model (GTK_TREE_VIEW (list));

  /* check use lang list already has selected language, if not, then
   * add it to list
   */
  valid = gtk_tree_model_get_iter_first (store, &iter);
  while (valid)
    {
      gchar *l;
      gtk_tree_model_get (store, &iter, 0, &l, -1);
      if (!strcmp (l, current_lang_in_available_list))
	{
	  return;
	}
      valid = gtk_tree_model_iter_next (store, &iter);
    }
  gtk_list_store_append (GTK_LIST_STORE (store), &iter);
  gtk_list_store_set (GTK_LIST_STORE (store), &iter, 0, current_lang_in_available_list, -1);
  gtk_list_store_set (GTK_LIST_STORE (store), &iter, 1, current_icon_in_available_list, -1);

  /* remove from available list */
  list = lookup_widget (GTK_WIDGET (button), "availableLangList");
  store = gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  valid = gtk_tree_model_get_iter_first (store, &iter);
  while (valid)
    {
      gchar *l;
      gtk_tree_model_get (store, &iter, 0, &l, -1);
      if (!strcmp (l, current_lang_in_available_list))
	{
	  break;
	}
      valid = gtk_tree_model_iter_next (store, &iter);
    }
  gtk_list_store_remove (GTK_LIST_STORE (store), &iter);
}

void lang_use_lang_list_clicked (GtkTreeView *treeview, gpointer user_data)
{
  GtkWidget *list;
  GtkTreeSelection *selection;
  gboolean valid;
  guint count = 0;
  GtkWidget *button;
  GSList *engines;
  GtkListStore *store;
  GtkTreeIter iter;
  gint i, len;
  gchar *lang_id;
  GSList *use_engines;
  GSList *lp;

  if (current_lang_in_use_list) {
    g_free (current_lang_in_use_list);
  }
  current_lang_in_use_list = get_selected_str (treeview);
  if (current_icon_in_use_list) {
    g_object_unref (current_icon_in_use_list);
  }
  current_icon_in_use_list = get_selected_icon (treeview);

  lang_id = setget_lang_to_id (current_lang_in_use_list);

  /* clear availableLang list selection */
  list = lookup_widget (GTK_WIDGET (treeview), "availableLangList");
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (list));
  gtk_tree_selection_unselect_all (selection);

  /* button sensitivity setting */
  util_deactivate (GTK_WIDGET (treeview), "addLangButton");
  util_activate (GTK_WIDGET (treeview), "delLangButton");

  /* activate if plural languages are in the list */
  list = lookup_widget (GTK_WIDGET (treeview), "useLangList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  valid = gtk_tree_model_get_iter_first (GTK_TREE_MODEL (store), &iter);
  while (valid)
    {
      count++;
      valid = gtk_tree_model_iter_next (GTK_TREE_MODEL (store), &iter);
    }
  if (count > 1)
    {
      util_activate (GTK_WIDGET (treeview), "upLangButton");
      util_activate (GTK_WIDGET (treeview), "downLangButton");
    }
  else
    {
      util_deactivate (GTK_WIDGET (treeview), "upLangButton");
      util_deactivate (GTK_WIDGET (treeview), "downLangButton");
    }      
  /* set available engine list */
  list = lookup_widget (GTK_WIDGET (treeview), "availableEngineList");
  engines = setget_get_available_engine_list (lang_id);
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_list_store_clear (store);
  for (lp = engines; lp; lp = g_slist_next (lp))
    {
      EngineDesc *desc = (EngineDesc *)lp->data;
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, desc->ui, -1);
    }
  /* set use engine list */
  list = lookup_widget (GTK_WIDGET (treeview), "useEngineList");
  use_engines = util_get_use_engine_list (lang_id, engines);
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_list_store_clear (store);

  for (lp = use_engines; lp; lp = g_slist_next (lp))
    {
      EngineDesc *desc = (EngineDesc *)lp->data;
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, desc->ui, -1);
    }
  /* store engine list to engine_table so that it can be set to registry
   * later
   */
  g_hash_table_insert (engine_table, lang_id, use_engines);
}

void lang_del_lang_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;
  GdkPixbuf *pbuf;
  gchar *lang;

  list = lookup_widget (GTK_WIDGET (button), "useLangList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, 0, &lang, -1);
  gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, 1, &pbuf, -1);
  gtk_list_store_remove (store, &iter);

  /* add deleted lang to available list */
  list = lookup_widget (GTK_WIDGET (button), "availableLangList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_list_store_append (store, &iter);
  gtk_list_store_set (store, &iter, 0, lang, -1);
  g_free (lang);
  if (pbuf != NULL) {
    gtk_list_store_set (store, &iter, 1, pbuf, -1);
    g_object_unref (pbuf);
  }

  util_deactivate (GTK_WIDGET (button), "delLangButton");
  util_deactivate (GTK_WIDGET (button), "upLangButton");
  util_deactivate (GTK_WIDGET (button), "downLangButton");
}

void lang_up_lang_button_clicked (GtkButton *button, gchar *user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;

  list = lookup_widget (GTK_WIDGET (button), "useLangList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);
  gtk_tree_path_prev (path);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_insert_before (store, &iter, &iter);
  gtk_list_store_set (store, &iter, 0, current_lang_in_use_list, -1);
  gtk_list_store_set (store, &iter, 1, current_icon_in_use_list, -1);
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (list), path, focus_column, FALSE);
}

void lang_down_lang_button_clicked (GtkButton *button, gchar *user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter, *iter_p;

  list = lookup_widget (GTK_WIDGET (button), "useLangList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  /*iter_p = gtk_tree_iter_copy (&iter);*/
  iter_p = &iter;
  if (gtk_list_store_remove (store, &iter))
    {
      gtk_list_store_insert_after (store, &iter, &iter);
      gtk_list_store_set (store, &iter, 0, current_lang_in_use_list, -1);
      gtk_list_store_set (store, &iter, 1, current_icon_in_use_list, -1);
      path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), &iter);
    }
  else
    {
      gtk_list_store_append (store, iter_p);
      gtk_list_store_set (store, iter_p, 0, current_lang_in_use_list, -1);
      gtk_list_store_set (store, iter_p, 1, current_icon_in_use_list, -1);
      path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), iter_p);
    }
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (list), path, focus_column, FALSE);
}

void lang_available_engine_list_clicked (GtkTreeView *treeview, gpointer user_data)
{
  current_engine_in_available_list = get_selected_str (treeview);

  /* button sensitivity setting */
  util_activate (GTK_WIDGET (treeview), "addLEButton");
  util_deactivate (GTK_WIDGET (treeview), "delLEButton");
  util_deactivate (GTK_WIDGET (treeview), "upLEButton");
  util_deactivate (GTK_WIDGET (treeview), "downLEButton");
}

void lang_use_engine_list_clicked (GtkTreeView *treeview, gpointer user_data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *str;
  gboolean valid;

  current_engine_in_use_list = get_selected_str (treeview);
  model = gtk_tree_view_get_model (treeview);
  gtk_tree_model_get_iter_first (model, &iter);
  valid = gtk_tree_model_iter_next (model, &iter);
  if (valid)
    {
      util_activate (GTK_WIDGET (treeview), "addLEButton");
      util_activate (GTK_WIDGET (treeview), "delLEButton");
      util_activate (GTK_WIDGET (treeview), "upLEButton");
      util_activate (GTK_WIDGET (treeview), "downLEButton");
    }
  else
    {
      /* only one engine exist, so unable to remove it */
      util_deactivate (GTK_WIDGET (treeview), "addLEButton");
      util_deactivate (GTK_WIDGET (treeview), "delLEButton");
      util_deactivate (GTK_WIDGET (treeview), "upLEButton");
      util_deactivate (GTK_WIDGET (treeview), "downLEButton");
    }
  return;
}

static GSList *engine_ui_to_desc (GSList *ui_list)
{
  GSList *ret = NULL;
  GSList *lp;

  for (lp = ui_list; lp; lp = g_slist_next (lp))
    {
      gchar *ui = (gchar *)lp->data;
      ret = g_slist_append (ret, cf_get_engine_desc_with_ui (ui));
    }
  return ret;
}

void lang_add_engine_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreeModel *store;
  GtkTreeIter iter;
  gint lang_count;
  gboolean valid;
  GSList *desc_list;

  if (current_engine_in_available_list == NULL) {
    return;
  }
    
  list = lookup_widget (GTK_WIDGET (button), "useEngineList");
  store = gtk_tree_view_get_model (GTK_TREE_VIEW (list));

  /* check use engine list already has selected engine, if not, then
   * add it to list
   */
  valid = gtk_tree_model_get_iter_first (store, &iter);
  while (valid)
    {
      gchar *l;
      gtk_tree_model_get (store, &iter, 0, &l, -1);
      if (!strcmp (l, current_engine_in_available_list))
	{
	  return;
	}
      valid = gtk_tree_model_iter_next (store, &iter);
    }
  gtk_list_store_append (GTK_LIST_STORE (store), &iter);
  gtk_list_store_set (GTK_LIST_STORE (store), &iter, 0, current_engine_in_available_list, -1);

  /* store engine list to engine_table so that it can be set to registry
   * later
   */
  desc_list = engine_ui_to_desc (util_store_to_list (GTK_LIST_STORE (store)));
  g_hash_table_insert (engine_table,
		       setget_lang_to_id (current_lang_in_use_list),
		       desc_list);
}

void lang_del_engine_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;
  GSList *desc_list;

  list = lookup_widget (GTK_WIDGET (button), "useEngineList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);

  util_deactivate (GTK_WIDGET (button), "delLEButton");
  util_deactivate (GTK_WIDGET (button), "upLEButton");
  util_deactivate (GTK_WIDGET (button), "downLEButton");

  /* store engine list to engine_table so that it can be set to registry
   * later
   */
  desc_list = engine_ui_to_desc (util_store_to_list (store));
  g_hash_table_insert (engine_table,
		       setget_lang_to_id (current_lang_in_use_list),
		       desc_list);
}

void lang_up_engine_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter;
  GSList *desc_list;

  list = lookup_widget (GTK_WIDGET (button), "useEngineList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_remove (store, &iter);
  gtk_tree_path_prev (path);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_list_store_insert_before (store, &iter, &iter);
  gtk_list_store_set (store, &iter, 0, current_engine_in_use_list, -1);
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (list), path, focus_column, FALSE);
  
  /* store engine list to engine_table so that it can be set to registry
   * later
   */
  desc_list = engine_ui_to_desc (util_store_to_list (store));
  g_hash_table_insert (engine_table,
		       setget_lang_to_id (current_lang_in_use_list),
		       desc_list);
}

void lang_down_engine_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *list;
  GtkTreePath *path;
  GtkTreeViewColumn *focus_column;
  GtkListStore *store;
  GtkTreeIter iter, *iter_p;
  GSList *desc_list;

  list = lookup_widget (GTK_WIDGET (button), "useEngineList");
  store = (GtkListStore *)gtk_tree_view_get_model (GTK_TREE_VIEW (list));
  gtk_tree_view_get_cursor (GTK_TREE_VIEW (list), &path, &focus_column);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  iter_p = gtk_tree_iter_copy (&iter);
  if (gtk_list_store_remove (store, &iter))
    {
      gtk_list_store_insert_after (store, &iter, &iter);
      gtk_list_store_set (store, &iter, 0, current_engine_in_use_list, -1);
      path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), &iter);
    }
  else
    {
      gtk_list_store_append (store, iter_p);
      gtk_list_store_set (store, iter_p, 0, current_engine_in_use_list, -1);
      path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), iter_p);
    }
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (list), path, focus_column, FALSE);
  gtk_tree_iter_free (iter_p);

  /* store engine list to engine_table so that it can be set to registry
   * later
   */
  desc_list = engine_ui_to_desc (util_store_to_list (store));
  g_hash_table_insert (engine_table,
		       setget_lang_to_id (current_lang_in_use_list),
		       desc_list);
}


