/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>

#include "kbltrans.h"
#include "support.h"
#include "iiim-properties.h"
#include "iiim-properties-trigger.h"

#define KBD_ICON_FILE "iiim-properties-kbd.png"
GdkPixbuf *kbd_icon;

GSList *setget_get_available_lang_list ();
GSList *setget_get_user_defined_kbl_list ();
GSList *setget_and_list_of_lang (GSList *, GSList *);
void util_activate (GtkWidget *, gchar *);
void util_deactivate (GtkWidget *, gchar *);
gboolean cf_initialize (Display *);
void general_initialize (IIIMProps *);
void lang_initialize (IIIMProps *);
void trigger_initialize (GtkWidget *, IIIMProps *);
void keyboard_initialize (GtkWidget *, IIIMProps *);
void misc_initialize (GtkWidget *, IIIMProps *);
void exec_initialize ();
void hkc_initialize ();
void util_set_iiimprops (IIIMProps *);
void setget_fetch_gconf_settings (IIIMProps *);
void setget_set_no_cf ();

static GtkListStore *lang_list_store;
static GtkListStore *lang_use_list_store;
static GtkListStore *engine_list_store;
static GtkListStore *engine_use_list_store;

static GtkListStore *trigger_list_store;
static GtkListStore *langlist_hotkey_list_store;
static GtkListStore *cycle_lang_hotkey_list_store;
static GtkListStore *reverse_cycle_lang_hotkey_list_store;
static GtkListStore *keyboard_layout_list_store;

/*
 * get use language list's model
 */
GtkListStore *init_get_lang_model ()
{
  return lang_use_list_store;
}

static gint p_strcmp (gconstpointer a, gconstpointer b)
{
  return strcmp (a, b);
}

/*
 * called from init_gui (update gui controls with given properties)
 */
static void update_gui (GtkWidget *dialog, IIIMProps *params)
{
#include "widget-list.h"

  GSList *lang_ui_list, *use_lang_ui_list, *use_langs, *user_kbl_list;
  GtkTreeIter iter;
  gint i, len;
  gchar *lang;
  gchar *trigger_keys;
  GSList *lp;
  gboolean add_lang;

  /* InputMethod enable/disable */
  enableCheckBox = lookup_widget (dialog, "enableCheckBox");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (enableCheckBox),
				params->b_im_enabled);

  /* Place of status display */
  statusPlaceComboBox = lookup_widget (dialog, "statusPlaceComboBox");
  gtk_combo_box_set_active (GTK_COMBO_BOX(statusPlaceComboBox),
			    params->e_status_placement);

  /* Sync Activation */
  syncActivationCheckBox = lookup_widget (dialog, "syncActivationCheckBox");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (syncActivationCheckBox),
				params->b_sync_activation);

  /* Language switch policy */
  perDesktopCheckbox = lookup_widget (dialog, "perDesktopCheckbox");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (perDesktopCheckbox),
				params->e_lang_switch_policy == LS_IC ?
				FALSE : TRUE);
  /* On/Off policy */
  onoffCheckbox = lookup_widget (dialog, "onoffCheckbox");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (onoffCheckbox),
				params->e_on_off_policy == OO_ACTIVATE ?
				TRUE : FALSE);
  /* Remember last language */
  remLastCheckbox = lookup_widget (dialog, "remLastCheckbox");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remLastCheckbox),
				params->b_remember_last_le);

  /* Available Language list */
  availableLangList = lookup_widget (dialog, "availableLangList");
  gtk_list_store_clear (lang_list_store);
  lang_ui_list = setget_get_available_lang_list();
  use_langs = setget_and_list_of_lang (setget_get_available_lang_list (), params->l_languages->langs);
  
  for (lp = lang_ui_list; lp; lp = g_slist_next (lp))
    {
      GSList *lp2;
      add_lang = TRUE;
      for (lp2 = use_langs; lp2; lp2 = g_slist_next (lp2))
	{
	  if (!strcmp (((LanguageID *)lp->data)->id, ((LanguageID *)lp2->data)->id))
	    {
	      /* available list shows only not used languages */
              add_lang = FALSE;
              break;
	    }
	}
      if (add_lang)
	{
	  lang = ((LanguageID *)(lp->data))->ui;
	  gtk_list_store_append (lang_list_store, &iter);
	  gtk_list_store_set (lang_list_store, &iter, 0, lang, -1);
	  if (((LanguageID *)(lp->data))->kbl) {
	    gtk_list_store_set (lang_list_store, &iter, 1, kbd_icon, -1);
	  }
	}
    }

  gtk_tree_view_set_model (GTK_TREE_VIEW(availableLangList),
			   GTK_TREE_MODEL(lang_list_store));
  g_slist_free (lang_ui_list);

  /* Use Language list */
  useLangList = lookup_widget (dialog, "useLangList");
  gtk_list_store_clear (lang_use_list_store);

  for (lp = use_langs; lp; lp = g_slist_next (lp))
    {
      lang = ((LanguageID *)(lp->data))->ui;
      gtk_list_store_append (lang_use_list_store, &iter);
      gtk_list_store_set (lang_use_list_store, &iter, 0, lang, -1);
      if (((LanguageID *)(lp->data))->kbl) {
	gtk_list_store_set (lang_use_list_store, &iter, 1, kbd_icon, -1);
      }
    }

  /* add user defined keyboard layout to use_list */
  user_kbl_list = setget_get_user_defined_kbl_list ();

  for (lp = user_kbl_list; lp; lp = g_slist_next (lp))
    {
      lang = ((LanguageID *)(lp->data))->ui;
      if (g_slist_find_custom (params->l_user_defined_non_use, lang, p_strcmp))
	{
	  gtk_list_store_append (lang_list_store, &iter);
	  gtk_list_store_set (lang_list_store, &iter, 0, lang, -1);
	  if (((LanguageID *)(lp->data))->kbl) {
	    gtk_list_store_set (lang_list_store, &iter, 1, kbd_icon, -1);
	  }
	}
      else {
	gtk_list_store_append (lang_use_list_store, &iter);
	gtk_list_store_set (lang_use_list_store, &iter, 0, lang, -1);
	if (((LanguageID *)(lp->data))->kbl) {
	  gtk_list_store_set (lang_use_list_store, &iter, 1, kbd_icon, -1);
	  /* may be better to set user defined keyboard icon - TODO */
	}
      }
    }

  gtk_tree_view_set_model (GTK_TREE_VIEW(useLangList),
			   GTK_TREE_MODEL(lang_use_list_store));

  /* Available Engine List */
  availableEngineList = lookup_widget (dialog, "availableEngineList");
  gtk_list_store_clear (engine_list_store);
  gtk_tree_view_set_model (GTK_TREE_VIEW(availableEngineList),
			   GTK_TREE_MODEL(engine_list_store));

  /* Use Engine List */
  useEngineList = lookup_widget (dialog, "useEngineList");
  gtk_list_store_clear (engine_use_list_store);
  gtk_tree_view_set_model (GTK_TREE_VIEW(useEngineList),
			   GTK_TREE_MODEL(engine_use_list_store));

  /* Trigger keys to activate */
  triggerList = lookup_widget (dialog, "triggerList");
  gtk_list_store_clear  (trigger_list_store);
  if (params->l_trigger_keys)
    {
      for (lp = params->l_trigger_keys->hotkeys; lp; lp = g_slist_next (lp))
	{
	  gtk_list_store_append (trigger_list_store, &iter);
	  gtk_list_store_set (trigger_list_store, &iter, 0, lp->data, -1);
	}
    }
  gtk_tree_view_set_model (GTK_TREE_VIEW(triggerList),
			   GTK_TREE_MODEL(trigger_list_store));

  /* Langlist with Hotkey enable/disable */
  langListEnableToggleButton = lookup_widget (dialog, "langListEnableToggleButton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (langListEnableToggleButton),
				params->b_lang_list_enabled);
  
  /* Langlist Hotkeys */
  popupHotkeyList = lookup_widget (dialog, "popupHotkeyList");
  gtk_list_store_clear (langlist_hotkey_list_store);
  if (params->l_lang_list_hotkey)
    {
      for (lp = params->l_lang_list_hotkey->hotkeys; lp; lp = g_slist_next (lp))
	{
	  gtk_list_store_append (langlist_hotkey_list_store, &iter);
	  gtk_list_store_set (langlist_hotkey_list_store, &iter, 0, lp->data, -1);
	}
    }
  gtk_tree_view_set_model (GTK_TREE_VIEW(popupHotkeyList),
			   GTK_TREE_MODEL(langlist_hotkey_list_store));

  /* Misc hotkey enable/disable */
  enableMiscHotkeyToggleButton = lookup_widget (dialog, "enableMiscHotkeyToggleButton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (enableMiscHotkeyToggleButton),
				params->b_misc_hotkey_enabled);

  /* Cycle lang hotkeys */
  langswitchHotkeyList = lookup_widget (dialog, "langswitchHotkeyList");
  gtk_list_store_clear (cycle_lang_hotkey_list_store);
  if (params->l_cycle_lang_hotkey)
    {
      for (lp = params->l_cycle_lang_hotkey->hotkeys; lp; lp = g_slist_next (lp))
	{
	  gtk_list_store_append (cycle_lang_hotkey_list_store, &iter);
	  gtk_list_store_set (cycle_lang_hotkey_list_store, &iter, 0, lp->data, -1);
	}
    }
  gtk_tree_view_set_model (GTK_TREE_VIEW(langswitchHotkeyList),
			   GTK_TREE_MODEL(cycle_lang_hotkey_list_store));

  /* Reverse cycle lang hotkeys */
  reverseLangswitchHotkeyList = lookup_widget (dialog, "reverseLangswitchHotkeyList");
  gtk_list_store_clear (reverse_cycle_lang_hotkey_list_store);
  if (params->l_reverse_cycle_lang_hotkey)
    {
      for (lp = params->l_reverse_cycle_lang_hotkey->hotkeys; lp; lp = g_slist_next (lp))
	{
	  gtk_list_store_append (reverse_cycle_lang_hotkey_list_store, &iter);
	  gtk_list_store_set (reverse_cycle_lang_hotkey_list_store, &iter, 0, lp->data, -1);
	}
    }
  gtk_tree_view_set_model (GTK_TREE_VIEW(reverseLangswitchHotkeyList),
			   GTK_TREE_MODEL(reverse_cycle_lang_hotkey_list_store));

  /* Keyboard Layout */
  keyboardLayoutList = lookup_widget (dialog, "keyboardLayoutList");
  gtk_list_store_clear (keyboard_layout_list_store);
  {
    gint num;
    gchar **ptr;
    gint i;

    kbltrans_get_supported_layout_names(&num, &ptr);
    for (i = 0; i < num; i++) {
      gtk_list_store_append (keyboard_layout_list_store, &iter);
      gtk_list_store_set (keyboard_layout_list_store, &iter, 0, *(ptr++), -1);
    }
  }
  if (params->b_kbd_check) {
    gtk_widget_set_sensitive (keyboardLayoutList, FALSE);
  }

  gtk_tree_view_set_model (GTK_TREE_VIEW(keyboardLayoutList),
			   GTK_TREE_MODEL(keyboard_layout_list_store));
  keyboardAutodetectCheckButton = lookup_widget (dialog, "keyboardAutodetectCheckButton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboardAutodetectCheckButton),
				params->b_kbd_check);
}

/*
 * set default button sensitibily
 */
static void activate_gui (GtkWidget *dialog)
{
  util_deactivate (dialog, "addLangButton");
  util_deactivate (dialog, "delLangButton");
  util_deactivate (dialog, "upLangButton");
  util_deactivate (dialog, "downLangButton");

  util_deactivate (dialog, "addLEButton");
  util_deactivate (dialog, "delLEButton");
  util_deactivate (dialog, "upLEButton");
  util_deactivate (dialog, "downLEButton");
}

/*
 * setup gui controls with given properities
 */
static void init_gui (GtkWidget *dialog, IIIMProps *iiim_props)
{
#include "widget-list.h"
  GtkCellRenderer *cell_renderer;
  GtkCellRenderer *cell_icon_renderer;
  GError *error = NULL;
  gchar *path = NULL;

  /* hold iiim_props sigleton in util module */
  util_set_iiimprops (iiim_props);

  /** Languages/Scripts tab **/
  path = gnome_program_locate_file (NULL, GNOME_FILE_DOMAIN_PIXMAP,
				    KBD_ICON_FILE, FALSE, NULL);
  if (!path) {
    path = gnome_program_locate_file (NULL, GNOME_FILE_DOMAIN_APP_PIXMAP,
				      KBD_ICON_FILE, FALSE, NULL);
  }
  if (!path) {
    kbd_icon = NULL;
  } else {
    kbd_icon = gdk_pixbuf_new_from_file (path, &error);
  }
  cell_renderer = gtk_cell_renderer_text_new ();
  cell_icon_renderer = gtk_cell_renderer_pixbuf_new ();
  lang_list_store = gtk_list_store_new (2, G_TYPE_STRING, GDK_TYPE_PIXBUF);
  availableLangList = lookup_widget (dialog, "availableLangList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (availableLangList),
					       -1,
					       "Language",
					       cell_renderer,
					       "text", 0, NULL);
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (availableLangList),
					       -1,
					       "Icon",
					       cell_icon_renderer,
					       "pixbuf", 1, NULL);

  lang_use_list_store = gtk_list_store_new (2, G_TYPE_STRING, GDK_TYPE_PIXBUF);
  useLangList = lookup_widget (dialog, "useLangList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (useLangList),
					       -1,
					       "Language",
					       cell_renderer,
					       "text", 0, NULL);
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (useLangList),
					       -1,
					       "Icon",
					       cell_icon_renderer,
					       "pixbuf", 1, NULL);
  
  engine_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  availableEngineList = lookup_widget (dialog, "availableEngineList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (availableEngineList),
					       -1,
					       "Engine",
					       cell_renderer,
					       "text", 0, NULL);

  engine_use_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  useEngineList = lookup_widget (dialog, "useEngineList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (useEngineList),
					       -1,
					       "Engine",
					       cell_renderer,
					       "text", 0, NULL);
  /** Trigger and Misc tab  **/
  trigger_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  triggerList = lookup_widget (dialog, "triggerList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (triggerList),
					       -1,
					       "Trigger",
					       cell_renderer,
					       "text", 0, NULL);

  langlist_hotkey_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  popupHotkeyList = lookup_widget (dialog, "popupHotkeyList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (popupHotkeyList),
					       -1,
					       "Hotkey",
					       cell_renderer,
					       "text", 0, NULL);

  cycle_lang_hotkey_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  langswitchHotkeyList = lookup_widget (dialog, "langswitchHotkeyList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (langswitchHotkeyList),
					       -1,
					       "Hotkey",
					       cell_renderer,
					       "text", 0, NULL);

  reverse_cycle_lang_hotkey_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  reverseLangswitchHotkeyList = lookup_widget (dialog, "reverseLangswitchHotkeyList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (reverseLangswitchHotkeyList),
					       -1,
					       "Hotkey",
					       cell_renderer,
					       "text", 0, NULL);

  /** Keyboard tab **/
  keyboard_layout_list_store = gtk_list_store_new (1, G_TYPE_STRING);
  keyboardLayoutList = lookup_widget (dialog, "keyboardLayoutList");
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (keyboardLayoutList),
					       -1,
					       "Layout",
					       cell_renderer,
					       "text", 0, NULL);

  update_gui (dialog, iiim_props);
  activate_gui (dialog);

  /* response close button */
  g_signal_connect (G_OBJECT (dialog), "destroy",
		    G_CALLBACK (gtk_main_quit), NULL);
			      
}


/*
 * called from main() - do all of initialization work
 */
void init_setup (GtkWidget *dialog, IIIMProps *iiim_props)
{
  if (!cf_initialize (GDK_DISPLAY_XDISPLAY (gtk_widget_get_display (dialog))))
    {
      setget_set_no_cf ();

    }
  setget_fetch_gconf_settings (iiim_props);
  init_gui (dialog, iiim_props);
  general_initialize (iiim_props);
  lang_initialize (iiim_props);
  trigger_initialize (dialog, iiim_props);
  keyboard_initialize (dialog, iiim_props);
  misc_initialize (dialog, iiim_props);
  exec_initialize ();
  hkc_initialize ();
}

/*
 * called from main. clean up properites
 * (NOT YET IMPLEMENTED)
 */
void init_free_props (IIIMProps *iiim_props)
{
  /* free all of allocated members */

  g_free (iiim_props);
}
