#include <config.h>

#include <gnome.h>

#include "gimlet.h"

GdkAtom   lang_atom, client_atom, status_atom, conv_atom;
GtkWindow *client;

static void
handle_selection (GtkWidget *widget,
			GdkEventSelection *event,
			gpointer user_data)
{
  GdkDisplay *display = gtk_widget_get_display (widget);

  if (event->target == client_atom)
    client = gdk_window_foreign_new_for_display (display,
						 event->requestor);
}

static void
process_status_text (gchar *data, int length)
{
  gchar *text;

  if (length == 1 && data[0] == 0x20) {
    text = g_strdup ("");
    gimlet->conversion_mode = FALSE;
  } else {
    text = g_strndup (data, length);
    gimlet->conversion_mode = TRUE;
  }

  gimlet_status_set_text (gimlet, text);
  g_free (text);
  gimlet_update_lang (gimlet);
}

/* this doesn't seem to get reached currently (iiimgcf bug?) */
static void
process_conversion_mode (gpointer data, int length)
{
  gimlet->conversion_mode = ((gulong*)data)[0];
  gimlet_update_lang (gimlet);
}

/* this is for reflecting correct language id to panel when focus is changed */
static void
process_current_input_language (gpointer data, int length)
{
  g_free (gimlet->current_iiim_lang);
  gimlet->current_iiim_lang = g_strndup (data, length);
  gimlet_update_lang (gimlet);
}

static void
handle_notification (GtkWidget *widget,
			   GdkEventProperty *event,
			   gpointer user_data)
{
  GdkAtom type;
  guchar *data = NULL;
  gint format, length = 0;

  if (event->atom != lang_atom &&
      event->atom != client_atom &&
      event->atom != status_atom &&
      event->atom != conv_atom)
    return;

  gdk_property_get (widget->window,
		    event->atom, event->atom,
		    0, INT_MAX, FALSE,
		    &type, &format, &length, &data);
  if (!data) return;

  if (type == status_atom)
    process_status_text (data, length);

  if (type == client_atom)
    ;

  if (type == lang_atom)
    process_current_input_language(data, length);

  if (type == conv_atom)
    process_conversion_mode (data, length);

  g_free (data);
}

void
gimlet_notify_language_to_client (gchar *lang)
{
  static GdkAtom desktop_lang_atom = GDK_NONE;

  g_return_if_fail (lang != NULL);

  gdk_property_change (client,
		       lang_atom, lang_atom,
		       8, GDK_PROP_MODE_REPLACE,
		       (guchar *)lang,
		       strlen (lang) + 1);

  if (desktop_lang_atom == GDK_NONE)
    desktop_lang_atom = gdk_atom_intern ("_IIIM_SWITCHER_DESKTOP_INPUT_LANGUAGE", FALSE);

  /* if language swiching is per desktop mode, then
   * desktop language of root window property will be used */
  gdk_property_change (gdk_get_default_root_window (),
                       desktop_lang_atom, desktop_lang_atom,
                       8, GDK_PROP_MODE_REPLACE,
                       (guchar *)lang,
                       strlen (lang) + 1); /* including last NULL */
}

void
gimlet_notify_conversion_to_client (gchar *conversion_mode)
{
  g_return_if_fail (conversion_mode != NULL);

  gdk_property_change (client,
		       conv_atom, conv_atom,
		       8, GDK_PROP_MODE_REPLACE,
		       (guchar *)conversion_mode,
		       strlen (conversion_mode) +1);
}

void
gimlet_xprop_init (GtkWidget *window)
{
  GdkAtom atom;
  GdkDisplay *display;
  GdkScreen *screen;

  display = gtk_widget_get_display (window);
  screen = gtk_widget_get_screen (window);

  atom = gdk_atom_intern (SWITCHER, FALSE);

  if (!gtk_selection_owner_set_for_display (display,
					    window,
					    atom,
					    GDK_CURRENT_TIME))
    return;

  lang_atom = gdk_atom_intern (SWITCHER_LANGUAGE, FALSE);
  client_atom = gdk_atom_intern (SWITCHER_CLIENT, FALSE);
  status_atom = gdk_atom_intern (SWITCHER_STATUS, FALSE);
  conv_atom = gdk_atom_intern (SWITCHER_CONVERSION, FALSE);

  gtk_widget_add_events (window,
			GDK_PROPERTY_CHANGE_MASK | GDK_STRUCTURE_MASK);

  g_signal_connect (G_OBJECT (window),
		    "selection-request-event",
		    G_CALLBACK (handle_selection),
		    NULL);

  g_signal_connect (G_OBJECT (window),
		    "property-notify-event",
		    G_CALLBACK (handle_notification),
		    NULL);
}

