/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.sym.xml;

import com.sun.g11n.vkb.sym.*;
import com.sun.g11n.vkb.*;
import java.util.*;
import java.io.*;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import static com.sun.g11n.vkb.Main.*;

/**
 *
 * @author naoyuki
 */
public class XMLSymbol implements SymbolCollection {
    
    private Map<String, Symbol> symbolMap;
    @Override public Collection<Symbol> getSymbolSet() {
        return symbolMap.values();
    }
    
    private static Map<String, Symbol> systemSymbolMap;
    @Override public Collection<Symbol> getSystemSymbolSet() {
        return systemSymbolMap.values();
    }
    
    private Map<String, Symbol> userSymbolMap;
    private Map<String, Symbol> activeUserSymbolMap;
    @Override public Collection<Symbol> getActiveUserSymbolSet() {
        return activeUserSymbolMap.values();
    }
    @Override public Collection<Symbol> getUserSymbolSet() {
        return userSymbolMap.values();
    }
    
    /*
     * Update user symbol set by re-reading user config dir
     */
    @Override public void updateSymbolSet() {
        removeUserSymbol();
        readUserConfigDir();
    }
    
    @Override public Symbol getSymbolByName(String name) {
        if (name == null) {
            return null;
        }
        return symbolMap.get(name);
    }
    
    private List<String> nonUseUserSymbolList;
    public List<String> getNonUseUserSymbolSet() {
        return nonUseUserSymbolList;
    }

    static XMLSymbol xmlSymbol = null;
    public static XMLSymbol getInstance() {
        if (xmlSymbol == null) {
            xmlSymbol = new XMLSymbol();
        }
        return xmlSymbol;
    }
    public static void resetInstance() {
        xmlSymbol = null;
    }
   
    private Map<String, List<Integer>> sourceIDMap;
    private String extractNumber(String id) {
        // id must be x-kbl-??-<num>-custom
        int start = id.indexOf("x-kbl-");
        if (start == -1) {
            return "0";
        }
        start = id.indexOf("-", start + 6);
        if (start == -1) {
            return "0";
        }
        int end = id.indexOf("-", start + 1);
        return id.substring(start + 1, end);
    }

    private void makeSourceIDMap(Map<String, Symbol> baseMap) {
        sourceIDMap = new HashMap<String, List<Integer>>();
        for (String name : baseMap.keySet()) {
            Symbol sym = baseMap.get(name);
            if (sym instanceof UserSymbolInst) {
                UserSymbolInst inst = (UserSymbolInst)sym;
                String id = inst.getID();
                String idd = extractNumber(id);
                Integer idi = Integer.valueOf(idd);
                String src = inst.getSource();
                String src_id = VKBManager.getInstance().getSymbolID(src);
                List<Integer> ilist;
                if (sourceIDMap.containsKey((src_id))) {
                    ilist = sourceIDMap.get(src_id);
                } else {
                    ilist = new ArrayList<Integer>();
                    sourceIDMap.put(src_id, ilist);
                }
                ilist.add(idi);
            }
        }
    }
    
    /*
     * Find unused number for specified source_id 
     */
    public String getUniqueID (String source_id) {
        if (source_id.endsWith(CUSTOM_ID_SUFFIX)) {
            int end = source_id.lastIndexOf(CUSTOM_ID_SUFFIX);
            end = source_id.lastIndexOf("-", end - 1);
            source_id = source_id.substring(0, end);
        }
        List<Integer> ilist;
        if (!sourceIDMap.containsKey(source_id)) {
            ilist = new ArrayList<Integer>();
            sourceIDMap.put(source_id, ilist);
        } else {
            ilist = sourceIDMap.get(source_id);
        }
        int i;
        for (i = 1;; i++) {
            boolean exist = false;
            for (Integer iobj : ilist) {
                if (iobj.intValue() == i) {
                    exist = true;
                    break;
                }
            }
            if (!exist) {
                ilist.add(i);
                break;
            }
        }
        return source_id + "-" + i + CUSTOM_ID_SUFFIX;
    }
    
    private XMLSymbol() {
        // system (IIIM) layout collection
        // this map is not changed dynamically, so setup only once
        if (systemSymbolMap == null) {
            systemSymbolMap = new HashMap<String, Symbol>();
            collectSymbolFromXML(new File(getSymbolTableFileName()), systemSymbolMap, false);
        }
        // user defined layout collection
        userSymbolMap = new HashMap<String, Symbol>();
        nonUseUserSymbolList = new ArrayList<String>();        
        activeUserSymbolMap = new HashMap<String, Symbol>();
        symbolMap =  new HashMap<String, Symbol>();        
        symbolMap.putAll(systemSymbolMap);
        readUserConfigDir();
        makeSourceIDMap(userSymbolMap);
    }
    
    public String getRealSource(String sourceName) {
        if (systemSymbolMap.containsKey(sourceName)) {
            return systemSymbolMap.get(sourceName).getDescription();
        }
        if (userSymbolMap.containsKey(sourceName)) {
            return getRealSource(userSymbolMap.get(sourceName).getDescription());
        }
        return "US/English"; // here should never be reached
    }

    /*
     * read user config dir and set userSymbolMap, activeUserSymbolMap and symbolMap
     */
    private void readUserConfigDir() {
        File dir = new File(getUserConfigDir());
        if (dir.isDirectory()) {
            File[] fileList = dir.listFiles(new ConfigFileFilter());
            for (File f : fileList) {
                collectSymbolFromXML(f, userSymbolMap, true);
            }
        }

        File configFile = new File(dir, getUserConfigFile());
        if (configFile.canRead()) {
            // config file only exist for only user restricted defined layout
            collectNonUseSymbolFromXML(configFile, nonUseUserSymbolList);
        }

        for (String key : userSymbolMap.keySet()) {
            if (!nonUseUserSymbolList.contains(key)) {
                activeUserSymbolMap.put(key, userSymbolMap.get(key));
            }
        }
        symbolMap.putAll(activeUserSymbolMap);
        resolveInclude(userSymbolMap);       
    }
    
    private void removeUserSymbol() {
        for (String key : userSymbolMap.keySet()) {
            if (symbolMap.containsKey(key)) {
                symbolMap.remove(key);
            }
        }
    }

    // incorporate source model info to custom symbols
    private void resolveInclude(Map<String, Symbol> map) {
        // store unique part as it's needed for saving new custom layot
        // which is based on another custom layout
        XMLCustomLayoutManager clmgr = XMLCustomLayoutManager.getInstance();

        for (String name : map.keySet()) {
            // Symbol instance must be SymbolInst
            Symbol symbol = map.get(name);
            if (!(symbol instanceof UserSymbolInst)) {
                continue;
            }
            UserSymbolInst customSymbol = (UserSymbolInst)symbol;
            String src = customSymbol.getSource();
            Symbol srcSymbol = symbolMap.get(src);
            if (srcSymbol instanceof SymbolInst) {
                SymbolInst inst = (SymbolInst)srcSymbol;
                clmgr.setCustomDict(name, symbol.getKeyMap(), src);
                customSymbol.resolveSource(inst);
            }
        }
    }
 
    private void collectSymbolFromXML(File file, Map<String, Symbol> symMap, boolean user) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputSource inputSource = new InputSource(new BufferedReader(new InputStreamReader(fis)));
            XMLReader reader = XMLReaderFactory.createXMLReader();
            IIIMXMLContentHandler contentHandler = new IIIMXMLContentHandler(symMap, user, file);
            reader.setContentHandler(contentHandler);
            reader.parse(inputSource);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SAXException se) {
            se.printStackTrace();
        }
    }
    
    private void collectNonUseSymbolFromXML(File file, List<String> symList) {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputSource inputSource = new InputSource(new BufferedReader(new InputStreamReader(fis)));
            XMLReader reader = XMLReaderFactory.createXMLReader();
            ConfigXMLContentHandler contentHandler = new ConfigXMLContentHandler(symList);
            reader.setContentHandler(contentHandler);
            reader.parse(inputSource);
        } catch(IOException e) {
            e.printStackTrace();
        } catch(SAXException se) {
            se.printStackTrace();
        }
    }
    
    enum CMODE {HEX, STRING, NONE};
    
    private class IIIMXMLContentHandler extends DefaultHandler {
        private Map<String, Symbol> symMap;
        private SymbolInst currentSymbol;
        private KeyModel currentModel;
        private String currentSymName;
        private String currentType;
        private int currentData;
        private String currentStrData;
        private CMODE charMode;
        private boolean user;
        private File file;

        private IIIMXMLContentHandler(Map<String, Symbol> symMap, boolean user, File file) {
            this.symMap = symMap;
            charMode = CMODE.NONE;
            this.user = user;
            this.file = file;
        }
        
        @Override public void startDocument() {
            // do nothing
        }
        @Override public void endDocument() {
            // do nothing
        }
        @Override public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals(LAYOUT)) {
                currentType = attributes.getValue(TYPE);
                if (user) {
                    currentSymbol = new UserSymbolInst(currentType, file);
                } else {
                    currentSymbol = new SymbolInst(currentType);
                }
                String custom = attributes.getValue(CUSTOM);
                if (custom != null && custom.equals(TRUE)) {
                    // This is custom layout and must have SOURCE type which is based on.
                    String sourceType = attributes.getValue(SOURCE);
                    ((UserSymbolInst)currentSymbol).setSource(sourceType);
                    String id = attributes.getValue(ID);
                    ((UserSymbolInst)currentSymbol).setID(id);
                }
            } else if (localName.equals(KEY)) {
                currentSymName = attributes.getValue(SYMBOL);
                currentModel = KeyModel.getInstance(currentSymName);
            } else if (localName.equals(CHAR1) || localName.equals(CHAR2) || 
                    localName.equals(CHAR3) || localName.equals(CHAR4) ||
                    localName.equals(CODE) || localName.equals(ALTCODE)) {
                charMode = CMODE.HEX;
            } else if (localName.equals(STR1) || localName.equals(STR2) ||
                    localName.equals(STR3) || localName.equals(STR4)) {
                charMode = CMODE.STRING;
            }
        }
        @Override public void endElement(String uri, String localName, String qName) {
            if (localName.equals(LAYOUT)) {
                symMap.put(currentType, currentSymbol);
            } else if (localName.equals(KEY)) {
                currentSymbol.add(currentSymName, currentModel);
            } else if (localName.equals(CHAR1)) {
                char[] chars = {(char)currentData};
                currentModel.setLabel(new String(chars), 0);
            } else if (localName.equals(CHAR2)) {
                char[] chars = {(char)currentData};
                currentModel.setLabel(new String(chars), 1);
            } else if (localName.equals(CHAR3)) {
                char[] chars = {(char)currentData};
                currentModel.setLabel(new String(chars), 2);
            } else if (localName.equals(CHAR4)) {
                char[] chars = {(char)currentData};
                currentModel.setLabel(new String(chars), 3);
            } else if (localName.equals(CODE)) {
                currentModel.setCode(currentData);
            } else if (localName.equals(ALTCODE)) {
                currentModel.setAltCode(currentData);
            } else if (localName.equals(STR1)) {
                currentModel.setLabel(currentStrData, 0);
            } else if (localName.equals(STR2)) {
                currentModel.setLabel(currentStrData, 1);
            } else if (localName.equals(STR3)) {
                currentModel.setLabel(currentStrData, 2);
            } else if (localName.equals(STR4)) {
                currentModel.setLabel(currentStrData, 3);
            }
            charMode = CMODE.NONE;
        }
        
        @Override public void characters(char[] ch, int start, int length) {
            if (length == 0) {
                return;
            }
            String strData = new String(ch, start, length);
            if (charMode == CMODE.HEX) {
                try {
                    currentData = Integer.valueOf(strData, 16);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (charMode == CMODE.STRING) {
                currentStrData = strData;
            }
        }
    }
    
    private class ConfigXMLContentHandler extends  DefaultHandler {
        private List<String> symList;
        private String currentText;
        private boolean inKBLConfig;
        private boolean inNonUse;
        private boolean inType;
        
        private ConfigXMLContentHandler(List<String> symList) {
            this.symList = symList;
            inKBLConfig = false;
            inNonUse = false;
            inType = false;
        }
        @Override public void startDocument() {
            // do nothing
        }
        @Override public void endDocument() {
            // do nothing
        }
        @Override public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals(CONFIG_ROOT)) {
                inKBLConfig = true;
            } else if (localName.equals(NON_USE_LIST)) {
                if (inKBLConfig) {
                    inNonUse = true;
                }
            } else if (localName.equals(TYPE)) {
                if (inNonUse) {
                    inType = true;
                }
            }
        }
        @Override public void endElement(String uri, String localName, String qName) {
            if (localName.equals(CONFIG_ROOT)) {
                inKBLConfig = false;
            } else if (localName.equals(NON_USE_LIST)) {
                if (inKBLConfig) {
                    inNonUse = false;
                }
            } else if (localName.equals(TYPE)) {
                if (inNonUse) {
                    symList.add(currentText);
                    inType = false;
                }
            }
        }
        @Override public void characters(char[] ch, int start, int length) {
            if (inType) {
                currentText = new String(ch, start, length);
            }
        }
    }
    
    private class SymbolInst implements Symbol, Comparable {
        protected String name;
        private Map<String, KeyModel> keyMap;
        boolean resolved;
        
        SymbolInst(String name) {
            this.name = name;
            keyMap = new HashMap<String, KeyModel>();
            resolved = true;
        }

        @Override public boolean isPredefined() {
            return true;
        }

        @Override public String getID() {
            return VKBManager.getInstance().getSymbolID(name);
        }
        
        @Override public String toString() {
            return name;
        }
        
        @Override public Map<String, KeyModel> getKeyMap() {
            return keyMap;
        }
        @Override public String getDescription() {
            return name;
        }
        
        private void add(String name, KeyModel model) {
            keyMap.put(name, model);
        }
        
        private void setResolved() {
            resolved = true;
        }
        
        private boolean isResolved() {
            return resolved;
        }
        
        @Override public int compareTo(Object s) {
            return toString().compareTo(s.toString());
        }
        
        void resolveSource(SymbolInst sinst) {
            // making sure source is resolved already
            if (sinst.isResolved() == false) {
                // need so resolve source recursively                
                String src = ((UserSymbolInst)sinst).getSource();
                Symbol symbol = symbolMap.get(src);
                if (symbol instanceof SymbolInst) {
                    SymbolInst symInst = (SymbolInst)symbol;
                    sinst.resolveSource(symInst);
                }
            }
            if (sinst.isResolved() == false) {
                // assert
                error(" something wrong in resolving custom layout");
            }
            Map<String, KeyModel> srcKeyMap = sinst.getKeyMap();
            Set<String> srcKeys = srcKeyMap.keySet();
            for (String srcKey : srcKeys) {
                if (keyMap.containsKey(srcKey) == false) {
                    keyMap.put(srcKey, srcKeyMap.get(srcKey));
                }
            }
            setResolved();
        }
    }

    private class UserSymbolInst extends SymbolInst implements  UserDefinedSymbol {
        private File file;
        private String id;
        private String source;
        
        UserSymbolInst(String name, File file) {
            super(name);
            this.file = file;
            resolved = false;
        }
        @Override public void delete() {
            file.delete();
        }

        private void setID(String id) {
            this.id = id;
            VKBManager.getInstance().registerSymbolID(name, id);
        }
        
        @Override public String getID() {
            return id;
        }

        @Override public boolean isPredefined() {
            return false;
        }
        
        private void setSource(String source) {
            this.source = source;
        }
        
        private String getSource() {
            return source;
        }
    }

    static class ConfigFileFilter implements FileFilter {
        @Override public boolean accept(File file) {
            if (file.length() < ROOT.length() * 3) {
                return false;
            }
            if (file.getName().endsWith(getLayoutFileSuffix())) {
                return true;
            }
            return false;
        }
    }
    // element and attribuute names of libkbltrans data xml format:
    static final String ROOT = "kbltrans";
    static final String LAYOUT = "lo";
    static final String TYPE = "type";
    static final String ID = "id";
    static final String KEY = "key";
    static final String SYMBOL = "sym";
    static final String CHAR1 = "c1";
    static final String CHAR2 = "c2";
    static final String CHAR3 = "c3";
    static final String CHAR4 = "c4";
    static final String CODE = "code";
    static final String ALTCODE = "altcode";
    static final String CUSTOM = "custom";
    static final String SOURCE = "source";
    static final String TRUE = "true";
    static final String FALSE = "false";
    static final String STR1 = "s1";
    static final String STR2 = "s2";
    static final String STR3 = "s3";
    static final String STR4 = "s4";

    static final String CUSTOM_ID_SUFFIX = "-custom";
    
    // config file specific
    static final String CONFIG_ROOT = "kblconfig";
    static final String NON_USE_LIST = "nonuse";
}
