/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb.geom;

import java.awt.geom.Point2D;
import java.awt.geom.GeneralPath;
import java.util.*;
/**
 *
 * @author naoyuki
 */
public class KeyShape {
    private Set<List<Point2D.Float>> pointSet;
    private int cornerRadius;
    private float width;
    private float height;
    private String name;

    /*
     * Represents one key's shape consists of points which represents
     * the shape of one key.
     */
    public KeyShape(String name) {
        this.name = name;
        cornerRadius = 0;
        pointSet = new HashSet<List<Point2D.Float>>();
        width = 0;
        height = 0;
        outerPathList = null;
        innerPathList = null;
    }
    
    public String getName() {
        return name;
    }

    /*
     * set corner radius for this key 
     */
    public void setCornerRadius(int radius) {
        cornerRadius = radius;
    }
    
    /*
     * get corner radius of this key
     */
    public int getCornerRadius() {
        return cornerRadius;
    }
    
    /*
     * Add one closed path to this shape
     * Usually, one key shape consists of two paths represent
     * outside and inside lines.
     * Most of key is square so path is usually rectangle, but
     * some keys like Return key of some type of keyboard are
     * not rectangle.
     */
    public void addOutline(List<Point2D.Float> pointList) {
        pointSet.add(pointList);
    }

    /*
     * Returns points represents this key shape
     */
    public Set<List<Point2D.Float>> getPointSet() {
        return pointSet;
    }

    /*
     * Calculate and return this key shape width from
     * points make this shape.
     */
    public float getWidth() {
        if (width > 0) 
            return width;

        for (List<Point2D.Float> pList : pointSet) {
            for (Point2D.Float point : pList) {
                float w = (float)point.getX();
                if (w > width) {
                    width = w;
                }
            }
        }
        return width;
    }
    public void setWidth(float width) {
        this.width = width;
    }

    /*
     * Calculate and return this key shape height from
     * points make this shape.
     */
    public float getHeight() {
        if (height > 0) 
            return height;

        for (List<Point2D.Float> pList : pointSet) {
            for (Point2D.Float point : pList) {
                float h = (float)point.getY();
                if (h > height) {
                    height =  h;
                }
            }
        }
        return height;        
    }
    public void setHeight(float height) {
        this.height = height;
    }
    
    // for debug
    private String typeName;
    public void setTypeName(String name) {
        this.typeName = name;
    }
    private List<Point2D.Float> outerPathList;
    
    /*
     * Returns outside shape path of this key shape 
     */
    public GeneralPath getOuterPath(double x, double y) {
        if (outerPathList == null) {
            float min = Float.MAX_VALUE;
            for (List<Point2D.Float> pointList : pointSet) {
                normalizePoint(pointList);
                float min2 = getMinX(pointList);
                if (min2 < min) {
                    min = min2;
                    outerPathList = pointList;
                }
            }
        }
        if (outerPathList != null) {
            // printPPL("OUTER", outerPathList);
            return makeGeneralPath(outerPathList, x, y);
        }
        return null;
    }
    
    private List<Point2D.Float> innerPathList;
    /*
     * Returns inside shape path of this key shape
     */
    public GeneralPath getInnerPath(double x, double y) {
        if (innerPathList == null) {
            float min = Float.MIN_VALUE;
            for (List<Point2D.Float> pointList : pointSet) {
                normalizePoint(pointList);
                float min2 = getMinX(pointList);
                if (min2 > min) {
                    min = min2;
                    innerPathList = pointList;
                }
            }
        }
        if (innerPathList != null) {
            // printPPL("INNER", innerPathList);
            return makeGeneralPath(innerPathList, x, y);
        }
        return null;
    }
    
    private void normalizePoint(List<Point2D.Float> plist) {
        if (plist.size() == 1) {
            plist.add(0, new Point2D.Float(0, 0));
        }
        if (plist.size() == 2) {
            Point2D p0 = plist.get(0);
            Point2D p1 = plist.get(1);
            plist.add(1, new Point2D.Float((float)p1.getX(), (float)p0.getY()));
            plist.add(3, new Point2D.Float((float)p0.getX(), (float)p1.getY()));
        }
    }
    
    private GeneralPath makeGeneralPath(List<Point2D.Float> plist, double x, double y) {
        GeneralPath gp = new GeneralPath();
        Point2D p0 = plist.get(0);
        gp.moveTo(p0.getX() + x, p0.getY() + y);
        for (Point2D p : plist.subList(1, plist.size())) {
            gp.lineTo(p.getX() + x, p.getY() + y);
        }
        gp.closePath();
        return gp;
    }
    
    private float getMinX(List<Point2D.Float> pointList) {
        float min = Float.MAX_VALUE;
        for (Point2D.Float p : pointList) {
            float x = (float)p.getX();
            if (x < min) {
                min = x;
            }
        }
        return min;
    }
    

    static void printPPL(String name, List<Point2D.Float> pl) {
        System.out.println(name + " -> ");
        for (Point2D.Float p : pl) {
            System.out.println("\t x = " + p.getX() + ", y = " + p.getY());
        }
    }
}
