/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import org.w3c.dom.*;
import java.awt.geom.*;
import java.util.*;
/**
 *
 * @author naoyuki
 */
public class XMLUtil {
    
    private static boolean pretty_print = true;
    
    public static void setPrettyPrint(boolean b) {
        pretty_print = b;
    }
    
    public static String toPString(List<Point2D.Float> list) {
        StringBuffer buffer = new StringBuffer();
        for (Point2D.Float p : list) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(Float.toString((float)p.getX()));
            buffer.append(",");
            buffer.append(Float.toString((float)p.getY()));
        }
        return buffer.toString();
    }
    
    private static int nestLevel = 0;
    public static String toXMLString(Node node) {
        short type = node.getNodeType();
        if (type == Node.TEXT_NODE) {
            return node.getNodeValue();
        }
        nestLevel++;
        
        StringBuffer buffer = new StringBuffer();        
        String name = node.getNodeName();
        buffer.append("<");
        buffer.append(name);
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0, len = attrs.getLength(); i < len; i++) {
            Node attr = attrs.item(i);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            buffer.append(" ");
            buffer.append(attrName);
            buffer.append("=");
            buffer.append("\"");
            buffer.append(attrValue);
            buffer.append("\"");
        }
        buffer.append(">");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0,  len = nodeList.getLength(); i < len; i++) {
            if (pretty_print && nodeList.item(i).getNodeType() != Node.TEXT_NODE) {
                 buffer.append("\n");
                 for (int j = 0; j < nestLevel; j++) {
                     buffer.append("  ");
                 }
            }
            buffer.append(toXMLString(nodeList.item(i)));
        }
        nestLevel--;
        if (pretty_print && node.getFirstChild() != null && node.getFirstChild().getNodeType() != Node.TEXT_NODE) {
            buffer.append("\n");
            for (int j = 0; j < nestLevel; j++) {
                buffer.append("  ");
            }
        }        
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");

        return buffer.toString();        
    }
    
    public static void writeFloat(Document doc, Element parent, String name, float value) {
        Element elm = doc.createElement(name);
        elm.appendChild(doc.createTextNode(Float.toString(value)));
        parent.appendChild(elm);
    }
    
    public static void writeInt(Document doc, Element parent, String name, int value) {
        Element elm = doc.createElement(name);
        elm.appendChild(doc.createTextNode(Integer.toString(value)));
        parent.appendChild(elm);
    }
    
    public static void writeFloatAttr(Element elm, String name, float value) {
        if (value == 0) {
            return;
        }
        elm.setAttribute(name, Float.toString(value));
    }
    
    public static void writeText(Document doc, Element parent, String name, String text) {
        if (text == null) {
            return;
        }
        Element elm = doc.createElement(name);
        text = text.replaceAll("&", "&amp;");        
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("'", "&apos;");
        text = text.replaceAll("\"", "&quot;");
        elm.appendChild(doc.createTextNode(text));
        parent.appendChild(elm);
    }
    
    public static void writeTextAttr(Element elm, String name, String value) {
        if (value == null) {
            return;
        }
        elm.setAttribute(name, value);
    }
}
