/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.xml.XMLCustomLayoutManager;
import com.sun.g11n.vkb.sym.xml.XMLSymbol;
import com.sun.g11n.vkb.sym.*;
import com.sun.g11n.vkb.geom.GeometryCollection;
import com.sun.g11n.vkb.geom.Geometry;

import java.util.*;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;

import static com.sun.g11n.vkb.Main.error;
import static com.sun.g11n.vkb.L10N._;

/**
 * VKBManager is the central KeyboadFrame management class.
 *  
 * @author naoyuki
 */
public class VKBManager {
    // VKBManager is singleton
    private static VKBManager manager;
    
    // ControlPanel is singleton
    private static ControlPanel controlPanel;
    
    // FrameStyleManager is singleton
    private FrameStyleManager fsManager;
    
    // IMInterface is singleton
    private static IMInterface imInterface;
    
    // mapping from layout name (US/English) to id (x-kbl-en)
    private static ResourceBundle idmap;
    
    /*
     * This is called only getInstance static method of this class
     * for making this instance singleton.
     */
    private VKBManager() {
        kbdSet = new HashSet<KeyboardFrame>();
        designMode = false;
        tooltipEnabled = Prefs.getTooltipEnabled();
        fsManager = FrameStyleManager.getInstance(this, kbdSet);
        imInterface = Main.getIMInterface();
        idmap = ResourceBundle.getBundle("com.sun.g11n.vkb.sym.vkb-symbol-id");
        syncMode = Prefs.getIMSync();
    }
    
    // hold KeyboardFrame user created
    private Set<KeyboardFrame> kbdSet;
    public int getNumKeyboardFrame() {
        return kbdSet.size();
    }

    // Mode design/input
    private boolean designMode;
    private Geometry currentGeometry;
    private Symbol currentSymbol;
    
    public static VKBManager getInstance() {
        if (manager == null) {
            manager = new VKBManager();
            controlPanel = ControlPanel.getInstance();
            //EDITING_TITLE = " : " + _("vkb.editing_title");
        }
        return manager;
    }

    public SortedSet<Symbol> getSortedSymbolSet() {
        SymbolCollection symbolCol = Main.getSymbolCollection();
        Collection<Symbol> symbols = symbolCol.getSymbolSet();
        SortedSet<Symbol> ssymbols = new TreeSet<Symbol>();      
        for (Symbol symbol : symbols) {
            String symbolName = symbol.toString();
            if (symbolName != null) {
                ssymbols.add(symbol);
            }
        }
        return ssymbols;
    }

    public SortedSet<Symbol> getPredefinedSymbolSet() {
        SymbolCollection symbolCol = Main.getSymbolCollection();
        Collection<Symbol> psymbols = symbolCol.getSystemSymbolSet();
        SortedSet<Symbol> spsymbols = new TreeSet<Symbol>();
        for (Symbol symbol : psymbols) {
            String symbolName = symbol.toString();
            if (symbolName != null) {
                spsymbols.add(symbol);
            }
        }
        return spsymbols;
    }

    public SortedSet<Symbol> getUserSymbolSet() {
        SymbolCollection symbolCol = Main.getSymbolCollection();
        Collection<Symbol> usymbols = symbolCol.getUserSymbolSet();
        SortedSet<Symbol> susymbols = new TreeSet<Symbol>();
        for (Symbol symbol : usymbols) {
            String symbolName = symbol.toString();
            if (symbolName != null) {
                susymbols.add(symbol);
            }
        }
        return susymbols;
    }
    
    public SortedSet<Geometry> getSortedGeometrySet() {
        GeometryCollection geomCol = Main.getGeometryCollection();
        Collection<Geometry> geoms = geomCol.getGeometrySet();
        SortedSet<Geometry> sgeoms = new TreeSet<Geometry>();
        for (Geometry geom : geoms) {
            String geomName = geom.toString();
            if (geomName != null) {
                sgeoms.add(geom);
            }
        }
        return sgeoms;
    }

    public boolean currentKeyboardDeletable() {
        String defGeomName = Main.getDefaultGeometryName();
        String defSymName = Main.getDefaultSymbolName();
        if (defGeomName.equals(getCurrentGeometry().getDescription()) &&
                defSymName.equals(getCurrentSymbol().getDescription())) {
            return false;
        }
        return currentKeyboardSaved();
    }
    public boolean currentKeyboardSaved() {
        return Prefs.isKeyboardSaved(new KeyboardDescription(getCurrentGeometry(), getCurrentSymbol()));
    }

    public void setCurrentGeometry(Geometry geom) {
        currentGeometry = geom;
    }
        
    public Geometry getCurrentGeometry() {
        String defaultName = Main.getDefaultGeometryName();
        if (currentGeometry == null) {
            GeometryCollection geomCol = Main.getGeometryCollection();
            Set<Geometry> geoms = geomCol.getGeometrySet();
            for (Geometry geom : geoms) {
                String geomName = geom.toString();
                if (geomName != null && geomName.equals(defaultName)) {
                    currentGeometry = geom;
                    break;
                }
            }
        }
        if (currentGeometry == null) {
            error(defaultName + " is not found.");
        }
        return currentGeometry;
    }
    
    public void setCurrentSymbol(Symbol symbol) {
        currentSymbol = symbol;
    }
    
    public Symbol getCurrentSymbol() {
        if (currentSymbol == null) {
            String defaultName = Main.getDefaultSymbolName();
            SymbolCollection symbolCol = Main.getSymbolCollection();
            Collection<Symbol> symbols = symbolCol.getSymbolSet();
            for (Symbol sym : symbols) {
                String symName = sym.toString();
                if (symName != null && symName.equals(defaultName)) {
                    currentSymbol = sym;
                    break;
                }
            }
            if (currentSymbol == null) {
                error(defaultName + " is not found.");
            }
        }
        return currentSymbol;
    }

    public Geometry getDefaultGeometry() {
        String defGeomStr = Main.getDefaultGeometryName();
        GeometryCollection geomCol = Main.getGeometryCollection();
        return geomCol.getGeometryByName(defGeomStr);
    }

    public Symbol getDefaultSymbol() {
        String defSymStr = Main.getDefaultSymbolName();
        SymbolCollection symCol = Main.getSymbolCollection();
        return symCol.getSymbolByName(defSymStr);
    }

    public Symbol getSymbolByName(String name) {
        SymbolCollection symCol = Main.getSymbolCollection();
        return symCol.getSymbolByName(name);
    }

    //private KeyboardFrame editTargetFrame;
    public EditKeyboardFrame getEditKeyboardFrame() {
        return editKeyboardFrame;
    }

    private EditKeyboardFrame editKeyboardFrame;
    public void setEditKeyboardFrame(EditKeyboardFrame frame) {
        editKeyboardFrame = frame;
    }
    public void redrawTargetFrame() {
        if (editKeyboardFrame != null && editKeyboardFrame.isVisible()) {
            editKeyboardFrame.getCanvas().repaint();
            return;
        }
        // obsolute staff
        if (editKeyboardFrame == null) {
            return;
        }
        KeyCanvas canvas = editKeyboardFrame.getCanvas();
        canvas.repaint();
    }
    
    private KeyboardFrame currentFrame;
    public void setCurrentFrame(KeyboardFrame frame) {
        currentFrame = frame;
        if (syncMode) {
            imInterface.syncKeyboard(frame.getCommonData().getSymbol().getID());
        }
    }
    public void setFocused(KeyboardFrame frame) {
        fsManager.setFocused(frame);
    }
    public KeyboardFrame getCurrentFrame() {
        return currentFrame;
    }
    public Frame getCurrentAWTFrame() {
        // get parent Frame from current KeyboardFrame
        
        return new JFrame();
    }
    public void closeFocusedFrame() {
        if (currentFrame != null) {
            fsManager.removeKeyboardFrame(currentFrame);
        }
    }

    Component getDialogParent() {
        if (controlPanel.isVisible()) {
            return controlPanel;
        }
        return currentFrame.getCanvas();
    }

    public boolean isDesignMode() {
        return designMode;
    }
    /*
     * bring up Delete Custom Symbol dialog (called from ContextMenu)
     */
    public void deleteCustomSymbol() {
        DeleteCustomSymbol dialog = new DeleteCustomSymbol(getCurrentAWTFrame(), true);
        dialog.setVisible(true);
        XMLSymbol.resetInstance();
    }

    /*
     * handle synchronization with libkbltrans keyboard emulation
     */
    private boolean syncMode;
    public void setSyncMode(boolean sync) {
        syncMode = sync;
        if (imInterface == null) {
            return;
        }
        if (sync) {
            KeyboardFrame frame = getCurrentFrame();
            Symbol symbol = frame.getCommonData().getSymbol();
            imInterface.syncKeyboard(symbol.getID());
        } else {
            imInterface.resetSyncKeyboard();
        }
        Prefs.setIMSync(sync);
    }
    public boolean getSyncMode() {
        return syncMode;
    }
    
    private boolean tooltipEnabled;
    public void setTooltip(boolean b) {
       tooltipEnabled = b;
       if (!b) {
           for (KeyboardFrame frame : kbdSet) {
               KeyCanvas canvas = frame.getCanvas();
               canvas.setToolTipText(null); // KeyCanvas is JPanel
           }
       }
       Prefs.setTooltipEnabled(b);
    }
    public boolean tooltip() {
        return tooltipEnabled;
    }
    
    // called from LayoutSaveDialog
    public void saveCurrentLayout(String layoutName, boolean system) {
        if (editKeyboardFrame != null) {
            KeyCanvas canvas = editKeyboardFrame.getCanvas();
            KeyViewSet keyViewSet = canvas.getKeyViewSet();
            if (XMLCustomLayoutManager.getInstance().save(keyViewSet, layoutName, system)) {
                // save success
                updateSymbolInfo(layoutName, keyViewSet);
            }
            XMLSymbol.resetInstance();
            //setDesignMode(false);
            // refresh iiimd/unitle/libkbltrans to hadndle new layout
            sendToServer();
            //_XContextMenu.getInstance().refreshSymbolMenu();
            ContextMenu.getInstance().refreshSymbolMenu();
        }
    }

    private Map<String, String> customIDMap = null;
    public void registerSymbolID(String name, String id) {
        if (customIDMap == null) {
            customIDMap = new HashMap<String, String>();
        }
        customIDMap.put(name, id);
    }
    
    public String getSymbolID(String name) {
        if (name != null) {
            if (idmap.containsKey(name)) {
                return idmap.getString(name);
            } else if (customIDMap != null && customIDMap.containsKey(name)) {
                return customIDMap.get(name);
            }
        }
        return null;
    }
    public String createSymbolID(String sourceID) {
        // custom layout
        return XMLSymbol.getInstance().getUniqueID(sourceID);
    }
    
    /*
     * send newly created layout to InputMethod server with invoking
     * external program (in iiim case, it's 'iiimx-settings-properties'
     * which read saved *.vkx file and send them to iiimd
     */
    private void sendToServer() {
        Runtime runtime = Runtime.getRuntime();
        String[] command = Main.getSendLayoutCommand();
        try {
            runtime.exec(command);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    // called from LayoutListEditor
    public void saveNonUseUserLayoutList(java.util.List<Symbol> list) {
        XMLCustomLayoutManager.getInstance().saveNonUseList(list);
        Main.getSymbolCollection().updateSymbolSet();
        ControlPanel.getInstance().updateSymbols();
    }
    
    // add new layout to ControlPanel symbol list and
    // replace current Symbol with new Symbol which has new id
    private void updateSymbolInfo(String newLayoutName, KeyViewSet keyViewSet) {
        String sourceName = keyViewSet.getSymbolName();
        String src_id = getSymbolID(sourceName);
        String id = createSymbolID(src_id);
        TmpSymbol symbol = new TmpSymbol(newLayoutName, keyViewSet.getKeyMap(), id);
        //ControlPanel.getInstance().addSymbolToUI(symbol);
        currentFrame.changeSymbol(symbol);
        manager.setCurrentSymbol(symbol);
    }

    public FrameStyle getFrameStyle() {
        return fsManager.getFrameStyle();
    }
    public void setFrameStyle(FrameStyle style) {
        fsManager.setFrameStyle(style);
    }
    /* 
     * Create New virtual keyboar frame
     */ 
    public KeyboardFrame newKeyboardFrame() {
        return fsManager.newKeyboardFrame();
    }
    
    public KeyboardFrame newKeyboardFrame(int x, int y) {
        return fsManager.newKeyboardFrame(x, y);
    }
    
    public KeyboardFrame newKeyboardFrame(FrameStyle style) {
        return fsManager.newKeyboardFrame(style);
    }

    public KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym) {
        return fsManager.newKeyboardFrame(geom, sym);
    }

    public KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym, int x, int y) {
        return fsManager.newKeyboardFrame(geom, sym, x, y);
    }
    
    public KeyboardFrame newKeyboardFrame(Geometry geom, Symbol sym, int x, int y, float scale_x, float scale_y) {
        return fsManager.newKeyboardFrame(geom, sym, x, y, scale_x, scale_y);
    }
    
    public KeyboardFrame newKeyboardFrame (FrameStyle style, Geometry geom, Symbol sym) {
        return fsManager.newKeyboardFrame(style, geom, sym);
    }

    /*
     * Create Edit keyboard frame
     */
    public EditKeyboardFrame newEditFrame () {
        KeyboardFrameCommonData cdata = new KeyboardFrameCommonData(getCurrentGeometry(), getCurrentSymbol());
        return new EditKeyboardFrame(cdata);
    }
    
    public void removeKeyboardFrame(KeyboardFrame frame) {
        fsManager.removeKeyboardFrame(frame);
    }
    public void setTabTitle(TabKeyboardFrame frame, int id, String title) {
        fsManager.setTabTitle(frame, id, title);
    }

    public void exitVKB() {
        if (kbdSet.size() > 0) {
            Prefs.setKeyboardFrames(kbdSet);
        }
        if (controlPanel.isVisible()) {
            controlPanel.recordPos(); // for position saving
        }
        fsManager.recordMainFrameRectangle();
        if (imInterface != null) {
            imInterface.resetSyncKeyboard();
        }
        System.exit(0);
    }

    public void invokeHelp() {
        Help.invokeHelp();
        /*
        if (imInterface != null) {
            imInterface.invokeNativeHelp();
        }*/
    }
}
