/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.geom.*;
import com.sun.g11n.vkb.sym.*;
import static com.sun.g11n.vkb.Main.error;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.*;
import java.util.prefs.*;


/**
 *
 * @author naoyuki
 */
public class Prefs {

    // supported user prefereces:
    //     - geometry:symbol list for Show Keyboard menu
    //     - geometry
    //     - symbol
    //     - frame style
    //     - frame list (x, y, scale_x, scale_y)
    //     - control panel visibility
    //     - control panel position
    //     - tooltip enabled
    //     
    private static Preferences prefs;
    static {
        prefs = Preferences.userNodeForPackage(Prefs.class);
    }
    
    public static void setShowKeyboardList(List<KeyboardDescription> list) {
        StringBuffer sbuf = new StringBuffer();
        for (KeyboardDescription desc : list) {
            Geometry geom = desc.getGeometry();
            Symbol sym = desc.getSymbol();
            sbuf.append(geom.getDescription());
            sbuf.append(LIST_DELIMITER);
            sbuf.append(sym.getDescription());
            sbuf.append(LIST_DELIMITER);
        }
        
        prefs.put(SHOW_KBD_LIST, sbuf.toString());
    }

    /*
     * if artument description is already in SHOW_KBD_LIST, then no action
     * and returns false, otherwise add desc and return true
     */
    public static boolean addShowKeyboardList(KeyboardDescription item) {
        String current = prefs.get(SHOW_KBD_LIST, "");
        
        String name = item.getDescription();
        String geomName = item.getGeometry().getDescription();
        String symName = item.getSymbol().getDescription();
        String itemStr;
        if (!name.equals(symName + " - " + geomName)) {
            itemStr = name + LIST_DELIMITER + geomName + LIST_DELIMITER2 + symName;
        } else {
            itemStr = item.getGeometry().getDescription() + LIST_DELIMITER + item.getSymbol().getDescription();
        }
        if (current.contains(itemStr)) {
            return false;
        }
        String newList = current + itemStr + LIST_DELIMITER;
        prefs.put(SHOW_KBD_LIST, newList);
        return true;
    }
    /*
     * if argument description is in SHOW_KBD_LIST, then delete it
     * and retruns true, otherwise no action and retruns false
     */
    public static boolean delShowKeyboardList(KeyboardDescription item) {
        String current = prefs.get(SHOW_KBD_LIST, "");
        String itemStr = item.getGeometry().getDescription() + LIST_DELIMITER + item.getSymbol().getDescription() + LIST_DELIMITER;
        int start = current.indexOf(itemStr);
        if (start == -1) {
            return false;
        }
        String pre = current.substring(0, start);
        String post = current.substring(start + itemStr.length());
        prefs.put(SHOW_KBD_LIST, pre + post);
        return true;
    }

    public static boolean isKeyboardSaved(KeyboardDescription desc) {
        String savedStr = prefs.get(SHOW_KBD_LIST, "");
        String descStr = desc.getGeometry().getDescription() + LIST_DELIMITER + desc.getSymbol().getDescription() + LIST_DELIMITER;
        return savedStr.contains(descStr);
    }
    public static List<KeyboardDescription> getShowKeyboardList() {
        List<KeyboardDescription> list = new ArrayList<KeyboardDescription>();
        String descStr = prefs.get(SHOW_KBD_LIST, "");
        GeometryCollection geomCol = Main.getGeometryCollection();
        SymbolCollection symCol = Main.getSymbolCollection();
        if (descStr != null && descStr.indexOf(LIST_DELIMITER) != -1) {
            String[] items = descStr.split(LIST_DELIMITER);
            for (int i = 0, len = items.length; i < len; i += 2) {
                if (items[i + 1].contains(LIST_DELIMITER2)) {
                    String name = items[i];
                    String[] items2 = items[i + 1].split(LIST_DELIMITER2);
                    Geometry geom = geomCol.getGeometryByName(items2[0]);
                    Symbol sym = symCol.getSymbolByName(items2[1]);
                    if (geom == null || sym == null) {
                        list.clear();
                        break;
                    }
                    list.add(new KeyboardDescription(name, geom, sym));
                } else {
                    Geometry geom = geomCol.getGeometryByName(items[i]);
                    Symbol sym = symCol.getSymbolByName(items[i + 1]);
                    if (geom == null || sym == null) {
                        list.clear();
                        break;
                    }
                    list.add(new KeyboardDescription(geom, sym));
                }
            }
        }
        
        if (list.isEmpty()) {
            // come here at the first time
            String geomStr = Main.getDefaultGeometryName();
            String symStr = Main.getDefaultSymbolName();
            Geometry geom = geomCol.getGeometryByName(geomStr);
            Symbol sym = symCol.getSymbolByName(symStr);
            list.add(new KeyboardDescription(geom, sym));
            prefs.put(SHOW_KBD_LIST, geomStr + LIST_DELIMITER + symStr + LIST_DELIMITER);
        }
        return list;
    }
    
    // Active Frame list
    public static void setKeyboardFrames(Set<KeyboardFrame> kbdSet) {
        StringBuffer sbuf = new StringBuffer();
        for (KeyboardFrame frame : kbdSet) {
            KeyboardFrameCommonData cdata = frame.getCommonData();
            Geometry geom = cdata.getGeometry();
            Symbol sym = cdata.getSymbol();            
            sbuf.append(geom.getDescription());
            sbuf.append(LIST_DELIMITER);
            sbuf.append(sym.getDescription());
            if (frame.isTarget()) {
                sbuf.append(TARGET_MARK);
            }
            sbuf.append(LIST_DELIMITER);
            sbuf.append(frame.getSavingPosScale());
            sbuf.append(LIST_DELIMITER);
        }
        prefs.put(FRAME_LIST, sbuf.toString());
    }
    
    public static Set<KeyboardFrame> getKeyboardFrames() {
        VKBManager manager = VKBManager.getInstance();
        Set<KeyboardFrame> kbdSet = new HashSet<KeyboardFrame>();
        String frameStr = prefs.get(FRAME_LIST, "");
        KeyboardFrame targetFrame = null;
        boolean target = false;
        if (frameStr != null && frameStr.length() > 10) {
            GeometryCollection geomCol = Main.getGeometryCollection();
            SymbolCollection symCol = Main.getSymbolCollection();
            String[] items = frameStr.split(LIST_DELIMITER);
            if ((items.length % 3) != 0) {
                // items must consists of the geometry and symbol pairs
                return kbdSet; // return null set
            }
            for (int i = 0, len = items.length; i < len; i += 3) {
                Geometry geometry = geomCol.getGeometryByName(items[i]);
                if (geometry == null) {
                    geometry = geomCol.getGeometryByName(Main.getDefaultGeometryName());
                    if (geometry == null) {
                        error(" no default geometry data.");
                    }
                }
                String symName = items[i + 1];
                if (symName.endsWith(TARGET_MARK)) {
                    target = true;
                    symName = symName.substring(0, symName.lastIndexOf(TARGET_MARK));
                }
                Symbol symbol = symCol.getSymbolByName(symName);
                if (symbol == null) {
                    // ignore no existing symbol keyboard
                    continue;
                }
                PosScale posScale = new PosScale(items[i + 2]);
                float scaleX, scaleY;
                if (Main.getKeepScale()) {
                    scaleX = posScale.getScaleX();
                    scaleY = posScale.getScaleY();
                } else {
                    scaleX = scaleY = -1;
                }
                KeyboardFrame kframe = manager.newKeyboardFrame(geometry, symbol, 
                        posScale.getX(), posScale.getY(), scaleX, scaleY);
                manager.setCurrentGeometry(geometry);
                manager.setCurrentSymbol(symbol);
                if (target) {
                    targetFrame = kframe;
                }
                kbdSet.add(kframe);
                target = false;
            }
        }
        if (targetFrame != null) {
            manager.setFocused(targetFrame);
        }
        return kbdSet;
    }
    
    private static class PosScale {
        private int x;
        private int y;
        private float scale_x;
        private float scale_y;
        
        PosScale(String info) {
            // format must be "[x/y - scale_x/scale_y]"
            // abbreviate format error checking
            x = y = 0;
            scale_x = scale_y = Main.getDefaultScaleFactor();
            try {
                info = info.trim();
                int id = info.indexOf("/");
                x = Integer.parseInt(info.substring(1, id));
                int id2 = info.indexOf(" - ", id + 1);
                y = Integer.parseInt(info.substring(id + 1, id2));
                id = info.indexOf("/", id2 + 3);
                scale_x = Float.parseFloat(info.substring(id2 + 3, id));
                id2 = info.indexOf("]", id + 1);
                scale_y = Float.parseFloat(info.substring(id + 1, id2));
            } catch(Exception e) {
                e.printStackTrace();
            }
        }
        int getX() {
            return x;
        }
        int getY() {
            return y;
        }
        float getScaleX() {
            return scale_x;
        }
        float getScaleY() {
            return scale_y;
        }
    }

    // Geometry
    public static void setGeometry(Geometry geom) {
        prefs.put(GEOMETRY, geom.getDescription());
    }
    public static String getGeometry() {
        return prefs.get(GEOMETRY, Main.getDefaultGeometryName());
    }
    // Symbol
    public static void setSymbol(Symbol sym) {
        prefs.put(SYMBOL, sym.getDescription());
    }
    public static String getSymbol() {
        return prefs.get(SYMBOL, Main.getDefaultSymbolName());
    }
    // Frame Style
    public static void setFrameStyle(FrameStyle style) {
        prefs.putInt(FRAME_STYLE, style.toInt());
    }
    public static FrameStyle getFrameStyle() {
        int fs = prefs.getInt(FRAME_STYLE, Main.getDefaultFrameStyle().toInt());
        return FrameStyle.fromInt(fs);
    }
    // Control Panel
    public static void setControlPanelVisibility(boolean visible) {
        prefs.putBoolean(CONTROL_PANEL, visible);
    }
    public static boolean getControlPanelVisibility() {
        return prefs.getBoolean(CONTROL_PANEL, Main.getDefaultControlPanelVisibility());
    }
    public static void setMainFrameRectangle(int x, int y, int width, int height) {
        prefs.putInt(MAINFRAME_X, x);
        prefs.putInt(MAINFRAME_Y, y);
        prefs.putInt(MAINFRAME_W, width);
        prefs.putInt(MAINFRAME_H, height);
    }
    public static Rectangle getMainFrameRectangle() {
        return new Rectangle(prefs.getInt(MAINFRAME_X, 0), prefs.getInt(MAINFRAME_Y, 0),
                prefs.getInt(MAINFRAME_W, 200), prefs.getInt(MAINFRAME_H, 70));
    }
    // Control Panel position
    public static void setControlPanelPosition(int x, int y) {
        prefs.putInt(CONTROL_POS_X, x);
        prefs.putInt(CONTROL_POS_Y, y);
    }
    public static Point getControlPanelPosition() {
        return new Point(prefs.getInt(CONTROL_POS_X, 0), prefs.getInt(CONTROL_POS_Y, 0));
    }
    // Tooltip
    public static void setTooltipEnabled(boolean tooltip) {
        prefs.putBoolean(TOOLTIP, tooltip);
    }
    public static boolean getTooltipEnabled() {
        return prefs.getBoolean(TOOLTIP, Main.getDefaultTooltipEnabled());
    }

    // syncronization
    public static void setIMSync(boolean sync) {
        prefs.putBoolean(SYNC, sync);
    }
    public static boolean getIMSync() {
        return prefs.getBoolean(SYNC, Main.getDefaultSyncMode());
    }

    // multiple keyboards support
    public static void setMultiKBDSupport(boolean multi) {
        prefs.putBoolean(MULTI, multi);
    }
    public static boolean getMultiKBDSupport() {
        return prefs.getBoolean(MULTI, false);
    }

    private static final String FRAME_LIST = "vkb.frame_list";
    private static final String GEOMETRY = "vkb.geometry";
    private static final String SYMBOL = "vkb.symbol";
    private static final String FRAME_STYLE = "vkb.frame_style";
    private static final String CONTROL_PANEL = "vkb.control_panel";
    private static final String CONTROL_POS_X = "vkb.control_panel.pos_x";
    private static final String CONTROL_POS_Y = "vkb.control_panel.pos_y";
    private static final String MAINFRAME_X = "vkb.mainframe.x";
    private static final String MAINFRAME_Y = "vkb.mainframe.y";
    private static final String MAINFRAME_W = "vkb.mainframe.w";
    private static final String MAINFRAME_H = "vkb.mainframe.h";    
    private static final String TOOLTIP = "vkb.tooltip";
    private static final String SYNC = "vkb.sync";
    private static final String MULTI = "vkb.multi";
    private static final String SHOW_KBD_LIST = "vkb.show_kbd_list";
    
    // string which will never be in symbol or geometry name
    private static final String LIST_DELIMITER = ",";
    private static final String LIST_DELIMITER2= "\t";
    private static final String TARGET_MARK = "@@@@";
    
    // default preferennce
    
}
