/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.geom.Geometry;
import com.sun.g11n.vkb.sym.Symbol;

/**
 *
 * @author naoyuki
 */
public class KeyboardFrameCommonData {
    private KeyboardLayout kbdLayout;
    private Geometry geometry;
    private Symbol symbol;
    private boolean resize;
    private KeyCanvas canvas;
    private int width;
    private int height;
    private KeyCanvasResizeListener resizeListener;
    private String kbdTitle;
    private boolean target;
    
    public Geometry getGeometry() {
        return geometry;
    }
    public Symbol getSymbol() {
        return symbol;
    }
    public void replaceSymbol(Symbol symbol) {
        this.symbol = symbol;
    }
    public boolean isResizable() {
        return resize;
    }
    public KeyCanvas getKeyCanvas() {
        return canvas;
    }
    public int getWidth() {
        return width;
    }
    public int getHeight() {
        return height;
    }
    public KeyCanvasResizeListener getResizeListener() {
        return resizeListener;
    }
    public String getKBDTitle() {
        return kbdTitle;
    }
    public void setKBDTitle(String title) {
        kbdTitle = title;
    }
    public boolean isTarget() {
        return target;
    }
    public void setTarget(boolean target) {
        this.target = target;
    }
    public void setScale(float scale_x, float scale_y) {
        width = (int)(kbdLayout.getWidth() * scale_x);
        height = (int)(kbdLayout.getHeight() * scale_y) + 50;
    }

    public KeyboardFrameCommonData(Geometry geom, Symbol sym) {
        geometry = geom;
        symbol = sym;
        kbdLayout = new KeyboardLayout(geom, sym);
        resize = Main.getDefaultResizable();
        canvas = new KeyCanvas(kbdLayout);
        kbdTitle = sym.getDescription() + " - " + geom.getDescription();
        canvas.setScale(geom.getScale(), geom.getScale());
        width = (int)(kbdLayout.getWidth() * geom.getScale());
        height = (int)(kbdLayout.getHeight() * geom.getScale()) + 50;
        resizeListener = new KeyCanvasResizeListener(canvas, width, height);
        target = false;
    }
}
