/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.util.*;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

/**
 *
 * @author naoyuki
 */

/*
 * Each key location which may be modified in Design mode is managed by this class.
 * This class instance exists per KeyboardLayout.
 */
public class KeyViewSet {

    private Map<String, KeyView> viewMap;
    private String symName;
    private String geomName;

    // modified indicates wether the contents is modified in design mode
    
    public void setSymbolName(String name) {
        symName = name;
    }
    public String getSymbolName() {
        return symName;
    }
    public void setGeometryName(String name) {
        geomName = name;
    }
    public String getGeometryName() {
        return geomName;
    }
    
    public KeyViewSet(String geomName, String symName) {
        viewMap = new HashMap<String, KeyView>();
        this.geomName = geomName;
        this.symName = symName;
    }
    
    public void add(String label, KeyView view) {
        viewMap.put(label, view);
    }
    
    public Collection<KeyView> getKeyViews() {
        return viewMap.values();
    }
    
    public Map<String, KeyModel> getKeyMap() {
        HashMap<String, KeyModel> map = new HashMap<String, KeyModel>();
        for (KeyView view : viewMap.values()) {
            KeyModel model = view.getModel();
            map.put(model.getName(), model);
        }
        return map;
    }
    
    public KeyModel findModel(String name) {
        KeyView view = viewMap.get(name);
        if (view == null) {
            return null;
        }
        return view.getModel();
    }
    /*
     * return KeyView which has KeyModel model
     * but other that argument view.
     * This method is used by KeyView to handle identical 
     * key handling (like Right Shift and Left Shift.
     */    
    public KeyView findAnotherView(KeyView view, KeyModel model) {
        Collection<KeyView> views = viewMap.values();
        for (KeyView key : views) {
            if (view == key) {
                continue;
            }
            KeyModel keyModel = key.getModel();
            if (keyModel == model) {
                return key;
            }
        }
        return null;
    }
    
    /*
     * Draw all of KeyView in this set
     */
    public void draw(Graphics2D g2) {
        Collection<KeyView> views = viewMap.values();
        for (KeyView view : views) {
            view.draw(g2);
        }
    }
    
    /*
     * find KeyView which is drawn on point 'p'
     */
    public KeyView findSelectKeyView(Point2D p) {
        Collection<KeyView> views = viewMap.values();
        for (KeyView view : views) {
            if (view.contains(p)) {
                return view;
            }
        }
        return null;
    }

    public KeyView findSelectKeyView(Point2D p, boolean charOnly) {
        KeyView view = findSelectKeyView(p);
        if (charOnly && view != null) {
            KeyModel model = view.getModel();
            if (model == null || !model.isCharacter()) {
                return null;
            }
        }
        return view;
    }
    
    /*
     * Swap KeyModel of target and source
     */
    public void adjust(KeyView sourceView, float x, float y) {
        KeyModel sourceModel = sourceView.getModel();
       
        Set<Map.Entry<String, KeyView>> entries = viewMap.entrySet();
        for (Map.Entry<String, KeyView> entry : entries) {
            KeyView view = entry.getValue();
            if (view.contains(x, y)) {
                KeyModel model = view.getModel();
                view.setModel(sourceModel);
                sourceView.setModel(model);
                return;
            }
        }
    }
}
