/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;

import java.awt.dnd.*;
import java.awt.datatransfer.*;

/**
 *
 * @author naoyuki
 */
public class KeyCanvas extends JPanel {

    private Image offImage;
    KeyViewSet keyViewSet;
    private boolean inDesign;
    private boolean isModifiable;
    private ContextMenu popup;
    private boolean modified;
    private static VKBManager manager;

    KeyViewSet getKeyViewSet() {
        return keyViewSet;
    }

    private KeyboardLayout layout;

    @Override public int getWidth() {
        return (int)(layout.getWidth() * scale_x);
    }
    @Override public int getHeight() {
        return (int)(layout.getHeight() * scale_y) + 20;
    }
    @Override public Dimension getSize() {
        return new Dimension(getWidth(), getHeight());
    }
    @Override public Dimension getPreferredSize() {
        return getSize();
    }
    @Override public Dimension getMinimumSize() {
        return getSize();
    }

    private float scale_x = (float)1.0;
    private float scale_y = (float)1.0;
    void setScale(float scale_x, float scale_y) {
        this.scale_x = scale_x;
        this.scale_y = scale_y;
        reset();
        repaint();
    }
    float getScaleX() {
        return scale_x;
    }
    float getScaleY() {
        return scale_y;
    }
    /* reverse scale point */
    private Point2D RSP(Point2D p) {
        Point2D p2 = new Point2D.Float((float)p.getX() / scale_x, (float)p.getY() / scale_y);
        return p2;
    }

    private void reset() {
        offImage = null;
    }

    @Override public void paint(Graphics g) {
        if (keyViewSet == null) {
            return;
        } 

        Dimension d = getSize();
        checkOffscreenImage();
        Graphics off_g = offImage.getGraphics();
        off_g.setColor(backColor);
        off_g.fillRect(0, 0, d.width, d.height);
        off_g.setColor(getForeground());
        Graphics2D g2 = (Graphics2D) off_g;
        g2.scale(scale_x, scale_y);

        keyViewSet.draw(g2);

        // dragging key should be always top of other keys        
        if (selectKey != null) {
            selectKey.draw(g2);
        }
        g.drawImage(offImage, 0, 0, null);

        //g.setColor(Color.RED);
        //g.drawRect(5, 5, d.width - 10, d.height - 10);
    }

    private void checkOffscreenImage() {
        if (offImage == null) {
            Dimension d = getSize();
            offImage = createImage(d.width, d.height);
        }
    }

    @Override public void update(Graphics g) {
        paint(g);
    }

    private DesignMouseListener designMouseListener;
    private InputMouseListener inputMouseListener;
    private DragSource dragSource;
    private Image dragImage;
    private Color normalBackColor;
    private Color editableBackColor;
    private Color backColor;
    public KeyCanvas(KeyboardLayout layout) {
        enableInputMethods(false);
        this.layout = layout;
        if (Main.getShowAllSection()) {
            keyViewSet = layout.setupKeyView2();
        } else {
            keyViewSet = layout.setupKeyView();
        }
        createUI();
        if (manager == null) {
            manager = VKBManager.getInstance();
        }
        inDesign = false;
        backColor = normalBackColor = getBackground();
        editableBackColor = normalBackColor.brighter();
        designMouseListener = new DesignMouseListener();
        inputMouseListener = new InputMouseListener();
        
        addMouseListener(inputMouseListener);
        addMouseMotionListener(inputMouseListener);

        // DnD staff
        dragSource = new DragSource();
        DragSourceListener sourceImpl = new DragSourceImpl();
        DropTargetImpl target = new DropTargetImpl();
        new DropTarget(this, target);
        DragGestureImpl gesture = new DragGestureImpl(null, sourceImpl);
        dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_COPY_OR_MOVE, gesture);
        
        modified = false;
    }
    
    public boolean isModified() {
        return modified;
    }
    
    public void setDesignMode(boolean design) {
        inDesign = design;
        changeMouseListener(inDesign);
    }
    
    public boolean isDesignMode() {
        return inDesign;
    }
    
    public void setModifiable(boolean mod) {
        isModifiable = mod;
        backColor = mod ? editableBackColor : normalBackColor;
        
        repaint();
    }
    
    public boolean isModifiable() {
        return isModifiable;
    }
    
    private void changeMouseListener(boolean design) {
        if (design) {
            removeMouseListener(inputMouseListener);
            removeMouseMotionListener(inputMouseListener);
            addMouseListener(designMouseListener);
            addMouseMotionListener(designMouseListener);
        } else {
            removeMouseListener(designMouseListener);
            removeMouseMotionListener(designMouseListener);
            addMouseListener(inputMouseListener);
            addMouseMotionListener(inputMouseListener);
        }
    }

    protected void createUI() {
        center();
    }

    public void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        setLocation(x, y);
    }
    private KeyView selectKey;
    private float offsetX;
    private float offsetY;
    
    private boolean ownDnD = false;
    
    private boolean checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (popup == null) {
                popup = ContextMenu.getInstance();
            }
            popup.show(this, e.getX(), e.getY());
            return true;
        }
        return false;
    }
    
    public KeyView getKeyView(Point p) {
        return keyViewSet.findSelectKeyView(RSP(p));
    }
    
    // invoke KeyEditor for specific point Key
    private static int KE_OFFSET_X = 30;
    private static int KE_OFFSET_Y = 30;
    public void invokeKeyEditor(Point p) {
        KeyView view = keyViewSet.findSelectKeyView(RSP(p));
        if (view != null) {
            KeyModel model = view.getModel();
            // only character keys can be modified
            if (model == null || !model.isCharacter()) {
                return;
            }

            KeyEditor keyEditor = KeyEditor.getInstance();
            keyEditor.setKeyView(view);
            EditKeyboardFrame target = manager.getEditKeyboardFrame();
            p.translate(KE_OFFSET_X, KE_OFFSET_Y);
            if (target != null) {
                Point p2 = target.getLocation();
                p.translate((int)p2.getX(), (int)p2.getY());
            }
            keyEditor.setLocation(p);
            keyEditor.setVisible(true);
        }
    }
    
    private class DesignMouseListener implements MouseListener, MouseMotionListener {
        @Override public void mouseClicked(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            if (isModifiable && e.getClickCount() > 1) {
                invokeKeyEditor(e.getPoint());
            }
        }
        @Override public void mouseEntered(MouseEvent e) {
            
        }
        @Override public void mouseExited(MouseEvent e) {
            
        }
        @Override public void mousePressed(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            selectKey = null;
            Point2D sp = RSP(e.getPoint());
            selectKey = keyViewSet.findSelectKeyView(sp, true); // find character key only
            if (selectKey == null) {
                return;
            }
            KeyModel model = selectKey.getModel();
            if (model == null || !model.isCharacter()) {
                selectKey = null;
                return;
            }

            if (ownDnD) {
                selectKey.setupSurface();
                selectKey.setDrag(true);
                offsetX = (float) (sp.getX() - selectKey.getX());
                offsetY = (float) (sp.getY() - selectKey.getY());
                repaint();
            }
        }
        @Override public void mouseReleased(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            Point2D sp = RSP(e.getPoint());
            if (selectKey != null && ownDnD) {
                selectKey.dragShadow((float) sp.getX() - offsetX, (float) sp.getY() - offsetY);
                selectKey.setDrag(false);
                keyViewSet.adjust(selectKey, (float) sp.getX(), (float) sp.getY());
                repaint();
            }
        }
        @Override public void mouseDragged(MouseEvent e) {
            Point2D sp = RSP(e.getPoint());
            if(selectKey != null && ownDnD) {
                selectKey.dragShadow((float)sp.getX() - offsetX, (float)sp.getY() - offsetY);
                repaint();
            }
        }
        @Override public void mouseMoved(MouseEvent e) {
        }
    }
    private class InputMouseListener implements MouseListener, MouseMotionListener {
        private KeyView tooltipTarget;
        @Override public void mouseClicked(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            if (selectKey != null) {
                selectKey.clicked();
            }
        }
        @Override public void mouseEntered(MouseEvent e) {
            if (manager.tooltip()) {
                Point2D sp = RSP(e.getPoint());
                tooltipTarget = keyViewSet.findSelectKeyView(sp);
                if (tooltipTarget != null) {
                    KeyModel m = tooltipTarget.getModel();
                    setToolTipText(m.getLabel());
                }
            }
        }

        @Override public void mouseMoved(MouseEvent e) {
            if (manager.tooltip()) {
                Point2D sp = RSP(e.getPoint());
                KeyView target = keyViewSet.findSelectKeyView(sp);
                if (target == null) {
                    setToolTipText(null);
                } else if (target != tooltipTarget) {
                    KeyModel m = target.getModel();
                    setToolTipText(m.getLabel());
                }
                tooltipTarget = target;
            }
        } 
        @Override public void mouseExited(MouseEvent e) {
            
        }
        @Override public void mousePressed(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            selectKey = null;
            Point2D sp = RSP(e.getPoint());
            selectKey = keyViewSet.findSelectKeyView(sp);
            if (selectKey != null) {
                selectKey.pressed();
                selectKey.setupSurface();
                repaint();
            }
        }
        @Override public void mouseReleased(MouseEvent e) {
            if (checkPopup(e)) {
                return;
            }
            if (selectKey != null) {
                selectKey.released();
                selectKey.setupSurface();
                repaint();
            }
            
        }
        @Override public void mouseDragged(MouseEvent e) {
            
        }

    }
    
    private class DragGestureImpl implements DragGestureListener {
        private Cursor cursor;
        private DragSourceListener sourceListener;
        
        DragGestureImpl(Cursor cursor, DragSourceListener sourceListener) {
            this.cursor = cursor;
            this.sourceListener = sourceListener;
        }
        @Override public void dragGestureRecognized(DragGestureEvent e) {
            if (inDesign) {
                KeyView view = keyViewSet.findSelectKeyView(RSP(e.getDragOrigin()));
                if (view == null) {
                    return;
                }
                KeyModel model = view.getModel();
                if (dragImage == null) {
                    dragImage = createImage((int)view.getWidth(), (int)view.getHeight());
                }
                view.fillDragImage(dragImage);
                e.startDrag(cursor, dragImage, new Point(0, 0), (Transferable) model, sourceListener);
            }
        }
    }

    private static class DragSourceImpl implements DragSourceListener {
        DragSourceImpl() {}
        @Override public void dragDropEnd(DragSourceDropEvent e) {
        }
        @Override public void dragEnter(DragSourceDragEvent e) {
        }
        @Override public void dragExit(DragSourceEvent e) {
        }
        @Override public void dragOver(DragSourceDragEvent e) {
        }
        @Override public void dropActionChanged(DragSourceDragEvent e) {
        }        
    }
    private static DataFlavor modelData;
    static {
        try {
            modelData = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    private class DropTargetImpl implements DropTargetListener {
        @Override public void dragEnter(DropTargetDragEvent e) {
        }
        @Override public void dragExit(DropTargetEvent e) {}
        @Override public void dragOver(DropTargetDragEvent e) {
            Point p = e.getLocation();
        }
        @Override public void dropActionChanged(DropTargetDragEvent e) {}
        @Override public void drop(DropTargetDropEvent e) {
            if (!isModifiable()) {
                // The last focused frame at design mode is set is the
                // only modifiable frame. Other frames can be used as 
                // drag source while design mode is on.
                return;
            }
            e.acceptDrop(e.getDropAction());
            try {
                Object source = e.getTransferable().getTransferData(modelData);
                KeyModel model = (KeyModel)source;
                
                KeyView droppedView = keyViewSet.findSelectKeyView(RSP(e.getLocation()));
                if (model == null || droppedView == null || selectKey == null)
                    return;
                KeyModel droppedModel = droppedView.getModel();
                KeyboardLayout fromKL = model.getLayout();
                KeyboardLayout toKL = droppedModel.getLayout();
                
                String srcName = model.getName();
                String tgtName = droppedModel.getName();
                KeyModel.Type srcType = model.getType();
                KeyModel.Type tgtType = model.getType();
                if (fromKL == toKL) {
                    // swap
                    model.setName(tgtName);
                    model.setType(tgtType);
                    droppedModel.setName(srcName);
                    droppedModel.setType(srcType);
                    droppedView.setModel(model);
                    selectKey.setModel(droppedModel);
                    droppedView.setModified(true);
                    selectKey.setModified(true);
                } else {
                    // just replace
                    KeyModel copyModel = model.copy();
                    copyModel.setName(tgtName);
                    copyModel.setLayout(toKL);
                    droppedView.setModel(copyModel);
                    droppedView.setModified(true);
                }
                modified = true;
                repaint();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }        
    }
}
