/*
Copyright 1990-2008 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import static com.sun.g11n.vkb.L10N.*;

/**
 *
 * @author naoyuki
 */
public enum FrameStyle {
    SINGLE_FRAME, MULTIPLE_FRAME, INTERNAL_FRAME, TAB_FRAME;
  
    @Override public String toString() {
        switch (this) {
            case SINGLE_FRAME:
                return _("vkb.single_frame");
            case MULTIPLE_FRAME:
                return _("vkb.multiple_frame");
            case INTERNAL_FRAME:
                return _("vkb.internal_frame");
            case TAB_FRAME:
                return _("vkb.tab_frame");
        }
        return "Unknown";
    }
    
    public int toInt() {
        switch(this) {
            case SINGLE_FRAME:
                return SINGLE_INT;
            case MULTIPLE_FRAME:
                return MULTIPLE_INT;
            case INTERNAL_FRAME:
                return INTERNAL_INT;
            case TAB_FRAME:
                return TAB_INT;
        }
        return SINGLE_INT;
    }
    public static FrameStyle fromInt(int i) {
        switch(i) {
            case SINGLE_INT:
                return SINGLE_FRAME;
            case MULTIPLE_INT:
                return MULTIPLE_FRAME;
            case INTERNAL_INT:
                return INTERNAL_FRAME;
            case TAB_INT:
                return TAB_FRAME;
        }
        return SINGLE_FRAME;
    }
    private static final int SINGLE_INT = 0;
    private static final int MULTIPLE_INT = 1;
    private static final int INTERNAL_INT = 2;
    private static final int TAB_INT = 3;
}
