/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.g11n.vkb;

import com.sun.g11n.vkb.sym.Symbol;
import static com.sun.g11n.vkb.L10N._;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @author naoyuki
 */
public class EditKeyboardFrame extends JFrame implements ActionListener {
    private KeyboardFrameCommonData cdata;
    JButton saveButton, saveAsButton, cancelButton;
    private KeyCanvas canvas;

    public EditKeyboardFrame(KeyboardFrameCommonData cdata) {
        super(cdata.getKBDTitle() + " : " + _("vkb.edit_window.title"));
        this.cdata = cdata;

        JPanel buttonPanel = new JPanel();
        saveButton = new JButton(_("vkb.edit_window.save"));
        saveAsButton = new JButton(_("vkb.edit_window.save_as"));
        cancelButton = new JButton(_("vkb.edit_window.cancel"));
        buttonPanel.add(saveButton);
        buttonPanel.add(saveAsButton);
        buttonPanel.add(cancelButton);
        saveButton.addActionListener(this);
        saveAsButton.addActionListener(this);
        cancelButton.addActionListener(this);

        Symbol symbol = cdata.getSymbol();
        // pre-defined symbol can not be overriden
        // only Save As is activated.
        saveButton.setEnabled(!symbol.isPredefined());

        KeyCanvas cv = cdata.getKeyCanvas();
        this.canvas = cv;
        canvas.setDesignMode(true);
        canvas.setModifiable(true);
        getContentPane().add(canvas, BorderLayout.CENTER);
        getContentPane().add(buttonPanel, BorderLayout.SOUTH);
        pack();
        setVisible(true);
        //setCanvasResizable(cdata.isResizable());
        VKBManager.getInstance().setEditKeyboardFrame(this);
    }

    public KeyCanvas getCanvas() {
        return canvas;
    }

    public KeyboardFrameCommonData getCommonData() {
        return cdata;
    }

    private void setCanvasResizable(boolean resize) {
        KeyCanvasResizeListener resizeListener = cdata.getResizeListener();
        if (resize && resizeListener != null) {
            addComponentListener(resizeListener);
        } else if (!resize && resizeListener != null) {
            removeComponentListener(resizeListener);
        }
    }

    @Override public void actionPerformed(ActionEvent ae) {
        Object c = ae.getSource();
        if (c == saveButton) {
            VKBManager.getInstance().saveCurrentLayout(cdata.getSymbol().getDescription(), false);
        } else if (c == saveAsButton) {
            LayoutSaveDialog lsd = new LayoutSaveDialog(this, true);
            lsd.setVisible(true);
        } else if (c == cancelButton) {
            // through to dispose();
        }
        dispose();
    }
}
