/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DeleteCustomSymbol.java
 *
 * Created on Mar 13, 2009, 4:04:05 PM
 */

package com.sun.g11n.vkb;

import java.util.*;
import java.text.MessageFormat;
import javax.swing.*;
import com.sun.g11n.vkb.sym.*;
import static com.sun.g11n.vkb.L10N._;
/**
 *
 * @author naoyuki
 */
public class DeleteCustomSymbol extends javax.swing.JDialog {

    /** Creates new form DeleteCustomSymbol */
    public DeleteCustomSymbol(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setupCustomSymbolList();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        customSymbolList = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        deleteButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("com/sun/g11n/vkb/vkb-message"); // NOI18N
        setTitle(bundle.getString("vkb.delete_custom_symbol.title")); // NOI18N

        jScrollPane1.setViewportView(customSymbolList);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 228, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 201, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        deleteButton.setText(bundle.getString("vkb.delete_custom_symbol.delete")); // NOI18N
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                symbolDelete(evt);
            }
        });

        cancelButton.setText(bundle.getString("vkb.delete_custom_symbol.cancel")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteCancel(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(deleteButton, javax.swing.GroupLayout.PREFERRED_SIZE, 88, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE)
                .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 88, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(deleteButton)
                    .addComponent(cancelButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGroup(layout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void symbolDelete(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_symbolDelete
        List<KeyboardDescription> savedKeyboards = Prefs.getShowKeyboardList();
        Object[] selected = customSymbolList.getSelectedValues();
        boolean deleteThis = true;
        for (Object obj : selected) {
            if (obj instanceof UserDefinedSymbol) {
                UserDefinedSymbol sym = (UserDefinedSymbol)obj;
                for (KeyboardDescription kbd : savedKeyboards) {
                    Symbol usingSym = kbd.getSymbol();
                    if (usingSym.getDescription().equals(sym.getDescription())) {
                        String message = MessageFormat.format(_("vkb.delete_custom_symbol.confirm.message"), usingSym.getDescription());
                        int ans = JOptionPane.showConfirmDialog(this, message, 
                                _("vkb.delete_custom_symbol.confirm.title"), JOptionPane.YES_NO_OPTION);
                        if (ans == JOptionPane.YES_OPTION) {
                            Prefs.delShowKeyboardList(kbd);                            
                        } else {
                            deleteThis = false;
                        }
                        break;
                    }
                } 
                if (!deleteThis) {
                    deleteThis = true;
                    continue;
                }
                sym.delete();
            }
        }
        dispose();
    }//GEN-LAST:event_symbolDelete

    private void deleteCancel(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteCancel
        dispose();
    }//GEN-LAST:event_deleteCancel

    private void setupCustomSymbolList() {
        VKBManager manager = VKBManager.getInstance();
        SortedSet<Symbol> usymbols = manager.getUserSymbolSet();
        DefaultListModel model = new DefaultListModel();
        for (Symbol sym : usymbols) {
            model.addElement(sym);
        }
        customSymbolList.setModel(model);
    }
    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                DeleteCustomSymbol dialog = new DeleteCustomSymbol(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JList customSymbolList;
    private javax.swing.JButton deleteButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

}
