/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * VariantOption.java
 *
 * Created on 2006/07/11, 13:53
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;
/**
 *
 * @author naoyuki
 */
public class VariantOption {
    
    public boolean isAlphanumeric() {
        if (getAlphanumericKeys()) {
            return true;
        }
        if (!getModifierKeys() && !getKeypadKeys() && !getFunctionKeys() && !getAlternateGroup()) {
            return true;
        }
        return false;
    }
    
    private Set<String> options = new HashSet<String>();
    /** Creates a new instance of VariantOption */
    public VariantOption() {
    }    
    
    public void setOpt(String key) {
        options.add(key);
    }

    public boolean getDefault() {
        if (options.contains("default")) {
            return true;
        }
        return false;
    }

    public boolean getPartial() {
        if (options.contains("partial")) {
            return true;
        }
        return false;
    }

    public boolean getHidden() {
        if (options.contains("hidden")) {
            return true;
        }
        return false;
    }

    public boolean getAlphanumericKeys() {
        if (options.contains("alphanumeric_keys")) {
            return true;
        }
        return false;
    }

    public boolean getModifierKeys() {
        if (options.contains("modifier_keys")) {
            return true;
        }
        return false;
    }    

    public boolean getKeypadKeys() {
        if (options.contains("keypad_keys")) {
            return true;
        }
        return false;
    }   

    public boolean getFunctionKeys() {
        if (options.contains("function_keys")) {
            return true;
        }
        return false;
    }

    public boolean getAlternateGroup() {
        if (options.contains("alternate_gruop")) {
            return true;
        }
        return false;
    }    
    
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String s : options) {
            sb.append(s);
            sb.append(", ");
        }
        return sb.toString();
    }
}
