/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Util.java
 *
 * Created on 2006/07/11, 14:17
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;

/**
 *
 * @author naoyuki
 */
public class Util {
    
    /** Creates a new instance of Util */
    private Util() {
    }
    
    public static String getTypeName(String line) {
        int id1 = line.indexOf("\"") + 1;
        int id2 = line.indexOf("\"", id1 + 1);
        if (id1 < id2) {
            return line.substring(id1, id2);
        } 
        return "basic";
    }    
    
    public static String trimComment(String line) {
        int commentStart = line.indexOf("//");
        if (commentStart != -1) {
            line = line.substring(0, commentStart).trim();
        }
        return line;
    }
    
    private static Set<String> ignoreSet = new HashSet<String>();
    static {
        ignoreSet.add("<XFER>");
        ignoreSet.add("<VOL->");
        ignoreSet.add("<VOL+>");
        ignoreSet.add("<UP>");
        ignoreSet.add("<UNDO>");
        ignoreSet.add("<TAB>");
        ignoreSet.add("<STOP>");
        ignoreSet.add("<SCLK>");
        ignoreSet.add("<RWIN>");
        ignoreSet.add("<RTSH>");
        ignoreSet.add("<RTRN>");
        ignoreSet.add("<RMTA>");
        ignoreSet.add("<RGHT>");
        ignoreSet.add("<RCTL>");
        ignoreSet.add("<RALT>");
        ignoreSet.add("<PRSC>");
        ignoreSet.add("<PROP>");
        ignoreSet.add("<POWR>");
        ignoreSet.add("<PGUP>");
        ignoreSet.add("<PGDN>");
        ignoreSet.add("<PAUS>");
        ignoreSet.add("<PAST>");
        ignoreSet.add("<OPEN>");
        ignoreSet.add("<NMLK>");
        ignoreSet.add("<NFER>");
        ignoreSet.add("<MUTE>");
        ignoreSet.add("<LMTA>");
        ignoreSet.add("<LFSH>");
        ignoreSet.add("<LEFT>");
        ignoreSet.add("<LCTL>");
        ignoreSet.add("<LALT>");
        ignoreSet.add("<KPSU>");
        ignoreSet.add("<KPMU>");
        ignoreSet.add("<KPEN>");
        ignoreSet.add("<KPDV>");
        ignoreSet.add("<KPDL>");
        ignoreSet.add("<KPAD>");
        ignoreSet.add("<KP9>");
        ignoreSet.add("<KP8>");
        ignoreSet.add("<KP7>");
        ignoreSet.add("<KP6>");
        ignoreSet.add("<KP5>");
        ignoreSet.add("<KP4>");
        ignoreSet.add("<KP3>");
        ignoreSet.add("<KP2>");
        ignoreSet.add("<KP1>");
        ignoreSet.add("<KP0>");
        ignoreSet.add("<INS>");
        ignoreSet.add("<HZTG>");
        ignoreSet.add("<HOME>");
        ignoreSet.add("<HKTG>");
        ignoreSet.add("<HELP>");
        ignoreSet.add("<FRNT>");
        ignoreSet.add("<FK12>");
        ignoreSet.add("<FK11>");
        ignoreSet.add("<FK10>");
        ignoreSet.add("<FK09>");
        ignoreSet.add("<FK08>");
        ignoreSet.add("<FK07>");
        ignoreSet.add("<FK06>");
        ignoreSet.add("<FK05>");
        ignoreSet.add("<FK04>");
        ignoreSet.add("<FK03>");
        ignoreSet.add("<FK02>");
        ignoreSet.add("<FK01>");
        ignoreSet.add("<FIND>");
        ignoreSet.add("<ESC>");
        ignoreSet.add("<END>");
        ignoreSet.add("<DOWN>");
        ignoreSet.add("<DELE>");
        ignoreSet.add("<CUT>");
        ignoreSet.add("<COPY>");
        ignoreSet.add("<COMP>");
        ignoreSet.add("<CAPS>");
        ignoreSet.add("<BKSP>");
        ignoreSet.add("<ALGR>");
        ignoreSet.add("<AGAI>");
    }
    
    public static boolean isIgnore(String sym) {
        return ignoreSet.contains(sym);
    }
    
    private static Map<String, String> keysymToKeycode = new HashMap<String, String>();
    static {
        keysymToKeycode.put("0", "30");
        keysymToKeycode.put("1", "31");
        keysymToKeycode.put("2", "32");
        keysymToKeycode.put("3", "33");
        keysymToKeycode.put("4", "34");
        keysymToKeycode.put("5", "35");
        keysymToKeycode.put("6", "36");
        keysymToKeycode.put("7", "37");
        keysymToKeycode.put("8", "38");
        keysymToKeycode.put("9", "39");
        keysymToKeycode.put("EuroSign", "0204");
        keysymToKeycode.put("a", "41");
        keysymToKeycode.put("ampersand", "96");
        keysymToKeycode.put("apostrophe", "de");
        keysymToKeycode.put("asciicircum", "0202");
        keysymToKeycode.put("asterisk", "97");
        keysymToKeycode.put("at", "0200");
        keysymToKeycode.put("b", "42");
        keysymToKeycode.put("backslash", "5c");
        keysymToKeycode.put("braceleft", "a1");
        keysymToKeycode.put("braceright", "a2");
        keysymToKeycode.put("bracketleft", "5b");
        keysymToKeycode.put("bracketright", "5d");
        keysymToKeycode.put("c", "43");
        keysymToKeycode.put("colon", "0201");
        keysymToKeycode.put("comma", "2c");
        keysymToKeycode.put("d", "44");
        keysymToKeycode.put("dead_abovedot", "86");
        keysymToKeycode.put("dead_abovering", "88");
        keysymToKeycode.put("dead_acute", "81");
        keysymToKeycode.put("dead_breve", "85");
        keysymToKeycode.put("dead_caron", "8a");
        keysymToKeycode.put("dead_cedilla", "8b");
        keysymToKeycode.put("dead_circumflex", "82");
        keysymToKeycode.put("dead_diaeresis", "87");
        keysymToKeycode.put("dead_doubleacute", "89");
        keysymToKeycode.put("dead_grave", "80");
        keysymToKeycode.put("dead_macron", "84");
        keysymToKeycode.put("dead_ogonek", "8c");
        keysymToKeycode.put("dead_tilde", "83");
        keysymToKeycode.put("dollar", "0203");
        keysymToKeycode.put("e", "45");
        keysymToKeycode.put("equal", "3d");
        keysymToKeycode.put("exclam", "0205");
        keysymToKeycode.put("f", "46");
        keysymToKeycode.put("g", "47");
        keysymToKeycode.put("greater", "a0");
        keysymToKeycode.put("h", "48");
        keysymToKeycode.put("i", "49");
        keysymToKeycode.put("j", "4a");
        keysymToKeycode.put("k", "4b");
        keysymToKeycode.put("l", "4c");
        keysymToKeycode.put("less", "99");
        keysymToKeycode.put("m", "4d");
        keysymToKeycode.put("minus", "2d");
        keysymToKeycode.put("multiply", "6a");
        keysymToKeycode.put("n", "4e");
        keysymToKeycode.put("numbersign", "0208");
        keysymToKeycode.put("o", "4f");
        keysymToKeycode.put("p", "50");
        keysymToKeycode.put("period", "2e");
        keysymToKeycode.put("plus", "0209");
        keysymToKeycode.put("q", "51");
        keysymToKeycode.put("quotedbl", "98");
        keysymToKeycode.put("r", "52");
        keysymToKeycode.put("s", "53");
        keysymToKeycode.put("semicolon", "3b");
        keysymToKeycode.put("slash", "2f");
        keysymToKeycode.put("space", "20");
        keysymToKeycode.put("t", "54");
        keysymToKeycode.put("u", "55");
        keysymToKeycode.put("underscore", "020b");
        keysymToKeycode.put("v", "56");
        keysymToKeycode.put("w", "57");
        keysymToKeycode.put("x", "58");
        keysymToKeycode.put("y", "59");
        keysymToKeycode.put("z", "5a");
    };
    private static Map<String, String> keysymToKeychar = new HashMap<String, String>();
    static {
        keysymToKeychar.put("space", "20");
        keysymToKeychar.put("exclam", "21");
        keysymToKeychar.put("quotedbl", "22");
        keysymToKeychar.put("doublequote", "22");
        keysymToKeychar.put("numbersign", "23");
        keysymToKeychar.put("dollar", "24");
        keysymToKeychar.put("percent", "25");
        keysymToKeychar.put("ampersand", "26");
        keysymToKeychar.put("apostrophe", "27");
        keysymToKeychar.put("quoteright", "27");
        keysymToKeychar.put("parenleft", "28");
        keysymToKeychar.put("parenright", "29");
        keysymToKeychar.put("asterisk", "2a");
        keysymToKeychar.put("plus", "2b");
        keysymToKeychar.put("comma", "2c");
        keysymToKeychar.put("minus", "2d");
        keysymToKeychar.put("period", "2e");
        keysymToKeychar.put("slash", "2f");
        keysymToKeychar.put("0", "30");
        keysymToKeychar.put("1", "31");
        keysymToKeychar.put("2", "32");
        keysymToKeychar.put("3", "33");
        keysymToKeychar.put("4", "34");
        keysymToKeychar.put("5", "35");
        keysymToKeychar.put("6", "36");
        keysymToKeychar.put("7", "37");
        keysymToKeychar.put("8", "38");
        keysymToKeychar.put("9", "39");
        keysymToKeychar.put("colon", "3a");
        keysymToKeychar.put("semicolon", "3b");
        keysymToKeychar.put("less", "3c");
        keysymToKeychar.put("equal", "3d");
        keysymToKeychar.put("greater", "3e");
        keysymToKeychar.put("question", "3f");
        keysymToKeychar.put("at", "40");
        keysymToKeychar.put("A", "41");
        keysymToKeychar.put("B", "42");
        keysymToKeychar.put("C", "43");
        keysymToKeychar.put("D", "44");
        keysymToKeychar.put("E", "45");
        keysymToKeychar.put("F", "46");
        keysymToKeychar.put("G", "47");
        keysymToKeychar.put("H", "48");
        keysymToKeychar.put("I", "49");
        keysymToKeychar.put("J", "4a");
        keysymToKeychar.put("K", "4b");
        keysymToKeychar.put("L", "4c");
        keysymToKeychar.put("M", "4d");
        keysymToKeychar.put("N", "4e");
        keysymToKeychar.put("O", "4f");
        keysymToKeychar.put("P", "50");
        keysymToKeychar.put("Q", "51");
        keysymToKeychar.put("R", "52");
        keysymToKeychar.put("S", "53");
        keysymToKeychar.put("T", "54");
        keysymToKeychar.put("U", "55");
        keysymToKeychar.put("V", "56");
        keysymToKeychar.put("W", "57");
        keysymToKeychar.put("X", "58");
        keysymToKeychar.put("Y", "59");
        keysymToKeychar.put("Z", "5a");
        keysymToKeychar.put("bracketleft", "5b");
        keysymToKeychar.put("backslash", "5c");
        keysymToKeychar.put("bracketright", "5d");
        keysymToKeychar.put("asciicircum", "5e");
        keysymToKeychar.put("asciicirum", "5e"); // maybe xkb data typo 
        keysymToKeychar.put("underscore", "5f");
        keysymToKeychar.put("grave", "60");
        keysymToKeychar.put("quoteleft", "60");
        keysymToKeychar.put("a", "61");
        keysymToKeychar.put("b", "62");
        keysymToKeychar.put("c", "63");
        keysymToKeychar.put("d", "64");
        keysymToKeychar.put("e", "65");
        keysymToKeychar.put("f", "66");
        keysymToKeychar.put("g", "67");
        keysymToKeychar.put("h", "68");
        keysymToKeychar.put("i", "69");
        keysymToKeychar.put("j", "6a");
        keysymToKeychar.put("k", "6b");
        keysymToKeychar.put("l", "6c");
        keysymToKeychar.put("m", "6d");
        keysymToKeychar.put("n", "6e");
        keysymToKeychar.put("o", "6f");
        keysymToKeychar.put("p", "70");
        keysymToKeychar.put("q", "71");
        keysymToKeychar.put("r", "72");
        keysymToKeychar.put("s", "73");
        keysymToKeychar.put("t", "74");
        keysymToKeychar.put("u", "75");
        keysymToKeychar.put("v", "76");
        keysymToKeychar.put("w", "77");
        keysymToKeychar.put("x", "78");
        keysymToKeychar.put("y", "79");
        keysymToKeychar.put("z", "7a");
        keysymToKeychar.put("braceleft", "7b");
        keysymToKeychar.put("bar", "7c");
        keysymToKeychar.put("braceright", "7d");
        keysymToKeychar.put("asciitilde", "7e");
        keysymToKeychar.put("nobreakspace", "a0");
        keysymToKeychar.put("exclamdown", "a1");
        keysymToKeychar.put("cent", "a2");
        keysymToKeychar.put("sterling", "a3");
        keysymToKeychar.put("currency", "a4");
        keysymToKeychar.put("yen", "a5");
        keysymToKeychar.put("brokenbar", "a6");
        keysymToKeychar.put("section", "a7");
        keysymToKeychar.put("diaeresis", "a8");
        keysymToKeychar.put("copyright", "a9");
        keysymToKeychar.put("ordfeminine", "aa");
        keysymToKeychar.put("guillemotleft", "ab");
        keysymToKeychar.put("notsign", "ac");
        keysymToKeychar.put("hyphen", "ad");
        keysymToKeychar.put("soft_hyphen", "ad");
        keysymToKeychar.put("registered", "ae");
        keysymToKeychar.put("macron", "af");
        keysymToKeychar.put("degree", "b0");
        keysymToKeychar.put("plusminus", "b1");
        keysymToKeychar.put("twosuperior", "b2");
        keysymToKeychar.put("threesuperior", "b3");
        keysymToKeychar.put("acute", "b4");
        keysymToKeychar.put("mu", "b5");
        keysymToKeychar.put("paragraph", "b6");
        keysymToKeychar.put("periodcentered", "b7");
        keysymToKeychar.put("cedilla", "b8");
        keysymToKeychar.put("onesuperior", "b9");
        keysymToKeychar.put("masculine", "ba");
        keysymToKeychar.put("guillemotright", "bb");
        keysymToKeychar.put("onequarter", "bc");
        keysymToKeychar.put("onehalf", "bd");
        keysymToKeychar.put("threequarters", "be");
        keysymToKeychar.put("questiondown", "bf");
        keysymToKeychar.put("Agrave", "c0");
        keysymToKeychar.put("Aacute", "c1");
        keysymToKeychar.put("Acircumflex", "c2");
        keysymToKeychar.put("Atilde", "c3");
        keysymToKeychar.put("Adiaeresis", "c4");
        keysymToKeychar.put("Aring", "c5");
        keysymToKeychar.put("AE", "c6");
        keysymToKeychar.put("Ccedilla", "c7");
        keysymToKeychar.put("Egrave", "c8");
        keysymToKeychar.put("Eacute", "c9");
        keysymToKeychar.put("Ecircumflex", "ca");
        keysymToKeychar.put("Ediaeresis", "cb");
        keysymToKeychar.put("Igrave", "cc");
        keysymToKeychar.put("Iacute", "cd");
        keysymToKeychar.put("Icircumflex", "ce");
        keysymToKeychar.put("Idiaeresis", "cf");
        keysymToKeychar.put("ETH", "d0");
        keysymToKeychar.put("Eth", "d0");
        keysymToKeychar.put("Ntilde", "d1");
        keysymToKeychar.put("Ograve", "d2");
        keysymToKeychar.put("Oacute", "d3");
        keysymToKeychar.put("Ocircumflex", "d4");
        keysymToKeychar.put("Otilde", "d5");
        keysymToKeychar.put("Odiaeresis", "d6");
        keysymToKeychar.put("multiply", "d7");
        keysymToKeychar.put("Ooblique", "d8");
        keysymToKeychar.put("Oslash", "d8");
        keysymToKeychar.put("Ugrave", "d9");
        keysymToKeychar.put("Uacute", "da");
        keysymToKeychar.put("Ucircumflex", "db");
        keysymToKeychar.put("Udiaeresis", "dc");
        keysymToKeychar.put("Yacute", "dd");
        keysymToKeychar.put("THORN", "de");
        keysymToKeychar.put("Thorn", "de");
        keysymToKeychar.put("ssharp", "df");
        keysymToKeychar.put("agrave", "e0");
        keysymToKeychar.put("aacute", "e1");
        keysymToKeychar.put("acircumflex", "e2");
        keysymToKeychar.put("atilde", "e3");
        keysymToKeychar.put("adiaeresis", "e4");
        keysymToKeychar.put("aring", "e5");
        keysymToKeychar.put("ae", "e6");
        keysymToKeychar.put("ccedilla", "e7");
        keysymToKeychar.put("egrave", "e8");
        keysymToKeychar.put("eacute", "e9");
        keysymToKeychar.put("ecircumflex", "ea");
        keysymToKeychar.put("ediaeresis", "eb");
        keysymToKeychar.put("igrave", "ec");
        keysymToKeychar.put("iacute", "ed");
        keysymToKeychar.put("icircumflex", "ee");
        keysymToKeychar.put("idiaeresis", "ef");
        keysymToKeychar.put("eth", "f0");
        keysymToKeychar.put("ntilde", "f1");
        keysymToKeychar.put("ograve", "f2");
        keysymToKeychar.put("oacute", "f3");
        keysymToKeychar.put("ocircumflex", "f4");
        keysymToKeychar.put("otilde", "f5");
        keysymToKeychar.put("odiaeresis", "f6");
        keysymToKeychar.put("division", "f7");
        keysymToKeychar.put("oslash", "f8");
        keysymToKeychar.put("ugrave", "f9");
        keysymToKeychar.put("uacute", "fa");
        keysymToKeychar.put("ucircumflex", "fb");
        keysymToKeychar.put("udiaeresis", "fc");
        keysymToKeychar.put("yacute", "fd");
        keysymToKeychar.put("thorn", "fe");
        keysymToKeychar.put("ydiaeresis", "ff");
        keysymToKeychar.put("Aogonek", "104");
        keysymToKeychar.put("breve", "2d8");
        keysymToKeychar.put("Lstroke", "141");
        keysymToKeychar.put("Lcaron", "13d");
        keysymToKeychar.put("Sacute", "15a");
        keysymToKeychar.put("Scaron", "160");
        keysymToKeychar.put("Scedilla", "15e");
        keysymToKeychar.put("Tcaron", "164");
        keysymToKeychar.put("Zacute", "179");
        keysymToKeychar.put("Zcaron", "17d");
        keysymToKeychar.put("Zabovedot", "17b");
        keysymToKeychar.put("aogonek", "105");
        keysymToKeychar.put("ogonek", "2db");
        keysymToKeychar.put("lstroke", "142");
        keysymToKeychar.put("lcaron", "13e");
        keysymToKeychar.put("sacute", "15b");
        keysymToKeychar.put("caron", "2c7");
        keysymToKeychar.put("scaron", "161");
        keysymToKeychar.put("scedilla", "15f");
        keysymToKeychar.put("tcaron", "165");
        keysymToKeychar.put("zacute", "17a");
        keysymToKeychar.put("doubleacute", "2dd");
        keysymToKeychar.put("zcaron", "17e");
        keysymToKeychar.put("zabovedot", "17c");
        keysymToKeychar.put("Racute", "154");
        keysymToKeychar.put("Abreve", "102");
        keysymToKeychar.put("Lacute", "139");
        keysymToKeychar.put("Cacute", "106");
        keysymToKeychar.put("Ccaron", "10c");
        keysymToKeychar.put("Eogonek", "118");
        keysymToKeychar.put("Ecaron", "11a");
        keysymToKeychar.put("Dcaron", "10e");
        keysymToKeychar.put("Dstroke", "110");
        keysymToKeychar.put("Nacute", "143");
        keysymToKeychar.put("Ncaron", "147");
        keysymToKeychar.put("Odoubleacute", "150");
        keysymToKeychar.put("Rcaron", "158");
        keysymToKeychar.put("Uring", "16e");
        keysymToKeychar.put("Udoubleacute", "170");
        keysymToKeychar.put("Tcedilla", "162");
        keysymToKeychar.put("racute", "155");
        keysymToKeychar.put("abreve", "103");
        keysymToKeychar.put("lacute", "13a");
        keysymToKeychar.put("cacute", "107");
        keysymToKeychar.put("ccaron", "10d");
        keysymToKeychar.put("eogonek", "119");
        keysymToKeychar.put("ecaron", "11b");
        keysymToKeychar.put("dcaron", "10f");
        keysymToKeychar.put("dstroke", "111");
        keysymToKeychar.put("nacute", "144");
        keysymToKeychar.put("ncaron", "148");
        keysymToKeychar.put("odoubleacute", "151");
        keysymToKeychar.put("rcaron", "159");
        keysymToKeychar.put("uring", "16f");
        keysymToKeychar.put("udoubleacute", "171");
        keysymToKeychar.put("tcedilla", "163");
        keysymToKeychar.put("abovedot", "2d9");
        keysymToKeychar.put("Hstroke", "126");
        keysymToKeychar.put("Hcircumflex", "124");
        keysymToKeychar.put("Iabovedot", "130");
        keysymToKeychar.put("Gbreve", "11e");
        keysymToKeychar.put("Jcircumflex", "134");
        keysymToKeychar.put("hstroke", "127");
        keysymToKeychar.put("hcircumflex", "125");
        keysymToKeychar.put("idotless", "131");
        keysymToKeychar.put("gbreve", "11f");
        keysymToKeychar.put("jcircumflex", "135");
        keysymToKeychar.put("Cabovedot", "10a");
        keysymToKeychar.put("Ccircumflex", "108");
        keysymToKeychar.put("Gabovedot", "120");
        keysymToKeychar.put("Gcircumflex", "11c");
        keysymToKeychar.put("Ubreve", "16c");
        keysymToKeychar.put("Scircumflex", "15c");
        keysymToKeychar.put("cabovedot", "10b");
        keysymToKeychar.put("ccircumflex", "109");
        keysymToKeychar.put("gabovedot", "121");
        keysymToKeychar.put("gcircumflex", "11d");
        keysymToKeychar.put("ubreve", "16d");
        keysymToKeychar.put("scircumflex", "15d");
        keysymToKeychar.put("kappa", "138");
        keysymToKeychar.put("kra", "138");
        keysymToKeychar.put("Rcedilla", "156");
        keysymToKeychar.put("Itilde", "128");
        keysymToKeychar.put("Lcedilla", "13b");
        keysymToKeychar.put("Emacron", "112");
        keysymToKeychar.put("Gcedilla", "122");
        keysymToKeychar.put("Tslash", "166");
        keysymToKeychar.put("rcedilla", "157");
        keysymToKeychar.put("itilde", "129");
        keysymToKeychar.put("lcedilla", "13c");
        keysymToKeychar.put("emacron", "113");
        keysymToKeychar.put("gcedilla", "123");
        keysymToKeychar.put("tslash", "167");
        keysymToKeychar.put("ENG", "14a");
        keysymToKeychar.put("eng", "14b");
        keysymToKeychar.put("Amacron", "100");
        keysymToKeychar.put("Iogonek", "12e");
        keysymToKeychar.put("Eabovedot", "116");
        keysymToKeychar.put("Imacron", "12a");
        keysymToKeychar.put("Ncedilla", "145");
        keysymToKeychar.put("Omacron", "14c");
        keysymToKeychar.put("Kcedilla", "136");
        keysymToKeychar.put("Uogonek", "172");
        keysymToKeychar.put("Utilde", "168");
        keysymToKeychar.put("Umacron", "16a");
        keysymToKeychar.put("amacron", "101");
        keysymToKeychar.put("iogonek", "12f");
        keysymToKeychar.put("eabovedot", "117");
        keysymToKeychar.put("imacron", "12b");
        keysymToKeychar.put("ncedilla", "146");
        keysymToKeychar.put("omacron", "14d");
        keysymToKeychar.put("kcedilla", "137");
        keysymToKeychar.put("uogonek", "173");
        keysymToKeychar.put("utilde", "169");
        keysymToKeychar.put("umacron", "16b");
        keysymToKeychar.put("overline", "203e");
        keysymToKeychar.put("kana_fullstop", "3002");
        keysymToKeychar.put("kana_openingbracket", "300c");
        keysymToKeychar.put("kana_closingbracket", "300d");
        keysymToKeychar.put("kana_comma", "3001");
        keysymToKeychar.put("kana_conjunctive", "30fb");
        keysymToKeychar.put("kana_middledot", "30fb");
        keysymToKeychar.put("kana_WO", "30f2");
        keysymToKeychar.put("kana_a", "30a1");
        keysymToKeychar.put("kana_i", "30a3");
        keysymToKeychar.put("kana_u", "30a5");
        keysymToKeychar.put("kana_e", "30a7");
        keysymToKeychar.put("kana_o", "30a9");
        keysymToKeychar.put("kana_ya", "30e3");
        keysymToKeychar.put("kana_yu", "30e5");
        keysymToKeychar.put("kana_yo", "30e7");
        keysymToKeychar.put("kana_tsu", "30c3");
        keysymToKeychar.put("kana_tu", "30c3");
        keysymToKeychar.put("prolongedsound", "30fc");
        keysymToKeychar.put("kana_A", "30a2");
        keysymToKeychar.put("kana_I", "30a4");
        keysymToKeychar.put("kana_U", "30a6");
        keysymToKeychar.put("kana_E", "30a8");
        keysymToKeychar.put("kana_O", "30aa");
        keysymToKeychar.put("kana_KA", "30ab");
        keysymToKeychar.put("kana_KI", "30ad");
        keysymToKeychar.put("kana_KU", "30af");
        keysymToKeychar.put("kana_KE", "30b1");
        keysymToKeychar.put("kana_KO", "30b3");
        keysymToKeychar.put("kana_SA", "30b5");
        keysymToKeychar.put("kana_SHI", "30b7");
        keysymToKeychar.put("kana_SU", "30b9");
        keysymToKeychar.put("kana_SE", "30bb");
        keysymToKeychar.put("kana_SO", "30bd");
        keysymToKeychar.put("kana_TA", "30bf");
        keysymToKeychar.put("kana_CHI", "30c1");
        keysymToKeychar.put("kana_TI", "30c1");
        keysymToKeychar.put("kana_TSU", "30c4");
        keysymToKeychar.put("kana_TU", "30c4");
        keysymToKeychar.put("kana_TE", "30c6");
        keysymToKeychar.put("kana_TO", "30c8");
        keysymToKeychar.put("kana_NA", "30ca");
        keysymToKeychar.put("kana_NI", "30cb");
        keysymToKeychar.put("kana_NU", "30cc");
        keysymToKeychar.put("kana_NE", "30cd");
        keysymToKeychar.put("kana_NO", "30ce");
        keysymToKeychar.put("kana_HA", "30cf");
        keysymToKeychar.put("kana_HI", "30d2");
        keysymToKeychar.put("kana_FU", "30d5");
        keysymToKeychar.put("kana_HU", "30d5");
        keysymToKeychar.put("kana_HE", "30d8");
        keysymToKeychar.put("kana_HO", "30db");
        keysymToKeychar.put("kana_MA", "30de");
        keysymToKeychar.put("kana_MI", "30df");
        keysymToKeychar.put("kana_MU", "30e0");
        keysymToKeychar.put("kana_ME", "30e1");
        keysymToKeychar.put("kana_MO", "30e2");
        keysymToKeychar.put("kana_YA", "30e4");
        keysymToKeychar.put("kana_YU", "30e6");
        keysymToKeychar.put("kana_YO", "30e8");
        keysymToKeychar.put("kana_RA", "30e9");
        keysymToKeychar.put("kana_RI", "30ea");
        keysymToKeychar.put("kana_RU", "30eb");
        keysymToKeychar.put("kana_RE", "30ec");
        keysymToKeychar.put("kana_RO", "30ed");
        keysymToKeychar.put("kana_WA", "30ef");
        keysymToKeychar.put("kana_N", "30f3");
        keysymToKeychar.put("voicedsound", "309b");
        keysymToKeychar.put("semivoicedsound", "309c");
        keysymToKeychar.put("Arabic_comma", "60c");
        keysymToKeychar.put("Arabic_semicolon", "61b");
        keysymToKeychar.put("Arabic_question_mark", "61f");
        keysymToKeychar.put("Arabic_hamza", "621");
        keysymToKeychar.put("Arabic_maddaonalef", "622");
        keysymToKeychar.put("Arabic_hamzaonalef", "623");
        keysymToKeychar.put("Arabic_hamzaonwaw", "624");
        keysymToKeychar.put("Arabic_hamzaunderalef", "625");
        keysymToKeychar.put("Arabic_hamzaonyeh", "626");
        keysymToKeychar.put("Arabic_alef", "627");
        keysymToKeychar.put("Arabic_beh", "628");
        keysymToKeychar.put("Arabic_tehmarbuta", "629");
        keysymToKeychar.put("Arabic_teh", "62a");
        keysymToKeychar.put("Arabic_theh", "62b");
        keysymToKeychar.put("Arabic_jeem", "62c");
        keysymToKeychar.put("Arabic_hah", "62d");
        keysymToKeychar.put("Arabic_khah", "62e");
        keysymToKeychar.put("Arabic_dal", "62f");
        keysymToKeychar.put("Arabic_thal", "630");
        keysymToKeychar.put("Arabic_ra", "631");
        keysymToKeychar.put("Arabic_zain", "632");
        keysymToKeychar.put("Arabic_seen", "633");
        keysymToKeychar.put("Arabic_sheen", "634");
        keysymToKeychar.put("Arabic_sad", "635");
        keysymToKeychar.put("Arabic_dad", "636");
        keysymToKeychar.put("Arabic_tah", "637");
        keysymToKeychar.put("Arabic_zah", "638");
        keysymToKeychar.put("Arabic_ain", "639");
        keysymToKeychar.put("Arabic_ghain", "63a");
        keysymToKeychar.put("Arabic_tatweel", "640");
        keysymToKeychar.put("Arabic_feh", "641");
        keysymToKeychar.put("Arabic_qaf", "642");
        keysymToKeychar.put("Arabic_kaf", "643");
        keysymToKeychar.put("Arabic_lam", "644");
        keysymToKeychar.put("Arabic_meem", "645");
        keysymToKeychar.put("Arabic_noon", "646");
        keysymToKeychar.put("Arabic_ha", "647");
        keysymToKeychar.put("Arabic_heh", "647");
        keysymToKeychar.put("Arabic_waw", "648");
        keysymToKeychar.put("Arabic_alefmaksura", "649");
        keysymToKeychar.put("Arabic_yeh", "64a");
        keysymToKeychar.put("Arabic_fathatan", "64b");
        keysymToKeychar.put("Arabic_dammatan", "64c");
        keysymToKeychar.put("Arabic_kasratan", "64d");
        keysymToKeychar.put("Arabic_fatha", "64e");
        keysymToKeychar.put("Arabic_damma", "64f");
        keysymToKeychar.put("Arabic_kasra", "650");
        keysymToKeychar.put("Arabic_shadda", "651");
        keysymToKeychar.put("Arabic_sukun", "652");
        keysymToKeychar.put("Serbian_dje", "452");
        keysymToKeychar.put("Macedonia_gje", "453");
        keysymToKeychar.put("Cyrillic_io", "451");
        keysymToKeychar.put("Ukrainian_ie", "454");
        keysymToKeychar.put("Ukranian_je", "454");
        keysymToKeychar.put("Macedonia_dse", "455");
        keysymToKeychar.put("Ukrainian_i", "456");
        keysymToKeychar.put("Ukranian_i", "456");
        keysymToKeychar.put("Ukrainian_yi", "457");
        keysymToKeychar.put("Ukranian_yi", "457");
        keysymToKeychar.put("Cyrillic_je", "458");
        keysymToKeychar.put("Serbian_je", "458");
        keysymToKeychar.put("Cyrillic_lje", "459");
        keysymToKeychar.put("Serbian_lje", "459");
        keysymToKeychar.put("Cyrillic_nje", "45a");
        keysymToKeychar.put("Serbian_nje", "45a");
        keysymToKeychar.put("Serbian_tshe", "45b");
        keysymToKeychar.put("Macedonia_kje", "45c");
        keysymToKeychar.put("Byelorussian_shortu", "45e");
        keysymToKeychar.put("Cyrillic_dzhe", "45f");
        keysymToKeychar.put("Serbian_dze", "45f");
        keysymToKeychar.put("numerosign", "2116");
        keysymToKeychar.put("Serbian_DJE", "402");
        keysymToKeychar.put("Macedonia_GJE", "403");
        keysymToKeychar.put("Cyrillic_IO", "401");
        keysymToKeychar.put("Ukrainian_IE", "404");
        keysymToKeychar.put("Ukranian_JE", "404");
        keysymToKeychar.put("Macedonia_DSE", "405");
        keysymToKeychar.put("Ukrainian_I", "406");
        keysymToKeychar.put("Ukranian_I", "406");
        keysymToKeychar.put("Ukrainian_YI", "407");
        keysymToKeychar.put("Ukranian_YI", "407");
        keysymToKeychar.put("Ukrainian_ghe_with_upturn", "491");
        keysymToKeychar.put("Ukrainian_GHE_WITH_UPTURN", "490");
        keysymToKeychar.put("Cyrillic_JE", "408");
        keysymToKeychar.put("Serbian_JE", "408");
        keysymToKeychar.put("Cyrillic_LJE", "409");
        keysymToKeychar.put("Serbian_LJE", "409");
        keysymToKeychar.put("Cyrillic_NJE", "40a");
        keysymToKeychar.put("Serbian_NJE", "40a");
        keysymToKeychar.put("Serbian_TSHE", "40b");
        keysymToKeychar.put("Macedonia_KJE", "40c");
        keysymToKeychar.put("Byelorussian_SHORTU", "40e");
        keysymToKeychar.put("Cyrillic_DZHE", "40f");
        keysymToKeychar.put("Serbian_DZE", "40f");
        keysymToKeychar.put("Cyrillic_yu", "44e");
        keysymToKeychar.put("Cyrillic_a", "430");
        keysymToKeychar.put("Cyrillic_be", "431");
        keysymToKeychar.put("Cyrillic_tse", "446");
        keysymToKeychar.put("Cyrillic_de", "434");
        keysymToKeychar.put("Cyrillic_ie", "435");
        keysymToKeychar.put("Cyrillic_ef", "444");
        keysymToKeychar.put("Cyrillic_ghe", "433");
        keysymToKeychar.put("Cyrillic_ha", "445");
        keysymToKeychar.put("Cyrillic_i", "438");
        keysymToKeychar.put("Cyrillic_shorti", "439");
        keysymToKeychar.put("Cyrillic_ka", "43a");
        keysymToKeychar.put("Cyrillic_el", "43b");
        keysymToKeychar.put("Cyrillic_em", "43c");
        keysymToKeychar.put("Cyrillic_en", "43d");
        keysymToKeychar.put("Cyrillic_o", "43e");
        keysymToKeychar.put("Cyrillic_pe", "43f");
        keysymToKeychar.put("Cyrillic_ya", "44f");
        keysymToKeychar.put("Cyrillic_er", "440");
        keysymToKeychar.put("Cyrillic_es", "441");
        keysymToKeychar.put("Cyrillic_te", "442");
        keysymToKeychar.put("Cyrillic_u", "443");
        keysymToKeychar.put("Cyrillic_zhe", "436");
        keysymToKeychar.put("Cyrillic_ve", "432");
        keysymToKeychar.put("Cyrillic_softsign", "44c");
        keysymToKeychar.put("Cyrillic_yeru", "44b");
        keysymToKeychar.put("Cyrillic_ze", "437");
        keysymToKeychar.put("Cyrillic_sha", "448");
        keysymToKeychar.put("Cyrillic_e", "44d");
        keysymToKeychar.put("Cyrillic_shcha", "449");
        keysymToKeychar.put("Cyrillic_che", "447");
        keysymToKeychar.put("Cyrillic_hardsign", "44a");
        keysymToKeychar.put("Cyrillic_YU", "42e");
        keysymToKeychar.put("Cyrillic_A", "410");
        keysymToKeychar.put("Cyrillic_BE", "411");
        keysymToKeychar.put("Cyrillic_TSE", "426");
        keysymToKeychar.put("Cyrillic_DE", "414");
        keysymToKeychar.put("Cyrillic_IE", "415");
        keysymToKeychar.put("Cyrillic_EF", "424");
        keysymToKeychar.put("Cyrillic_GHE", "413");
        keysymToKeychar.put("Cyrillic_HA", "425");
        keysymToKeychar.put("Cyrillic_I", "418");
        keysymToKeychar.put("Cyrillic_SHORTI", "419");
        keysymToKeychar.put("Cyrillic_KA", "41a");
        keysymToKeychar.put("Cyrillic_EL", "41b");
        keysymToKeychar.put("Cyrillic_EM", "41c");
        keysymToKeychar.put("Cyrillic_EN", "41d");
        keysymToKeychar.put("Cyrillic_O", "41e");
        keysymToKeychar.put("Cyrillic_PE", "41f");
        keysymToKeychar.put("Cyrillic_YA", "42f");
        keysymToKeychar.put("Cyrillic_ER", "420");
        keysymToKeychar.put("Cyrillic_ES", "421");
        keysymToKeychar.put("Cyrillic_TE", "422");
        keysymToKeychar.put("Cyrillic_U", "423");
        keysymToKeychar.put("Cyrillic_ZHE", "416");
        keysymToKeychar.put("Cyrillic_VE", "412");
        keysymToKeychar.put("Cyrillic_SOFTSIGN", "42c");
        keysymToKeychar.put("Cyrillic_YERU", "42b");
        keysymToKeychar.put("Cyrillic_ZE", "417");
        keysymToKeychar.put("Cyrillic_SHA", "428");
        keysymToKeychar.put("Cyrillic_E", "42d");
        keysymToKeychar.put("Cyrillic_SHCHA", "429");
        keysymToKeychar.put("Cyrillic_CHE", "427");
        keysymToKeychar.put("Cyrillic_HARDSIGN", "42a");
        keysymToKeychar.put("Cyrillic_schwa", "4d9");
        keysymToKeychar.put("Cyrillic_SCHWA", "4d8");
        keysymToKeychar.put("Cyrillic_en_descender", "4a3");
        keysymToKeychar.put("Cyrillic_EN_descender", "4a2");
        keysymToKeychar.put("Cyrillic_ghe_bar", "493");
        keysymToKeychar.put("Cyrillic_GHE_bar", "492");
        keysymToKeychar.put("Cyrillic_u_straight", "4af");
        keysymToKeychar.put("Cyrillic_U_straight", "4ae");
        keysymToKeychar.put("Cyrillic_u_straight_bar", "4b1");
        keysymToKeychar.put("Cyrillic_U_straight_bar", "4b0");
        keysymToKeychar.put("Cyrillic_ka_descender", "49b");
        keysymToKeychar.put("Cyrillic_KA_descender", "49a");
        keysymToKeychar.put("Cyrillic_o_bar", "4e9");
        keysymToKeychar.put("Cyrillic_O_bar", "4e8");
        keysymToKeychar.put("Cyrillic_shha", "4bb");
        keysymToKeychar.put("Cyrillic_SHHA", "4ba");
        keysymToKeychar.put("Greek_ALPHAaccent", "386");
        keysymToKeychar.put("Greek_EPSILONaccent", "388");
        keysymToKeychar.put("Greek_ETAaccent", "389");
        keysymToKeychar.put("Greek_IOTAaccent", "38a");
        keysymToKeychar.put("Greek_IOTAdieresis", "3aa");
        keysymToKeychar.put("Greek_IOTAdiaeresis", "3aa");
        keysymToKeychar.put("Greek_OMICRONaccent", "38c");
        keysymToKeychar.put("Greek_UPSILONaccent", "38e");
        keysymToKeychar.put("Greek_UPSILONdieresis", "3ab");
        keysymToKeychar.put("Greek_OMEGAaccent", "38f");
        keysymToKeychar.put("Greek_accentdieresis", "385");
        keysymToKeychar.put("Greek_horizbar", "2015");
        keysymToKeychar.put("Greek_alphaaccent", "3ac");
        keysymToKeychar.put("Greek_epsilonaccent", "3ad");
        keysymToKeychar.put("Greek_etaaccent", "3ae");
        keysymToKeychar.put("Greek_iotaaccent", "3af");
        keysymToKeychar.put("Greek_iotadieresis", "3ca");
        keysymToKeychar.put("Greek_iotaaccentdieresis", "390");
        keysymToKeychar.put("Greek_omicronaccent", "3cc");
        keysymToKeychar.put("Greek_upsilonaccent", "3cd");
        keysymToKeychar.put("Greek_upsilondieresis", "3cb");
        keysymToKeychar.put("Greek_upsilonaccentdieresis", "3b0");
        keysymToKeychar.put("Greek_omegaaccent", "3ce");
        keysymToKeychar.put("Greek_ALPHA", "391");
        keysymToKeychar.put("Greek_BETA", "392");
        keysymToKeychar.put("Greek_GAMMA", "393");
        keysymToKeychar.put("Greek_DELTA", "394");
        keysymToKeychar.put("Greek_EPSILON", "395");
        keysymToKeychar.put("Greek_ZETA", "396");
        keysymToKeychar.put("Greek_ETA", "397");
        keysymToKeychar.put("Greek_THETA", "398");
        keysymToKeychar.put("Greek_IOTA", "399");
        keysymToKeychar.put("Greek_KAPPA", "39a");
        keysymToKeychar.put("Greek_LAMBDA", "39b");
        keysymToKeychar.put("Greek_LAMDA", "39b");
        keysymToKeychar.put("Greek_MU", "39c");
        keysymToKeychar.put("Greek_NU", "39d");
        keysymToKeychar.put("Greek_XI", "39e");
        keysymToKeychar.put("Greek_OMICRON", "39f");
        keysymToKeychar.put("Greek_PI", "3a0");
        keysymToKeychar.put("Greek_RHO", "3a1");
        keysymToKeychar.put("Greek_SIGMA", "3a3");
        keysymToKeychar.put("Greek_TAU", "3a4");
        keysymToKeychar.put("Greek_UPSILON", "3a5");
        keysymToKeychar.put("Greek_PHI", "3a6");
        keysymToKeychar.put("Greek_CHI", "3a7");
        keysymToKeychar.put("Greek_PSI", "3a8");
        keysymToKeychar.put("Greek_OMEGA", "3a9");
        keysymToKeychar.put("Greek_alpha", "3b1");
        keysymToKeychar.put("Greek_beta", "3b2");
        keysymToKeychar.put("Greek_gamma", "3b3");
        keysymToKeychar.put("Greek_delta", "3b4");
        keysymToKeychar.put("Greek_epsilon", "3b5");
        keysymToKeychar.put("Greek_zeta", "3b6");
        keysymToKeychar.put("Greek_eta", "3b7");
        keysymToKeychar.put("Greek_theta", "3b8");
        keysymToKeychar.put("Greek_iota", "3b9");
        keysymToKeychar.put("Greek_kappa", "3ba");
        keysymToKeychar.put("Greek_lambda", "3bb");
        keysymToKeychar.put("Greek_lamda", "3bb");
        keysymToKeychar.put("Greek_mu", "3bc");
        keysymToKeychar.put("Greek_nu", "3bd");
        keysymToKeychar.put("Greek_xi", "3be");
        keysymToKeychar.put("Greek_omicron", "3bf");
        keysymToKeychar.put("Greek_pi", "3c0");
        keysymToKeychar.put("Greek_rho", "3c1");
        keysymToKeychar.put("Greek_sigma", "3c3");
        keysymToKeychar.put("Greek_finalsmallsigma", "3c2");
        keysymToKeychar.put("Greek_tau", "3c4");
        keysymToKeychar.put("Greek_upsilon", "3c5");
        keysymToKeychar.put("Greek_phi", "3c6");
        keysymToKeychar.put("Greek_chi", "3c7");
        keysymToKeychar.put("Greek_psi", "3c8");
        keysymToKeychar.put("Greek_omega", "3c9");
        keysymToKeychar.put("leftradical", "23b7");
        keysymToKeychar.put("topleftradical", "250c");
        keysymToKeychar.put("horizconnector", "2500");
        keysymToKeychar.put("topintegral", "2320");
        keysymToKeychar.put("botintegral", "2321");
        keysymToKeychar.put("vertconnector", "2502");
        keysymToKeychar.put("topleftsqbracket", "23a1");
        keysymToKeychar.put("botleftsqbracket", "23a3");
        keysymToKeychar.put("toprightsqbracket", "23a4");
        keysymToKeychar.put("botrightsqbracket", "23a6");
        keysymToKeychar.put("topleftparens", "239b");
        keysymToKeychar.put("botleftparens", "239d");
        keysymToKeychar.put("toprightparens", "239e");
        keysymToKeychar.put("botrightparens", "23a0");
        keysymToKeychar.put("leftmiddlecurlybrace", "23a8");
        keysymToKeychar.put("rightmiddlecurlybrace", "23ac");
        keysymToKeychar.put("lessthanequal", "2264");
        keysymToKeychar.put("notequal", "2260");
        keysymToKeychar.put("greaterthanequal", "2265");
        keysymToKeychar.put("integral", "222b");
        keysymToKeychar.put("therefore", "2234");
        keysymToKeychar.put("variation", "221d");
        keysymToKeychar.put("infinity", "221e");
        keysymToKeychar.put("nabla", "2207");
        keysymToKeychar.put("approximate", "223c");
        keysymToKeychar.put("similarequal", "2243");
        keysymToKeychar.put("ifonlyif", "21d4");
        keysymToKeychar.put("implies", "21d2");
        keysymToKeychar.put("identical", "2261");
        keysymToKeychar.put("radical", "221a");
        keysymToKeychar.put("includedin", "2282");
        keysymToKeychar.put("includes", "2283");
        keysymToKeychar.put("intersection", "2229");
        keysymToKeychar.put("union", "222a");
        keysymToKeychar.put("logicaland", "2227");
        keysymToKeychar.put("logicalor", "2228");
        keysymToKeychar.put("partialderivative", "2202");
        keysymToKeychar.put("function", "192");
        keysymToKeychar.put("leftarrow", "2190");
        keysymToKeychar.put("uparrow", "2191");
        keysymToKeychar.put("rightarrow", "2192");
        keysymToKeychar.put("downarrow", "2193");
        keysymToKeychar.put("soliddiamond", "25c6");
        keysymToKeychar.put("checkerboard", "2592");
        keysymToKeychar.put("ht", "2409");
        keysymToKeychar.put("ff", "240c");
        keysymToKeychar.put("cr", "240d");
        keysymToKeychar.put("lf", "240a");
        keysymToKeychar.put("nl", "2424");
        keysymToKeychar.put("vt", "240b");
        keysymToKeychar.put("lowrightcorner", "2518");
        keysymToKeychar.put("uprightcorner", "2510");
        keysymToKeychar.put("upleftcorner", "250c");
        keysymToKeychar.put("lowleftcorner", "2514");
        keysymToKeychar.put("crossinglines", "253c");
        keysymToKeychar.put("horizlinescan1", "23ba");
        keysymToKeychar.put("horizlinescan3", "23bb");
        keysymToKeychar.put("horizlinescan5", "2500");
        keysymToKeychar.put("horizlinescan7", "23bc");
        keysymToKeychar.put("horizlinescan9", "23bd");
        keysymToKeychar.put("leftt", "251c");
        keysymToKeychar.put("rightt", "2524");
        keysymToKeychar.put("bott", "2534");
        keysymToKeychar.put("topt", "252c");
        keysymToKeychar.put("vertbar", "2502");
        keysymToKeychar.put("emspace", "2003");
        keysymToKeychar.put("enspace", "2002");
        keysymToKeychar.put("em3space", "2004");
        keysymToKeychar.put("em4space", "2005");
        keysymToKeychar.put("digitspace", "2007");
        keysymToKeychar.put("punctspace", "2008");
        keysymToKeychar.put("thinspace", "2009");
        keysymToKeychar.put("hairspace", "200a");
        keysymToKeychar.put("emdash", "2014");
        keysymToKeychar.put("endash", "2013");
        keysymToKeychar.put("ellipsis", "2026");
        keysymToKeychar.put("doubbaselinedot", "2025");
        keysymToKeychar.put("onethird", "2153");
        keysymToKeychar.put("twothirds", "2154");
        keysymToKeychar.put("onefifth", "2155");
        keysymToKeychar.put("twofifths", "2156");
        keysymToKeychar.put("threefifths", "2157");
        keysymToKeychar.put("fourfifths", "2158");
        keysymToKeychar.put("onesixth", "2159");
        keysymToKeychar.put("fivesixths", "215a");
        keysymToKeychar.put("careof", "2105");
        keysymToKeychar.put("figdash", "2012");
        keysymToKeychar.put("leftanglebracket", "2329");
        keysymToKeychar.put("rightanglebracket", "232a");
        keysymToKeychar.put("oneeighth", "215b");
        keysymToKeychar.put("threeeighths", "215c");
        keysymToKeychar.put("fiveeighths", "215d");
        keysymToKeychar.put("seveneighths", "215e");
        keysymToKeychar.put("trademark", "2122");
        keysymToKeychar.put("signaturemark", "2613");
        keysymToKeychar.put("leftopentriangle", "25c1");
        keysymToKeychar.put("rightopentriangle", "25b7");
        keysymToKeychar.put("emopencircle", "25cb");
        keysymToKeychar.put("emopenrectangle", "25af");
        keysymToKeychar.put("leftsinglequotemark", "2018");
        keysymToKeychar.put("rightsinglequotemark", "2019");
        keysymToKeychar.put("leftdoublequotemark", "201c");
        keysymToKeychar.put("rightdoublequotemark", "201d");
        keysymToKeychar.put("prescription", "211e");
        keysymToKeychar.put("minutes", "2032");
        keysymToKeychar.put("seconds", "2033");
        keysymToKeychar.put("latincross", "271d");
        keysymToKeychar.put("filledrectbullet", "25ac");
        keysymToKeychar.put("filledlefttribullet", "25c0");
        keysymToKeychar.put("filledrighttribullet", "25b6");
        keysymToKeychar.put("emfilledcircle", "25cf");
        keysymToKeychar.put("emfilledrect", "25ae");
        keysymToKeychar.put("enopencircbullet", "25e6");
        keysymToKeychar.put("enopensquarebullet", "25ab");
        keysymToKeychar.put("openrectbullet", "25ad");
        keysymToKeychar.put("opentribulletup", "25b3");
        keysymToKeychar.put("opentribulletdown", "25bd");
        keysymToKeychar.put("openstar", "2606");
        keysymToKeychar.put("enfilledcircbullet", "2022");
        keysymToKeychar.put("enfilledsqbullet", "25aa");
        keysymToKeychar.put("filledtribulletup", "25b2");
        keysymToKeychar.put("filledtribulletdown", "25bc");
        keysymToKeychar.put("leftpointer", "261c");
        keysymToKeychar.put("rightpointer", "261e");
        keysymToKeychar.put("club", "2663");
        keysymToKeychar.put("diamond", "2666");
        keysymToKeychar.put("heart", "2665");
        keysymToKeychar.put("maltesecross", "2720");
        keysymToKeychar.put("dagger", "2020");
        keysymToKeychar.put("doubledagger", "2021");
        keysymToKeychar.put("checkmark", "2713");
        keysymToKeychar.put("ballotcross", "2717");
        keysymToKeychar.put("musicalsharp", "266f");
        keysymToKeychar.put("musicalflat", "266d");
        keysymToKeychar.put("malesymbol", "2642");
        keysymToKeychar.put("femalesymbol", "2640");
        keysymToKeychar.put("telephone", "260e");
        keysymToKeychar.put("telephonerecorder", "2315");
        keysymToKeychar.put("phonographcopyright", "2117");
        keysymToKeychar.put("caret", "2038");
        keysymToKeychar.put("singlelowquotemark", "201a");
        keysymToKeychar.put("doublelowquotemark", "201e");
        keysymToKeychar.put("leftcaret", "3c");
        keysymToKeychar.put("rightcaret", "3e");
        keysymToKeychar.put("downcaret", "2228");
        keysymToKeychar.put("upcaret", "2227");
        keysymToKeychar.put("overbar", "af");
        keysymToKeychar.put("downtack", "22a5");
        keysymToKeychar.put("upshoe", "2229");
        keysymToKeychar.put("downstile", "230a");
        keysymToKeychar.put("underbar", "5f");
        keysymToKeychar.put("jot", "2218");
        keysymToKeychar.put("quad", "2395");
        keysymToKeychar.put("uptack", "22a4");
        keysymToKeychar.put("circle", "25cb");
        keysymToKeychar.put("upstile", "2308");
        keysymToKeychar.put("downshoe", "222a");
        keysymToKeychar.put("rightshoe", "2283");
        keysymToKeychar.put("leftshoe", "2282");
        keysymToKeychar.put("lefttack", "22a2");
        keysymToKeychar.put("righttack", "22a3");
        keysymToKeychar.put("hebrew_doublelowline", "2017");
        keysymToKeychar.put("hebrew_aleph", "5d0");
        keysymToKeychar.put("hebrew_bet", "5d1");
        keysymToKeychar.put("hebrew_beth", "5d1");
        keysymToKeychar.put("hebrew_gimel", "5d2");
        keysymToKeychar.put("hebrew_gimmel", "5d2");
        keysymToKeychar.put("hebrew_dalet", "5d3");
        keysymToKeychar.put("hebrew_daleth", "5d3");
        keysymToKeychar.put("hebrew_he", "5d4");
        keysymToKeychar.put("hebrew_waw", "5d5");
        keysymToKeychar.put("hebrew_zain", "5d6");
        keysymToKeychar.put("hebrew_zayin", "5d6");
        keysymToKeychar.put("hebrew_chet", "5d7");
        keysymToKeychar.put("hebrew_het", "5d7");
        keysymToKeychar.put("hebrew_tet", "5d8");
        keysymToKeychar.put("hebrew_teth", "5d8");
        keysymToKeychar.put("hebrew_yod", "5d9");
        keysymToKeychar.put("hebrew_finalkaph", "5da");
        keysymToKeychar.put("hebrew_kaph", "5db");
        keysymToKeychar.put("hebrew_lamed", "5dc");
        keysymToKeychar.put("hebrew_finalmem", "5dd");
        keysymToKeychar.put("hebrew_mem", "5de");
        keysymToKeychar.put("hebrew_finalnun", "5df");
        keysymToKeychar.put("hebrew_nun", "5e0");
        keysymToKeychar.put("hebrew_samech", "5e1");
        keysymToKeychar.put("hebrew_samekh", "5e1");
        keysymToKeychar.put("hebrew_ayin", "5e2");
        keysymToKeychar.put("hebrew_finalpe", "5e3");
        keysymToKeychar.put("hebrew_pe", "5e4");
        keysymToKeychar.put("hebrew_finalzade", "5e5");
        keysymToKeychar.put("hebrew_finalzadi", "5e5");
        keysymToKeychar.put("hebrew_zade", "5e6");
        keysymToKeychar.put("hebrew_zadi", "5e6");
        keysymToKeychar.put("hebrew_kuf", "5e7");
        keysymToKeychar.put("hebrew_qoph", "5e7");
        keysymToKeychar.put("hebrew_resh", "5e8");
        keysymToKeychar.put("hebrew_shin", "5e9");
        keysymToKeychar.put("hebrew_taf", "5ea");
        keysymToKeychar.put("hebrew_taw", "5ea");
        keysymToKeychar.put("Thai_kokai", "e01");
        keysymToKeychar.put("Thai_khokhai", "e02");
        keysymToKeychar.put("Thai_khokhuat", "e03");
        keysymToKeychar.put("Thai_khokhwai", "e04");
        keysymToKeychar.put("Thai_khokhon", "e05");
        keysymToKeychar.put("Thai_khorakhang", "e06");
        keysymToKeychar.put("Thai_ngongu", "e07");
        keysymToKeychar.put("Thai_chochan", "e08");
        keysymToKeychar.put("Thai_choching", "e09");
        keysymToKeychar.put("Thai_chochang", "e0a");
        keysymToKeychar.put("Thai_soso", "e0b");
        keysymToKeychar.put("Thai_chochoe", "e0c");
        keysymToKeychar.put("Thai_yoying", "e0d");
        keysymToKeychar.put("Thai_dochada", "e0e");
        keysymToKeychar.put("Thai_topatak", "e0f");
        keysymToKeychar.put("Thai_thothan", "e10");
        keysymToKeychar.put("Thai_thonangmontho", "e11");
        keysymToKeychar.put("Thai_thophuthao", "e12");
        keysymToKeychar.put("Thai_nonen", "e13");
        keysymToKeychar.put("Thai_dodek", "e14");
        keysymToKeychar.put("Thai_totao", "e15");
        keysymToKeychar.put("Thai_thothung", "e16");
        keysymToKeychar.put("Thai_thothahan", "e17");
        keysymToKeychar.put("Thai_thothong", "e18");
        keysymToKeychar.put("Thai_nonu", "e19");
        keysymToKeychar.put("Thai_bobaimai", "e1a");
        keysymToKeychar.put("Thai_popla", "e1b");
        keysymToKeychar.put("Thai_phophung", "e1c");
        keysymToKeychar.put("Thai_fofa", "e1d");
        keysymToKeychar.put("Thai_phophan", "e1e");
        keysymToKeychar.put("Thai_fofan", "e1f");
        keysymToKeychar.put("Thai_phosamphao", "e20");
        keysymToKeychar.put("Thai_moma", "e21");
        keysymToKeychar.put("Thai_yoyak", "e22");
        keysymToKeychar.put("Thai_rorua", "e23");
        keysymToKeychar.put("Thai_ru", "e24");
        keysymToKeychar.put("Thai_loling", "e25");
        keysymToKeychar.put("Thai_lu", "e26");
        keysymToKeychar.put("Thai_wowaen", "e27");
        keysymToKeychar.put("Thai_sosala", "e28");
        keysymToKeychar.put("Thai_sorusi", "e29");
        keysymToKeychar.put("Thai_sosua", "e2a");
        keysymToKeychar.put("Thai_hohip", "e2b");
        keysymToKeychar.put("Thai_lochula", "e2c");
        keysymToKeychar.put("Thai_oang", "e2d");
        keysymToKeychar.put("Thai_honokhuk", "e2e");
        keysymToKeychar.put("Thai_paiyannoi", "e2f");
        keysymToKeychar.put("Thai_saraa", "e30");
        keysymToKeychar.put("Thai_maihanakat", "e31");
        keysymToKeychar.put("Thai_saraaa", "e32");
        keysymToKeychar.put("Thai_saraam", "e33");
        keysymToKeychar.put("Thai_sarai", "e34");
        keysymToKeychar.put("Thai_saraii", "e35");
        keysymToKeychar.put("Thai_saraue", "e36");
        keysymToKeychar.put("Thai_sarauee", "e37");
        keysymToKeychar.put("Thai_sarau", "e38");
        keysymToKeychar.put("Thai_sarauu", "e39");
        keysymToKeychar.put("Thai_phinthu", "e3a");
        keysymToKeychar.put("Thai_maihanakat_maitho", "dde");
        keysymToKeychar.put("Thai_baht", "e3f");
        keysymToKeychar.put("Thai_sarae", "e40");
        keysymToKeychar.put("Thai_saraae", "e41");
        keysymToKeychar.put("Thai_sarao", "e42");
        keysymToKeychar.put("Thai_saraaimaimuan", "e43");
        keysymToKeychar.put("Thai_saraaimaimalai", "e44");
        keysymToKeychar.put("Thai_lakkhangyao", "e45");
        keysymToKeychar.put("Thai_maiyamok", "e46");
        keysymToKeychar.put("Thai_maitaikhu", "e47");
        keysymToKeychar.put("Thai_maiek", "e48");
        keysymToKeychar.put("Thai_maitho", "e49");
        keysymToKeychar.put("Thai_maitri", "e4a");
        keysymToKeychar.put("Thai_maichattawa", "e4b");
        keysymToKeychar.put("Thai_thanthakhat", "e4c");
        keysymToKeychar.put("Thai_nikhahit", "e4d");
        keysymToKeychar.put("Thai_leksun", "e50");
        keysymToKeychar.put("Thai_leknung", "e51");
        keysymToKeychar.put("Thai_leksong", "e52");
        keysymToKeychar.put("Thai_leksam", "e53");
        keysymToKeychar.put("Thai_leksi", "e54");
        keysymToKeychar.put("Thai_lekha", "e55");
        keysymToKeychar.put("Thai_lekhok", "e56");
        keysymToKeychar.put("Thai_lekchet", "e57");
        keysymToKeychar.put("Thai_lekpaet", "e58");
        keysymToKeychar.put("Thai_lekkao", "e59");
        keysymToKeychar.put("Hangul_Kiyeog", "3131");
        keysymToKeychar.put("Hangul_SsangKiyeog", "3132");
        keysymToKeychar.put("Hangul_KiyeogSios", "3133");
        keysymToKeychar.put("Hangul_Nieun", "3134");
        keysymToKeychar.put("Hangul_NieunJieuj", "3135");
        keysymToKeychar.put("Hangul_NieunHieuh", "3136");
        keysymToKeychar.put("Hangul_Dikeud", "3137");
        keysymToKeychar.put("Hangul_SsangDikeud", "3138");
        keysymToKeychar.put("Hangul_Rieul", "3139");
        keysymToKeychar.put("Hangul_RieulKiyeog", "313a");
        keysymToKeychar.put("Hangul_RieulMieum", "313b");
        keysymToKeychar.put("Hangul_RieulPieub", "313c");
        keysymToKeychar.put("Hangul_RieulSios", "313d");
        keysymToKeychar.put("Hangul_RieulTieut", "313e");
        keysymToKeychar.put("Hangul_RieulPhieuf", "313f");
        keysymToKeychar.put("Hangul_RieulHieuh", "3140");
        keysymToKeychar.put("Hangul_Mieum", "3141");
        keysymToKeychar.put("Hangul_Pieub", "3142");
        keysymToKeychar.put("Hangul_SsangPieub", "3143");
        keysymToKeychar.put("Hangul_PieubSios", "3144");
        keysymToKeychar.put("Hangul_Sios", "3145");
        keysymToKeychar.put("Hangul_SsangSios", "3146");
        keysymToKeychar.put("Hangul_Ieung", "3147");
        keysymToKeychar.put("Hangul_Jieuj", "3148");
        keysymToKeychar.put("Hangul_SsangJieuj", "3149");
        keysymToKeychar.put("Hangul_Cieuc", "314a");
        keysymToKeychar.put("Hangul_Khieuq", "314b");
        keysymToKeychar.put("Hangul_Tieut", "314c");
        keysymToKeychar.put("Hangul_Phieuf", "314d");
        keysymToKeychar.put("Hangul_Hieuh", "314e");
        keysymToKeychar.put("Hangul_A", "314f");
        keysymToKeychar.put("Hangul_AE", "3150");
        keysymToKeychar.put("Hangul_YA", "3151");
        keysymToKeychar.put("Hangul_YAE", "3152");
        keysymToKeychar.put("Hangul_EO", "3153");
        keysymToKeychar.put("Hangul_E", "3154");
        keysymToKeychar.put("Hangul_YEO", "3155");
        keysymToKeychar.put("Hangul_YE", "3156");
        keysymToKeychar.put("Hangul_O", "3157");
        keysymToKeychar.put("Hangul_WA", "3158");
        keysymToKeychar.put("Hangul_WAE", "3159");
        keysymToKeychar.put("Hangul_OE", "315a");
        keysymToKeychar.put("Hangul_YO", "315b");
        keysymToKeychar.put("Hangul_U", "315c");
        keysymToKeychar.put("Hangul_WEO", "315d");
        keysymToKeychar.put("Hangul_WE", "315e");
        keysymToKeychar.put("Hangul_WI", "315f");
        keysymToKeychar.put("Hangul_YU", "3160");
        keysymToKeychar.put("Hangul_EU", "3161");
        keysymToKeychar.put("Hangul_YI", "3162");
        keysymToKeychar.put("Hangul_I", "3163");
        keysymToKeychar.put("Hangul_J_Kiyeog", "11a8");
        keysymToKeychar.put("Hangul_J_SsangKiyeog", "11a9");
        keysymToKeychar.put("Hangul_J_KiyeogSios", "11aa");
        keysymToKeychar.put("Hangul_J_Nieun", "11ab");
        keysymToKeychar.put("Hangul_J_NieunJieuj", "11ac");
        keysymToKeychar.put("Hangul_J_NieunHieuh", "11ad");
        keysymToKeychar.put("Hangul_J_Dikeud", "11ae");
        keysymToKeychar.put("Hangul_J_Rieul", "11af");
        keysymToKeychar.put("Hangul_J_RieulKiyeog", "11b0");
        keysymToKeychar.put("Hangul_J_RieulMieum", "11b1");
        keysymToKeychar.put("Hangul_J_RieulPieub", "11b2");
        keysymToKeychar.put("Hangul_J_RieulSios", "11b3");
        keysymToKeychar.put("Hangul_J_RieulTieut", "11b4");
        keysymToKeychar.put("Hangul_J_RieulPhieuf", "11b5");
        keysymToKeychar.put("Hangul_J_RieulHieuh", "11b6");
        keysymToKeychar.put("Hangul_J_Mieum", "11b7");
        keysymToKeychar.put("Hangul_J_Pieub", "11b8");
        keysymToKeychar.put("Hangul_J_PieubSios", "11b9");
        keysymToKeychar.put("Hangul_J_Sios", "11ba");
        keysymToKeychar.put("Hangul_J_SsangSios", "11bb");
        keysymToKeychar.put("Hangul_J_Ieung", "11bc");
        keysymToKeychar.put("Hangul_J_Jieuj", "11bd");
        keysymToKeychar.put("Hangul_J_Cieuc", "11be");
        keysymToKeychar.put("Hangul_J_Khieuq", "11bf");
        keysymToKeychar.put("Hangul_J_Tieut", "11c0");
        keysymToKeychar.put("Hangul_J_Phieuf", "11c1");
        keysymToKeychar.put("Hangul_J_Hieuh", "11c2");
        keysymToKeychar.put("Hangul_RieulYeorinHieuh", "316d");
        keysymToKeychar.put("Hangul_SunkyeongeumMieum", "3171");
        keysymToKeychar.put("Hangul_SunkyeongeumPieub", "3178");
        keysymToKeychar.put("Hangul_PanSios", "317f");
        keysymToKeychar.put("Hangul_KkogjiDalrinIeung", "3181");
        keysymToKeychar.put("Hangul_SunkyeongeumPhieuf", "3184");
        keysymToKeychar.put("Hangul_YeorinHieuh", "3186");
        keysymToKeychar.put("Hangul_AraeA", "318d");
        keysymToKeychar.put("Hangul_AraeAE", "318e");
        keysymToKeychar.put("Hangul_J_PanSios", "11eb");
        keysymToKeychar.put("Hangul_J_KkogjiDalrinIeung", "11f0");
        keysymToKeychar.put("Hangul_J_YeorinHieuh", "11f9");
        keysymToKeychar.put("Korean_Won", "20a9");
        keysymToKeychar.put("OE", "152");
        keysymToKeychar.put("oe", "153");
        keysymToKeychar.put("Ydiaeresis", "178");
        keysymToKeychar.put("EcuSign", "20a0");
        keysymToKeychar.put("ColonSign", "20a1");
        keysymToKeychar.put("CruzeiroSign", "20a2");
        keysymToKeychar.put("FFrancSign", "20a3");
        keysymToKeychar.put("LiraSign", "20a4");
        keysymToKeychar.put("MillSign", "20a5");
        keysymToKeychar.put("NairaSign", "20a6");
        keysymToKeychar.put("PesetaSign", "20a7");
        keysymToKeychar.put("RupeeSign", "20a8");
        keysymToKeychar.put("WonSign", "20a9");
        keysymToKeychar.put("NewSheqelSign", "20aa");
        keysymToKeychar.put("DongSign", "20ab");
        keysymToKeychar.put("EuroSign", "20ac");
        keysymToKeychar.put("dead_grave", "300");
        keysymToKeychar.put("dead_acute", "301");
        keysymToKeychar.put("dead_acutee", "301");
        keysymToKeychar.put("dead_circumflex", "302");
        keysymToKeychar.put("dead_tilde", "303");
        keysymToKeychar.put("dead_macron", "304");
        keysymToKeychar.put("dead_breve", "306");
        keysymToKeychar.put("dead_abovedot", "307");
        keysymToKeychar.put("dead_diaeresis", "308");
        keysymToKeychar.put("dead_abovering", "30a");
        keysymToKeychar.put("dead_doubleacute", "30b");
        keysymToKeychar.put("dead_caron", "30c");
        keysymToKeychar.put("dead_cedilla", "327");
        keysymToKeychar.put("dead_ogonek", "328");
        keysymToKeychar.put("dead_iota", "345");
        keysymToKeychar.put("dead_voiced_sound", "30f");
        keysymToKeychar.put("dead_semivoiced_sound", "30a");
        keysymToKeychar.put("dead_belowdot", "323");
        keysymToKeychar.put("BackSpace", "8");
        keysymToKeychar.put("Tab", "9");
        keysymToKeychar.put("Linefeed", "a");
        keysymToKeychar.put("Clear", "b");
        keysymToKeychar.put("Return", "d");
    };
    
    public static String toKeychar(String keysym) {
        String keychar = null;
        if (keysym.startsWith("0x") && keysym.length() > 4) {
            keychar = keysym.substring((keysym.length() - 4));
        } else {
            keychar = keysymToKeychar.get(keysym);
        }
        return keychar;
    }
    
    public static String toKeycode(String keysym) {
        String keycode = keysymToKeycode.get(keysym);
        return keycode;
    }
}
