/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * SheetCreator.java
 *
 * Created on 2006/07/06, 15:42
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.io.*;
import java.util.*;

import com.sun.star.uno.XComponentContext;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.beans.XPropertySet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XViewFreezable;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.util.XMergeable;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;

/**
 *
 * @author naoyuki
 */
public class SheetHandler {
    
    private XSpreadsheet sheet;
    
    public SheetHandler(String sheetName) throws Exception {
        sheet = getSheet(sheetName);
    }

    public void setStr (int col, int row, String value) throws Exception {
        XCell cell = sheet.getCellByPosition(col, row);
        XText textCell = (XText)UnoRuntime.queryInterface(XText.class, cell);
        textCell.setString(value);
    }
    
    public void format() {
        // setting color, font, width
        try {
            XColumnRowRange colRowRange = (XColumnRowRange)UnoRuntime.queryInterface(XColumnRowRange.class, sheet);
            XTableColumns columns = (XTableColumns)UnoRuntime.queryInterface(XTableColumns.class, colRowRange.getColumns());
            Object firstCol = columns.getByIndex(0);
            XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, firstCol);
            props.setPropertyValue("CellBackColor", new Integer(0xEEEEDD));
            props.setPropertyValue("CharWeight", new Float(com.sun.star.awt.FontWeight.BOLD));
            XTableRows rows = (XTableRows)UnoRuntime.queryInterface(XTableRows.class, colRowRange.getRows());
            Object firstRow = rows.getByIndex(0);
            XPropertySet rprops = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, firstRow);
            rprops.setPropertyValue("CellBackColor", new Integer(0xEEDDEE));
            rprops.setPropertyValue("CharWeight", new Float(com.sun.star.awt.FontWeight.BOLD));
            Object secondRow = rows.getByIndex(1);
            rprops = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, secondRow);
            rprops.setPropertyValue("CellBackColor", new Integer(0xDDEEDD));
            
            // freeze header row and column
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, doc);
            XController controller = model.getCurrentController();
            XViewFreezable freezer = (XViewFreezable)UnoRuntime.queryInterface(XViewFreezable.class, controller);
            freezer.freezeAtPosition(1, 2);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public void grayOutCol(int column) {
        try {
            XColumnRowRange colRowRange = (XColumnRowRange)UnoRuntime.queryInterface(XColumnRowRange.class, sheet);
            XTableColumns columns = (XTableColumns)UnoRuntime.queryInterface(XTableColumns.class, colRowRange.getColumns());
            Object col = columns.getByIndex(column);
            XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, col);
            props.setPropertyValue("CellBackColor", new Integer(0xEFEFEF));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public void blankRow(int row) {
        try {
            XColumnRowRange colRowRange = (XColumnRowRange)UnoRuntime.queryInterface(XColumnRowRange.class, sheet);
            XTableRows rows = (XTableRows)UnoRuntime.queryInterface(XTableRows.class, colRowRange.getRows());
            Object rowObj = rows.getByIndex(row);
            XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, rowObj);
            props.setPropertyValue("CellBackColor", new Integer(0xDDDDDD));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    private static XSpreadsheet getSheet(String name) throws Exception {
        XSpreadsheet sheet;
        
        if (!initialized) {
            init();
            initialized = true;
            sheets = doc.getSheets();
            
            delset = new HashSet<Object>();
            XIndexAccess ia = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, sheets);            
            for (int i = 0, len = ia.getCount(); i < len;  i++) {
                Object s = ia.getByIndex(i);
                if (s != null)
                    delset.add(s);
            }            
        }
        sheets = doc.getSheets();

        if (sheets.hasByName(name)) {
            Object s = sheets.getByName(name);
            sheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, s);
            return sheet;
        }
        sheets.insertNewByName(name, (short)0);
        Object sheetObj = sheets.getByName(name);

        if (delset != null) {
            Iterator itr = delset.iterator();

            while (itr.hasNext()) {
                Object s = itr.next();
                XNamed sh = (XNamed)UnoRuntime.queryInterface(XNamed.class, s);
                String n = sh.getName();
                sheets.removeByName(n);
            }
            delset = null;
        }

        sheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, sheetObj);

        return sheet;
    }
        
    private static boolean initialized = false;    
    private static Set<Object> delset = null;
    private static XSpreadsheets sheets;

    private static XSpreadsheetDocument doc;
    private static void init() {
        XComponentLoader loader = getComponentLoader();
        PropertyValue[]  loadProps = new PropertyValue[0];
        try {
            XComponent component = loader.loadComponentFromURL(
                "private:factory/scalc", "_blank", 0, loadProps);
            doc = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, component);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    private static XComponentLoader getComponentLoader() {
        XComponentLoader loader = null;
        XMultiComponentFactory mcf;
        XComponentContext context;
        try {
            context = Bootstrap.bootstrap();
            mcf = context.getServiceManager();
            if (mcf == null) {
                System.out.println(" remote ServiceManager is not available");
                System.exit(1);
            }
            System.out.println(" connected to remote ServiceManager");
            Object desktop = mcf.createInstanceWithContext("com.sun.star.frame.Desktop", context);
            if (desktop == null) {
                System.out.println(" failed to make Desktop");
                System.exit(1);
            }

            loader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, desktop);
        } catch(Exception e) {
            e.printStackTrace();
            return null;
        }
        return loader;
    }
}
