/*
Copyright 1990-2006 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * CalcOutput.java
 *
 * Created on 2006/07/20, 15:01
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package kldhandler;

import java.util.*;

/**
 *
 * @author naoyuki
 */
public class CalcOutput implements DataOutput {
    
    /** Creates a new instance of CalcOutput */
    public CalcOutput() {
    }
    
    public void print(Map<String, Map<String, GLSymbol>> pinfo) throws Exception {
        // collect all of keycode exist in all types first
        SortedSet<String> allCode = new TreeSet<String>();
        for (String name : pinfo.keySet()) {
            Map<String, GLSymbol> m = pinfo.get(name);
            allCode.addAll(m.keySet());
        }
        // make code column at most left side
        // each code occupys 4 (g1l1, g1l2, g2l1, g2l2) rows plus 1 separator row
        SheetHandler sheetHandler = new SheetHandler("Layout map table");
        sheetHandler.format();
        
        sheetHandler.setStr(0, 0, "layout");
        sheetHandler.setStr(0, 1, "config");
        int i = 0;
        for (String code : allCode) {
            int r = i * 5 + 2;
            sheetHandler.setStr(0, r, code);
            i++;
            sheetHandler.blankRow(r + 4);            
        }
        int column = 1;
        SortedSet<String> sset = new TreeSet<String>(pinfo.keySet());
        for (String name : sset) {
            // add one column for this 'name' layout'
            sheetHandler.setStr(column, 0, name);
            // show config info at 2nd row
            LONameMapper mapper = Main.getMapper();
            String configStr = mapper.getConfigStr(name);
            if (configStr != null) {
                sheetHandler.setStr(column, 1, configStr);
            }
            if (mapper.srcOnly(name)) {
                sheetHandler.grayOutCol(column);
            }

            Map<String, GLSymbol> m = pinfo.get(name);
            Set<String> set = m.keySet();
            // add one keycode info with 4 symbols
            int row = 2;
            for (String gcode : allCode) {
                if (set.contains(gcode)) {
                    // fill 4 symbols
                    String gls = m.get(gcode).toString();
                    String[] gla = gls.split(",");
                    sheetHandler.setStr(column, row, gla[0].trim());
                    sheetHandler.setStr(column, row + 1, gla[1].trim());
                    sheetHandler.setStr(column, row + 2, gla[2].trim());
                    sheetHandler.setStr(column, row + 3, gla[3].trim());
                }
                row += 5;
            }
            column++;
        }
    }
    
}
