#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_select_hotkey_profile_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card8		scope,
    IIIMP_card16	profile_id)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_SELECT_HOTKEY_PROFILE;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.select_hotkey_profile.scope = scope;
    m->v.select_hotkey_profile.profile_id = profile_id;
    return m;
}


void
iiimp_select_hotkey_profile_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
	free(m);
}


uchar_t *
iiimp_select_hotkey_profile_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card8		scope,
    IIIMP_card16	profile_id,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    IIIMP_card16	scope_profile_id;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* PAD(2) or IC_ID */
    nbyte += 2;	/* SCOPE and PROFILE ID */

    nbyte += PAD(nbyte);

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_SELECT_HOTKEY_PROFILE, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    scope_profile_id = ((0x8000 & (scope << 15)) | (0x7fff & profile_id));
    PUTU16(scope_profile_id, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_select_hotkey_profile_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_select_hotkey_profile_v *	v;
    size_t				rest;
    const uchar_t *			p;
    IIIMP_card16			scope_profile_id;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.select_hotkey_profile);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);
    GETU16(scope_profile_id, rest, p, data_s->byte_swap);
    v->scope = ((0x8000 & scope_profile_id) >> 15);
    v->profile_id = (0x7fff & scope_profile_id);

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_select_hotkey_profile_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tscope = %s (%d)\n",
		  (0 == m->v.register_hotkeys.scope) ?
		  "global" : "session specific",
		  m->v.register_hotkeys.scope);
    (void)fprintf(data_s->print_fp, "\thotkey profile ID = %d\n", 
		  (0x7fff & m->v.register_hotkeys.profile_id));
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
