#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_aux_simple_new(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = opcode;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.aux_simple.class_index = class_index;
    m->v.aux_simple.input_method_name = input_method_name;
    return m;
}


void
iiimp_aux_simple_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_string_delete(data_s, m->v.aux_simple.input_method_name);
    free(m);
    return;
}


uchar_t *
iiimp_aux_simple_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name,
    size_t *		buf_size)
{
    size_t	nbyte;
    int		length;
    uchar_t *	buf;
    size_t	rest;
    uchar_t *	p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 4;	/* auxiliary window class index */
    nbyte += input_method_name->nbyte;	/* input method name */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, opcode, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU32(class_index, rest, p, data_s->byte_swap);
    iiimp_string_pack(data_s, input_method_name, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_aux_simple_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *	m;
    size_t		rest;
    const uchar_t *	p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);

    GETU32(m->v.aux_simple.class_index, rest, p, data_s->byte_swap);

    m->v.aux_simple.input_method_name =
	iiimp_string_unpack(data_s, &rest, &p, rest);
    if (NULL == m->v.aux_simple.input_method_name) {
	free(m);
	return NULL;
    }

    return m;
}


void
iiimp_aux_simple_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tindex=%d name=",
		  m->v.aux_simple.class_index);
    iiimp_string_print(data_s, m->v.aux_simple.input_method_name);
    (void)fputc('\n', data_s->print_fp);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
