#if !defined(IIIMP_DATA_P_H)
#define IIIMP_DATA_P_H


#include <stdio.h>
#include <sys/types.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#include <iiimp-data.h>


#ifdef	__cplusplus
extern "C" {
#endif


#if defined(_BIG_ENDIAN) || defined(WORDS_BIGENDIAN)

#define	GET_SCOPE_FOR_HOTKEY(n, p, b) \
				if (0 == (b)) { \
				    if ((*((uchar_t *)(p + 0)) & 0x80)) { \
					(n) = 1; \
				    } else { \
					(n) = 0; \
				    } \
				} else { \
				    if ((*((uchar_t *)(p + 1)) & 0x80)) { \
					(n) = 1; \
				    } else { \
					(n) = 0; \
				    } \
				};

#define	GETU15(n, p, b)	((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 8) + \
					  (((*((uchar_t *)(p + 1))) & 0x7F) << 0)) : \
					 ((((*((uchar_t *)(p + 0))) & 0x7F) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8))))

#define	GETU16(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 8) + \
					  ((*((uchar_t *)(p + 1))) << 0)) : \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8)))), \
				 ((p) += 2), \
				 ((r) -= 2))

#define	GETU32(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 24) + \
					  ((*((uchar_t *)(p + 1))) << 16) + \
					  ((*((uchar_t *)(p + 2))) << 8) + \
					  ((*((uchar_t *)(p + 3))) << 0)) : \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8) + \
					  ((*((uchar_t *)(p + 2))) << 16) + \
					  ((*((uchar_t *)(p + 3))) << 24)))), \
				 ((p) += 4), \
				 ((r) -= 4))

#define	GETU64(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((uint64_t)(*((uchar_t *)(p + 0))) << 56) + \
					  ((uint64_t)(*((uchar_t *)(p + 1))) << 48) + \
					  ((uint64_t)(*((uchar_t *)(p + 2))) << 40) + \
					  ((uint64_t)(*((uchar_t *)(p + 3))) << 32) + \
					  ((uint64_t)(*((uchar_t *)(p + 4))) << 24) + \
					  ((uint64_t)(*((uchar_t *)(p + 5))) << 16) + \
					  ((uint64_t)(*((uchar_t *)(p + 6))) << 8)  + \
					  ((uint64_t)(*((uchar_t *)(p + 7))) << 0)) : \
					 (((uint64_t)(*((uchar_t *)(p + 0))) << 0) + \
					  ((uint64_t)(*((uchar_t *)(p + 1))) << 8) + \
					  ((uint64_t)(*((uchar_t *)(p + 2))) << 16) + \
					  ((uint64_t)(*((uchar_t *)(p + 3))) << 24) + \
					  ((uint64_t)(*((uchar_t *)(p + 4))) << 32) + \
					  ((uint64_t)(*((uchar_t *)(p + 5))) << 40) + \
					  ((uint64_t)(*((uchar_t *)(p + 6))) << 48) + \
					  ((uint64_t)(*((uchar_t *)(p + 7))) << 56)))), \
				 ((p) += 8), \
				 ((r) -= 8))

#define	GET16(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 8) + \
					   ((*((uchar_t *)(p + 1))) << 0)) : \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8)))), \
			 ((p) += 2), \
			 ((r) -= 2))

#define	GET32(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				((int32_t)(((*((uchar_t *)(p + 0))) << 24) + \
					   ((*((uchar_t *)(p + 1))) << 16) + \
					   ((*((uchar_t *)(p + 2))) << 8) + \
					   ((*((uchar_t *)(p + 3))) << 0))) : \
				((int32_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8) + \
					   ((*((uchar_t *)(p + 2))) << 16) + \
					   ((*((uchar_t *)(p + 3))) << 24))))), \
			 ((p) += 4), \
			 ((r) -= 4))

#define	PUTU16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUTU32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			}; \
			((p) += 4); \
			((r) -= 4)

#define	PUTU64(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff00000000000000ULL) >> 56); \
				(*((p) + 1)) = (((n) & 0x00ff000000000000ULL) >> 48); \
				(*((p) + 2)) = (((n) & 0x0000ff0000000000ULL) >> 40); \
				(*((p) + 3)) = (((n) & 0x000000ff00000000ULL) >> 32); \
				(*((p) + 4)) = (((n) & 0x00000000ff000000ULL) >> 24); \
				(*((p) + 5)) = (((n) & 0x0000000000ff0000ULL) >> 16); \
				(*((p) + 6)) = (((n) & 0x000000000000ff00ULL) >> 8); \
				(*((p) + 7)) = (((n) & 0x00000000000000ffULL) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x00000000000000ffULL) >> 0); \
				(*((p) + 1)) = (((n) & 0x000000000000ff00ULL) >> 8); \
				(*((p) + 2)) = (((n) & 0x0000000000ff0000ULL) >> 16); \
				(*((p) + 3)) = (((n) & 0x00000000ff000000ULL) >> 24); \
				(*((p) + 4)) = (((n) & 0x000000ff00000000ULL) >> 32); \
				(*((p) + 5)) = (((n) & 0x0000ff0000000000ULL) >> 40); \
				(*((p) + 6)) = (((n) & 0x00ff000000000000ULL) >> 48); \
				(*((p) + 7)) = (((n) & 0xff00000000000000ULL) >> 56); \
			}; \
			((p) += 8); \
			((r) -= 8)

#define	PUT16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUT32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			}; \
			((p) += 4); \
			((r) -= 4)

#else /* !(_BIG_ENDIAN || WORDS_BIGENDIAN) */

#define	GET_SCOPE_FOR_HOTKEY(n, p, b) \
				if (0 == (b)) { \
				    if ((*((uchar_t *)(p + 1)) & 0x80)) { \
					(n) = 1; \
				    } else { \
					(n) = 0; \
				    } \
				} else { \
				    if ((*((uchar_t *)(p + 0)) & 0x80)) { \
					(n) = 1; \
				    } else { \
					(n) = 0; \
				    } \
				};

#define	GETU15(n, p, b)	((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  (((*((uchar_t *)(p + 1))) & 0x7F) << 8)) : \
					 ((((*((uchar_t *)(p + 0))) & 0x7F) << 8) + \
					  ((*((uchar_t *)(p + 1))) << 0))))

#define	GETU16(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8)) : \
					 (((*((uchar_t *)(p + 0))) << 8) + \
					  ((*((uchar_t *)(p + 1))) << 0)))), \
				 ((p) += 2), \
				 ((r) -= 2))

#define	GETU32(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8) + \
					  ((*((uchar_t *)(p + 2))) << 16) + \
					  ((*((uchar_t *)(p + 3))) << 24)) : \
					 (((*((uchar_t *)(p + 0))) << 24) + \
					  ((*((uchar_t *)(p + 1))) << 16) + \
					  ((*((uchar_t *)(p + 2))) << 8) + \
					  ((*((uchar_t *)(p + 3))) << 0)))), \
				 ((p) += 4), \
				 ((r) -= 4))

#define	GETU64(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((uint64_t)(*((uchar_t *)(p + 0))) << 0) + \
					  ((uint64_t)(*((uchar_t *)(p + 1))) << 8) + \
					  ((uint64_t)(*((uchar_t *)(p + 2))) << 16) + \
					  ((uint64_t)(*((uchar_t *)(p + 3))) << 24) + \
					  ((uint64_t)(*((uchar_t *)(p + 4))) << 32) + \
					  ((uint64_t)(*((uchar_t *)(p + 5))) << 40) + \
					  ((uint64_t)(*((uchar_t *)(p + 6))) << 48) + \
					  ((uint64_t)(*((uchar_t *)(p + 7))) << 56)) : \
					 (((uint64_t)(*((uchar_t *)(p + 0))) << 56) + \
					  ((uint64_t)(*((uchar_t *)(p + 1))) << 48) + \
					  ((uint64_t)(*((uchar_t *)(p + 2))) << 40) + \
					  ((uint64_t)(*((uchar_t *)(p + 3))) << 32) + \
					  ((uint64_t)(*((uchar_t *)(p + 4))) << 24) + \
					  ((uint64_t)(*((uchar_t *)(p + 5))) << 16) + \
					  ((uint64_t)(*((uchar_t *)(p + 6))) << 8) + \
					  ((uint64_t)(*((uchar_t *)(p + 7))) << 0)))), \
				 ((p) += 8), \
				 ((r) -= 8))

#define	GET16(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8)) : \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 8) + \
					   ((*((uchar_t *)(p + 1))) << 0)))), \
			 ((p) += 2), \
			 ((r) -= 2))

#define	GET32(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 ((int32_t)(((*((uchar_t *)(p + 0))) << 0) + \
					    ((*((uchar_t *)(p + 1))) << 8) + \
					    ((*((uchar_t *)(p + 2))) << 16) + \
					    ((*((uchar_t *)(p + 3))) << 24))) : \
				 ((int32_t)(((*((uchar_t *)(p + 0))) << 24) + \
					    ((*((uchar_t *)(p + 1))) << 16) + \
					    ((*((uchar_t *)(p + 2))) << 8) + \
					    ((*((uchar_t *)(p + 3))) << 0))))), \
			 ((p) += 4), \
			 ((r) -= 4))

#define	PUTU16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUTU32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			}; \
			((p) += 4); \
			((r) -= 4)

#define	PUTU64(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x00000000000000ffULL) >> 0); \
				(*((p) + 1)) = (((n) & 0x000000000000ff00ULL) >> 8); \
				(*((p) + 2)) = (((n) & 0x0000000000ff0000ULL) >> 16); \
				(*((p) + 3)) = (((n) & 0x00000000ff000000ULL) >> 24); \
				(*((p) + 4)) = (((n) & 0x000000ff00000000ULL) >> 32); \
				(*((p) + 5)) = (((n) & 0x0000ff0000000000ULL) >> 40); \
				(*((p) + 6)) = (((n) & 0x00ff000000000000ULL) >> 48); \
				(*((p) + 7)) = (((n) & 0xff00000000000000ULL) >> 56); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff00000000000000ULL) >> 56); \
				(*((p) + 1)) = (((n) & 0x00ff000000000000ULL) >> 48); \
				(*((p) + 2)) = (((n) & 0x0000ff0000000000ULL) >> 40); \
				(*((p) + 3)) = (((n) & 0x000000ff00000000ULL) >> 32); \
				(*((p) + 4)) = (((n) & 0x00000000ff000000ULL) >> 24); \
				(*((p) + 5)) = (((n) & 0x0000000000ff0000ULL) >> 16); \
				(*((p) + 6)) = (((n) & 0x000000000000ff00ULL) >> 8); \
				(*((p) + 7)) = (((n) & 0x00000000000000ffULL) >> 0); \
			}; \
			((p) += 8); \
			((r) -= 8)

#define	PUT16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUT32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			}; \
			((p) += 4); \
			((r) -= 4)

#endif /* !(_BIG_ENDIAN || WORDS_BIGENDIAN) */

#define	GETU8(n, r, p, b)	(((n) = (*((uint8_t *)(p)))),  ((p) += 1), ((r) -= 1))
#define	GET8(n, r, p, b)	(((n) = (*((int8_t *)(p)))),   ((p) += 1), ((r) -= 1))

#define	PUTU8(n, r, p, b)	(((*p) = (n)), ((p) += 1), ((r) -= 1))
#define	PUT8(n, r, p, b)	(((*p) = (n)), ((p) += 1), ((r) -= 1))

#define	SKIP8(r, p)		(((p) += 1), ((r) -= 1))
#define	SKIP16(r, p)		(((p) += 2), ((r) -= 2))
#define	SKIP32(r, p)		(((p) += 4), ((r) -= 4))


#define PUT_PACKET_HEADER(ptr, opcode, length) \
	(*((ptr) + 0) = (((opcode) & 0x7f)), \
	 *((ptr) + 1) = (((length) & 0x00ff0000) >> 16), \
	 *((ptr) + 2) = (((length) & 0x0000ff00) >> 8), \
	 *((ptr) + 3) = (((length) & 0x000000ff) >> 0))


#define STRING_PAD(len)		((2 + (len)) % 4)
#define STRING_OBJECT_SIZE(len)	(2 + (len) + (STRING_PAD((len))))
#define PAD2(n)			((n) & 0x02)
#define PAD(n)			((4 - ((n) & 0x03)) & 0x03)

#define REQUIRE_PROTOCOL_VERSION(data_s, v) \
do { \
    if ((v) > (data_s)->protocol_version) { \
	(data_s)->status = IIIMP_DATA_PROTOCOL_VERSION_ERROR; \
	return NULL; \
    } \
} while(0)


#define KEY_EVENT_OBJECT_SIZE	(4 * 4)


typedef struct iiimp_attribute_id {
    int				id_predefined;
    int				id_dynamic;
    struct iiimp_attribute_id *	next;
} IIIMP_attribute_id;


struct iiimp_data_s {
    int				byte_swap;
    IIIMP_attribute_id *	attribute_id;
    int				status;
    FILE *			print_fp;
    uint_t			print_flag;
    int				protocol_version;
    IIIMP_card32_list *		capability;
    IIIMP_card32_list *		option;
};


/* prototype of composite data unpack function */

#define IIIMP_dal \
	IIIMP_data_s *		data_s, \
	size_t *		nbyte, \
	const uchar_t **	ptr, \
	size_t			byte_length

IIIMP_card16_list *		iiimp_card16_list_unpack(IIIMP_dal);
IIIMP_card32_list *		iiimp_card32_list_unpack(IIIMP_dal);
IIIMP_keyevent_list *		iiimp_keyevent_list_unpack(IIIMP_dal);
IIIMP_hotkey *			iiimp_hotkey_unpack(IIIMP_dal);
IIIMP_hotkey *			iiimp_hotkey_list_unpack(IIIMP_dal);
IIIMP_string *			iiimp_string_unpack(IIIMP_dal);
IIIMP_string *			iiimp_string_list_unpack(IIIMP_dal);
#if defined(USE_OBSOLETE_NS_CODE)
IIIMP_utf8string *		iiimp_utf8string_unpack(IIIMP_dal);
IIIMP_utf8string *		iiimp_utf8string_list_unpack(IIIMP_dal);
#endif /* USE_OBSOLETE_NS_CODE */
IIIMP_feedback_attr_list *	iiimp_feedback_attr_list_unpack(IIIMP_dal);
IIIMP_char_with_feedback *	iiimp_char_with_feedback_unpack(IIIMP_dal);
IIIMP_char_with_feedback *	iiimp_char_with_feedback_list_unpack(IIIMP_dal);
IIIMP_operation *		iiimp_operation_unpack(IIIMP_dal);
IIIMP_operation *		iiimp_operation_list_unpack(IIIMP_dal);
IIIMP_annotation_value *	iiimp_annotation_text_unpack(IIIMP_dal);
IIIMP_annotation_value *	iiimp_annotation_string_unpack(IIIMP_dal);
IIIMP_annotation *		iiimp_annotation_unpack(IIIMP_dal);
IIIMP_text *			iiimp_text_unpack(IIIMP_dal);
IIIMP_text *			iiimp_text_list_unpack(IIIMP_dal);
IIIMP_client_descriptor *	iiimp_client_descriptor_unpack(IIIMP_dal);
IIIMP_object_descriptor *	iiimp_object_descriptor_unpack(IIIMP_dal);
IIIMP_object_descriptor *	iiimp_object_descriptor_list_unpack(IIIMP_dal);
IIIMP_ccdef *			iiimp_ccdef_unpack(IIIMP_dal);
IIIMP_language *		iiimp_language_unpack(IIIMP_dal);
IIIMP_language *		iiimp_language_list_unpack(IIIMP_dal);
IIIMP_imeinfo *			iiimp_imeinfo_unpack(IIIMP_dal);
IIIMP_imeinfo *			iiimp_imeinfo_list_unpack(IIIMP_dal);
IIIMP_jarfile_object *		iiimp_jarfile_object_unpack(IIIMP_dal);
IIIMP_inputmethod_descriptor *	iiimp_inputmethod_descriptor_unpack(IIIMP_dal);
IIIMP_inputmethod_descriptor *	iiimp_inputmethod_descriptor_list_unpack(IIIMP_dal);
IIIMP_binaryfile_object *	iiimp_binaryfile_object_unpack(IIIMP_dal);
IIIMP_imattribute *		iiimp_imattribute_unpack(IIIMP_dal);
IIIMP_imattribute *		iiimp_imattribute_list_unpack(IIIMP_dal);
IIIMP_icattribute *		iiimp_icattribute_unpack(IIIMP_dal);
IIIMP_icattribute *		iiimp_icattribute_list_unpack(IIIMP_dal);
IIIMP_contents *		iiimp_contents_unpack(IIIMP_dal);
#if defined(USE_OBSOLETE_NS_CODE)
IIIMP_open *			iiimp_open_unpack(IIIMP_dal);
IIIMP_open_reply *		iiimp_open_reply_unpack(IIIMP_dal);
IIIMP_close *			iiimp_close_unpack(IIIMP_dal);
IIIMP_close_reply *		iiimp_close_reply_unpack(IIIMP_dal);
IIIMP_read *			iiimp_read_unpack(IIIMP_dal);
IIIMP_read_reply *		iiimp_read_reply_unpack(IIIMP_dal);
IIIMP_write *			iiimp_write_unpack(IIIMP_dal);
IIIMP_write_reply *		iiimp_write_reply_unpack(IIIMP_dal);
IIIMP_opendir *			iiimp_opendir_unpack(IIIMP_dal);
IIIMP_opendir_reply *		iiimp_opendir_reply_unpack(IIIMP_dal);
IIIMP_closedir_reply *		iiimp_closedir_reply_unpack(IIIMP_dal);
IIIMP_closedir *		iiimp_closedir_unpack(IIIMP_dal);
IIIMP_closedir_reply *		iiimp_closedir_reply_unpack(IIIMP_dal);
IIIMP_seek *			iiimp_seek_unpack(IIIMP_dal);
IIIMP_seek_reply *		iiimp_seek_reply_unpack(IIIMP_dal);
IIIMP_mkdir *			iiimp_mkdir_unpack(IIIMP_dal);
IIIMP_mkdir_reply *		iiimp_mkdir_reply_unpack(IIIMP_dal);
IIIMP_rmdir *			iiimp_rmdir_unpack(IIIMP_dal);
IIIMP_rmdir_reply *		iiimp_rmdir_reply_unpack(IIIMP_dal);
IIIMP_symlink *			iiimp_symlink_unpack(IIIMP_dal);
IIIMP_symlink_reply *		iiimp_symlink_reply_unpack(IIIMP_dal);
IIIMP_stat *			iiimp_stat_unpack(IIIMP_dal);
IIIMP_stat_reply *		iiimp_stat_reply_unpack(IIIMP_dal);
IIIMP_lstat *			iiimp_lstat_unpack(IIIMP_dal);
IIIMP_lstat_reply *		iiimp_lstat_reply_unpack(IIIMP_dal);
IIIMP_fstat *			iiimp_fstat_unpack(IIIMP_dal);
IIIMP_fstat_reply *		iiimp_fstat_reply_unpack(IIIMP_dal);
IIIMP_creat *			iiimp_creat_unpack(IIIMP_dal);
IIIMP_creat_reply *		iiimp_creat_reply_unpack(IIIMP_dal);
IIIMP_lseek *			iiimp_lseek_unpack(IIIMP_dal);
IIIMP_lseek_reply *		iiimp_lseek_reply_unpack(IIIMP_dal);
IIIMP_unlink *			iiimp_unlink_unpack(IIIMP_dal);
IIIMP_unlink_reply *		iiimp_unlink_reply_unpack(IIIMP_dal);
IIIMP_rename *			iiimp_rename_unpack(IIIMP_dal);
IIIMP_rename_reply *		iiimp_rename_reply_unpack(IIIMP_dal);
IIIMP_fcntl *			iiimp_fcntl_unpack(IIIMP_dal);
IIIMP_fcntl_reply *		iiimp_fcntl_reply_unpack(IIIMP_dal);
IIIMP_truncate *		iiimp_truncate_unpack(IIIMP_dal);
IIIMP_truncate_reply *		iiimp_truncate_reply_unpack(IIIMP_dal);
IIIMP_ftruncate *		iiimp_ftruncate_unpack(IIIMP_dal);
IIIMP_ftruncate_reply *		iiimp_ftruncate_reply_unpack(IIIMP_dal);
#endif /* USE_OBSOLETE_NS_CODE */

#undef IIIMP_dal


/* prototype of composite data pack function */

extern void	iiimp_card16_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16_list *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_card32_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card32_list *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_string_pack(
    IIIMP_data_s *	data_s,
    IIIMP_string *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_string_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_string *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

#if defined(USE_OBSOLETE_NS_CODE)
extern void	iiimp_utf8string_pack(
    IIIMP_data_s *	data_s,
    IIIMP_utf8string *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_utf8string_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_utf8string *	m,
    size_t *		nbyte,
    uchar_t **		ptr);
#endif /* USE_OBSOLETE_NS_CODE */

extern void	iiimp_feedback_attr_list_pack(
    IIIMP_data_s *		data_s,
    IIIMP_feedback_attr_list *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_char_with_feedback_pack(
    IIIMP_data_s *		data_s,
    IIIMP_char_with_feedback *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_char_with_feedback_list_pack(
    IIIMP_data_s *		data_s,
    IIIMP_char_with_feedback *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_operation_pack(
    IIIMP_data_s *	data_s,
    IIIMP_operation *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_operation_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_operation *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_annotation_text_pack(
    IIIMP_data_s *		data_s,
    IIIMP_annotation_value *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_annotation_string_pack(
    IIIMP_data_s *		data_s,
    IIIMP_annotation_value *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_annotation_pack(
    IIIMP_data_s *	data_s,
    IIIMP_annotation *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_annotation_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_annotation *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_text_pack(
    IIIMP_data_s *	data_s,
    IIIMP_text *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_text_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_text *	text,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_client_descriptor_pack(
    IIIMP_data_s *		data_s,
    IIIMP_client_descriptor *	cd,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_object_descriptor_pack(
    IIIMP_data_s *		data_s,
    IIIMP_object_descriptor *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_object_descriptor_list_pack(
    IIIMP_data_s *		data_s,
    IIIMP_object_descriptor *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_ccdef_pack(
    IIIMP_data_s *	data_s,
    IIIMP_ccdef *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_language_pack(
    IIIMP_data_s *	data_s,
    IIIMP_language *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_language_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_language *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void     iiimp_imeinfo_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imeinfo *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void     iiimp_imeinfo_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imeinfo *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_jarfile_object_pack(
    IIIMP_data_s *		data_s,
    IIIMP_jarfile_object *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_inputmethod_descriptor_pack(
    IIIMP_data_s *			data_s,
    IIIMP_inputmethod_descriptor *	m,
    size_t *				nbyte,
    uchar_t **				ptr);

extern void	iiimp_inputmethod_descriptor_list_pack(
    IIIMP_data_s *			data_s,
    IIIMP_inputmethod_descriptor *	m,
    size_t *				nbyte,
    uchar_t **				ptr);

extern void	iiimp_binaryfile_object_pack(
    IIIMP_data_s *		data_s,
    IIIMP_binaryfile_object *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_imattribute_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imattribute *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_imattribute_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_imattribute *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_icattribute_pack(
    IIIMP_data_s *	data_s,
    IIIMP_icattribute *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_icattribute_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_icattribute *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_keyevent_list_pack(
    IIIMP_data_s *		data_s,
    IIIMP_keyevent_list *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	iiimp_hotkey_pack(
    IIIMP_data_s *	data_s,
    IIIMP_hotkey *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_hotkey_list_pack(
    IIIMP_data_s *	data_s,
    IIIMP_hotkey *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_contents_pack(
    IIIMP_data_s *	data_s,
    IIIMP_contents *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

#if defined(USE_OBSOLETE_NS_CODE)
extern void	iiimp_open_pack(
    IIIMP_data_s *	data_s,
    IIIMP_open *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_open_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_open_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_read_pack(
    IIIMP_data_s *	data_s,
    IIIMP_read *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_read_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_read_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_write_pack(
    IIIMP_data_s *	data_s,
    IIIMP_write *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_write_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_write_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_close_pack(
    IIIMP_data_s *	data_s,
    IIIMP_close *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_close_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_close_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_seek_pack(
    IIIMP_data_s *	data_s,
    IIIMP_seek *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_seek_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_seek_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_opendir_pack(
    IIIMP_data_s *	data_s,
    IIIMP_opendir *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	iiimp_opendir_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_opendir_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_closedir_pack(
    IIIMP_data_s *	data_s,
    IIIMP_closedir *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_closedir_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_closedir_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_mkdir_pack(
    IIIMP_data_s *	data_s,
    IIIMP_mkdir *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_mkdir_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_mkdir_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_rmdir_pack(
    IIIMP_data_s *	data_s,
    IIIMP_rmdir *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_rmdir_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_rmdir_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_symlink_pack(
    IIIMP_data_s *	data_s,
    IIIMP_symlink *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_symlink_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_symlink_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_stat_pack(
    IIIMP_data_s *	data_s,
    IIIMP_stat *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_stat_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_stat_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void iiimp_lstat_pack(
    IIIMP_data_s *	data_s,
    IIIMP_lstat *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void iiimp_lstat_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_lstat_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_fstat_pack(
    IIIMP_data_s *	data_s,
    IIIMP_fstat *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_fstat_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_fstat_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_creat_pack(
    IIIMP_data_s *	data_s,
    IIIMP_creat *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_creat_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_creat_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_lseek_pack(
    IIIMP_data_s *	data_s,
    IIIMP_lseek *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_lseek_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_lseek_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_unlink_pack(
    IIIMP_data_s *	data_s,
    IIIMP_unlink *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_unlink_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_unlink_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_rename_pack(
    IIIMP_data_s *	data_s,
    IIIMP_rename *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_rename_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_rename_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_fcntl_pack(
    IIIMP_data_s *	data_s,
    IIIMP_fcntl *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_fcntl_reply_pack(
    IIIMP_data_s *	data_s,
    IIIMP_fcntl_reply *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_truncate_pack(
    IIIMP_data_s *	data_s,
    IIIMP_truncate *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_truncate_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_truncate_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);

extern void	 iiimp_ftruncate_pack(
    IIIMP_data_s *	data_s,
    IIIMP_ftruncate *	m,
    size_t *		nbyte,
    uchar_t **		ptr);

extern void	 iiimp_ftruncate_reply_pack(
    IIIMP_data_s *		data_s,
    IIIMP_ftruncate_reply *	m,
    size_t *			nbyte,
    uchar_t **			ptr);
#endif /* USE_OBSOLETE_NS_CODE */

extern void	iiimp_message_header_print(IIIMP_data_s *	data_s,
					   int			opcode,
					   int			im_id,
					   int			ic_id);

extern void	iiimp_card16_list_print(IIIMP_data_s *		data_s,
					IIIMP_card16_list *	m);

extern void	iiimp_card32_list_print(IIIMP_data_s *		data_s,
					IIIMP_card32_list *	m);

extern void	iiimp_byte_stream_print(IIIMP_data_s *		data_s,
					IIIMP_byte_stream *	m);

extern void	iiimp_string_print(IIIMP_data_s *	data_s,
				   IIIMP_string *	m);

extern void	iiimp_string_list_print(IIIMP_data_s *	data_s,
					IIIMP_string *	m);

#if defined(USE_OBSOLETE_NS_CODE)
extern void	iiimp_utf8string_print(IIIMP_data_s *	data_s,
				   IIIMP_utf8string *	m);

extern void	iiimp_utf8string_list_print(IIIMP_data_s *	data_s,
					IIIMP_utf8string *	m);

#endif /* USE_OBSOLETE_NS_CODE */
extern void	iiimp_feedback_attr_print(IIIMP_data_s *	data_s,
					  IIIMP_feedback_attr *	m);

extern void	iiimp_feedback_attr_list_print(
    IIIMP_data_s *			data_s,
    IIIMP_feedback_attr_list *	m);

extern void	iiimp_char_with_feedback_print(
    IIIMP_data_s *			data_s,
    IIIMP_char_with_feedback *	m);

extern void	iiimp_char_with_feedback_list_print(
    IIIMP_data_s *			data_s,
    IIIMP_char_with_feedback *	m);

extern void	iiimp_operation_print(IIIMP_data_s *	data_s,
				      IIIMP_operation *	m);

extern void	iiimp_operation_list_print(IIIMP_data_s *	data_s,
					   IIIMP_operation *	m);

extern void	iiimp_annotation_print(IIIMP_data_s *		data_s,
				       IIIMP_annotation *	m);

extern void	iiimp_text_print(IIIMP_data_s * data_s, IIIMP_text * m);

extern void	iiimp_text_list_print(IIIMP_data_s * data_s, IIIMP_text * m);

extern void	iiimp_client_descriptor_print(IIIMP_data_s *		data_s,
					      IIIMP_client_descriptor *	m);

extern void	iiimp_object_descriptor_print(IIIMP_data_s *		data_s,
					      IIIMP_object_descriptor *	m);

extern void	iiimp_object_descriptor_list_print(
    IIIMP_data_s *			data_s,
    IIIMP_object_descriptor *	m);

extern void	iiimp_ccdef_print(IIIMP_data_s * data_s, IIIMP_ccdef * m);

extern void	iiimp_language_print(IIIMP_data_s * data_s, IIIMP_language * m);

extern void	iiimp_jarfile_object_print(IIIMP_data_s *		data_s,
					   IIIMP_jarfile_object *	m);

extern void	iiimp_binaryfile_object_print(IIIMP_data_s *		data_s,
					      IIIMP_binaryfile_object *	m);

extern void	iiimp_inputmethod_descriptor_print(
    IIIMP_data_s *			data_s,
    IIIMP_inputmethod_descriptor *	m);

extern void	iiimp_inputmethod_descriptor_list_print(
    IIIMP_data_s *			data_s,
    IIIMP_inputmethod_descriptor *	m);

extern void	iiimp_imattribute_print(IIIMP_data_s *		data_s,
					IIIMP_imattribute *	m);

extern void	iiimp_imattribute_list_print(IIIMP_data_s *		data_s,
					     IIIMP_imattribute *	m);

extern void	iiimp_character_subsets_print(IIIMP_data_s *	data_s,
					      IIIMP_card32 *	m);

extern void	iiimp_character_subsets_list_print(IIIMP_data_s *	data_s,
						   IIIMP_card32_list *	m);

extern void	iiimp_icattribute_print(IIIMP_data_s *		data_s,
					IIIMP_icattribute *	m);

extern void	iiimp_icattribute_list_print(IIIMP_data_s *		data_s,
					     IIIMP_icattribute *	m);

extern void	iiimp_keyevent_print(IIIMP_data_s *	data_s,
				     IIIMP_keyevent *	m);

extern void	iiimp_keyevent_list_print(IIIMP_data_s *	data_s,
					  IIIMP_keyevent_list *	m);

extern void	iiimp_contents_print(IIIMP_data_s * data_s, IIIMP_contents * m);

#if defined(USE_OBSOLETE_NS_CODE)
extern void	iiimp_open_print(IIIMP_data_s * data_s, IIIMP_open * m);
extern void	iiimp_open_reply_print(IIIMP_data_s * data_s, IIIMP_open_reply * m);
extern void	iiimp_read_print(IIIMP_data_s * data_s, IIIMP_read * m);
extern void	iiimp_read_reply_print(IIIMP_data_s * data_s, IIIMP_read_reply * m);
extern void	iiimp_write_print(IIIMP_data_s * data_s, IIIMP_write * m);
extern void	iiimp_write_reply_print(IIIMP_data_s * data_s, IIIMP_write_reply * m);
extern void	iiimp_close_print(IIIMP_data_s * data_s, IIIMP_close * m);
extern void	iiimp_close_reply_print(IIIMP_data_s * data_s, IIIMP_close_reply * m);
extern void	iiimp_seek_print(IIIMP_data_s * data_s, IIIMP_seek *m);
extern void	iiimp_seek_reply_print(IIIMP_data_s * data_s, IIIMP_seek_reply *m);
extern void	iiimp_opendir_print(IIIMP_data_s * data_s, IIIMP_opendir *m);
extern void	iiimp_opendir_reply_print(IIIMP_data_s * data_s, IIIMP_opendir_reply *m);
extern void	iiimp_closedir_print(IIIMP_data_s * data_s, IIIMP_closedir *m);
extern void	iiimp_closedir_reply_print(IIIMP_data_s * data_s, IIIMP_closedir_reply *m);
extern void	iiimp_mkdir_print(IIIMP_data_s * data_s, IIIMP_mkdir *m);
extern void	iiimp_mkdir_reply_print(IIIMP_data_s * data_s, IIIMP_mkdir_reply *m);
extern void	iiimp_rmdir_print(IIIMP_data_s * data_s, IIIMP_rmdir *m);
extern void	iiimp_rmdir_reply_print(IIIMP_data_s * data_s, IIIMP_rmdir_reply *m);
extern void	iiimp_symlink_print(IIIMP_data_s * data_s, IIIMP_symlink *m);
extern void	iiimp_symlink_reply_print(IIIMP_data_s * data_s, IIIMP_symlink_reply *m);
extern void	iiimp_stat_print(IIIMP_data_s * data_s, IIIMP_stat *m);
extern void	iiimp_stat_reply_print(IIIMP_data_s * data_s, IIIMP_stat_reply *m);
extern void	iiimp_lstat_print(IIIMP_data_s * data_s, IIIMP_lstat *m);
extern void	iiimp_lstat_reply_print(IIIMP_data_s * data_s, IIIMP_lstat_reply *m);
extern void	iiimp_fstat_print(IIIMP_data_s * data_s, IIIMP_fstat *m);
extern void	iiimp_fstat_reply_print(IIIMP_data_s * data_s, IIIMP_fstat_reply *m);
extern void	iiimp_creat_print(IIIMP_data_s * data_s, IIIMP_creat *m);
extern void	iiimp_creat_reply_print(IIIMP_data_s * data_s, IIIMP_creat_reply *m);
extern void	iiimp_lseek_print(IIIMP_data_s * data_s, IIIMP_lseek *m);
extern void	iiimp_lseek_reply_print(IIIMP_data_s * data_s, IIIMP_lseek_reply *m);
extern void	iiimp_unlink_print(IIIMP_data_s * data_s, IIIMP_unlink *m);
extern void	iiimp_unlink_reply_print(IIIMP_data_s * data_s, IIIMP_unlink_reply *m);
extern void	iiimp_rename_print(IIIMP_data_s * data_s, IIIMP_rename *m);
extern void	iiimp_rename_reply_print(IIIMP_data_s * data_s, IIIMP_rename_reply *m);
extern void	iiimp_fcntl_print(IIIMP_data_s * data_s, IIIMP_fcntl *m);
extern void	iiimp_fcntl_reply_print(IIIMP_data_s * data_s, IIIMP_fcntl_reply *m);
extern void	iiimp_truncate_print(IIIMP_data_s * data_s, IIIMP_truncate *m);
extern void	iiimp_truncate_reply_print(IIIMP_data_s * data_s, IIIMP_truncate_reply *m);
extern void	iiimp_ftruncate_print(IIIMP_data_s * data_s, IIIMP_ftruncate *m);
extern void	iiimp_ftruncate_reply_print(IIIMP_data_s * data_s, IIIMP_ftruncate_reply *m);
#endif /* USE_OBSOLETE_NS_CODE */

extern void	iiimp_simple_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_simple_im_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_invalid_message_print(IIIMP_data_s *	data_s,
					    IIIMP_message *	m);

extern void	iiimp_aux_simple_print(IIIMP_data_s *	data_s,
				       IIIMP_message *	m);

extern void	iiimp_aux_value_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_connect_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_connect_reply_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_register_trigger_keys_print(IIIMP_data_s *	data_s,
						  IIIMP_message *	m);

extern void	iiimp_trigger_notify_print(IIIMP_data_s *	data_s,
					   IIIMP_message *	m);

extern void	iiimp_select_hotkey_profile_print(IIIMP_data_s *	data_s,
						  IIIMP_message *	m);

extern void	iiimp_register_hotkeys_print(IIIMP_data_s *	data_s,
					     IIIMP_message *	m);

extern void	iiimp_hotkey_print(IIIMP_data_s *	data_s,
				   IIIMP_hotkey *	m);

extern void	iiimp_hotkey_list_print(IIIMP_data_s *	data_s,
					IIIMP_hotkey *	m);

extern void	iiimp_hotkey_notify_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_hotkey_state_notify_print(IIIMP_data_s *	data_s,
						IIIMP_message *	m);

extern void	iiimp_file_operation_print(IIIMP_data_s *	data_s,
					   IIIMP_message *	m);

extern void	iiimp_file_operation_reply_print(IIIMP_data_s *		data_s,
						 IIIMP_message *	m);

extern void	iiimp_register_hotkeys_print(IIIMP_data_s *	data_s,
					     IIIMP_message *	m);

extern void	iiimp_setimvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_getimvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_getimvalues_reply_print(IIIMP_data_s *	data_s,
					      IIIMP_message *	m);

extern void	iiimp_createic_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_seticvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_geticvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_geticvalues_reply_print(IIIMP_data_s *	data_s,
					      IIIMP_message *	m);

extern void	iiimp_preedit_start_reply_print(IIIMP_data_s *	data_s,
						IIIMP_message *	m);

extern void	iiimp_preedit_draw_print(IIIMP_data_s *		data_s,
					 IIIMP_message *	m);

extern void	iiimp_status_draw_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_forward_event_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_forward_event_with_operations_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m);

extern void	iiimp_forward_event_with_operations_reply_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m);

extern void	iiimp_commit_string_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_lookup_choice_start_print(IIIMP_data_s *	data_s,
						IIIMP_message *	m);

extern void	iiimp_lookup_choice_draw_print(IIIMP_data_s *	data_s,
					       IIIMP_message *	m);

extern void	iiimp_lookup_choice_process_print(IIIMP_data_s *	data_s,
						  IIIMP_message *	m);

extern void	iiimp_protocol_version_print(IIIMP_data_s *	data_s,
					     IIIMP_message *	m);

extern IIIMP_card16	iiimp_attribute_id_search(
    IIIMP_data_s *	data_s,
    IIIMP_card16	id_dynamic);

extern void	iiimp_attribute_id_update(IIIMP_data_s *	data_s,
					  IIIMP_card16		id_predefined,
					  IIIMP_card16		id_dynamic);

extern void	iiimp_attribute_id_destroy(IIIMP_data_s * data_s);


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMP_DATA_P_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
