#include <qpushbutton.h>
#include "IIIMLookupChoice.hh"

#ifndef MAX
#define MAX(x, y) ((x > y) ? (x) : (y))
#endif

void
IIIMLookupChoiceItemWidget::drawContents(
    QPainter *p
)
{
    QRect r = contentsRect();
    QSize s1, s2;

    s1 = plabel->draw(p, this, r);
    r.moveBy(s1.width() + margin(), 0);
    s2 = pchoice->draw(p, this, r);
    currentsize = QSize(s1.width() + s2.width() + margin(),
			MAX(s1.height(), s2.height()));
    updateGeometry();
}

QSize
IIIMLookupChoiceItemWidget::sizeHint() const
{
    QSize s = minimumSizeHint();
    if (s.isValid()) return s;
    int plus = (frameWidth() + margin()) * 2 + 1;
    return QSize(plus, plus);
}

QSize
IIIMLookupChoiceItemWidget::minimumSizeHint() const
{
    int plus = (frameWidth() + margin()) * 2;
    if (!currentsize.isValid()) return currentsize;
    return QSize(currentsize.width() + plus, currentsize.height() + plus);
}

IIIMLookupChoiceItemWidget::
IIIMLookupChoiceItemWidget(
    IIIMCF_text label,
    IIIMCF_text choice,
    QWidget *parent,
    const char *name,
    WFlags f
) : QFrame(parent, name, f)
{
    plabel = new IIIMText(label);
    pchoice = new IIIMText(choice);
    setFrameStyle(QFrame::PopupPanel | QFrame::Sunken);
    setMargin(1);
    setSizePolicy(QSizePolicy(QSizePolicy::Preferred,
			      QSizePolicy::Preferred));
}

IIIMLookupChoiceItemWidget::
~IIIMLookupChoiceItemWidget()
{
    delete plabel;
    delete pchoice;
}

void
IIIMLookupChoiceWidget::erase_all_items()
{
    IIIMLookupChoiceItemWidgetList::iterator it;
    for (it = itemlist.begin(); it != itemlist.end(); it++) {
	delete *it;
    }
    itemlist.erase(itemlist.begin(), itemlist.end());
}

void
IIIMLookupChoiceWidget::set_layout(
    IIIMCF_lookup_choice ilc
)
{
    IIIMF_status st;
    int ndir;

    st = iiimcf_get_lookup_choice_configuration(ilc,
						&choices_per_window,
						&number_of_rows,
						&number_of_columns,
						&ndir);
    if (st != IIIMF_STATUS_SUCCESS) return;
#if 0
    if ((direction == IIIMCF_LOOKUP_CHOICE_HORIZONTAL_DIRECTION)
	&& (ndir != direction)) {
	playout = new QBoxLayout(this, QBoxLayout::LeftToRight,
				 frameWidth(), frameWidth(), name());
	playout->setAutoAdd(true);
    } else if (!playout || ((direction == IIIMCF_LOOKUP_CHOICE_VERTICAL_DIRECTION)
			    && (ndir != direction))) {
	playout = new QBoxLayout(this, QBoxLayout::Down,
				 frameWidth(), frameWidth(), name());
	playout->setAutoAdd(true);
    }
#endif
    direction = ndir;
}

void
IIIMLookupChoiceWidget::update_items(
    IIIMCF_lookup_choice ilc
)
{
    IIIMF_status st;
    IIIMCF_text cand, label;
    int i, flag;
    int size, idx_first, idx_last, idx_current;
    IIIMLookupChoiceItemWidget *piw;

    st = iiimcf_get_lookup_choice_size(ilc, &size,
				       &idx_first, &idx_last, &idx_current);
    if (st != IIIMF_STATUS_SUCCESS) return;

    erase_all_items();
    for (i = 0; i < size; i++) {
	st = iiimcf_get_lookup_choice_item(ilc, i, &cand, &label, &flag);
	if ((st == IIIMF_STATUS_SUCCESS)
	    && (flag & IIIMCF_LOOKUP_CHOICE_ITEM_ENABLED)) {
	    piw = new IIIMLookupChoiceItemWidget(label, cand, this);
	    itemlist.push_back(piw);
	}
    }
}

void
IIIMLookupChoiceWidget::update_im()
{
    IIIMF_status st;
    IIIMCF_lookup_choice ilc;

    st = iiimcf_get_lookup_choice(ctx, &ilc);
    if (st == IIIMF_STATUS_SUCCESS) {
	set_layout(ilc);
	update_items(ilc);
	show();
    } else {
	hide();
    }
}

IIIMLookupChoiceWidget::IIIMLookupChoiceWidget(
    IIIMCF_context x_ctx,
    QWidget *parent,
    const char *name,
    WFlags f
) : QHBox(parent, name, f)
{
    ctx = x_ctx;
    playout = NULL;
    setMargin(1);
    setFrameStyle(QFrame::GroupBoxPanel | QFrame::Raised);
}

IIIMLookupChoiceWidget::~IIIMLookupChoiceWidget()
{
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
