#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "chewing_properties.h"

#define KB_DEFAULT_STR       "標準鍵盤"
#define KB_HSU_STR           "許氏鍵盤"
#define KB_IBM_STR           "IBM 鍵盤"
#define KB_GIN_YIEH_STR      "精業鍵盤"
#define KB_ET_STR            "倚天鍵盤"
#define KB_ET26_STR          "倚天26鍵盤"
#define KB_DVORAK_STR        "Dvorak 鍵盤"
#define KB_DVORAK_HSU_STR    "Dvorak + 許氏鍵盤"
#define KB_HANYU_PINYIN_STR  "漢語拼音鍵盤"
#define KB_DACHEN_CP26_STR   "大千26鍵盤"

struct _builtin_keymap{
        char *name;
        char *translated_name;
} builtin_keymaps [] = {
    "KB_DEFAULT",       KB_DEFAULT_STR,
    "KB_HSU",           KB_HSU_STR,
    "KB_IBM",           KB_IBM_STR,
    "KB_GIN_YEIH",      KB_GIN_YIEH_STR,
    "KB_ET",            KB_ET_STR,
    "KB_ET26",          KB_ET26_STR,
    "KB_DVORAK",        KB_DVORAK_STR,
    "KB_DVORAK_HSU",    KB_DVORAK_HSU_STR,
    "KB_HANYU_PINYIN",  KB_HANYU_PINYIN_STR,
    "KB_DACHEN_CP26",   KB_DACHEN_CP26_STR,
};

#define KB_TYPE_NUM sizeof(builtin_keymaps)/sizeof(struct _builtin_keymap)

#define CHEWING_KEYMAP_MODE_STR     "鍵盤排列方式："
#define CHEWING_KEYMAP_MODE_ID      0

char **KeymappingOptions = NULL;

ImePropertyRec chewing_options[] = {
    {CHEWING_KEYMAP_MODE_ID, ENCODE_UTF8, "/keymapping",
     CHEWING_KEYMAP_MODE_STR, NULL, ImeProperty_Selection, {0, 0}, 0},
};

ImePropertyListRec chewing_optionlist = {
    sizeof(chewing_options) / sizeof(ImePropertyRec),
    chewing_options
};

extern ImmServices imm_services;

ImeResult chewing_Init_Ime_Properties(ImeInfoRec * chewing_info)
{
    int i, num_keymap;

    if (chewing_info == NULL)
	return (IME_FAIL);

    DEBUG_printf("chewing_Init_Ime_Properties\n");

    if (KeymappingOptions == NULL) {
        KeymappingOptions = (char **) calloc (KB_TYPE_NUM + 1, sizeof (char *));
        if (KeymappingOptions == NULL)
            return (IME_FAIL);

        num_keymap = 0;
        for (i = 0; i < KB_TYPE_NUM ; i++) {
            char *keymapping_str;
            keymapping_str = (char *)builtin_keymaps[i].translated_name;
            if (keymapping_str) {
                KeymappingOptions[num_keymap++] = keymapping_str;
            }
        }

        if (num_keymap == 0)
            return (IME_FAIL);
    }

    chewing_options[CHEWING_KEYMAP_MODE_ID].range.multiString_range = KeymappingOptions;
    chewing_options[CHEWING_KEYMAP_MODE_ID].value.int_value = 0;

    chewing_info->pl = (ImePropertyListRec *) (&chewing_optionlist);

    return (IME_OK);
}

ImeResult chewing_Destroy_Ime_Properties(ImeInfoRec * chewing_info)
{
    int i;

    if (KeymappingOptions != NULL)
        free ((char *)KeymappingOptions);

    return (IME_OK);
}

ImeResult chewing_Set_Ime_Properties(ImeInputContext ic,
				     ChewingContext * cxt)
{
    int i;
    ImePropertyListRec *pl;
    ImePropertyRec *pi;

    DEBUG_printf("chewing_Set_Ime_Properties\n");

    if (cxt == NULL)
	return (IME_FAIL);

    chewing_set_KBType( cxt, 0);

    pl = imm_services->ImmGetPropertyList(ic);
    if (pl != NULL && pl->count > 0 && pl->properties != NULL) {
	for (i = 0; i < pl->count; i++) {
	    pi = &(pl->properties[i]);
            //DEBUG_printf("++++++++++++Set Key map: %d \n", pi->value.int_value);
	    switch (pi->id) {
	    case CHEWING_KEYMAP_MODE_ID:
                {
                    int opt_idx = pi->value.int_value;
                    int keymap_id = 0;
                    if (opt_idx >= 0 && opt_idx < KB_TYPE_NUM)
                        keymap_id = chewing_KBStr2Num (builtin_keymaps[opt_idx].name);
                    chewing_set_KBType (cxt, keymap_id);
                }
                //DEBUG_printf("++++++++++++Set Key map id: %d, name: %s \n", pi->value.int_value, pi->value.string_value);
		break;
	    }
	}
    }

    return (IME_OK);
}
