#ifndef _PROPERTY_WINDOW_H_
#define _PROPERTY_WINDOW_H_

#include <gtk/gtk.h>

#include "property_data.h"

typedef struct _ime_property_widget_t {
    ImePropertyRec *ime_property;
    GtkWidget *widget;
} ime_property_widget_t;

typedef struct _ime_module_widget_t {
    int num_ime_properties;
    ime_property_widget_t **ime_property_widgets;
} ime_module_widget_t;

typedef struct _property_window_t {
    GtkWidget *main_window;

    GtkTreeStore *category_list_model;
    GtkWidget *category_list_view;

    GtkListStore *ime_list_model;
    GtkWidget *ime_list_view;

    GtkWidget *work_area;

    GtkWidget *apply_button;
    GtkWidget *restore_button;

    int modified_status;

    GtkWidget *widget_show_ime_icon;
    GtkWidget *widget_show_zy_icon;
    GtkWidget *widget_show_qjbj_icon;
    GtkWidget *widget_show_punct_icon;
    GtkWidget *widget_show_vkb_icon;
    GtkWidget *widget_show_utility_icon;

    GtkWidget *widget_direction_vertical;
    GtkWidget *widget_direction_horizontal;

    GtkWidget *widget_fkey_vkb_list;

    GtkWidget *widget_beep_enabled;
    GtkWidget *widget_beep_disabled;

    int num_ime_modules;
    ime_module_widget_t **ime_module_widgets;

} property_window_t;

#endif /* _PROPERTY_WINDOW_H_ */
