#ifndef __HANGUL_TABLE_H_
#define __HANGUL_TABLE_H_

#ifndef TABLE_PRIVATE_DEFINED
#error "This file should be included only by hangul.c"
#endif

/* Combining Hangul Jamo Chosung => Compatibilty Jamo Chosung */
static UTFCHAR _combining_chosung_to_compatibility_chosung[] = {
  0x3131,
  0x3132,
  0x3134,
  0x3137,
  0x3138,
  0x3139,
  0x3141,
  0x3142,
  0x3143,
  0x3145,
  0x3146,
  0x3147,
  0x3148,
  0x3149,
  0x314a,
  0x314b,
  0x314c,
  0x314d,
  0x314e	
};

static UTFCHAR _combining_jungsung_to_compatibility_moeum[] = {
  0x314f,
  0x3150,
  0x3151,
  0x3152,
  0x3153,
  0x3154,
  0x3155,
  0x3156,
  0x3157,
  0x3158,
  0x3159,
  0x315a,
  0x315b,
  0x315c,
  0x315d,
  0x315e,
  0x315f,
  0x3160,
  0x3161,
  0x3162,
  0x3163
};

static UTFCHAR _combining_jongsung_to_compatibility_jaeum[] = {
  0x3131,
  0x3132,
  0x3133,
  0x3134,
  0x3135,
  0x3136,
  0x3137,
  0x3139,
  0x313a,
  0x313b,
  0x313c,
  0x313d,
  0x313e,
  0x313f,
  0x3140,
  0x3141,
  0x3142,
  0x3144,
  0x3145,
  0x3146,
  0x3147,
  0x3148,
  0x314a,
  0x314b,
  0x314c,
  0x314d,
  0x314e
};
static UTFCHAR _combining_jongsung_to_combining_chosung[] = {
  0x1100, 0x1101, 0x1109, 0x1102, 0x110c, 0x1112, 0x1103, 0x1105,
  0x1100, 0x1106, 0x1107, 0x1109, 0x1110, 0x1111, 0x1112, 0x1106,
  0x1107, 0x1109, 0x1109, 0x110a, 0x110b, 0x110c, 0x110e, 0x110f,
  0x1110, 0x1111, 0x1112 
};

static UTFCHAR _combining_chosung_to_combining_jongsung[] = {
  /* Initial consonant    -> Final consonant       */
  0x11a8,  /* choseong kiyeok      -> jongseong kiyeok      */
  0x11a9,  /* choseong ssangkiyeok -> jongseong ssangkiyeok */
  0x11ab,  /* choseong nieun       -> jongseong nieun       */
  0x11ae,  /* choseong tikeut      -> jongseong tikeut      */
  0x0,     /* choseong ssangtikeut -> jongseong tikeut      */
  0x11af,  /* choseong rieul       -> jongseong rieul       */
  0x11b7,  /* choseong mieum       -> jongseong mieum       */
  0x11b8,  /* choseong pieup       -> jongseong pieup       */
  0x0,     /* choseong ssangpieup  -> jongseong pieup       */
  0x11ba,  /* choseong sios        -> jongseong sios        */
  0x11bb,  /* choseong ssangsios   -> jongseong ssangsios   */
  0x11bc,  /* choseong ieung       -> jongseong ieung       */
  0x11bd,  /* choseong cieuc       -> jongseong cieuc       */
  0x0,     /* choseong ssangcieuc  -> jongseong cieuc       */
  0x11be,  /* choseong chieuch     -> jongseong chieuch     */
  0x11bf,  /* choseong khieukh     -> jongseong khieukh     */
  0x11c0,  /* choseong thieuth     -> jongseong thieuth     */
  0x11c1,  /* choseong phieuph     -> jongseong phieuph     */
  0x11c2   /* choseong hieuh       -> jongseong hieuh       */
};

static UTFCHAR _combining_coupled_jongsung_decompose[][2] = {
  { 0,      0x1100 }, /* jong kiyeok        = cho  kiyeok               */
  { 0x11a8, 0x1100 }, /* jong ssangkiyeok   = jong kiyeok + cho kiyeok  */
  { 0x11a8, 0x1109 }, /* jong kiyeok-sios   = jong kiyeok + cho sios    */
  { 0,      0x1102 }, /* jong nieun         = cho  nieun                */
  { 0x11ab, 0x110c }, /* jong nieun-cieuc   = jong nieun  + cho cieuc   */
  { 0x11ab, 0x1112 }, /* jong nieun-hieuh   = jong nieun  + cho hieuh   */
  { 0,      0x1103 }, /* jong tikeut        = cho  tikeut               */
  { 0,      0x1105 }, /* jong rieul         = cho  rieul                */
  { 0x11af, 0x1100 }, /* jong rieul-kiyeok  = jong rieul  + cho kiyeok  */
  { 0x11af, 0x1106 }, /* jong rieul-mieum   = jong rieul  + cho mieum   */
  { 0x11af, 0x1107 }, /* jong rieul-pieup   = jong rieul  + cho pieup   */
  { 0x11af, 0x1109 }, /* jong rieul-sios    = jong rieul  + cho sios    */
  { 0x11af, 0x1110 }, /* jong rieul-thieuth = jong rieul  + cho thieuth */
  { 0x11af, 0x1111 }, /* jong rieul-phieuph = jong rieul  + cho phieuph */
  { 0x11af, 0x1112 }, /* jong rieul-hieuh   = jong rieul  + cho hieuh   */
  { 0,      0x1106 }, /* jong mieum         = cho  mieum                */
  { 0,      0x1107 }, /* jong pieup         = cho  pieup                */
  { 0x11b8, 0x1109 }, /* jong pieup-sios    = jong pieup  + cho sios    */
  { 0,      0x1109 }, /* jong sios          = cho  sios                 */
  { 0x11ba, 0x1109 }, /* jong ssangsios     = jong sios   + cho sios    */
  { 0,      0x110b }, /* jong ieung         = cho  ieung                */
  { 0,      0x110c }, /* jong cieuc         = cho  cieuc                */
  { 0,      0x110e }, /* jong chieuch       = cho  chieuch              */
  { 0,      0x110f }, /* jong khieukh       = cho  khieukh              */
  { 0,      0x1110 }, /* jong thieuth       = cho  thieuth              */
  { 0,      0x1111 }, /* jong phieuph       = cho  phieuph              */
  { 0,      0x1112 }  /* jong hieuh         = cho  hieuh                */
};

#endif /* #ifndef __HANGUL_TABLE_H_ */
