/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#include <stdio.h>
#include <stdlib.h>
#include <alloca.h> /* for alloca() */
#include <string.h>
#include <assert.h>
#include <ctype.h>
#include <le-options.h>
#include "configapi.h"
#include "util.h"

static Bool parse_line (const char *line, KOLE_config **option);

Bool
get_configuration (const char *fname, int *ret_noptions, KOLE_config ***options)
{
  FILE *fp;
  char *line;
  KOLE_config *pconf;
  
  /* read file */
  assert (fname != NULL);
  if (!fname){
    /* TO DO: log error */
    return False;
  }

  assert (ret_noptions != NULL);
  if (!ret_noptions){
    /* TO DO: log error */
    return False;
  }
  
  fp = fopen (fname, "r");

  if (!fp)
    return False;
  *ret_noptions = 0;
  *options = NULL;
  while ((line = (char *)safe_getline (fp))){
    if (parse_line (line, &pconf)){
      *options =
	(KOLE_config **) realloc (*options, sizeof (KOLE_config *) * *ret_noptions);
      (*options)[*ret_noptions] = pconf;
      (*ret_noptions)++;
    } else
      continue;
  }
  return True;
}


static Bool
parse_line (const char *line, KOLE_config **option)
{
  char *buffer;
  char *p, *delim;
  char *name, *value;
  
  assert (line != NULL);
  if (!line)
    return False;

  assert (option != NULL);
  if (!option)
    return False;
  
  buffer = alloca (strlen (line) + 1);
  strncpy (buffer, line, strlen (line) + 1);
  p = buffer;

  /* ':' is delimeter */
  delim = strchr (buffer, ':');
  if (!delim) /* invalid format */
    return False;
  

  while (*p && isspace (*p)) p++;
  /* start of name */

  if (!*p || *p == '#')
    return False;
  else 
    name = p;

#if 0  
  while (*p && p < delim && !isspace (*p)) p++;
  
  
  /* end of name */
  if (!*p)
    return False;
  else if (*p == ':' || isspace (*p))
    /* even if p == delim, it doesn't matter */
    *p = '\0';
  else
    return False;
  /* done with name, now start getting value */
#endif

  p = delim - 1;
  while ( p > name && isspace (*p)) p--;
  
  if (p == name) /* error */
    return False;
  *(p + 1) = '\0';
  /* done with name, now start getting value */
  
  p = delim + 1;

  while (*p && isspace (*p)) p++;
  /* start of value */
  if (!*p) /* invalid format(no value) */
    return False;
  else
    value = p;

  while (*p && !isspace (*p)) p++;

  if (*p == '\n')
    *p = '\0';
  /* I don't need to check EOL here */
  *option = leoption_make_option_with_string_value (name, value);

  if (!*option)
    return False;
  else
    return True;
}


#ifdef TEST_RUN

int
main (int argc, char **argv)
{
  int nopt;
  KOLE_config **pconf;
  Bool ret;

  if (argc != 2){
    fprintf (stderr, "provide file name\n");
    return 0;
  }

  ret = get_configuration (argv[1], &nopt, &pconf);
  if (!ret){
    fprintf (stderr,"error\n");
  } else {
    int i;
    KOLE_config *p;
    fprintf (stdout, "%d options returned...\n", nopt);
    for (i = 0 ; i < nopt; i++){
      p = pconf[i];
      leoption_debug_print (p);
    }
  }
  return 0;
}

#endif
