#include <stdio.h>
#include <assert.h>
#include "engine-property.h"

static KOLE_property *pleproperty;
static int g_leproperty_initialized = 0;

struct _KOLE_property {
  INPUT_MODE_T input_mode;
  OPTION_KEYBOARD_LAYOUT keyboard;
  OPTION_CHARSET charset;
  OPTION_DELETION deletion;
  OPTION_COMMIT_MODE commit;
};


KOLE_property *
leproperty_init ()
{
  if (g_leproperty_initialized)
    return pleproperty;
  
  pleproperty =
    (KOLE_property *) malloc (sizeof (KOLE_property));

  assert (pleproperty != NULL);
  
  if (!pleproperty)
    return NULL;
  
  pleproperty->input_mode = INPUT_MODE_ENGLISH;
  pleproperty->keyboard = LAYOUT_2PART;
  pleproperty->charset = IN_UNICODE;
  pleproperty->deletion = BY_CHAR;
  pleproperty->commit = COMMIT_BY_HOTKEY;

  g_leproperty_initialized = 1;
  
  return pleproperty;
}

int
leproperty_get_input_mode (KOLE_property *pp)
{
  return (int) pp->input_mode;
}

void
leproperty_set_input_mode (KOLE_property *pp, INPUT_MODE_T imode)
{
   if(pp == NULL)
	return;
   pp->input_mode = imode;
}

int
leproperty_get_keyboard (KOLE_property *pp)
{
  return (int) pp->keyboard;
}

void
leproperty_set_keyboard (KOLE_property *pp, KEYBOARD_LAYOUT_T k)
{
  pleproperty->keyboard = k;
}

int
leproperty_get_charset (KOLE_property *pp)
{
  return (int) pp->charset;
}

void
leproperty_set_charset (KOLE_property *pp, OPTION_CHARSET c)
{
  pleproperty->charset = c; 
}

int
leproperty_get_deletion (KOLE_property *pp)
{
  return (int) pp->deletion;
}

void
leproperty_set_deletion (KOLE_property *pp, OPTION_DELETION d)
{
  pleproperty->deletion = d; 
}

int
leproperty_get_commit (KOLE_property *pp)
{
  return (int) pp->commit;
}

void
leproperty_set_commit (KOLE_property *pp, OPTION_COMMIT_MODE c)
{
  pleproperty->commit = c; 
}

void
leproperty_done (KOLE_property *pp)
{
  if (pp && g_leproperty_initialized){
    free (pp);
    pp = NULL;
  }
}
