/*

run the following command to get memory leak report:

valgrind --leak-check=full ./test

*/

#include <stdio.h>

#include "le_info.h"
#include "le_session.h"
#include "le_desktop.h"

int main (int argc, char **argv)
{
    LeInfoRec *le_info;
    LeDesktopContextRec *le_desktop_context;
    LeSessionContextRec *le_session_context;

    le_info = (LeInfoRec *)le_info_new();
    le_info_print(le_info);

    le_session_context = (LeSessionContextRec *)le_session_context_new();
    le_session_context_destroy (le_session_context);

    le_desktop_context = (LeDesktopContextRec *)le_desktop_context_new();
    le_desktop_context_destroy (le_desktop_context);

    le_info_destroy(le_info);
}

