#ifndef _CTIM_H_
#define _CTIM_H_

#include "ime.h"
#include "codetable.h"

#define MAX_CANDIDATES_NUM              16
#define MAX_INPUT_KEY_NUM               128
#define MAX_PREEDIT_CHAR_NUM            128
#define MAX_CANDIDATE_CHAR_NUM          256
#define MAX_COMMIT_CHAR_NUM             256

#define MAX_KEYMAP_KEY_NUM              95

#define IME_PREEDIT_AREA                0x01
#define IME_LOOKUP_AREA                 0x02
#define IME_STATUS_AREA                 0x04
#define IME_COMMIT                      0x08
#define IME_BEEP                        0x10

enum ctim_arguments {
	KEYBYKEY_MODE_ID = 0,
	HELPINFO_MODE_ID,
	AUTOSELECT_MODE_ID,
	KEYPROMPT_MODE_ID,
	KEYMAPPING_MODE_ID,
	CTIM_ARGS_NUM
};

typedef struct _ImeBufferRec {
	ImeEncoding encoding;

	char input_buf[MAX_INPUT_KEY_NUM];
	int  input_len;

	char preedit_buf[MAX_PREEDIT_CHAR_NUM];
	int  preedit_len;

	char *candidates[MAX_CANDIDATES_NUM];
	char candidates_buf[MAX_CANDIDATES_NUM][MAX_CANDIDATE_CHAR_NUM];
	char *comments[MAX_CANDIDATES_NUM];
	char comments_buf[MAX_CANDIDATES_NUM][MAX_CANDIDATE_CHAR_NUM];
	char *lookups[MAX_CANDIDATES_NUM];
	char lookups_buf[MAX_CANDIDATES_NUM][MAX_CANDIDATE_CHAR_NUM];
	int  num_candidates;
	int  candidates_start_pos;

	int  commit_len;
	char commit_buf[MAX_COMMIT_CHAR_NUM];

	int  preedit_caretpos;
        int  cur_lookup_pos;
        int  lookup_label_type;
	int  page_state;
        int  return_status;
} ImeBufferRec;

#endif /* _CTIM_H_ */
