/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  <assert.h>
#include  "GeneType.h"
#include  "PyBasic.h"

extern  CHAR   szLocale[10];

CHAR* SHENGMUSTR[26] =
{
   /* Total 26*/
    "a",  "b",  "c",  "ch", "d",  
    "e",  "f",  "g",  "h",  "j",  
    "k",  "l",  "m",  "n",  "o",  
    "p",  "q",  "r",  "s",  "sh", 
    "t",  "w",  "x",  "y",  "z",  
    "zh"
};


/************************
    a    e    m    n    o
    0   80  191  211  237
    1   81  192  212  238
************************/
JINT INDEXSMTOYINJIE[27] = 
{
/*  "a",  "b",  "c",  "ch",  "d", */
      0,    5,   21,    38,   57,
      
/*  "e",  "f",  "g",   "h",  "j", */
     80,   84,   94,   113,  132,

/*  "k",  "l",  "m",   "n",  "o", */
    146,  165,  191,   211,  237,

/*  "p",  "q",  "r",   "s",  "sh", */
    239,  256, 	270,   285,  301,

/*  "t",  "w",  "x",   "y",  "z", */
    320,  340, 	349,   363,  378,

/*  "zh" */
    395,  415
};


/*
**  i ==> ch,   u ==> sh,   v ==> zh
*/
JINT INDEXMAGIC[26] = 
{ 
  /* a   b   c   d   e   f   g   h   i   j   k   l   m */
     0,  1,  2,  4,  5,  6,  7,  8,  3,  9, 10, 11, 12,
     
  /* n   o   p   q   r   s   t   u   v   w   x   y   z */
    13, 14, 15, 16, 17, 18, 20, 19, 25, 21, 22, 23, 24
};

/*************   ZiRanMa ShuangPin Keyboard Layout    ************
      NOTES:  No "er" in this ZRM KeyLayout, ASSUME it's R
                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang               
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo             er   ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

************** Shuang Pin Keyboard Layout In CStar2.97************
                   ch [u]     sh [i]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ia   uan  ao   e    an   ang  iang i    ian  iao  in   ie
       ua                            uang
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  iu   o    ou   er   en   ai   eng  u    v    ei   uai  iong un
       uo        ing                      ui        ue   ong
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

**********  Intelligent ABC ShuangPin Keyboard Layout   **********
            ch [E] sh [V] zh[A] 0 or ' [Zero ShengMu]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   in   ua   e    en   eng  ang  i    an   ao   ai   ue
            uai  ia                                           ui
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  un   o    uan  ei   iu   ong  uang u    v    ian  ie   ing  iao
       uo             er   iong iang                
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

*****************************************************************/

CHAR* YUNMUSTR[37] =
{
  /*  0  */
    "",
  /********* Standard YunMu(33) **********/
  /*  1       2       3       4       5      6       7       8       9      0a   */
    "a",    "ai",   "an",   "ang",  "ao",   "e",    "ei",   "en",   "eng",  "er", 

  /* 0b      0c      0d      0e      0f      10      11      12      13      14  */
    "i",    "ia",   "ian",  "iang", "iao",  "ie",   "in",   "ing",  "iong", "iu",

  /* 15      16      17      18      19      1a      1b      1c      1d      1e  */
    "o",    "ong",  "ou",   "u",    "v",    "ua",   "uai",  "uan",  "uang", "ue",

  /* 1f      20      21  */
    "ui",   "un",   "uo",

  /******** Additional ShengMu(3) **********/
  /* 22      23      24  */
    "ch",   "sh",   "zh"
};

JINT KEYLAYMODE[3][27] = {
    /* ShuangPin Keyboard Layout of ZiRanMa 6.2 */
    /*  A         B         C         D         E  */
    0x000001, 0x000017, 0x00000F, 0x001D0E, 0x000006,
    /*  F         G         H         I         J  */
    0x000008, 0x000009, 0x000004, 0x22000B, 0x000003,
    /*  K         L         M         N         O  */
    0x000005, 0x000002, 0x00000D, 0x000011, 0x002115,
    /*  P         Q         R         S         T  */
    0x000020, 0x000014, 0x000A1C, 0x001316, 0x00001E,
    /*  U         V         W         X         Y  */
    0x230018, 0x241F19, 0x001A0C, 0x000010, 0x001B12,
    /*  Z  */
    0x000007, 0x000000,

    /* ShuangPin Keyboard Layout of Chinese Star2.97 */
    /*  A         B         C         D         E  */
    0x000001, 0x001A0C, 0x00001C, 0x000005, 0x000006,
    /*  F         G         H         I         J  */
    0x000003, 0x000004, 0x001D0E, 0x23000B, 0x00000D,
    /*  K         L         M         N         O  */
    0x00000F, 0x000011, 0x000010, 0x000014, 0x002115,
    /*  P         Q         R         S         T  */
    0x000017, 0x00120A, 0x000008, 0x000002, 0x000009,
    /*  U         V         W         X         Y  */
    0x220018, 0x241F19, 0x000007, 0x001E1B, 0x001613,
    /*  Z  */
    0x000020, 0x000000,

    /* ShuangPin Keyboard Layout of Intelligent ABC */
    /*  A         B         C         D         E  */
    0x000001, 0x000017, 0x00111B, 0x001A0C, 0x000006,
    /*  F         G         H         I         J  */
    0x000008, 0x000009, 0x000004, 0x23000B, 0x000003,
    /*  K         L         M         N         O  */
    0x000005, 0x000002, 0x001E1F, 0x000020, 0x002115,
    /*  P         Q         R         S         T  */
    0x00001C, 0x000007, 0x00140A, 0x001613, 0x001D0E,
    /*  U         V         W         X         Y  */
    0x220018, 0x240019, 0x00000D, 0x000010, 0x000012,
    /*  Z  */
    0x00000F, 0x000000
};

CHAR* YINJIESTR[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "cha",    "chai",   "chan",   "chang",  "chao",    
    "che",    "chen",   "cheng",  "chi",    "chong",   
    "chou",   "chu",    "chua",   "chuai",  "chuan",   
    "chuang", "chui",   "chun",   "chuo",   "ci",      
    "cong",   "cou",    "cu",     "cuan",   "cui",     
    "cun",    "cuo",    "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "sha",    "shai",    
    "shan",   "shang",  "shao",   "she",    "shei",    
    "shen",   "sheng",  "shi",    "shou",   "shu",     
    "shua",   "shuai",  "shuan",  "shuang", "shui",    
    "shun",   "shuo",   "si",     "song",   "sou",     
    "su",     "suan",   "sui",    "sun",    "suo",     
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zha",    "zhai",   "zhan",    
    "zhang",  "zhao",   "zhe",    "zhei",   "zhen",    
    "zheng",  "zhi",    "zhong",  "zhou",   "zhu",     
    "zhua",   "zhuai",  "zhuan",  "zhuang", "zhui",    
    "zhun",   "zhuo",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo", ""
};

/*
**  DUOYINZILIST by Hanzi Internal Code and 
**  Their Pronunciation (Yinjie String) in DUOYINZIYINJIECODE.
**  Some Hanzi Have 3 or 4 Pronunciation, So, Their Codes
**  Appear Several Times In DYZLIST.
**
**  To Reduce Array Size, Define As "static short" is Perfact.
**
**  The Data Is Generated From "GB2andDuoYinZi-UV.txt" by
**  getdyz.c
*/

JINT  DYZLIST[TOTAL_DYZYINJIE] = {
    0xB0A2, 0xB0AC, 0xB0BC, 0xB0C7, 0xB0D2, 0xB0D8, 0xB0E2, 0xB0E3, 
    0xB0E3, 0xB0F2, 0xB0F5, 0xB0F6, 0xB0FE, 0xB1A1, 0xB1A4, 0xB1A4, 
    0xB1A9, 0xB1D9, 0xB1DB, 0xB1E2, 0xB1E3, 0xB2AE, 0xB2B4, 0xB2B7, 
    0xB2CE, 0xB2CE, 0xB2D8, 0xB2DE, 0xB2E0, 0xB2E0, 0xB2E9, 0xB2EE, 
    0xB2EE, 0xB2F0, 0xB2F4, 0xB2F4, 0xB2FC, 0xB3A4, 0xB3A7, 0xB3AF, 
    0xB3B0, 0xB3B5, 0xB3C6, 0xB3CB, 0xB3CE, 0xB3D3, 0xB3D7, 0xB3DF, 
    0xB3F0, 0xB3F4, 0xB4AB, 0xB4B1, 0xB4C2, 0xB4E9, 0xB4F3, 0xB4F4, 
    0xB5A5, 0xB5A5, 0xB5A7, 0xB5AF, 0xB5C3, 0xB5C4, 0xB5D4, 0xB5D7, 
    0xB5D8, 0xB5E8, 0xB5F7, 0xB6A1, 0xB6B1, 0xB6B2, 0xB6BC, 0xB6C1, 
    0xB6C8, 0xB6D7, 0xB6D8, 0xB6D9, 0xB6DA, 0xB6E6, 0xB6E9, 0xB6EA, 
    0xB6F1, 0xB7AC, 0xB7B1, 0xB7EB, 0xB7F0, 0xB7F1, 0xB7F7, 0xB8AC, 
    0xB8C7, 0xB8E4, 0xB8EC, 0xB8EF, 0xB8F2, 0xB8F8, 0xB9C8, 0xB9E3, 
    0xB9EA, 0xB9EA, 0xB9F1, 0xBABB, 0xBAC7, 0xBAC7, 0xBACB, 0xBACD, 
    0xBACD, 0xBACF, 0xBAD1, 0xBAD1, 0xBAD9, 0xBAD9, 0xBAE7, 0xBAEC, 
    0xBBA3, 0xBBAE, 0xBBB2, 0xBBB5, 0xBBB9, 0xBBE1, 0xBBE7, 0xBBED, 
    0xBBFC, 0xBCA9, 0xBCC0, 0xBCD0, 0xBCD2, 0xBCD6, 0xBCDB, 0xBCF7, 
    0xBCFB, 0xBDAB, 0xBDB5, 0xBDB6, 0xBDC0, 0xBDC4, 0xBDC5, 0xBDC7, 
    0xBDC9, 0xBDCB, 0xBDDB, 0xBDE2, 0xBDE5, 0xBDE6, 0xBEA2, 0xBEB1, 
    0xBED7, 0xBEE4, 0xBEF5, 0xBEF9, 0xBFA1, 0xBFA3, 0xBFA7, 0xBFA8, 
    0xBFA9, 0xBFA9, 0xBFAC, 0xBFB8, 0xBFC7, 0xBFC8, 0xBFD4, 0xBFFE, 
    0xC0A3, 0xC0A8, 0xC0AF, 0xC0B0, 0xC0D1, 0xC0D3, 0xC0D5, 0xC0D6, 
    0xC0DF, 0xC0E2, 0xC1A9, 0xC1CA, 0xC1CB, 0xC1F9, 0xC2B5, 0xC2B6, 
    0xC2BD, 0xC2CA, 0xC2CC, 0xC2DA, 0xC2E4, 0xC2E4, 0xC2E7, 0xC2F1, 
    0xC2F6, 0xC2FB, 0xC3A5, 0xC3B0, 0xC3B4, 0xC3B4, 0xC3B4, 0xC3BB, 
    0xC3CB, 0xC3D3, 0xC3D5, 0xC3D8, 0xC3DA, 0xC3E4, 0xC4A3, 0xC4A6, 
    0xC4A8, 0xC4B2, 0xC4B7, 0xC4C4, 0xC4C4, 0xC4C4, 0xC4C5, 0xC4C7, 
    0xC4C7, 0xC4C8, 0xC4CF, 0xC4D8, 0xC4D8, 0xC4E7, 0xC4F1, 0xC4F2, 
    0xC5AA, 0xC5AC, 0xC5B1, 0xC5B6, 0xC5C9, 0xC5D6, 0xC5D9, 0xC5DA, 
    0xC6A5, 0xC6BB, 0xC6C1, 0xC6C7, 0xC6C7, 0xC6C8, 0xC6D2, 0xC6D3, 
    0xC6D3, 0xC6D8, 0xC6D9, 0xC6DA, 0xC6DC, 0xC6E4, 0xC6E6, 0xC6EB, 
    0xC6F5, 0xC6F6, 0xC7A6, 0xC7AC, 0xC7B3, 0xC7B6, 0xC7BF, 0xC7CA, 
    0xC7D1, 0xC7D2, 0xC7D7, 0xC7F8, 0xC8A6, 0xC8AF, 0xC8B2, 0xC8B8, 
    0xC8F4, 0xC8FB, 0xC9AB, 0xC9AF, 0xC9B2, 0xC9BC, 0xC9D1, 0xC9D2, 
    0xC9DF, 0xCAA1, 0xCAA2, 0xCAAF, 0xCAB2, 0xCAB3, 0xCAB6, 0xCACA, 
    0xCACF, 0xCAEC, 0xCAF4, 0xCAF5, 0xCAFD, 0xCBA5, 0xCBAD, 0xCBB5, 
    0xCBB5, 0xCBBC, 0xCBC5, 0xCBC6, 0xCBDE, 0xCBF5, 0xCBFE, 0xCCC0, 
    0xCCC8, 0xCCD5, 0xCCE1, 0xCDCA, 0xCDCD, 0xCDD4, 0xCDD8, 0xCDF2, 
    0xCEB2, 0xCEB5, 0xCEBE, 0xCECE, 0xCED0, 0xCEDE, 0xCFB3, 0xCFB4, 
    0xCFB5, 0xCFB7, 0xCFBA, 0xCFC3, 0xCFC5, 0xCFCB, 0xCFEF, 0xCFF7, 
    0xCFF9, 0xD0A3, 0xD0AE, 0xD0B0, 0xD0D0, 0xD0D0, 0xD0E7, 0xD0EA, 
    0xD0F3, 0xD1AA, 0xD1CA, 0xD1CC, 0xD2B6, 0xD2B7, 0xD2C5, 0xD2D9, 
    0xD2F3, 0xD3BF, 0xD3E1, 0xD3F5, 0xD3FD, 0xD4B1, 0xD4BC, 0xD4BF, 
    0xD4DB, 0xD4DC, 0xD4E4, 0xD4F1, 0xD4F8, 0xD4FA, 0xD4FB, 0xD4FE, 
    0xD4FE, 0xD5A4, 0xD5A6, 0xD5A6, 0xD5B3, 0xD5D9, 0xD5DB, 0xD5E2, 
    0xD6A8, 0xD6B3, 0xD6C5, 0xD6D6, 0xD6D8, 0xD6E0, 0xD7A6, 0xD7A7, 
    0xD7AA, 0xD7AC, 0xD7B5, 0xD7C1, 0xD7C5, 0xD7C5, 0xD7C8, 0xD7D0, 
    0xD7DB, 0xD7E4, 0xD7F5, 0xD8AA, 0xD8BD, 0xD8BF, 0xD8C3, 0xD8C5, 
    0xD8DF, 0xD8EE, 0xD8F7, 0xD8FD, 0xD9A4, 0xD9A4, 0xD9A4, 0xD9A6, 
    0xD9B9, 0xD9CA, 0xD9CD, 0xD9CD, 0xDAB5, 0xDAE7, 0xDAE9, 0xDAE9, 
    0xDAF3, 0xDBA8, 0xDBD7, 0xDBDF, 0xDBE6, 0xDBED, 0xDBFD, 0xDBFD, 
    0xDCBE, 0xDCC0, 0xDCC4, 0xDCC5, 0xDCD1, 0xDCE6, 0xDCE7, 0xDCE8, 
    0xDCEB, 0xDCF9, 0xDCFE, 0xDDB3, 0xDDB8, 0xDDB9, 0xDDC9, 0xDDD2, 
    0xDDD8, 0xDECA, 0xDECC, 0xDED5, 0xDED6, 0xDED9, 0xDEDB, 0xDEE2, 
    0xDFAF, 0xDFAF, 0xDFB6, 0xDFBC, 0xDFBE, 0xDFC1, 0xDFC2, 0xDFC9, 
    0xDFDA, 0xDFF6, 0xDFFA, 0xE0A8, 0xE0A9, 0xE0AA, 0xE0B5, 0xE0B8, 
    0xE0C4, 0xE0C5, 0xE0C9, 0xE0CB, 0xE0DC, 0xE0DC, 0xE0E1, 0xE0E5, 
    0xE0EA, 0xE0EE, 0xE0F7, 0xE0FC, 0xE1BC, 0xE1BD, 0xE1CB, 0xE1DD, 
    0xE1E7, 0xE2BC, 0xE2DB, 0xE2EC, 0xE3A6, 0xE3BB, 0xE3DB, 0xE3DD, 
    0xE3E7, 0xE3F1, 0xE3F8, 0xE4AB, 0xE4B0, 0xE4C5, 0xE4CE, 0xE4D0, 
    0xE4DA, 0xE4F0, 0xE5A3, 0xE5EE, 0xE6E6, 0xE6F4, 0xE6FC, 0xE7B0, 
    0xE7C2, 0xE7D1, 0xE7D1, 0xE7D8, 0xE7D8, 0xE7E3, 0xE7F1, 0xE7F5, 
    0xE7FB, 0xE8BC, 0xE8C8, 0xE8DB, 0xE8DD, 0xE8DE, 0xE8E4, 0xE8E9, 
    0xE8ED, 0xE9A9, 0xE9AB, 0xE9C4, 0xE9D7, 0xEAC1, 0xEADA, 0xEAF9, 
    0xEAFD, 0xEAFD, 0xEAFE, 0xEBE7, 0xECA5, 0xECA8, 0xECB6, 0xECCC, 
    0xECD9, 0xECE2, 0xECF2, 0xECF3, 0xECF8, 0xEDA5, 0xEDAB, 0xEDB0, 
    0xEDB3, 0xEDB9, 0xEDD1, 0xEDD1, 0xEEAE, 0xEED9, 0xEEE4, 0xEEE8, 
    0xEEF5, 0xEEFA, 0xEFA2, 0xEFE1, 0xEFE2, 0xEFE2, 0xEFE6, 0xEFF9, 
    0xF0B0, 0xF0C0, 0xF0E3, 0xF0FB, 0xF0FD, 0xF1BF, 0xF1CA, 0xF1D2, 
    0xF1D3, 0xF1D4, 0xF1E2, 0xF1E2, 0xF1E6, 0xF1E6, 0xF1FB, 0xF2A1, 
    0xF2A2, 0xF2C2, 0xF2D9, 0xF2F8, 0xF3D0, 0xF3DE, 0xF4D6, 0xF4EC, 
    0xF4ED, 0xF4ED, 0xF4F2, 0xF5A1, 0xF5A7, 0xF5C0, 0xF5DA, 0xF5E8, 
    0xF5FE, 0xF6A6, 0xF6B1, 0xF6B8, 0xF6BC, 0xF6BF, 0xF6EB, 0xF7BD, 
    0xF7D4, 0xF7DC, 0xF7E1, 0xF7E5  
};

/*
**  DuoYinZi YinJie Code. Corresponding to the Above Struct.
*/
JINT DYZYJCODE[TOTAL_DYZYINJIE] = {
        80,    368,    340,    239,    239,     19,    241,     19, 
       241,    242,    242,     12,     19,     19,     20,    255, 
       255,    247,     10,    248,    248,      6,    253,     19, 
        28,    308,    381,    293,    396,    383,    395,     30, 
        39,     21,     23,    303,    397,    398,      2,    399, 
       399,    142,     44,    309,     65,     44,    310,     43, 
       265,    358,    410,    411,     42,    394,     58,      1, 
       303,     40,    303,    322,     63,     66,    396,     62, 
        62,    329,    330,    403,    333,    333,     74,     74, 
        79,     36,     77,     75,    338,    339,    129,    368, 
       348,    241,    253,    252,     93,    247,     13,    255, 
        99,    117,     94,    132,    113,    132,    374,      2, 
       145,    265,    142,     11,      0,    151,    124,    124, 
       131,     99,    117,    208,    114,    208,    135,    103, 
       350,    126,    129,    247,    114,    159,    362,    125, 
       256,    256,    396,     94,    137,    105,    137,    148, 
       351,    259,    352,    260,    144,    366,    144,    144, 
       414,     42,    142,    354,    132,     95,    139,    102, 
       392,    104,    136,    377,    143,    362,     94,    257, 
        99,    190,    137,     97,    260,    114,    116,    110, 
       129,    106,    395,    349,    210,    190,    171,    376, 
       170,    180,    176,    169,    170,    185,    181,    184, 
       181,    314,    185,    108,    165,    169,    169,    194, 
       208,    342,    200,    208,    208,    192,    366,    208, 
       206,    198,    198,     13,     13,    342,    210,    192, 
       192,    210,    191,    213,    217,    218,    217,    217, 
       218,    236,    212,    212,    221,    224,     69,    298, 
       183,    216,    366,     80,    239,    241,      9,      9, 
       363,    251,     18,     19,    339,    240,     20,    249, 
       253,      9,      9,    132,    349,    132,    132,    132, 
       354,    261,    364,     96,    134,    148,    135,    305, 
       133,    142,    263,    238,    143,    360,    110,    260, 
       273,    290,    302,    300,     38,    301,     41,    289, 
       368,    356,     45,     59,    308,    293,    404,    164, 
       404,    311,    407,    407,    319,     35,    307,    317, 
       376,    286,     30,    310,    358,    296,     57,    304, 
        41,    366,     66,    338,    413,     79,    320,    208, 
       368,    374,    374,    408,    112,    208,    351,    351, 
       132,    124,    113,    301,    118,    258,    116,    361, 
         4,    136,    133,    367,    116,    121,    266,    310, 
        49,    354,    367,    369,    354,    409,    344,     99, 
       364,     47,    312,    359,    371,    377,    366,    366, 
       378,     34,    394,    396,     29,    378,     38,     94, 
       363,    303,    378,    383,    222,    305,    306,    401, 
       387,    310,    310,     47,     47,    374,    399,    367, 
       409,    391,     54,    394,    399,    400,     30,    379, 
       386,     33,    395,    173,    256,    225,     19,    133, 
       303,    368,     44,     70,     94,    257,    261,    213, 
       293,    137,    186,    190,    137,    364,    247,    253, 
       344,    362,    359,    369,     46,    333,     10,     13, 
       375,     93,    266,     13,    407,    330,    349,    328, 
       387,    256,    370,    249,    108,    176,     10,    374, 
       274,    381,    373,    251,    228,    380,    190,    107, 
       326,    337,    324,    191,    321,    247,      6,    106, 
        30,    273,    399,     51,    395,    320,    144,    347, 
       301,    211,    368,    119,     51,    409,     45,    361, 
        38,    214,    375,     61,    333,    260,    341,     86, 
       404,    323,    262,    405,    173,    261,    115,    248, 
       410,    316,    253,    159,    359,    202,    369,    265, 
       402,    320,     59,     40,    321,    249,    118,    328, 
       248,    207,    209,    289,    382,     88,    116,    130, 
       162,     15,    388,    142,    376,    339,    181,    164, 
       129,    402,     38,     18,    392,    140,     13,    258, 
       301,    300,     19,    364,    368,    349,    348,     42, 
       377,     61,    221,    256,    303,    226,    325,    411, 
       320,    359,    190,    182,    332,    239,    329,    339, 
        45,     71,    366,    181,    322,    355,     78,    190, 
       374,    124,     57,     37,    350,    362,    257,    407, 
       349,    247,    312,    363,    138,    262,    322,    354, 
       118,    151,    353,    373,    394,    377,    308,    256, 
       406,    373,    261,    394,    310,     19,     70,    349, 
       392,    176,    351,    369,    202,    412,    403,    124, 
       303,    258,    208,    269 
}; 


/*
**  Index Of Above DuoYinZiList by High Byte of Hzcode.
**  Distance Of 0xB0(a1) to 0xF7(fe) is: 0x48 = 72
*/
JINT INDEXOFDYZLIST[DISTOF_B0_F7 + 1] = {
      0,  13,  21,  37,  50,  56,  67,  81,  87,  94,  99, 112, 121, 
         129, 142, 148, 160, 170, 174, 186, 198, 216, 224, 242, 252, 
         258, 265, 277, 287, 291, 296, 302, 313, 321, 324, 329, 333, 
         345, 352, 358, 371, 380, 388, 393, 400, 411, 417, 424, 435, 
         452, 457, 460, 467, 474, 476, 479, 489, 497, 501, 507, 508, 
         517, 524, 530, 536, 541, 551, 556, 558, 563, 569, 575, 580  
};


/*
**  "CH SH ZH"in the following table was adjusted.
*/
CHAR* YINJIESTR_CSZ[NUM_YINJIE + 1] = 
{
    "a",      "ai",     "an",     "ang",    "ao",      
    "ba",     "bai",    "ban",    "bang",   "bao",     
    "bei",    "ben",    "beng",   "bi",     "bian",    
    "biao",   "bie",    "bin",    "bing",   "bo",      
    "bu",     "ca",     "cai",    "can",    "cang",    
    "cao",    "ce",     "cei",    "cen",    "ceng",    
    "ci",     "cong",   "cou",    "cu",     "cuan",    
    "cui",    "cun",    "cuo",    "cha",    "chai",    
    "chan",   "chang",  "chao",   "che",    "chen",    
    "cheng",  "chi",    "chong",  "chou",   "chu",     
    "chua",   "chuai",  "chuan",  "chuang", "chui",    
    "chun",   "chuo",   "da",     "dai",    "dan",     
    "dang",   "dao",    "de",     "dei",    "den",     
    "deng",   "di",     "dia",    "dian",   "diao",    
    "die",    "ding",   "diu",    "dong",   "dou",     
    "du",     "duan",   "dui",    "dun",    "duo",     
    "e",      "en",     "eng",    "er",     "fa",      
    "fan",    "fang",   "fei",    "fen",    "feng",    
    "fiao",   "fo",     "fou",    "fu",     "ga",      
    "gai",    "gan",    "gang",   "gao",    "ge",      
    "gei",    "gen",    "geng",   "gong",   "gou",     
    "gu",     "gua",    "guai",   "guan",   "guang",   
    "gui",    "gun",    "guo",    "ha",     "hai",     
    "han",    "hang",   "hao",    "he",     "hei",     
    "hen",    "heng",   "hong",   "hou",    "hu",      
    "hua",    "huai",   "huan",   "huang",  "hui",     
    "hun",    "huo",    "ji",     "jia",    "jian",    
    "jiang",  "jiao",   "jie",    "jin",    "jing",    
    "jiong",  "jiu",    "ju",     "juan",   "jue",     
    "jun",    "ka",     "kai",    "kan",    "kang",    
    "kao",    "ke",     "kei",    "ken",    "keng",    
    "kong",   "kou",    "ku",     "kua",    "kuai",    
    "kuan",   "kuang",  "kui",    "kun",    "kuo",     
    "la",     "lai",    "lan",    "lang",   "lao",     
    "le",     "lei",    "leng",   "li",     "lia",     
    "lian",   "liang",  "liao",   "lie",    "lin",     
    "ling",   "liu",    "lo",     "long",   "lou",     
    "lu",     "lv",     "luan",   "lue",    "lun",     
    "luo",    "m",      "ma",     "mai",    "man",     
    "mang",   "mao",    "me",     "mei",    "men",     
    "meng",   "mi",     "mian",   "miao",   "mie",     
    "min",    "ming",   "miu",    "mo",     "mou",     
    "mu",     "n",      "na",     "nai",    "nan",     
    "nang",   "nao",    "ne",     "nei",    "nen",     
    "neng",   "ni",     "nian",   "niang",  "niao",    
    "nie",    "nin",    "ning",   "niu",    "nong",    
    "nou",    "nu",     "nv",     "nuan",   "nue",     
    "nun",    "nuo",    "o",      "ou",     "pa",      
    "pai",    "pan",    "pang",   "pao",    "pei",     
    "pen",    "peng",   "pi",     "pian",   "piao",    
    "pie",    "pin",    "ping",   "po",     "pou",     
    "pu",     "qi",     "qia",    "qian",   "qiang",   
    "qiao",   "qie",    "qin",    "qing",   "qiong",   
    "qiu",    "qu",     "quan",   "que",    "qun",     
    "ran",    "rang",   "rao",    "re",     "ren",     
    "reng",   "ri",     "rong",   "rou",    "ru",      
    "rua",    "ruan",   "rui",    "run",    "ruo",     
    "sa",     "sai",    "san",    "sang",   "sao",     
    "se",     "sen",    "seng",   "si",     "song",    
    "sou",    "su",     "suan",   "sui",    "sun",     
    "suo",    "sha",    "shai",   "shan",   "shang",   
    "shao",   "she",    "shei",   "shen",   "sheng",   
    "shi",    "shou",   "shu",    "shua",   "shuai",   
    "shuan",  "shuang", "shui",   "shun",   "shuo",    
    "ta",     "tai",    "tan",    "tang",   "tao",     
    "te",     "tei",    "teng",   "ti",     "tian",    
    "tiao",   "tie",    "ting",   "tong",   "tou",     
    "tu",     "tuan",   "tui",    "tun",    "tuo",     
    "wa",     "wai",    "wan",    "wang",   "wei",     
    "wen",    "weng",   "wo",     "wu",     "xi",      
    "xia",    "xian",   "xiang",  "xiao",   "xie",     
    "xin",    "xing",   "xiong",  "xiu",    "xu",      
    "xuan",   "xue",    "xun",    "ya",     "yan",     
    "yang",   "yao",    "ye",     "yi",     "yin",     
    "ying",   "yo",     "yong",   "you",    "yu",      
    "yuan",   "yue",    "yun",    "za",     "zai",     
    "zan",    "zang",   "zao",    "ze",     "zei",     
    "zen",    "zeng",   "zi",     "zong",   "zou",     
    "zu",     "zuan",   "zui",    "zun",    "zuo",     
    "zha",    "zhai",   "zhan",   "zhang",  "zhao",    
    "zhe",    "zhei",   "zhen",   "zheng",  "zhi",     
    "zhong",  "zhou",   "zhu",    "zhua",   "zhuai",   
    "zhuan",  "zhuang", "zhui",   "zhun",   "zhuo", "" 
};

/*
**  Each Hz have 9Bits(0~512) to indicates Yinjie Code.
**  Total 6768 (6763 + 5Space) chars included.	(6768 * 9) / 32 + 1 = 1904
*/
JUINT GBHZCODETOYJ[] = {
    0x00000020, 0x10080402, 0x01008040, 0x20100804, 0x02020100, 0x80402010, 0x08040201, 0x80C06040, 0x20100804,
    0x02010080, 0x4028140A, 0x05028140, 0xA0502814, 0x0A050281, 0x40A05028, 0x140C0603, 0x0180C060, 0x30180E07,
    0x0381C0E0, 0x70381C0E, 0x070381C0, 0xE0703820, 0x10080402, 0x01008040, 0x20100804, 0x02412090, 0x48241209,
    0x04824120, 0x90482412, 0x09048241, 0x40A05028, 0x140A0502, 0x8140A050, 0x28140A05, 0x02C160B0, 0x5830180C,
    0x06030180, 0xD068341A, 0x0D068341, 0xA0D06834, 0x1A0D0683, 0x41A0D068, 0x341A0D06, 0x8341A0E0, 0x70381C0E,
    0x070381C0, 0xE070381C, 0x0F0783C1, 0xE1008040, 0x20110884, 0x42211088, 0x48241209, 0x04824120, 0x90482613,
    0x0984C261, 0x30984C26, 0x130984C2, 0x6130984C, 0x26130985, 0x028140A0, 0x5028140A, 0x05028140, 0xA8582C16,
    0x0B0582C1, 0x60B0582C, 0x160B85C2, 0xE170B85C, 0x2E180C06, 0x030180C8, 0x6432190C, 0x868341A0, 0xD0683A1D,
    0x130984C2, 0x6130984C, 0x26130984, 0xC271389C, 0x5028140A, 0x05028140, 0xA0502814, 0x8A452291, 0x48A45229,
    0x148A4522, 0x9148A854, 0x2A150A85, 0x42A150A8, 0x562B158A, 0xC562B160, 0xB0582C16, 0x0B0582C1, 0x60B05A2D,
    0x168B45A2, 0xD168B45A, 0x2D168B45, 0xA2D168B8, 0x5C2E170B, 0x85C2E170, 0xB85C2E17, 0x0B85C2E1, 0x70BC5E2F,
    0x178BC603, 0x0180C060, 0x30180C06, 0x030180C0, 0x6231188C, 0x46231188, 0xC4623118, 0x8C462311, 0x88C46634,
    0x1A0D0683, 0x41A0D06A, 0x351A8D46, 0xA351B0D8, 0x6C361B0D, 0xC6E371B8, 0xDC6E371C, 0x0E03C1E0, 0xF0783C1E,
    0x0F0783C1, 0xE0F0783E, 0x1F0F87C3, 0xE1F10084, 0x42211088, 0x84422118, 0x8C462311, 0x88C46231, 0x20904825,
    0x128944A2, 0x5128E472, 0x391C8E47, 0x23A1D0E8, 0x743A1D0E, 0x8743A1D0, 0xE8743B1D, 0x8EC763B1, 0xD8EC763B,
    0x1D8EC763, 0xB1D8EC78, 0x3C1E0F07, 0x83D1E8F4, 0x7A3D1E8F, 0x47A3D1E8, 0xF47A3E1F, 0x0F882412, 0x09048241,
    0x20908844, 0x22110884, 0x42211088, 0x44221108, 0x84422110, 0x88442221, 0x10884422, 0x11088442, 0x21108844,
    0x22110884, 0x4229148A, 0x45229148, 0xA4522918, 0x8C462311, 0x88C46239, 0x1C8E4723, 0x91C8E472, 0x39209249,
    0x24924924, 0x92492492, 0x49251289, 0x44A25128, 0x944B2592, 0xC964B259, 0x2C964B25, 0x92C964B2, 0x592C984C,
    0x26130984, 0xC269349A, 0x4D271389, 0xC4E27138, 0x9C4E2713, 0xC9E4F279, 0x3C9E4F27, 0x93C9E4F2, 0x7940A050,
    0x28140A05, 0x028140A0, 0x5028140A, 0x2532994C, 0xA6532994, 0xCA6542A1, 0x50A8542A, 0x150A8552, 0xA954AA55,
    0x2A954AA5, 0x52A954AA, 0x552A954A, 0xA552B158, 0xAC562B15, 0x8AC562B1, 0x58AC572B, 0x95CAE572, 0xB95CAE57,
    0x2B95CAE5, 0x82C160B0, 0x582C160B, 0x0582C160, 0xB0582C16, 0x0B2592C9, 0x64B2592C, 0x964B2592, 0xC964B259,
    0x2C96CB85, 0xD2E974BA, 0x5D2E974B, 0xA5D2E974, 0xBA5D2E97, 0x4BA5D2E9, 0x74BA5D2E, 0x974BA5D2, 0xE974BA5D,
    0x2E974BA5, 0xD2E974BA, 0x5D2E974B, 0xA5D2E974, 0xBA5D2F17, 0x8BE5F2F9, 0x7CBE5F30, 0x180C0603, 0x0180C060,
    0x30180C06, 0x130984C2, 0x6130984C, 0x26131188, 0xC4623118, 0x8C462311, 0x88C66331, 0x98CC6633, 0x198CC663,
    0x3198CC66, 0x33198CC6, 0x6432994C, 0xC6633198, 0xCC663319, 0xCCE67339, 0x9CCE6733, 0x99CCE673, 0x399CCE67,
    0x341A0D06, 0x8341A0D0, 0x68341A4D, 0x269349A4, 0xD269349A, 0x4D269349, 0xA4D26934, 0x9A4D26A3, 0x51A8D46A,
    0x351ACD66, 0xB361B0D8, 0x6C361B0D, 0x86C361B0, 0xD86D369B, 0x4DC6E371, 0xB8DC6E37, 0x1B8DC6E3, 0x71B8DC6E,
    0x371B8DE6, 0xF379C0E0, 0x70381C0E, 0x071391C8, 0xE472391C, 0x8E473399, 0xCCE67339, 0x9CCE6733, 0x99CCE673,
    0x399CCE67, 0x3399CCE8, 0x743A1D4E, 0xA753A9D4, 0xEA753A9D, 0x4EC763B1, 0xD8EC763B, 0x1D8EC763, 0xB1D8EC76,
    0x3B1D8EC7, 0x63B9DCF0, 0x783C1E0F, 0x2793C9E4, 0xF27A3D1E, 0x8F47A3D1, 0xE8F47A3D, 0x9ECF67B3, 0xD9ECF67C,
    0x3E1F0F87, 0xC3E1F0F8, 0x7C3E1F0F, 0x87C3E1F0, 0xF87C3E1F, 0x4FA7D3E9, 0xF4FA7D3E, 0x9F4FC7E3, 0xF1F8FC7F,
    0x3F9FCFE7, 0xF3F9FCFE, 0x7F3F9FCF, 0xE7F3FA01, 0x00804020, 0x10080402, 0x01008040, 0x20100814, 0x0A050281,
    0x40A05028, 0x140A0502, 0x8140A050, 0x28140A05, 0x02814120, 0x90482412, 0x09068341, 0xA0D06834, 0x1A0D0683,
    0x42211088, 0x44221108, 0x84422110, 0x88442211, 0x08844221, 0x10884422, 0x11088442, 0x21108844, 0x22110884,
    0x42211088, 0x44221108, 0x84422110, 0x88442211, 0x08844221, 0x10884422, 0x150A8542, 0xA150A854, 0x2A150A85,
    0x42A150A8, 0x542A150C, 0x86432190, 0xC8643219, 0x0C864321, 0x90C86432, 0x190C8643, 0x2190C864, 0x32190C86,
    0x432190C8, 0x6432190C, 0x86432190, 0xC8643219, 0x0E8743A1, 0xD0E8743A, 0x1D0E8743, 0xA1D0E884, 0x42211088,
    0x44221108, 0x84422110, 0x88442211, 0x08844221, 0x10884422, 0x11088442, 0x21108944, 0xA2512894, 0x4A251289,
    0x44A25128, 0x944A2512, 0x8944A251, 0x28944A25, 0x128944A2, 0x5148A452, 0x29148A45, 0x229148A4, 0x5229148A,
    0x45229148, 0xA4522916, 0x8B45A2D1, 0x68B45A2D, 0x168B45A2, 0xD168B45A, 0x2D168B45, 0xA2D168B4, 0x5A2D168C,
    0x462351A8, 0xD46A351A, 0x8D46A351, 0xA8D46A35, 0x1A8D46A3, 0x51C8E472, 0x391C8E47, 0x2391C8E4, 0x72391C8E,
    0x472391C8, 0xE472391C, 0x8E472391, 0xC8F47A3D, 0x1E8F47A3, 0xD2090482, 0x41209048, 0x24120904, 0x8A452291,
    0x48A45229, 0x148A4522, 0x92492492, 0x49349A4D, 0x26934A25, 0x128944A2, 0x512A954A, 0xA552A954, 0xAA592C96,
    0x4B25D2E9, 0x74BA5D2E, 0x974BA5D2, 0xE974BA5D, 0x2E974CA6, 0x532994D2, 0x69369B4D, 0xA6D389C4, 0xE2713A9D,
    0x4EA753A9, 0xD4EA793C, 0x9E4F2793, 0xE9F4FA7D, 0x40A050A8, 0x542A150A, 0x8542A151, 0x28944A25, 0x128944A2,
    0x5128944A, 0x351A8D46, 0xA4522914, 0x8A552A95, 0x4AA552A9, 0x54CA6532, 0x9D4EA753, 0xA9D4EA75, 0x3A9D4EA7,
    0x53A9D4EA, 0x7542A150, 0xA8542A15, 0x0A954AA5, 0x52A954AA, 0x552A9552, 0xA956AB55, 0xAAD56AB5, 0x5AAD56AB,
    0x55AB158A, 0xC56AB55A, 0xAD56AB55, 0xAAD56AB5, 0x5AAD56AB, 0x55AAD56A, 0xB55AAD56, 0xAB55AAD5, 0x6AB55AAD,
    0x56AB55AA, 0xD56AB55C, 0xAF57ABD5, 0xEAF57ABD, 0x5EAF57AB, 0xD5EAF57A, 0xC160B058, 0x2C160B05, 0x82C160B0,
    0x58AC562B, 0x158AC562, 0xB158AC56, 0x2B158AC9, 0x64B2592C, 0x966B359A, 0xCD66B359, 0xACD66B35, 0x9AD168B4,
    0x5A2D168B, 0x45A2D168, 0xB45A2D16, 0x8B45AAD5, 0x6AB55AAD, 0x56AB55AA, 0xD56AB75B, 0xADD6EB75, 0xBADD6EB7,
    0x5C2E170B, 0x85C2E172, 0xB95CAE57, 0x2B95CAE5, 0x72B95CAE, 0x572B95CA, 0xE572B95C, 0xAE574BA5, 0xD2E974BA,
    0x5D2E974B, 0xA5D2E974, 0xBA5DAED7, 0x6BB5DAED, 0x78BC5EAF, 0x57ABD5EA, 0xF57ABE5F, 0x2F97CBE5, 0xF2F97CBE,
    0x5F2F97CC, 0x06030180, 0xC0603018, 0x0C060B05, 0x82C160B0, 0x584C2613, 0x0984C261, 0x30984C36, 0x1B0D86C3,
    0x61B1188C, 0x46231188, 0xC4623118, 0x8C462315, 0x8CC66331, 0x98CC6633, 0x198CC663, 0x3198CC66, 0x33198EC7,
    0x63B2190C, 0x86432190, 0xC8643259, 0x2C964B25, 0x92C964B2, 0x592C964B, 0x2592CA65, 0x32994CA6, 0x532994CA,
    0x65B2D96C, 0xB65B2D96, 0xCB663319, 0xACD66B35, 0x9ACD6733, 0x99CCE673, 0x399ED068, 0x341A0D06, 0x8341A0D0,
    0x68341A0D, 0x068341A0, 0xD068B45A, 0x2D269349, 0xA4D26934, 0x9A4D2693, 0x49A4D269, 0x349A8D46, 0xA351A8D4,
    0x6A355AAD, 0x56AB55AC, 0xD66B35DB, 0x0D86C361, 0xB0D96D36, 0x9B6DC6EB, 0x75BADD6E, 0xB75BADD6, 0xEB75BADE,
    0x6F379BCD, 0xE6F379BE, 0xDF70381C, 0x2E170B85, 0xC2E170B8, 0x9C6E371B, 0x8DC6E372, 0x391C8E47, 0x2B95CAE5,
    0x73B9DCEE, 0x874BA9D4, 0xEC763B1D, 0x8ED773B9, 0xDCEE773B, 0x9DCEF77B, 0xBDDEEF77, 0xBC1E0F07, 0x83C1E0F1,
    0x78BC5E2F, 0x178BC5E2, 0xF2793C9E, 0x4F279BCD, 0xE6F379BC, 0xDE6F47A3, 0xD1E8F47A, 0x3D1E8F47, 0xABD5ECF6,
    0x7B3D9ECF, 0x67B3D9EC, 0xF67B3D9E, 0xCF67BBDD, 0xEEF77BBD, 0xDEEF77BB, 0xDDEEF77B, 0xBDDEEF77, 0xBBE1F0F8,
    0x7C3E5F2F, 0x97CBE9F4, 0xFB7DBEDF, 0x6FB7E3F1, 0xF8FC7E3F, 0x1F8FC7E3, 0xF5FAFD7E, 0xBF5FAFD7, 0xEBF9FEFF,
    0x7FBFDFEF, 0xF7FBFDFE, 0xFF7FBFDF, 0xEFF7FC02, 0x01008040, 0x20100804, 0x02010080, 0x40201008, 0x04020100,
    0x80402010, 0x08040201, 0x00804020, 0x10080402, 0x01008040, 0x60301814, 0x0A050281, 0x40A05028, 0x140A0502,
    0x8140A050, 0x28140A05, 0x028140A0, 0x70381C0E, 0x070381C0, 0xE0904824, 0x12090482, 0x41209048, 0x24120904,
    0x824160B0, 0x582C160D, 0x068341A0, 0xD068341A, 0x0D068341, 0xE0F0783C, 0x1E0F0783, 0xC1E0F078, 0x3C1E1108,
    0x84C26130, 0x984C2613, 0x098542A1, 0x50A8542A, 0x150A8542, 0xA150A854, 0x2E170B85, 0xC2E170B8, 0x5C2E170B,
    0x86432190, 0xC8643219, 0x0C86C361, 0xD0E8743A, 0x1F0F87C3, 0xE1F10884, 0x42231189, 0x44A25128, 0x944A2512,
    0x8944A271, 0x38A4562B, 0x158AC562, 0xB158AC56, 0x2B168B45, 0xA2F178BC, 0x5E2F178B, 0xC5E2F178, 0xCC66351A,
    0x8D46E371, 0xC8E4763B, 0x1D8F47A3, 0xD1E8FC7E, 0x3F1F9048, 0x2412190C, 0x86432291, 0x48A47249, 0x6CB65B2D,
    0x96CB65B2, 0xD96CBA5D, 0x2F97CBE5, 0xF2F97CBE, 0x5F2F97CB, 0xE5F2F97C, 0xBE5F3098, 0x4C261309, 0x84C26131,
    0x98CC6633, 0x198CC663, 0x3198CC66, 0x532994CA, 0x6532994C, 0xA6532994, 0xCA69349A, 0x4D269349, 0xA4D26934,
    0x9A4D2693, 0x49A4D26B, 0x359ACD66, 0xB359ACD6, 0x6B359ACD, 0xA6D369B4, 0xDA6D369B, 0x4DA6D369, 0xB4DA6D36,
    0x9B4DA6D3, 0x69B4DA6D, 0x369B4DA6, 0xD369B4DA, 0x6D369B4D, 0xA6D369B4, 0xDA6D369B, 0x4DA6D369, 0xB4DA6D36,
    0x9BCDE6F3, 0x79BCDE6F, 0x379BCDE7, 0x1389C4E2, 0x71389C4E, 0x271389C4, 0xE271389C, 0x4E271389, 0xC4E27138,
    0x9C4E2713, 0x89C4E271, 0x389C4E27, 0x1399CCEA, 0x753A9D4E, 0xE773C9E4, 0xF27B3D9E, 0xCF67D3E9, 0xF4FA7F3F,
    0x9FCFE4B2, 0x592C964B, 0x2592C964, 0xB2592C96, 0x4B2592C9, 0x64D26934, 0x9A4D2693, 0x49A4F279, 0x3C9E5128,
    0x944A2512, 0x8944A251, 0x28944A25, 0x32994CAA, 0x552A954A, 0xA552A954, 0xAA552A95, 0xCAE572C9, 0x64B2592C,
    0x964B2594, 0x0A050281, 0x40A05028, 0x140A0D06, 0x8341A0D0, 0x68341A0D, 0x0A8542A1, 0x50A8542A, 0x150A8542,
    0xA150A854, 0x2A150A85, 0x43A1D0E8, 0x743A1D0E, 0x8743A1D0, 0xE8743A25, 0x128944A2, 0x5128944A, 0x25128945,
    0xA3D1E8F4, 0x7A452291, 0x48A45229, 0x148A4522, 0x9148A452, 0x29149A4D, 0x269349A4, 0xD26934AA, 0x552A954A,
    0xA5D2E974, 0xCA653299, 0x4CA65329, 0x94CA6536, 0x9B4DA6D3, 0x69B4DA6D, 0x369B4DA6, 0xD369D4EA, 0x753A9F4F,
    0xA7D3E9F4, 0xFA7D3E9F, 0x4FA7D42A, 0x151A8D46, 0xA351A8D4, 0xAA552A9D, 0x4EA753A9, 0xD4EA753A, 0x9D4EA754,
    0xAA552A95, 0x4AA552AB, 0x55AB55AA, 0xD56AB55A, 0xAD56AB55, 0xAAD56AB5, 0x5AAD56AB, 0x55EAF57A, 0xBD5EAF57,
    0xABD5EAF5, 0x8AC562B1, 0x58AC562B, 0x158AC562, 0xB158AC56, 0x2B158AC5, 0x62B158AC, 0x562B158A, 0xC562B158,
    0xAC562B15, 0x8ACD66B3, 0x59ACD66B, 0x359ACD66, 0xB55AAD56, 0xEB75BADD, 0x6EB75BAD, 0xD6EB95CA, 0xE572B95C,
    0xAE572B95, 0xCAE572B9, 0x5CAE572B, 0x95CAE572, 0xB95CAE57, 0x2B95CAE5, 0x72B95DAE, 0xD76BB5DA, 0xED76BB5D,
    0xAED76BB5, 0xDAED76BB, 0x5DAED76B, 0xB5DAED76, 0xBB5DAED7, 0x6BB5DAED, 0x76BB5DAE, 0xD76BD5EA, 0xF57ABD5E,
    0xAF57ABD5, 0xEAF57ABD, 0x5FAFD7EB, 0xF5FAFD7E, 0xBF5FAFD7, 0xEBF5FAFD, 0x7EBF5FAF, 0xD7EBF5FA, 0xFD7EBF5F,
    0xAFD82C16, 0x0B0582C1, 0x60B0582C, 0x160B0582, 0xC160B058, 0x2C160B05, 0x86C361B0, 0xD86C361B, 0x0D86C361,
    0xB0D86C36, 0x1B0D86C3, 0x62B158AC, 0x562B158A, 0xC562B158, 0xAC562B15, 0x8AC562B1, 0x58AC562B, 0x1D8EC763,
    0xB1D8EC76, 0x3B1D8EC9, 0x64B2592C, 0x964B2592, 0xC964B259, 0x2C964B25, 0x96CB65B2, 0xD96CB65B, 0x359ACD66,
    0xB359ACD6, 0x6B359ECF, 0x67B3D9EC, 0xF67B3D9E, 0xCF67B3D9, 0xECF67B3D, 0x9ECF67B4, 0x5A2D168B, 0x45A2D168,
    0xB45A2D36, 0x9B4DA6D3, 0x69B55AAD, 0x56AB55AA, 0xD56AB55A, 0xAD56AB55, 0xAAD76BB5, 0xDAED76BB, 0x5DAED76B,
    0xB5DAED76, 0xBB5DAED9, 0x6CB65B2D, 0x96CB65B2, 0xD96CB65B, 0x2D96CB65, 0xB2D96CB6, 0x5B2D96CB, 0x65B2D96C,
    0xB65B2D96, 0xCB65B2D9, 0x6DB6DB6D, 0xB6DB6DB6, 0xDB6DB6DB, 0x6DB6DB6D, 0xB6DB6DB7, 0x5BADD6EB, 0x75BADD6E,
    0xB75BADD6, 0xEB75BADD, 0x6FB7DBED, 0xF6FB7DBE, 0xDF6FB7DB, 0xEDF6FB7D, 0xBEE170B8, 0x5C2E170B, 0x85C2E170,
    0xB85C2E17, 0x0B85C2E1, 0x70B85C2E, 0x170B85C2, 0xE170B85C, 0x2E170B85, 0xC2E170B8, 0x5C2E170B, 0x85C2E170,
    0xB85C2E17, 0x0B85C2E1, 0x70B85C2E, 0x171B8DC6, 0xE371B8DC, 0x6E371B8D, 0xC6E371B8, 0xDC6E372B, 0x95CAE572,
    0xB95CAE57, 0x2B95CAE5, 0x72B95CAE, 0x572B95CE, 0xE974BA5D, 0x2E974BA5, 0xD2E974BA, 0x5D2E974B, 0xA5D6EB75,
    0xBADD6EB7, 0x5BADD6EB, 0x75BADD6E, 0xB75BADD6, 0xEB75BADD, 0xAED76BB5, 0xDAED76BB, 0x5DAED76B, 0xB5DAED76,
    0xBB5DAED7, 0x6BB5DAED, 0x76BB5DAE, 0xD76BB5DA, 0xED76BB5D, 0xAED76BB5, 0xDAED76BB, 0x5DAED76B, 0xB5DAEF77,
    0xBBDDEEF7, 0x7BBDDEEF, 0x77BBDDEE, 0xF77BBDDE, 0xEF77BBDD, 0xEF178BC5, 0xE2F178BC, 0x5E2F178B, 0xCDE6F379,
    0xBCDE6F37, 0x9BCDE6F3, 0x79BD5EAF, 0x57BBDDEE, 0xF77BBDDE, 0xEF97CBE5, 0xF2FB7DBE, 0xDFAFD7EB, 0xF5FAFD7E,
    0xBF5FAFD7, 0xEBF5FAFD, 0x7FBFDFEF, 0xF80C0E0B, 0x0582C162, 0xF178BC5E, 0x2F178BC5, 0xE2F178BC, 0x5E2F178C,
    0xC6633198, 0xCC66371B, 0x8DC6E371, 0xB8DC6E37, 0x1B8DC6E3, 0x71B8DC6E, 0x371D8EC7, 0x63B1D8EC, 0x763B1D8E,
    0xC763B1D8, 0xEC763F1F, 0x8FC7E3F1, 0xF8FC7E3F, 0x1F90C864, 0x32190C86, 0x432190C8, 0x64B2592C, 0x964B2592,
    0xC964B259, 0x2C964B25, 0x92C964F2, 0x793C9E4F, 0x2793C9E4, 0xF2793C9E, 0x4F2793CA, 0x6532994C, 0xA6532994,
    0xCA653299, 0x4CA65329, 0x94CA6532, 0x994CA653, 0x2994CA65, 0x32994CA6, 0x532994CA, 0x6532994C, 0xA6532994,
    0xCA653299, 0x5CAE572B, 0x95CAE572, 0xB95CAE57, 0x2D96CB65, 0xB2D96CB6, 0x5B2D96CB, 0x65B2D96C, 0xBE5F2F97,
    0xCBE5F2F9, 0x7CBE5F2F, 0x97CBE5F2, 0xF97CBE5F, 0x2F97CBE5, 0xF2F97CBE, 0x5F3198CC, 0xE6B359AC, 0xD66B359B,
    0xCDE6F379, 0xBCDE6F39, 0x9CCE6733, 0x99CCEE77, 0x3D9ECF67, 0xB3D9ECF6, 0x7B3D9ECF, 0x60F0783C, 0x1E0F0783,
    0xC1E0F078, 0x3C1E0F07, 0x83C26130, 0x984C2613, 0x0985C2E1, 0x70B86C36, 0x1B0D86C3, 0x61B0D87C, 0x3E231188,
    0xC4627138, 0xAC562B15, 0x8AC562B1, 0x40000000, 0x000018A1, 0x2B85F6F4, 0x75EE6516, 0x98DB0509, 0xC5D9F40D,    /* Change 0000 to FFFF!!! */
    0xA9DBADD9, 0x42158EE2, 0xA2BB18A8, 0x84442355, 0x98848032, 0x4152234D, 0xFE6425B6, 0x2424B6FB, 0x6429FA6E,
    0x5103AFE6, 0xABAAB6E1, 0x5945A74D, 0xC9352A12, 0xD9564FBE, 0x5210441D, 0xC29B571D, 0x91F1CAA8, 0xE98DA512,
    0xBB3DED75, 0x4AE0A430, 0x95CBB8D2, 0x575B81A2, 0x9B536EA1, 0x50853BAA, 0x792997B8, 0x5284E887, 0x2B44616C,
    0x56C255B7, 0x67E5D200, 0x5981471E, 0x19E9C2FA, 0xB60DA41B, 0x1368E2C5, 0xB2C484AC, 0x61171430, 0x8BB05D5D,
    0x45A19108, 0xDCDDA077, 0x4DA94CA0, 0x586BC088, 0x855DB51E, 0x8E028510, 0x25FE7A2E, 0x9765125A, 0xCDB0266F,
    0x6258976F, 0xE095C97C, 0xAB581F16, 0x55F933F3, 0x2ACEB622, 0x4F52F772, 0x39B2693B, 0x10B1F0AB, 0x8285566A,
    0x42206686, 0x885E4D05, 0x67821894, 0x250C2E7A, 0xB1769A0A, 0x2542C435, 0xA6DE50BB, 0x5A00442C, 0x1BE1A03C,
    0x944D9939, 0x04360608, 0x90B66345, 0x83B4562A, 0xB9024581, 0xC898A055, 0x90BF9470, 0xE146CF7A, 0xC201455D,
    0x39C2142C, 0x3AE15824, 0xF7055BC8, 0x54142E53, 0x2E9F829F, 0xEF2ADB91, 0x8ABA5D7B, 0xD0AD88FB, 0x65C71CFD,
    0x97E15685, 0x9189FD83, 0x0A989D8C, 0x6C8B3D8A, 0x4F624821, 0xA5E3C14C, 0x941C0B84, 0x82CA0549, 0xC212E876,
    0xAC570C79, 0x250BDEE0, 0xAD8001CC, 0x0B7222E4, 0x5642A9B7, 0x5A404B59, 0x189293B6, 0x4C1B05FB, 0x88B66C70,
    0xB52CAEF9, 0x4015C1EE, 0xDE7B53E4, 0x23A4E91A, 0xE2AC3D98, 0xEEEC2BA2, 0xC05D637B, 0xDC032886, 0xA92E0484,
    0xAB596016, 0x02EDB2F2, 0x57422B4A, 0x08E7BE52, 0x355F1487, 0xE0D5C814, 0x025E0E71, 0xA72E0D03, 0x03E96E05,
    0x6923A1D0, 0x71717568, 0xE0B8B12E, 0x50866CC6, 0x05708803, 0x43C8EA6A, 0x072F4C82, 0x17625648, 0x5A06D4CE,
    0x422205E8, 0x75F59204, 0x65453065, 0x67ACB250, 0x1B36ADDD, 0x4A0C6BAA, 0xB69F5F2E, 0xCAAEA429, 0xA5595172,
    0x1BA2E015, 0xD93229AB, 0x0002CE05, 0x34BBB1FC, 0x1A5DA78E, 0xC476CC30, 0xF10D56B9, 0x1A4E7012, 0xCCD2C158,
    0x1424E00A, 0x2AE94012, 0xEFA62E1E, 0x16842E4A, 0x6D176814, 0x4155A3AA, 0x115A0843, 0x4FD5172B, 0xB4A1904A,
    0xAEABC42B, 0x385272CE, 0xB140DA92, 0x11AC4211, 0x9055801E, 0xAC47AAC5, 0xC2B52706, 0x9D68317B, 0x557CC4AD,
    0x41C28F25, 0x570B25CB, 0x7050ABC7, 0x370AEE6D, 0xE7575897, 0x8C14863D, 0x40585D78, 0x8111288B, 0xD5C17491,
    0xA4DBC02D, 0x4421C00C, 0x8E7F2CA0, 0x46C2362E, 0xD706BB00, 0xAD012515, 0xDE705119, 0xA1A7F8D7, 0x64817D72,
    0xCA1CF216, 0x25CE2444, 0x603FBDEC, 0x99E41E1D, 0xAF70A28E, 0xA6C14172, 0x11383D55, 0x62C016E2, 0xEB4AE03A,
    0x569401A0, 0xA3841AE3, 0x7A49578D, 0x2B424B8C, 0x9ED8BAC9, 0x542849A2, 0x0472B2B8, 0x5841B833, 0x6A06CD70,
    0x7827C9E8, 0x46632716, 0xE532B458, 0x02E5499A, 0xB98B965F, 0xABB8A421, 0x66FEEC65, 0xACF3596A, 0x21F0472D,
    0xB98EC264, 0x7542B672, 0x38230E5A, 0xCAD51226, 0xE8A246C9, 0xEE22E44A, 0xE13AED40, 0xC1809282, 0x5A5DC276,
    0x164B0C60, 0x0289D486, 0x0100CB0E, 0x54D173D1, 0x56197CC0, 0x2E40C939, 0x0992F648, 0x2C5FF8A4, 0x43B60CB9,
    0x0E904EA8, 0xA485C23C, 0xF78B8550, 0x6D7AC219, 0xACBD3E2D, 0x2EB7683D, 0xD8FF58CA, 0x3D28630B, 0xF9C2B15B,
    0x61638BA5, 0x54240205, 0x00855AEB, 0xE040E29C, 0x0A7C4B92, 0x50B661D1, 0xA188CDB8, 0x125116AC, 0x9AA54D26,
    0xB61A6C27, 0x04DA422B, 0x6EAC5EEB, 0x17612AE3, 0x06C69AC9, 0x9098E599, 0x04237022, 0x0B9E421B, 0x55B4F6A6,
    0xAE8A5016, 0xEC9A2215, 0x1F2AC240, 0x46D60392, 0xF35E7995, 0xE2A9F9BC, 0xAC1A8F56, 0xDDABF719, 0x4DC0E0BE,
    0x6ECC842C, 0x93E09AB1, 0x58633631, 0xC8B482C6, 0xC56A3F8D, 0x1072BB89, 0x266D64A9, 0x57625761, 0x75C2C013,
    0xBB2084D2, 0x76859915, 0x1FCD35DE, 0xF5C373CE, 0xCD60A980, 0xAEC0D330, 0x111428B1, 0x2CEE5381, 0xE890515C,
    0xCA3B85F5, 0xC498A46B, 0x2607390F, 0x8317B0E6, 0xDB8A6E97, 0x45570B85, 0x36D81A49, 0xDA92F790, 0x549A04A2,
    0x51DC2910, 0xB82D90AE, 0x29AB8C0F, 0x823BCA88, 0xA0ACCE41, 0x01B28815, 0xD1170417, 0x8C566C8A, 0x4A06776C,
    0xAC1E99A9, 0x5A02E946, 0x8D545D85, 0x35DACA0A, 0xD90A861D, 0xA930C4A6, 0x6DE3038F, 0xC024A262, 0xCDDDA4CA,
    0x27324D20, 0xEAC9D2B0, 0xAA304E16, 0xEB9B6C94, 0x9EB4622F, 0xAD0F1A99, 0xE99A8B3F, 0xD616485C, 0x95C50397,
    0x4259D034, 0x4B521D6A, 0x7CB545E5, 0x15C53563, 0x3C8F0E02, 0x2BAC63FE, 0x5E015D93, 0x12F3CF79, 0xA980AE1F,
    0x9A1B1733, 0xBB15B194, 0x8893A02C, 0xEF5435A2, 0xB6C6B641, 0x92F3261D, 0xC9FEAD8B, 0xD01040DB, 0x317686F2,
    0x67202E56, 0x153864F8, 0xBE3FABF2, 0xF705CDA0, 0xC13892CB, 0xE634D142, 0x9A54ADA1, 0x0A15F177, 0xF834EB9E,
    0x39D8AE57, 0x82C1D40A, 0x09370F19, 0x3751638E, 0x0502AE2C, 0x6047F432, 0x1B0B6BAE, 0x232FF702, 0x9A15163A,
    0x3DBC828A, 0xD84D8691, 0x0D51560F, 0xEB91A202, 0x135E021A, 0x280B5AFA, 0xCD1D6265, 0xCA94B694, 0x0D432896,
    0xCA210A01, 0x7AEA3850, 0x8B73B24B, 0xA0DBB0C6, 0x7E57B657, 0x2EC0D456, 0x0CDCE4BB, 0x49473969, 0x7C16D710,
    0x9C2ED10F, 0xB132B5F9, 0x54AFCB08, 0x5582822C, 0x1E891483, 0x450E7025, 0xDE995C34, 0x341EE017, 0xD8B95B6C,
    0x81BE452A, 0xBC75765E, 0x0D703027, 0x85E2F175, 0xCF8344A4, 0x0137D929, 0x770B7073, 0x8EAC27D7, 0xC2B60097,
    0xCE05F295, 0xC022D65E, 0x0F0F8A10, 0x960445DB, 0x2C63AB28, 0x6F2F79C1, 0x82C45DCB, 0x174623A4, 0xE9D10E66,
    0xB0909690, 0x02BCC0DE, 0x4F9BAD61, 0x756C1A5E, 0xC14865A0, 0x64A0E346, 0x719A8AC9, 0x45CC4ADB, 0x821822F9,
    0x612AD972, 0x1B12C704, 0x8781410F, 0xF87B7210, 0x697BBA11, 0xD095808B, 0x3520975B, 0x91074FD6, 0x6A14A667,
    0xB3DACF36, 0xE5F57502, 0xAF805CA0, 0x07C51DB0, 0x3F561623, 0x98976BBD, 0x79B001A1, 0xA2901721, 0x187ED18E,
    0x7F85E14B, 0x906DF2B3, 0x58BCD12B, 0x93180099, 0x80AD7BB2, 0xEDD1A430, 0xC45A1FB0, 0x959DF976, 0xAE5320B7,
    0x46BF1735, 0xEB0DD729, 0x53CA2D0D, 0x0425693C, 0x5A9654DA, 0xE2194C91, 0xB6014C35, 0x234FA793, 0x7225768F,
    0x0159CAA6, 0x92EA4307, 0x2C5A0C4B, 0x04B8163D, 0x7C36581C, 0x10C42470, 0x8268D6C5, 0xABD4E847, 0xDA3A124C,
    0x1B0B1742, 0x6475A18D, 0x72C915E8, 0x12BB1188, 0x46629F84, 0x62B97B12, 0x2A070018, 0xD0F2E7C3, 0x05E20F53,
    0x484120CB, 0x9C4D751D, 0x7755DB16, 0x613135D4, 0x08D010CC, 0x2937957B, 0xE4768408, 0xDC224503, 0x4A5D7394,
    0xB8648F8A, 0xDB74DB29, 0x0B5CE41B, 0xD571C60C, 0x40B959D6, 0x10D0342A, 0x11089420, 0x97D0D7D7, 0x72D0280C,
    0xC13DDFA5, 0xE52980EB, 0x42315FEC, 0x779371DA, 0xF8C4BB0A, 0x5BB009AD, 0xBC556C40, 0x850E66EB, 0x428802CE,
    0xA95AADD5, 0xD6B82E6C, 0xA1B86530, 0x65F45649, 0x4D09420E, 0xCBA28425, 0x74857634, 0x22A14864, 0x3BED8869,
    0xAE1A5088, 0xE433E12D, 0x058E818C, 0x61362348, 0x46868FCE, 0x052B97FC, 0x29F43DAF, 0x8D0936BB, 0x8A5EF255,
    0x17220964, 0x6BADDCE1, 0x78ADC550, 0x08B8CD04, 0xCF9D6A5B, 0xA04B724A, 0x4972859A, 0x65B146AC, 0x942B288B,
    0x36926D89, 0xF8E9C9F1, 0x9264D497, 0xC2579D59, 0xC08B0015, 0xEED8423A, 0x1840D665, 0x550A1381, 0x6DC8C6BA,
    0x08D1F283, 0x334B2243, 0x2F57ACEE, 0xD5D804B6, 0xC73207C7, 0x51D27078, 0x3E706834, 0x9F0AE845, 0x3DD9E8C4,
    0xC6A2DBAB, 0x5B85B6B0, 0x4E81CD8F, 0x997B4506, 0xDF6DAE1C, 0xD8F9EB61, 0xF2ED5826, 0x026D00EA, 0x8AD58530,
    0xBB5C2EC5, 0x59557D20, 0x2292D12C, 0xF5D569F1, 0x187C2BCD, 0xA4B5FCA4, 0x28F85DC5, 0x327281EC, 0x952A0028,
    0xAEE7ABB0, 0xFA2D089A, 0x8540BA1B, 0x76DC1C32, 0x04CD6EC0, 0x09AC4639, 0x86ED761C, 0xDA596843, 0x00F0FA2B,
    0x275AF3C0, 0xE2C95002, 0xAD5BE2E9, 0xA4252D4C, 0xBB6461D7, 0xA098C24B, 0x60C75B80, 0x13414471, 0x66591242,
    0xB403B206, 0xF9041E14, 0x4E20A1C2, 0xAC809A53, 0x285D2ED9, 0xD949C273, 0x2C7735BB, 0xDC255831, 0x73454C86,
    0x214B2D6D, 0xD953DE35, 0x27513112, 0xECE7C8B5, 0x28B33491, 0xC1B0BA49, 0x572532AB, 0x540BA613, 0x4AB6D8F7,
    0x53AB5098, 0x23B1B11E, 0x8A2F5C1F, 0xB8F58D3C, 0x692F6389, 0xDD014A0A, 0x380F022B, 0x2569C830, 0x2DDB2669,
    0x4BBF4281, 0x3BC34A84, 0x449FCDAD, 0x14006B75, 0xEE4F4B2A, 0x4A77516A, 0x15B16F1E, 0x116E293C, 0xBD30907D,
    0x859C65A4, 0x5C9C885F, 0x430145D5, 0x2A6A2A6B, 0x04AD3114, 0x04ABC5AA, 0x4D0CA883, 0x23801037, 0x602C7C97,
    0x519A506F, 0x447D0B07, 0x0549C94A, 0x026939FC, 0x02B88195, 0xD8CD031A, 0x3DA8B5B8, 0x214220FA, 0x1B097D74,
    0xC35A0842, 0x8483FD72, 0x4D53BFC4, 0x50320A0F, 0x3D701303, 0xF2B3412E, 0x501B8368, 0x4E174842, 0xEAA12F12,
    0xC921244D, 0xE2EC3CDC, 0x883AD75F, 0xA463E5D1, 0x1B7704E4, 0x8D2495CC, 0x285D2529, 0xE50D5665, 0xD84D5A69,
    0xBB57E915, 0xC6580814, 0x373E1403, 0xCC6AE5B9, 0x0D72C82D, 0x5628846D, 0xD8F8B936, 0x0488E895, 0x6CBD5B75,
    0x3025C778, 0xB79E5ED0, 0x85B5DC32, 0x8A9AE096, 0xBF2DCB95, 0xCD358BB5, 0xD876A5B8, 0x1EC4EB84, 0x2C845CD0,
    0x03A11000, 0xF5F5CB18, 0xB7B88C00, 0xEA6B8111, 0xEE44855C, 0x24D5D846, 0x741D6EA5, 0x1292F76B, 0x8A3AED70,
    0x13352248, 0xA633C478, 0x8531A655, 0xE2D57A18, 0x1E31A403, 0x51C4F1C8, 0x2812BA07, 0x29C5D908, 0x1C5DE2F7,
    0xB3A44486, 0xC55E0C55, 0x2541AA68, 0x6EE5C21D, 0xCCD02311, 0xC76B4719, 0xC1440483, 0x1CE00744, 0x498EE497,
    0x3994334E, 0x161480EB, 0x177D9F20, 0x5094209D, 0x02636417, 0x5EF1AAF9, 0xD5126725, 0x5C45C733, 0x49D95B75,
    0x8762E12B, 0x416DD610, 0x856C6524, 0xB0AA6292, 0x0088B6B4, 0x6699098D, 0x715A312E, 0xC0E0F00A, 0xEDD8AE70,
    0x385C1EF4, 0xA85D5950, 0xC81BC55A, 0xC5D5125C, 0xBB27BB5D, 0x57109073, 0x120C0461, 0x30D8177A, 0xE8BA86F2,
    0x9B20032F, 0x9A1D76C1, 0x95C74E98, 0x8F640BC6, 0x5E83640A, 0x15ECC569, 0x2E145CB9, 0x41EBD36C, 0xBDD9084B,
    0x4221B1F8, 0x33E421FA, 0x399ADFCD, 0x0AD92D29, 0x0A0E1727, 0x01B5FB64, 0x2F26919B, 0x185DF31B, 0x0C1EFF05,
    0xCBC72055, 0x3068ED37, 0x77B0E494, 0x4803D9A0, 0xAEAD068B, 0xA50CC252, 0xE4986E22, 0x5F082135, 0x365AED76,
    0x17D75C2E, 0x81A4BEE0, 0x0DCA81CA, 0xC635CE5E, 0xFF5D98D6, 0x191370C8, 0xBD910670, 0x216132D0, 0x690A072C,
    0x44D0EBB5, 0xF648155B, 0x4AAEE0C2, 0xEB3C247C, 0xF77C0F59, 0xE2D09439, 0x9509705A, 0x5772E574, 0x33E0ED70,
    0x64E52010, 0x7B70F4BB, 0x0A46A396, 0x583BE35B, 0x20871711, 0xCC196B81, 0xA44353AF, 0xB3B296C9, 0x70B69EAB,
    0x51BD0F94, 0x8B39CA86, 0xA90A222B, 0xA8E56DAA, 0x6C252742, 0x2D221080, 0x2680862E, 0xC0F285D9, 0x7AB6A685,
    0x09D05450, 0x406D7EBE, 0x84442C10, 0x8383F0BB, 0x284409E5, 0x10C4619E, 0x551C4F12, 0xBE22CE17, 0x8C006290,
    0x7F954439, 0x7598A165, 0x87B16508, 0xAD0B3341, 0xEE7C484C, 0x0D38333C, 0xA3298383, 0xA2EECADA, 0xCD3108F4,
    0x2BCB6E20, 0x18FB0458, 0x8E04D2B0, 0x699BB0E2, 0xB6CDBBD4, 0xC472B47A, 0x397D0A18, 0x421775CB, 0xE34408B5,
    0x0558EEA5, 0x602BF1BC, 0xB994174F, 0x74137226, 0xB0534222, 0x2C16A332, 0xB55E869B, 0x528DF2D3, 0xFA120EB4,
    0xC295D462, 0x934B75BC, 0x459B60CB, 0x04628424, 0xBA800748, 0x40900A01, 0xB2DCAA07, 0xDA584CDB, 0xA1BA5F89,
    0x568E6DA3, 0x9823090C, 0x8E8B1A01, 0x489A7274, 0xD2423D98, 0xD2E0D5C4, 0x05401125, 0xB180B6C5, 0x8586AE2E,
    0xB05B2974, 0x4BA03D46, 0xC4875290, 0x983B342D, 0x1A113FAC, 0x98A8164A, 0x11239764, 0xC0009325, 0x98E86375,
    0xAF5C2144, 0xB56C1C2E, 0x022C5D6B, 0x96CAEC24, 0xE78B0000
};


/*
**  This Table is for GBK!!
**  Each Hz have 9Bits(0~512) to indicates Yinjie Code.
**  This Table was seperated to 2 party: [0x8140 ~ 0xA0FE], [0xAA40 ~ 0xFEFE].
**  Both part include 0x??7F
*/
JUINT GBKHZCODETOYJ[] = {
    /*
    **  [0x8140 ~ 0xA0FE] (0xA0 - 0x81 + 1) * (0xFE - 0x40 + 1) = 32 * 191
    */
    0x4B4C2BDF, 0xF650C26C, 0x4884AC2E, 0xA0746A11, 0x126C1467, 0x8E23B2EF, 0xFC035C46, 0xFFDE27C1, 0x6DC6AC5F,
    0x46FFFFE4, 0xA9B7FFFF, 0xFFFFFFFF, 0xFFFB4DB3, 0xFFFF6A18, 0x3FFFF11F, 0xFD766E30, 0x2ED67704, 0x83026DFF,
    0xB3C96546, 0x628400A0, 0x39B7D811, 0x76FBA8A1, 0x5E4F63A1, 0x3FF57028, 0x48B744FF, 0xD7C4C7A3, 0x004C5429,
    0x98448AA2, 0xA45D6CB6, 0x590C55C8, 0x5957A59C, 0x8A4EAE5C, 0x1665500A, 0x29EE3B2E, 0xB9C47791, 0x5C0AD563,
    0xBFD7DCED, 0xDB159F2D, 0x0A063DEE, 0x1361764C, 0xC0C1CB85, 0x2020D988, 0x7ADA2806, 0xD7E15360, 0x49F8C760,
    0x281519C1, 0x23C20CDD, 0x0B0F5926, 0x9532FA9A, 0xE06DB8B2, 0x6CE025C9, 0x4D7A2617, 0x5AB2D171, 0x24947540,
    0x71A29182, 0xD1662860, 0xBA4712A9, 0x934A884D, 0xAD61A8DD, 0xABB3836A, 0x76B9702E, 0xAA1048B8, 0x147DE95D,
    0x2ED7ACC4, 0x215E514D, 0x2541D850, 0xC0F1895E, 0xD60ABB58, 0xC5C29CA0, 0x491B6E11, 0xABAACA60, 0xC613FE63,
    0xA4CE18E3, 0xB1B591ED, 0x003022E5, 0x4892B653, 0x08BD932B, 0x10449C18, 0x2EB88E6A, 0x8590D6B9, 0x6C16E42D,
    0x4345C5E3, 0x7AC5D825, 0x48B61647, 0x95B280AE, 0x6A942109, 0x81562405, 0xBB1A30B6, 0x5D6CF8B0, 0xF1741B94,
    0x65212E16, 0x2B505898, 0x1AC95381, 0x57C44942, 0x4F259457, 0xAEF1573D, 0xE4D0C022, 0x50CEA89A, 0xECBD0C90,
    0x0C0C63E0, 0xAB0C56DD, 0x40965B4A, 0x81242DEC, 0xD215558B, 0xC3384064, 0xF06976C6, 0x40260354, 0x59CF1D07,
    0xB610A50B, 0x50503D14, 0xAF58B0A0, 0x55F53DC8, 0x939A97A2, 0x11951110, 0x51522936, 0xC005A282, 0x82102681,
    0x1A218508, 0x82C57D1C, 0x505984CD, 0x35FAFB36, 0xDE8A42C1, 0x0B39600C, 0x7AE09172, 0x8A2E03C4, 0xFFFD0C31,
    0x444B6F61, 0x70880A82, 0x3013A9C0, 0x28A81322, 0xB8E38437, 0x452A55D2, 0x84124207, 0xDF32925B, 0xA9D5162C,
    0x56D1EB0B, 0x7188A21F, 0x3840AB57, 0xD7C760A6, 0xD8AB6BDF, 0x2CA4D268, 0xA0525329, 0xA2AD936F, 0xFFFFFFFF,
    0x9A12BFFF, 0xF4055DA8, 0xB09C1CE9, 0x3FF425C1, 0x883BB631, 0x0348C352, 0x31899634, 0x59EE3FFB, 0x83266CC8,
    0x47273FE5, 0xDB132682, 0x613E3C4B, 0xACD80A1A, 0x4EC6A79A, 0x51707249, 0x82E20156, 0x8619D9D1, 0x1C949E8A,
    0x59D74945, 0x52AA3863, 0x932CB4B2, 0x8592CA4C, 0xC0FC4F9C, 0xE2435424, 0x0848841D, 0xD5920AD2, 0xEC288ACD,
    0x5A654208, 0x944CBC50, 0x661AA889, 0xE5344879, 0x164A5F5F, 0xEEE254B8, 0x986A2556, 0x95C5100F, 0xF8D70661,
    0x048B9784, 0xB43212D8, 0x8325932B, 0x86A9AA18, 0x72011A8D, 0x0515046A, 0xB5ED2F4E, 0x1A8FB8BC, 0xBABD1CB5,
    0x370A8DC8, 0x64350D08, 0x86436505, 0x18764AB7, 0x2F6B4526, 0x96594B86, 0x5DA0A947, 0xA70D354B, 0x0B454289,
    0x5925D146, 0x2668B951, 0x744BA3E0, 0xEB90A09D, 0x26CA24D9, 0xD8970B55, 0x6A6AA95C, 0xBE66C844, 0x38AA1760,
    0xB8220AA8, 0xF24A3876, 0xC1B55A97, 0x4AD15C3E, 0x16914682, 0x7FE0D2F9, 0x7EE0F647, 0x510C6503, 0x38E51A67,
    0x6C236E08, 0x74A9F214, 0x55828614, 0x27CBB1B9, 0x023B372B, 0xD5F2925A, 0x35215D01, 0x5B0D16A6, 0xF0866D5D,
    0xAB55AC42, 0x8172E8D9, 0x5DB12240, 0x708988BA, 0x50885121, 0x0A15D8FD, 0x631802B5, 0x90B17FF5, 0xBFFE0B6B,
    0x9B30E913, 0x2A6620AE, 0x1ABBAB48, 0x88A021BA, 0xD6AD14A9, 0xD4D6CB65, 0xDCCEB384, 0xC2BFEAB2, 0x5A042E17,
    0x0B804753, 0x73581638, 0xAD56A164, 0xE84AC468, 0x3E6A848B, 0xBFE7A663, 0x0E4C8412, 0x5BDDC83A, 0xE8C20C63,
    0x0A140F55, 0xC6A0E094, 0x7A312457, 0x46363402, 0xB888BC8B, 0xA6B49AC8, 0x066C8F7A, 0xB357F0E2, 0x14DB2C2B,
    0x175C05CF, 0xC0F1A05C, 0x751CA48C, 0x1537F034, 0xBB6D3B1C, 0x87354FF8, 0x52815F41, 0xC00A6502, 0x345E7161,
    0x4F1AA880, 0x2B41A953, 0x4D3D5D47, 0xEDEB27FC, 0xEB775BFF, 0xD87863B5, 0x7D520554, 0x01598B29, 0x5174E73F,
    0xBA9A4D20, 0x639DC10B, 0x4F1DD595, 0xB0915DF8, 0xA04A8010, 0xA0DFF33F, 0xFFFEB054, 0x4B7FFFFA, 0xC22A0053,
    0x81809124, 0x4BB5254D, 0x5D00B9B1, 0xE422805A, 0x0751AE56, 0x48C69804, 0x0077540F, 0x03446762, 0x840320B0,
    0xAFC1CD57, 0xF382FBFE, 0x42480A3F, 0xF43010EE, 0xED90CB09, 0xEAB76BD5, 0xB9947CBC, 0x9FCEC841, 0x7D605767,
    0x4013DC2B, 0x0BB4805C, 0x88B60A01, 0x617B9D62, 0xE5FF057F, 0xE0869A45, 0xB8EC2D91, 0x5D0CF626, 0x0098E517,
    0x34A10115, 0xC8160D53, 0x54FFCB3F, 0xF1EFFB52, 0x060D022B, 0xE5590685, 0x09102F1E, 0x98E84170, 0x0D857009,
    0x3E204E0E, 0xEAFDFC52, 0xFD1D300F, 0x85EA198E, 0x3C88171F, 0x5830E150, 0xB9087EB0, 0x9D4BB041, 0x88A0776A,
    0x28624262, 0xE4085C6A, 0x211DDD94, 0x95D801D5, 0x5F3640DC, 0x6D4E192D, 0xB2E4391D, 0xFFC96D74, 0x0D885D77,
    0x00DD0D77, 0x62C0F4F0, 0x4E1E58DE, 0xF71C438C, 0x8473A020, 0xCED6F27B, 0xDC608445, 0x0A6D4C5A, 0x42E50209,
    0xBAB86E27, 0xC629EB20, 0xAD5A9C9A, 0xED0B62B5, 0x72B7680E, 0xC58FB7BD, 0x818B5D27, 0xA76D828B, 0x97FD4B40,
    0x020E0FFF, 0xFCD38408, 0x15568A04, 0xEADB82F8, 0x2F28FFE0, 0x50C50CBA, 0x9DC3FF5B, 0x206E2E2A, 0x8256EE8C,
    0x7C5E46A8, 0x1281C29B, 0x4F384362, 0x870A09C2, 0xE27F39AF, 0x4E034AC5, 0xDD1E9D7F, 0xDDEEF6BA, 0x853E9E28,
    0x5E206E0B, 0xB5DDAE9F, 0x4C7FAE53, 0xE8EBB40A, 0x059E1E40, 0x6BD2F70B, 0x410B94B5, 0x5C20C584, 0xD548B00D,
    0x45909168, 0x41722C0F, 0x4347650D, 0x541465B4, 0xB6B9849A, 0x2D2055A6, 0x5CBA7CFF, 0xE50083A7, 0x9B350876,
    0x5D0785D7, 0x13D9371E, 0x5D36DB89, 0xE6E135B6, 0xC537091E, 0x872921E1, 0xD00564AF, 0x820B805B, 0x85C40567,
    0x1B418184, 0x2485D122, 0x85212A11, 0xE8AC82C8, 0xFA14465B, 0xC845047C, 0xA20F5647, 0x2F45A9B1, 0x79268416,
    0x18821284, 0xF9B6509B, 0x004701D2, 0xEA36EA18, 0xC376281A, 0x55856B5A, 0x8C05346C, 0x53C5A7F0, 0x6ABCE19A,
    0x04DD9888, 0x976004CD, 0x84BB200A, 0x16E04879, 0x8C29A9BF, 0x8B39544A, 0x28F2611A, 0x219F8AB4, 0x3A009956,
    0xB4575089, 0xFB95D127, 0x289B326B, 0x42D25C13, 0x2AAD7B02, 0x2FA4D165, 0x73276AC9, 0x004CF6C4, 0xA566C4B5,
    0x392A052F, 0x6060B172, 0xB9772198, 0xCD0A84F1, 0x700F0D10, 0xB1C94220, 0xB329FF42, 0x1C2068A2, 0x108ED940,
    0xC140AB19, 0xC820A25E, 0x057FA7C9, 0x25582138, 0x48429A93, 0xC9F4220B, 0x48B080A1, 0x0E6DF974, 0x30120604,
    0x4CD3DEE4, 0x443DBC26, 0x3B53A38F, 0xC3C87C0A, 0xD4A7AE80, 0x6D63D8CA, 0x2956A15C, 0xDB285583, 0xF2DD6F1A,
    0x56ACC516, 0xAB62AC0B, 0x568FE6EE, 0x0C1CBE6C, 0xF8A33E59, 0xD4737619, 0x3A6F7034, 0xA1CB38C0, 0x74AA1AB4,
    0x12D96C4D, 0x842D5988, 0x2B83FFCD, 0x10064320, 0x597F3598, 0x81741A20, 0x37FF7942, 0x814A2427, 0x9A3D6444,
    0xB69FD262, 0xE05A00AE, 0x45B50300, 0x95A38D70, 0x08875793, 0x6F2879B1, 0x61060D5D, 0x8AC8F024, 0x6BA44D5F,
    0x2AA10F43, 0xB2EA2CE3, 0x59CABBCE, 0x995BC970, 0x5C90CDDB, 0x1A9632C1, 0x67FF5625, 0x8173D8F6, 0xADDE9D5F,
    0xB8141A00, 0xD9A140ED, 0x672A64D9, 0xA072EAD3, 0x070E78DB, 0x5841E474, 0x4892842F, 0xD80FA8F3, 0x42190CDE,
    0xCA64ABE7, 0x936A44F9, 0x6C672C9E, 0x850BADB2, 0x68843742, 0xE4C7A1DC, 0xC45B6261, 0x975A4971, 0xC0E29364,
    0x6B5D81AD, 0xACA1CF36, 0xFCA8D7EB, 0x96CAE006, 0xD97692AB, 0x51D3D805, 0x7F3C495C, 0x804A0B86, 0x507C288E,
    0x0B2D2C33, 0x880204AB, 0x5B6D508A, 0xE57A4B76, 0x168B45A2, 0x889643E1, 0xB14D7118, 0x0E0BABD0, 0x120AE36B,
    0x472B4895, 0xF3E9F479, 0x6E6B0E10, 0xB4EBB560, 0x8516630E, 0xDB70640D, 0x6E043765, 0x975124C7, 0xA65500CA,
    0x015CAD08, 0x9AC64E13, 0x36B113D5, 0xEC487495, 0xF158AA08, 0x4F88904F, 0xFECF4E37, 0x0C6DD778, 0xAC5D6AC6,
    0x78811803, 0x08364AEE, 0x898AB22C, 0x92870510, 0x10A86C02, 0x5EF704E5, 0xA185704A, 0xDD1BA6E4, 0x55403473,
    0x54E40F87, 0xC0236D80, 0xFA34D711, 0x04FC6B2E, 0xBF5F682C, 0x55E7D371, 0x072967B8, 0x1F6BAA28, 0x85B05088,
    0x63154AA8, 0xAB81DD10, 0x559B4AA0, 0x6AF8458D, 0xC049B805, 0xC02DF71B, 0x008A3045, 0x07AECFB8, 0xAB98A76C,
    0xA0DC82F7, 0x86503669, 0x646E92D6, 0xB7753DB1, 0x68886FA9, 0xE05729E2, 0x04FEC956, 0xABED8385, 0x3A418134,
    0x92D06EAD, 0xD95B143F, 0x02B5B770, 0x6AD3E84D, 0xAAE1B92E, 0xE2A9B42C, 0x5ADD7045, 0xE772E7A9, 0xB5C29536,
    0x16A30CF6, 0x1C58F5E2, 0x8064A702, 0xD7CBBC1C, 0xED924338, 0xC247FFFC, 0x1A6CE345, 0x38E93760, 0x4A81C68E,
    0x831F26CE, 0x378D62C4, 0xA040A46E, 0x17004C18, 0x5E092CAF, 0x09AFDCD0, 0x512E879D, 0xD8E704D1, 0xEA10A653,
    0x9C0A580B, 0x1AFD7D47, 0x5758B0EA, 0xF57ABDB8, 0x9EA2CA98, 0x0D351301, 0x82BA0D44, 0xD248B36C, 0x9589BB5D,
    0xFFB0970F, 0xCA415C5C, 0xBA0ED891, 0xC9058A42, 0x715D4255, 0x2BEAD280, 0xF5027A89, 0x57005341, 0x8FFEF007,
    0xB700EB88, 0x92809AAD, 0x02802271, 0x58AB6A38, 0xC3697EAB, 0x6948E2ED, 0x4DEE0450, 0xC29FB4A5, 0xA0B9F9FF,
    0x04536D20, 0xE3B0157C, 0x502E9197, 0x2512997E, 0x1770694D, 0x805583FB, 0x255A8424, 0xD62EA695, 0x95B91050,
    0xB10521A5, 0x96C2B6EB, 0x5F8A8F66, 0x82DA7998, 0xC55EB8D7, 0x151FF4A5, 0x7E182FA0, 0x2CCFA8E5, 0x333546A3,
    0x119A6D60, 0x85EAF568, 0x4FC9DC49, 0x273C9D60, 0x1A8911A4, 0x09371C1D, 0xFD01761E, 0x166136DA, 0x45C32846,
    0x2865D28B, 0xAB6318E6, 0x843FD318, 0x976C229D, 0x12E1B656, 0x30826952, 0x5E0D00A7, 0x936BB5A0, 0xC0F22A89,
    0x00AD6B89, 0x60611205, 0x747087A6, 0xD1C93611, 0x0E884A8A, 0x0841723D, 0x3D702814, 0x010330A8, 0x188F103D,
    0x1ED76ECF, 0x45BD803A, 0x1383222D, 0x8A9C6AC5, 0x628A27E2, 0x5106EB72, 0x22DC9097, 0xDC2D2D8B, 0x7DBEE0E1,
    0xAFA11129, 0x73710809, 0x88AC4547, 0xAB444DDA, 0xF1718BA2, 0x55A6E5BA, 0xDCF55D47, 0x0A2E4A2B, 0x6362162A,
    0x112EC884, 0x470DB2D9, 0x6C515B0F, 0xE80458A9, 0x65FF7FBF, 0xFFF09CA6, 0x3EE08A95, 0xC2FFE5DB, 0xD11DC258,
    0x77E50F83, 0xB1D34026, 0xD0B85C1F, 0x90147C5E, 0x753D8264, 0xA6D0D1D1, 0xB9F98E43, 0x55875054, 0x212CF793,
    0xB3D61260, 0x87E118CE, 0xF1A23250, 0xB4740E56, 0x080F3806, 0x9A408458, 0xA3287C06, 0x8371CC98, 0x20A0B0C8,
    0x040C1983, 0x144D7D4E, 0x86091810, 0x94CBF9B5, 0x8B06275A, 0xC0C89CDD, 0xAC3D4DB8, 0x6529594B, 0x0D3CDC9D,
    0x61DD4281, 0x216A984B, 0x269C41EE, 0xCCB9386A, 0xC0574694, 0x0DCB596C, 0x9F281483, 0xA351AB8B, 0x88E97370,
    0x18D3E4B0, 0x2658A6B8, 0x5436FFD3, 0xE0D81A9D, 0x62B9425C, 0xABF4CBA2, 0xB6993E21, 0x3F502D54, 0x09611CD6,
    0xBEDC0A71, 0xF29CD884, 0x7CAE1090, 0xE059A242, 0x885D217F, 0xC5592B82, 0x3E636845, 0x9171C874, 0x3BD81B32,
    0x1DA18C65, 0x406A710C, 0x10B08ECE, 0x0873D324, 0xE1564821, 0x1728140D, 0xC2E170BC, 0x5E2B36CB, 0xB0B88B74,
    0x658B8275, 0x342656AE, 0x425A176A, 0xF5DAA0B7, 0x288B0FE5, 0x03FFF426, 0x503F9653, 0x58912869, 0xB2141C5D,
    0xAC022BB9, 0x3078B87C, 0x2D080BC5, 0x76E40B19, 0x6F0F04A3, 0x95512239, 0x7E246080, 0x4D96455B, 0x9336B35C,
    0x425750B5, 0x60FCE200, 0x23A093A0, 0x482B2A86, 0xBE74475C, 0x012C77A2, 0x380ED8A5, 0x9A442302, 0x111AEA5D,
    0xAE836DD6, 0x80F84901, 0x6706CE2B, 0xB42BA343, 0xFF36AEAA, 0x4CCA168E, 0x52C54A23, 0x1D4DD004, 0x4494F909,
    0x408BAE16, 0x535ACC5D, 0x3085DE1E, 0xC3E40D85, 0x8774FFA3, 0xC1B789C5, 0x3D139059, 0x9D60B480, 0xA40ABAC2,
    0xB81E45B5, 0xC56AA03F, 0x7056B60A, 0x15C0F8F8, 0x52C7569B, 0x0D9004DD, 0x257B5D4A, 0x1BDBA4E3, 0x8636AC8A,
    0x4229ECE7, 0x6478EE90, 0xE11B20AC, 0x6508D611, 0x0D741F36, 0x2F2461BC, 0x20340E41, 0x6126C0AB, 0x4560C758,
    0x06DA0FEC, 0xABA1D879, 0x71163112, 0xE9700C16, 0xD8ECC247, 0xAE50C33D, 0xE64500B7, 0x49900843, 0x4A386ADD,
    0xB124F277, 0x40CDAA68, 0x1349D750, 0x574B6AB4, 0x3344B88C, 0x68359671, 0x9C32F969, 0x1C05C170, 0xB85C46CD,
    0xC7534093, 0xC36432FC, 0x8D57BBA4, 0xC8AB8AEA, 0x61506140, 0xA6503176, 0x41708F80, 0x402ECFC5, 0x887EEA2F,
    0xCA5345B0, 0x0853D815, 0x08440B95, 0xEFC51204, 0x5BFFB1DC, 0x6BB5D145, 0x089E4D94, 0x24034882, 0xA96152A9,
    0xAFB35635, 0xC0BA4043, 0x5FA14D5E, 0xF70AFB5C, 0x774245C9, 0x909583FC, 0x1A0C8E0C, 0xA66E5705, 0x9C89227E,
    0x00DB1495, 0xE175DAE2, 0x3A640059, 0x04D42341, 0x4EC71865, 0x1D831B68, 0x4F28A150, 0xDD4BAB56, 0x60B50228,
    0x531FAD10, 0xF142111C, 0x6C992BDA, 0xCC9A1A40, 0xC261BC18, 0xC2E49230, 0x590B9451, 0x6346A634, 0x35DAD87C,
    0xC69F0F90, 0xA3E1F0A1, 0x36A43108, 0x88CB85C2, 0xD9090B15, 0x62F7BC71, 0x0AB89D30, 0x4D04C2E3, 0x1D708112,
    0x134090B7, 0x60257600, 0x94205B14, 0x20E34564, 0xD378830E, 0xF2779AB3, 0x51FC5D02, 0x812FF790, 0x9631AC05,
    0xA264B176, 0xD3B37664, 0x2E7A2158, 0xD0A18A17, 0xFF8B79B5, 0x2042E031, 0x091CA480, 0xC08F0E23, 0x38905D62,
    0x0D2040C4, 0x63693C9E, 0xE5C918D1, 0x0496A2CB, 0x16B92324, 0x1648EB5D, 0x7EED3D09, 0x99A902D9, 0x6A698CE5,
    0x470210D2, 0xF5F2144C, 0x59442345, 0xC262EDFE, 0x716F4855, 0x82989B7E, 0x3173279E, 0x822B1568, 0x34C99AC7,
    0x0A0F57C8, 0xFBC49859, 0x4F05C444, 0x35B800B6, 0x42BD8398, 0x48482804, 0xE204B4B5, 0xE4D606A6, 0xAA0E5E47,
    0x0B04A903, 0x04CBBD12, 0xCE333224, 0x2F676219, 0x348D435B, 0x1AC7A15D, 0x602CE19B, 0x49B256A4, 0x003ADA7F,
    0xB65F11C9, 0x7421094A, 0xA5162369, 0xE81328BE, 0xBE854309, 0x8156EAC7, 0xFEB38432, 0x9A20D154, 0x18C2572B,
    0x6B820A16, 0xE1EE51CC, 0xA584D7D1, 0x4CC287FC, 0x6D2F1CA2, 0x40EADA21, 0xF1AB543E, 0xD645B34C, 0x9141D90B,
    0xC5D71C29, 0x58AC7451, 0x2C468BC6, 0xA702C908, 0x4D26578B, 0x45C6C5CA, 0xE3085F18, 0xE2C5B433, 0xEB550E6E,
    0xB9013282, 0xB6105D38, 0x2E64D405, 0x4284D03D, 0x0F6E3440, 0x90810549, 0x3ABF1937, 0x40AE15F1, 0x6B60F46D,
    0x1CB79662, 0xD40A2108, 0x191D8A02, 0x62B4849C, 0x165DCF54, 0xC2906271, 0xF5114042, 0x56D0D746, 0xBAE73D70,
    0x0A0E1083, 0xC9122D12, 0x9F1DD890, 0xA04475BC, 0xA0C864A1, 0x2823053A, 0x3ADEE6B7, 0xDBDBA7C4, 0x4845C663,
    0xCA224DAC, 0x9435894B, 0x420349D7, 0x2AD88522, 0xDAAB0AAE, 0x444DEAFA, 0x455AA53F, 0xDC972B78, 0x140A04A7,
    0x435C98C2, 0x8B908AC4, 0xE15F3199, 0x22EFF889, 0x5ED65691, 0x2A83C442, 0x9D5A6E37, 0x212D496B, 0x81800EFD,
    0x22270B0D, 0x13B06862, 0x63B3A205, 0x99227DD8, 0x0D6727B8, 0x4884FB82, 0x5D1084A7, 0x5849F6DA, 0xF3340201,
    0x2164A70B, 0x177596E0, 0x8897A232, 0xE4B57835, 0x5B61B0DA, 0x60100486, 0x33FE07BB, 0x29EB1354, 0x2A16EC88,
    0xA512AE30, 0x3856373D, 0x9ECF2296, 0x79E18933, 0x2E283A3D, 0x16BFF800, 0x356A5D2B, 0x22F1F709, 0x8A1BFF94,
    0x2ABE4AB8, 0xD4FCAAEC, 0x844220EC, 0x54AA090A, 0xCE28B6CD, 0x99ACDA90, 0xDEB80A03, 0xA266A7C2, 0xB1BAD058,
    0x831F2D97, 0xF2B4D11D, 0x6D095A1E, 0x9925A1D5, 0xA00EB2A0, 0xB09362B9, 0x1BFE4900, 0x84806B75, 0x0D2A6C80,
    0xB42893C8, 0x8456529A, 0x7A2FD80E, 0x7FF48D7D, 0x4796AECD, 0x72190399, 0xD6AD49CF, 0x6232D2F6, 0xED749793,
    0xB800AACB, 0x314D5EC2, 0x57335C2F, 0x281B3B36, 0xDF7225D6, 0x20EC46B2, 0x1ADA37B7, 0x4B1FE884, 0x998AB429,
    0x801D6D8A, 0xD4231EF9, 0x623AB403, 0xEDDC7204, 0xE7681A2C, 0x6848B7D2, 0xCEBB7042, 0x200756FB, 0x7AB6854D,
    0xB095E698, 0xF3ADC25F, 0x6497A201, 0x28BB6006, 0xDF17642B, 0x458A1237, 0xFEDC835D, 0x4556EBE5, 0xDCBA876C,
    0xCBDE2E07, 0xC9C0666B, 0x820BD9D0, 0x37182961, 0xEE075A15, 0xFFEE8A52, 0xA11ECE40, 0x54A0172C, 0x255C6AA8,
    0x54ADDF73, 0x8FFC480A, 0x4F1EAB4D, 0xC8D068B4, 0x3D178157, 0x2B96A2AE, 0x0CA75321, 0x30C5D702, 0xF99EA687,
    0x97D591AC, 0x392DDC14, 0x49810DFF, 0xE4D3ED8C, 0x60309356, 0xD1484620, 0x340658B8, 0x175AC7CB, 0x592AC76E,
    0x2863EF38, 0x89A90973, 0x266B57C3, 0xD5D35825, 0xA162B7DB, 0xE6CE1069, 0x3C5CA53B, 0x01CAB951, 0xD07ADA5D,
    0x9C4C64D3, 0x46B5D08D, 0x8B1D9A42, 0x8042E814, 0x9E0D0D49, 0x72E0A2B9, 0xAC4D6E46, 0xAD58CAD8, 0xADFBFF74,
    0x85C03257, 0x0B06495A, 0x1E4A04A2, 0x4068904B, 0x0630B807, 0x90D88299, 0x4EEA5433, 0xE355B71B, 0x84D8BB17,
    0xA4276112, 0x0B493C6C, 0xD1BD7FEE, 0x4895AE36, 0xD51D1602, 0xA98A4458, 0x4C171AAE, 0xAA16A598, 0x05652260,
    0x94426EAB, 0x77B66C84, 0x8F135F80, 0x80D211CF, 0x29120521, 0x8FF56762, 0x169484B0, 0xAE9041C2, 0xC49A004A,
    0x835C91C8, 0x2CF0A2B0, 0x8B56FFC2, 0x55E2DD13, 0x28A657C6, 0x95B00092, 0xF43F0280, 0x058503E2, 0xB8281082,
    0x14DF95B7, 0x6BB1A4DE, 0x4930D5C4, 0xA55168B2, 0x0177B65D, 0x91F70894, 0x033C5D53, 0x49F0A581, 0x641DBB56,
    0x5C9D5123, 0x0472385A, 0x234D9401, 0x59EC1845, 0xEC47188A, 0x58E7D431, 0xBABA3D37, 0x113290BF, 0xF974CCF6,
    0x97DC2684, 0xF2EA06B0, 0x85C21CEE, 0x0FDB5DB1, 0x0D763B56, 0xDF00DB71, 0xC2CF1CB6, 0xA96D80B4, 0x0A8912A2,
    0x92956A68, 0x469310F8, 0x7CA65DAE, 0xA1FB45B7, 0x24F82322, 0x6DE37BB5, 0x618C4242, 0x2262C805, 0x542EC136,
    0xA1566683, 0x17BA16E0, 0x2809BB19, 0x26943502, 0xDD2DBBE0, 0xD9D2842D, 0xB9128030, 0x40981778, 0xACDB2959,
    0xA6456878, 0xC92CD52F, 0x5DFF9A60, 0x06295BC6, 0x88631B91, 0x1CC84340, 0xB55EC618, 0x9873D538, 0x25B48885,
    0xCA0F56F2, 0x0231B95E, 0x81BA408E, 0x05F2FC2C, 0xFB2311BD, 0x854873E1, 0xFCDCE1B8, 0x1892A6E3, 0x7308842F,
    0x552A0581, 0xF1759A0F, 0x3CA69B2F, 0xF2855AE5, 0x60C95C0A, 0xA5097079, 0x2D1B90C5, 0x92D50D2B, 0x6D29ED97,
    0x96C2D0C1, 0xF425B2D2, 0x53B55C31, 0x01F7FCE0, 0xFAA2C94B, 0xEBA37221, 0x51A15C6C, 0x2CD6A884, 0x346CAA86,
    0x54DE67C4, 0xE168B590, 0x8D481110, 0x2847613D, 0xC71A1A87, 0x4AF08871, 0xE604695A, 0xAA4C55D9, 0xA8563E84,
    0x2522D0C3, 0x11CC110E, 0xB36C5C50, 0x32FC45A0, 0x5A604762, 0x2E0FF2CA, 0x04788495, 0x04C5A31C, 0xC1B90889,
    0x42CD90D0, 0x31EDC01F, 0xFF934C95, 0xB7118505, 0x9500A804, 0x8FA84813, 0x25C77031, 0x21AE2E68, 0x3DB200C9,
    0xB81B86E8, 0x4513F482, 0x3131B2AE, 0xB9434C09, 0x56AB8EAE, 0x55A2218B, 0x1902EE5D, 0x650C44BB, 0xBAB4AF97,
    0x93ABD0E3, 0x183E5D73, 0x6C56E5C5, 0x884284A0, 0xDCE1BB2D, 0xD4A88AF9, 0xB91D095A, 0x5C90D71B, 0xADCA1EE5,
    0x098A14E8, 0xE9E4CAB0, 0x1F364283, 0x1FFBB2F9, 0x5A225D8F, 0x121FF53A, 0x9F2EAB56, 0x815AF765, 0xA1B4FE73,
    0xB38A8630, 0x000DC120, 0x93B39D94, 0x4A8504FC, 0x02321741, 0x876A04A0, 0xD0D571BB, 0x586DF5CA, 0x1229DC7C,
    0xA41FECE5, 0x8AE8B865, 0xFF398C6E, 0x050BB0E0, 0xFE140A23, 0xA042E910, 0xBA459595, 0x4A95B7FB, 0xB2B4DC50,
    0xC8341A16, 0xE9AD9FFE, 0x9080C265, 0x08BB804E, 0xD8174111, 0xB2579AC8, 0xC2908A98, 0x5C48A8D5, 0x1088764B,
    0x43ABC224, 0xB4321B2E, 0x9AB8474F, 0x904B0DA9, 0x03044227, 0x1024CB85, 0x84D8C600, 0xA25EE28F, 0xFFFDEEB2,
    0x42C79895, 0x3B514E2B, 0x5F474249, 0x5FF7A238, 0x9E0D8FB1, 0x23D38A98, 0xE6811F25, 0x3495B4D8, 0xAE36438D,
    0x642E48C9, 0x080451B4, 0x119A402B, 0xB07B5926, 0xDB791684, 0x8793D553, 0x18AA6E08, 0xDFD94458, 0x60D0FE54,
    0x1CD4D870, 0x91740AA9, 0x54A7A350, 0x9948122D, 0x171A489E, 0x8BA0E0E6, 0x54AC903E, 0x392CF67B, 0xCD607775,
    0x3E20DC8C, 0x62E8BDE4, 0x0DCA3C73, 0x97A5ADFC, 0xB281BD13, 0xD5AAD171, 0x52932550, 0xA30D0464, 0x2DD5020B,
    0xBFA74086, 0x93E7FDEC, 0x1E174A05, 0xB2547476, 0x6A902EA1, 0x0D83BB8B, 0xC66C81BD, 0x8B6B07B1, 0x2494A764,
    0x2EC03297, 0x1AE25BFE, 0x02A43455, 0x77064C2D, 0xFB61B14F, 0xD4289473, 0xF2CB9436, 0xB38F90AB, 0x822E6DFF,
    0x14229650, 0x9AC18186, 0x4209928F, 0x56B16A9C, 0xE6AD332B, 0xC6E59B85, 0x35528517, 0xA31B42D7, 0xA21966A3,
    0x7E1CD16D, 0xEA7D8698, 0x50A92B67, 0xB2555CF4, 0x97793CD9, 0x26E38C72, 0x6EAD5324, 0xD6D1D325, 0x820A8084,
    0x1F23CD26, 0xC39915EC, 0x7514C00A, 0xC2E5CA39, 0x57907B52, 0x6CEDD5CB, 0x245AB436, 0x42AECD40, 0x79F2EEA6,
    0x8385F297, 0x10982EEE, 0xCD8895EE, 0xE764211A, 0x45007BD7, 0x6EF163FA, 0x19D309A6, 0x154E042A, 0xC14C3476,
    0xB619D92C, 0x4FFDCAD8, 0x7A9AB1AF, 0x66F6A9B8, 0x5C5053C0, 0x200C6A48, 0x82B01740, 0x84ECE844, 0x3166E171,
    0x9B227254, 0x2BB03505, 0x36A7CD6E, 0x88E24BA5, 0x1109982D, 0xD07776B0, 0x1EEB0B41, 0x2C050441, 0xB9DB06C2,
    0xB9294B2B, 0x8AC57AE4, 0xFD451BA5, 0x97757DB9, 0x919D16D0, 0x4735430C, 0x8717365E, 0xB018D7BA, 0xE566077F,
    0x9B006F37, 0x19448A6C, 0x01788C6B, 0x4186618C, 0xEA808010, 0xB2964449, 0x8E548840, 0xDB8C4B71, 0xBD86ED66,
    0x3E0341E2, 0xE43A7167, 0x30648117, 0x27CBA8A0, 0xAB7437B0, 0xA0F76425, 0xAC555D42, 0x2E16E8A3, 0x807F285F,
    0x81A203E3, 0x7A83BA8F, 0x6FAEB268, 0x73039A9E, 0xA82E3003, 0x200957B6, 0x385F6741, 0x8A2D8355, 0x888E9087,
    0x0FDC8F5F, 0xFB1CE0D8, 0x1F51D9F2, 0x8F748220, 0x263C40A2, 0x6B8EF421, 0xBA4F02AE, 0xD76564E6, 0x6C6E5192,
    0x0FDC3215, 0x697DA945, 0x6FA7C74E, 0xE0D144E1, 0xFEB3AC48, 0xA442D461, 0xF408A912, 0x1E8E7795, 0xA9E8BA62,
    0x3B57D0D2, 0xFAE81172, 0xE3BB2CD9, 0x43C3993E, 0xC57612D8, 0x568C20F5, 0xD0FA1757, 0x912DE7FC, 0x93087770,
    0x953DD1D4, 0x083679CA, 0x70451624, 0x484408C6, 0x812623C8, 0xB2EAF64C, 0xDA70C96E, 0xDCAE4C84, 0x54010823,
    0xAD8AAE37, 0x126878F8, 0x8B432440, 0x358089A6, 0x057208A9, 0x0AE1862A, 0x189AAD11, 0x2E55B75B, 0x6AE64B94,
    0x4612AAE8, 0x1B13C458, 0x0F143316, 0xA86910B4, 0xD21141D7, 0xD73068AA, 0xB45B61B9, 0x4A89A7EB, 0x4E5D6EA6,
    0x26957FE7, 0xC534E169, 0x7264A115, 0xE86B92CE, 0xE086140E, 0x9AE86539, 0x56797744, 0x165BAAB5, 0x387E1574,
    0x81151216, 0xCB92B444, 0xBBB62B59, 0x32F398F1, 0x1028B91D, 0x72EA753B, 0x5EACBB85, 0xD7ED860B, 0x65D8DB61,
    0xB0A04F59, 0xABB5885D, 0x7B806541, 0x6E4ACBFE, 0xE0F749BC, 0x52659692, 0xC4DB6336, 0x9B41C39A, 0xF64F2E97,
    0xC79740B6, 0x2B12D062, 0x5CA0DB69, 0xB0238A03, 0x2C88B39E, 0x6167FB0D, 0x9ABF71AE, 0x65ADD36A, 0xC126D37B,
    0x49D79039, 0x37E804DA, 0x2B408B3F, 0xEB22EA30, 0x56FF45E7, 0xA9872544, 0xBECE2E8A, 0x9F2BB383, 0xB2092C8F,
    0xB0D77369, 0x1210AD09, 0xFF5D5B11, 0xCB351A09, 0x235D11B4, 0x0F42A2E8, 0x043E597E, 0x422395D8, 0x458EE088,
    0xBB7FCC2F, 0x734D5E6A, 0x2998FFFF, 0xE66AC0B0, 0xECA2CAD7, 0x9025953D, 0x91100DB9, 0x65D03508, 0x1575D2E9,
    0x145B1188, 0xC63562DE, 0x8A84458F, 0xE5584CAA, 0xDAB244C8, 0x4D5596B4, 0xD96068A1, 0x8A8A2134, 0x058ABB5C,
    0xBC9D8ED5, 0xDBCB565F, 0x08B73255, 0xE8CAE19E, 0xD9030683, 0xC3E04432, 0xE01823B8, 0x53521843, 0xE5C32958,
    0x5A9CDDD1, 0x14628C45, 0x8243576B, 0xB70B08B9, 0x0028B7C0, 0xAD96A822, 0x44824E9A, 0x2201725B, 0xB2CC9331,
    0x2C5A94EC, 0x61E5C118, 0xC745FFC4, 0xB70B4A9D, 0x6417AEC3, 0x03EAF40A, 0x916958B8, 0x58B1E811, 0xCFFC2517,
    0x3B5A9143, 0x01ECC4EC, 0xA707C555, 0xAD08E2E9, 0x4A04B520, 0x17CB156A, 0xE520B1B5, 0x576C4B7B, 0x785E1F78,
    0xFFA9C3E2, 0xF3623856, 0xC9A1A9D4, 0x8A75A5DB, 0x1F93798B, 0x6B073485, 0xBF0C531A, 0xA5EFA468, 0x1DD206F1,
    0x152186B7, 0x6C583810, 0x131ADD49, 0x62D72236, 0x81126195, 0x8C36C318, 0x2A4A3031, 0xB48850B8, 0x5E0D869A,
    0x812B5FC6, 0x1A282E16, 0x37429652, 0xE8E18D74, 0x14BE44B0, 0x23F58569, 0x3A9B04AE, 0xAB496B27, 0x83CC272C,
    0x18562203, 0x002A104F, 0x9E319842, 0x67BB5DC4, 0xAB9B50E5, 0x5A4F7470, 0xBA6B535A, 0x3DDBB6EB, 0xADA47613,

    /*
    **  [0xAA40 ~ 0xFEFE] (0xFE - 0xAA + 1) * (0xFE - 0x40 + 1) = 85 * 191
    */
    0x4ED7CF27, 0x6C7A12D5, 0x2F9B5349, 0x2C39B578, 0x1594B64B, 0x4E68B781, 0x5EC20680, 0x03EE2A64, 0x340D476C,
    0xC2653275, 0x8597FF09, 0xFF2CD6EE, 0xE34A8040, 0xC685075B, 0xADD2B09B, 0x3A4EC0BB, 0x8EAED363, 0xAC0EE1FF,
    0xC9060C4C, 0x243B1050, 0x043108C1, 0x60D06A00, 0x28B3B3D3, 0x6C30CB0C, 0xDC9C8831, 0xA3C96813, 0xED7EBEE3,
    0x077FFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFE83,
    0x7332164D, 0x836CDD73, 0x40963261, 0xED82857E, 0x009065DA, 0x17328849, 0x7954053D, 0x1086860B, 0xB402EC29,
    0x3D570BA8, 0x9B5B1C11, 0x784831D2, 0x0861DBEE, 0x0770013F, 0x0BB5F0F1, 0xA10B310F, 0x43A6B34A, 0x0A3BFEB5,
    0x06E49148, 0x8432B4DB, 0x5FCB5B2C, 0xD6DB3CA2, 0x0C99B502, 0x6C15E370, 0xBECEF454, 0x8F2E5592, 0x80B4855C,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEB82D,
    0x48B18154, 0xCAF8C4E7, 0x08B65A2C, 0xC5DAEAD1, 0x5A8A9616, 0x6AC44096, 0x3446CDBB, 0x2999B35A, 0xC524620C,
    0x16940520, 0xC5C9B08A, 0x0A81E7A0, 0xC544512D, 0x1281BB31, 0x86F68A45, 0x90751666, 0xA1AB1193, 0xFFFEC434,
    0x4366852A, 0xF85932D6, 0x805ACDA2, 0xB2CB7566, 0xB992455C, 0x981445AA, 0xB551490C, 0x095218F0, 0x8CE053FF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFA8F341F,
    0xB8211172, 0xC848115E, 0xC7B89F6B, 0x15C20D9B, 0x056A850F, 0x166B1484, 0xA0DC8B2A, 0xA296A844, 0x0A2C037E,
    0x1E220DF4, 0x2409FE45, 0x2AA48C6E, 0xC8A2E846, 0x718853D7, 0x509688CD, 0x6CBEAB25, 0xAB72916F, 0xFAB6F908,
    0xA41BA54A, 0x55BAE55A, 0xA7B9326C, 0x108360F6, 0xF87F0984, 0xCF8ADFF9, 0xEBFE077A, 0x95877FFF, 0xFD53FFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFF3, 0xE5C3FE8F,
    0x148BBFE3, 0xC64671F8, 0x0ECB7FC3, 0xD728057D, 0x7042770D, 0x1675C1DD, 0x6AE56CA4, 0x9CC53079, 0xA0A0511A,
    0x944D1725, 0x9FF975F8, 0x4785B0C1, 0xA8D95AD5, 0xA5492E99, 0x9120DA4B, 0x4BFE87AA, 0x0E5ADFF6, 0x93483549,
    0x2F834723, 0x05E156E0, 0x7D995D9A, 0x491B82D4, 0x8C7D1E67, 0x10E2D14D, 0x4156265A, 0x91966871, 0x87FFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFEF72, 0x3119123B,
    0x9C109AA0, 0xD30E5ABD, 0x67162420, 0x15E11837, 0x0969CA03, 0xB2857474, 0xBDBA2FA6, 0xA26B0819, 0xB0B98C8B,
    0xB0D3D876, 0x194BFC9F, 0x37B80331, 0xC6C602CD, 0x0844010B, 0x814CD26A, 0x5ED6219A, 0x657FE2EB, 0xB164782C,
    0xA79C2B27, 0xF4EDC521, 0x5D365C06, 0xA81FF8B3, 0x1D3410DC, 0x30927911, 0x1570B883, 0x1756304F, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD6AA9A, 0xF95C7771,
    0x3B57CD86, 0xE72DDAB1, 0x7455AB67, 0x03B09048, 0x2084175B, 0x5139362A, 0xB506A542, 0x5A2E571B, 0xA50888BE,
    0x5DAEC27F, 0xF0295027, 0x0506DF98, 0x8050F2D1, 0xA0847B18, 0x8A073068, 0xC204017E, 0xFFCEA803, 0xADFC4675,
    0xB0DBCEA8, 0x800D9100, 0x137C9D91, 0x06079C26, 0x198B34A4, 0x5239610F, 0xFC764B80, 0x5C814000, 0x00040201,
    0x00804020, 0x10080402, 0x01008040, 0x40201008, 0x04020100, 0x80403018, 0x0C080402, 0x01008040, 0x20100805,
    0x028140A0, 0x5028140A, 0x05028140, 0xA0502814, 0x0A050281, 0x80C06030, 0x180C0603, 0x01C0E070, 0x381C0E07,
    0x0381C0E0, 0x70381C0E, 0x07040201, 0x00804020, 0x10080402, 0x01008048, 0x24120904, 0xE3CEC760, 0x9D5AEC55,
    0x2EC247AB, 0x9C6AB515, 0x67433C40, 0x4ABB38C0, 0x780234AB, 0x4C0C3805, 0xDD9B6378, 0x9659ACE9, 0xB209E256,
    0x6257E6D6, 0xDC981268, 0x831CE494, 0x28E9A319, 0x9997C94D, 0x860DDC18, 0xA824C9FF, 0xADE9A462, 0x13659D3E,
    0xC95B5939, 0x56831A08, 0x733F8B44, 0xA8F2830A, 0xBF5D51CB, 0xE926FAB2, 0xB26D0859, 0x64C12090, 0x48241209,
    0x04824120, 0x90482414, 0x0A050281, 0x40A05028, 0x140A0502, 0x8140A050, 0x2C160B05, 0x830180C0, 0x6030180D,
    0x068341A0, 0xD068341A, 0x0D068341, 0xA0D06834, 0x1A0D0683, 0x41A0D068, 0x341A0E07, 0x0381C0E0, 0x70381C0E,
    0x070381C0, 0xF0783C1E, 0x10080402, 0x01108844, 0x22110884, 0x82412090, 0x48241256, 0xA9A548F7, 0xBA09724B,
    0xCB5D904C, 0x0AF59102, 0x6FBD8DD0, 0xCC63DDA2, 0x93672A56, 0xCDCC9AD2, 0x10782C3F, 0xB40B17FC, 0x75C08A9C,
    0x684F83EB, 0x817308DC, 0x7F9F575F, 0xF34588AD, 0x0D6FB3B2, 0x4DC86B78, 0x0503FF43, 0x63D8C309, 0x08B6D56E,
    0x41B2194F, 0xB652ACE1, 0x686520D7, 0x2C85B9B1, 0x84ADA1A5, 0x32F06484, 0xFEFE909A, 0x04824130, 0x984C2613,
    0x0984C261, 0x30984C26, 0x130984C2, 0x6130984C, 0x28140A05, 0x028140A0, 0x5028140A, 0x0542C160, 0xB0582C16,
    0x0B0582C1, 0x60B05C2E, 0x170B85C2, 0xE170C060, 0x30180C06, 0x432190C8, 0x64341A0D, 0x068341D0, 0xE8984C26,
    0x130984C2, 0x6130984C, 0x261389C4, 0xE28140A0, 0x5028140A, 0x05028140, 0xA4527BB9, 0x6591182B, 0xC0148E45,
    0xC1D70729, 0xD308ED20, 0xAD2EB34A, 0x095CA224, 0x2250C84A, 0xAA88A682, 0x3AEC97A9, 0x941A5977, 0x3BF16809,
    0x5504DFB7, 0x450A6A17, 0x97369420, 0x2B937005, 0x33647B2A, 0x4F507AC4, 0x13FFFF4D, 0x25C50A83, 0xD5DAC35E,
    0x042DE9A2, 0xB15DB25A, 0xA334FFCF, 0xAB90E3AA, 0x4D9E4D5B, 0x09E9B16C, 0x003F0714, 0x8A452291, 0x48A45229,
    0x148A4522, 0xA150A854, 0x2A150A85, 0x42A158AC, 0x562B158A, 0xC582C160, 0xB0582C16, 0x0B0582C1, 0x68B45A2D,
    0x168B45A2, 0xD168B45A, 0x2D168B45, 0xA2E170B8, 0x5C2E170B, 0x85C2E170, 0xB85C2E17, 0x0B85C2F1, 0x78BC5E2F,
    0x180C0603, 0x0180C060, 0x30180C06, 0x030188C4, 0x6231188C, 0x46231188, 0xC5669109, 0xB350C768, 0x62B2E35C,
    0x802F4C31, 0x9B611EA7, 0x724BD627, 0xE0226578, 0x78426C52, 0x6004E2CC, 0x3208C033, 0xCA0A0B59, 0x2D0CD2F7,
    0x51526030, 0x057806F2, 0x4D52FFED, 0xD5014400, 0x08F65AAE, 0x528350AF, 0xFEE2AB7C, 0xC020023C, 0x20E17A84,
    0x97AA7048, 0x6AE91C88, 0x13990108, 0x4AD43577, 0x1D04435D, 0xB380441D, 0xFD563118, 0x8C462311, 0x88CC6834,
    0x1A0D0683, 0x41A0D46A, 0x351A8D46, 0xA361B0D8, 0x6C361B8D, 0xC6E371B8, 0xDC6E381C, 0x0783C1E0, 0xF0783C1E,
    0x0F0783C1, 0xE0F07C3E, 0x1F0F87C3, 0xE2010884, 0x42211108, 0x84423118, 0x8C462311, 0x88C46241, 0x20904A25,
    0x128944A2, 0x51C8E472, 0x391C8E47, 0x43A1D0E8, 0x743A1D0E, 0x8743A1D2, 0x24636F3E, 0x0F2E0F77, 0xBDD9F650,
    0x00A5D0D7, 0x68CBCC3C, 0x13B6B02B, 0xEA155AAF, 0x28AD5695, 0x618F3B92, 0xB56EB768, 0x4F0D8A70, 0xADB22778,
    0xA0302C56, 0xE170309A, 0x2FFFDC26, 0xD75CA528, 0xBAC994B1, 0x84EBAFFD, 0xDAB99737, 0x57B28623, 0x12AD1534,
    0x2FA8C854, 0x4349B310, 0xB45C8F72, 0x80D18A06, 0xEB71C1A0, 0xF2577AE5, 0x7C743B1D, 0x8EC763B1, 0xD8EC763B,
    0x1D8EC763, 0xB1D8EC78, 0x3C1E0F07, 0x83D1E8F4, 0x7A3D1E8F, 0x47A3D1E8, 0xF47A3E1F, 0x0F882412, 0x09048241,
    0x20908844, 0x22110884, 0x42211088, 0x44221108, 0x84422110, 0x88442221, 0x10884422, 0x11088442, 0x21108844,
    0x22110884, 0x4229148A, 0x45229148, 0xA4522918, 0x8C462311, 0x88C46986, 0x52E0C692, 0x9081592B, 0xA210C543,
    0x92B02805, 0xDB4402EC, 0x84928A07, 0x66E952B5, 0xCAC91EAB, 0x6F136BE2, 0xAE2D62A7, 0xC4B0626B, 0x857DBD09,
    0x2C1D6F39, 0x445E52EC, 0x9D03BDDB, 0xAADBABDC, 0x26B46F62, 0xB29FF472, 0x0E9B3641, 0x98EE383C, 0xA4489797,
    0x72850C56, 0xA9EA8CC0, 0x8BA44E2D, 0x6BD5C9A7, 0x159D0421, 0x328A3561, 0x1C8E4723, 0x91C8E472, 0x391C9049,
    0x24924924, 0x92492492, 0x49249289, 0x44A25128, 0x944A2592, 0xC964B259, 0x2C964B25, 0x92C964B2, 0x592C964C,
    0x26130984, 0xC261349A, 0x4D269389, 0xC4E27138, 0x9C4E2713, 0x89E4F279, 0x3C9E4F27, 0x93C9E4F2, 0x793CA050,
    0x28140A05, 0x028140A0, 0x5028140A, 0x0512994C, 0xA6532994, 0xCA6F6094, 0xA2ECBCFF, 0xDC20A0E4, 0x21741AEC,
    0x448BF096, 0x7160F50C, 0x8DBB59F2, 0x86234C56, 0x55154225, 0x42EC7A42, 0x111B2842, 0x5CAB309F, 0xFDC10105,
    0x42441FE8, 0x809D3710, 0xBA953964, 0x48187BB2, 0xECFB4254, 0x7FF59081, 0xF142BA07, 0xC8920AD1, 0x1552ED34,
    0x45DB9536, 0xE0484AA8, 0x9D44116B, 0x86E1ADBA, 0xC22D4E0E, 0xF3D67299, 0x50A8542A, 0x150A8542, 0xA154AA55,
    0x2A954AA5, 0x52A954AA, 0x552A954A, 0xA552A954, 0xAC562B15, 0x8AC562B1, 0x58AC562B, 0x15CAE572, 0xB95CAE57,
    0x2B95CAE5, 0x72B960B0, 0x582C160B, 0x0582C160, 0xB0582C16, 0x0B0582C9, 0x64B2592C, 0x964B2592, 0xC964B259,
    0x2C964B25, 0xB2E174BA, 0x5D2E974B, 0xA5D2E974, 0xBA5D2E97, 0x6506CCF5, 0x6EA96B84, 0x412DD4A1, 0x55248A8E,
    0x58D76B8A, 0x21AA5D40, 0x221688D6, 0x37E11412, 0x104ABF2D, 0xE0A319B1, 0x7604313D, 0x400EB352, 0xC32D3997,
    0x5A2DC240, 0x6929E916, 0x45B84E11, 0x70A7E2B7, 0x341D20FF, 0xC495545A, 0x51168A7B, 0x0B9864BA, 0xB2225306,
    0xB5C6AEE7, 0x40E036E0, 0x49978E72, 0xED434C15, 0x9A090D01, 0x5685D2E9, 0x74BA5D2E, 0x974BA5D2, 0xE974BA5D,
    0x2E974BA5, 0xD2E974BA, 0x5D2E974B, 0xA5D2E974, 0xBA5D2E97, 0x4BA5E2F1, 0x7CBE5F2F, 0x97CBE603, 0x0180C060,
    0x30180C06, 0x030180C2, 0x6130984C, 0x26130984, 0xC2623118, 0x8C462311, 0x88C46231, 0x18CC6633, 0x198CC663,
    0x3198CC66, 0x33198CC6, 0x633198CC, 0x86532998, 0xCC663339, 0xCAE55301, 0x566CC49B, 0x4219ABE3, 0x74285D71,
    0xB7035488, 0x895C5D08, 0x74CAA987, 0x81A2ED3D, 0x5AA8471B, 0x10C7324D, 0x7B282D94, 0xE5F154C0, 0xD188C0A1,
    0xB53B6C21, 0x4530281A, 0x0D318B87, 0x576430F4, 0x5D93FFCB, 0x72CB959A, 0x44BB8B34, 0xC0922360, 0xD6182768,
    0x074AEBEF, 0xC9A9F26C, 0x381BAEAB, 0x84982211, 0x13646315, 0x4CC66331, 0x9CCE6733, 0x99CCE673, 0x399CCE67,
    0x3399CCE6, 0x7341A0D0, 0x68341A0D, 0x068341A4, 0xD269349A, 0x4D269349, 0xA4D26934, 0x9A4D2693, 0x49A4D26A,
    0x351A8D46, 0xA351ACD6, 0x6B361B0D, 0x86C361B0, 0xD86C361B, 0x0D86D369, 0xB4DC6E37, 0x1B8DC6E3, 0x71B8DC6E,
    0x371B8DC6, 0xE371B8DE, 0x6F379C0E, 0x070381C0, 0xE0711A16, 0x72E7A82C, 0x25970234, 0xCDAD476A, 0x1DE060D4,
    0xC9B86056, 0x1303C896, 0x8318CBB2, 0xE185BA18, 0x28810690, 0x83F6C0B8, 0x89EE0FBB, 0x542FF2E3, 0x75C0F828,
    0x4E3F2FC8, 0x447069BD, 0x1E111165, 0x8AA58584, 0x27FF64CB, 0x878B11D9, 0x750CCD51, 0x0E9112B5, 0x4D857336,
    0xBE401E10, 0x07B9811C, 0xB95CDB07, 0x91E4B9A2, 0x04AF9B1C, 0x8E472391, 0xC8E47239, 0x9CCE6733, 0x99CCE673,
    0x399CCE67, 0x3399CCE6, 0x73399CCE, 0x6743A1D0, 0xEA753A9D, 0x4EA753A9, 0xD4EA763B, 0x1D8EC763, 0xB1D8EC76,
    0x3B1D8EC7, 0x63B1D8EC, 0x763B1DCE, 0xE783C1E0, 0xF0793C9E, 0x4F2793D1, 0xE8F47A3D, 0x1E8F47A3, 0xD1ECF67B,
    0x3D9ECF67, 0xB3E1F0F8, 0x7C3E1F0F, 0x87C3E1F0, 0xF8A7515D, 0xAF075435, 0x0690C918, 0x5C20147C, 0xD6580F38,
    0xCB40B3D4, 0x75CAE50D, 0x53B95D94, 0xCB782ABD, 0x4F02BC65, 0x51CAF071, 0x330EAD97, 0x2FAE578C, 0xF59CAB34,
    0xC84D1D07, 0x66E8931D, 0x02C60340, 0xF5C1522F, 0xFF160688, 0xEE39064D, 0x04F86047, 0x3432C2E9, 0x41EA9A1A,
    0x59E6C0CA, 0x929C28ED, 0x5F2EAB6F, 0x0B947400, 0x0D8E3E1F, 0x0F87C3E1, 0xF0F87D3E, 0x9F4FA7D3, 0xE9F4FA7D,
    0x3F1F8FC7, 0xE3F1FCFE, 0x7F3F9FCF, 0xE7F3F9FC, 0xFE7F3F9F, 0xCFE80402, 0x01008040, 0x20100804, 0x02010080,
    0x40205028, 0x140A0502, 0x8140A050, 0x28140A05, 0x028140A0, 0x5028140A, 0x05048241, 0x20904824, 0x1A0D0683,
    0x41A0D068, 0x341A0D08, 0x84422110, 0x88442210, 0xE07D8FD0, 0xC1CCAC22, 0x195B622E, 0xBB01469B, 0x32173743,
    0x8F9610ED, 0x08FC7DD8, 0x2E5827C2, 0x67F9C210, 0xE75070AB, 0x71442709, 0x154F2546, 0x99F2688B, 0xAA104D96,
    0xB5108CEE, 0xE31D5A25, 0x5984B530, 0x74E727FC, 0xB8849C0D, 0xC1B92659, 0xEB28842C, 0x5E6243B4, 0x5020468D,
    0xBD014BB9, 0x4800C0F5, 0x7AAE976C, 0x53406CE2, 0x14844221, 0x10884422, 0x11088442, 0x21108844, 0x22110884,
    0x42211088, 0x44221108, 0x84422110, 0x88442211, 0x08844221, 0x10884422, 0x11088442, 0x21108844, 0x2A150A85,
    0x42A150A8, 0x542A150A, 0x8542A150, 0xA8542A19, 0x0C864321, 0x90C86432, 0x190C8643, 0x2190C864, 0x32190C86,
    0x432190C8, 0x6432190C, 0x86432190, 0xC86432D3, 0x2E2A305B, 0x4AF53450, 0xE86336CA, 0xD7E148C0, 0x3C29A138,
    0xC4285171, 0x23A58909, 0x97181A80, 0xC90509F0, 0x3C663351, 0x1129D444, 0x2C02A9B4, 0x032BE5D3, 0x21262A3D,
    0xB8AAEC48, 0xF2F91A9B, 0x2543D80D, 0xC90FFA19, 0x1E2E6164, 0x9742D84C, 0xE0114D98, 0x9FE0C12B, 0x35229D62,
    0x3D574BB4, 0xC8D13546, 0x5D459F32, 0x95F46165, 0x0C864321, 0x90C86432, 0x190E8743, 0xA1D0E874, 0x3A1D0E87,
    0x43A1D0E8, 0x84422110, 0x88442211, 0x08844221, 0x10884422, 0x11088442, 0x21108844, 0x22110884, 0x42211089,
    0x44A25128, 0x944A2512, 0x8944A251, 0x28944A25, 0x128944A2, 0x5128944A, 0x25128944, 0xA25148A4, 0x5229148A,
    0x45229148, 0xA4522914, 0x8A452291, 0x48A4259E, 0x25821613, 0xD5ABA580, 0xC2162A80, 0x67601568, 0x157E6F58,
    0xA2558C35, 0x7060E02C, 0x70119B16, 0xB00C6834, 0x54B46540, 0x20A28C21, 0xBF0B5DC1, 0xD91608A2, 0xBC690576,
    0x0F955736, 0x7B94C201, 0x67B02192, 0xFFFAFC65, 0x9484260B, 0xC8482625, 0xDEC40992, 0xC241C7F3, 0x307D9558,
    0x2ED629C6, 0x865D895F, 0x84071BEE, 0x34835229, 0x148B45A2, 0xD168B45A, 0x2D168B45, 0xA2D168B4, 0x5A2D168B,
    0x45A2D168, 0xB45A2D16, 0x8B462311, 0xA8D46A35, 0x1A8D46A3, 0x51A8D46A, 0x351A8D46, 0xA351A8E4, 0x72391C8E,
    0x472391C8, 0xE472391C, 0x8E472391, 0xC8E47239, 0x1C8E4723, 0x91C8E47A, 0x3D1E8F47, 0xA3D1E904, 0x82412090,
    0x48241209, 0x04824522, 0x9148A452, 0x394AC8B4, 0x503AAF5D, 0xF09679AD, 0x60CDFFB9, 0x22AE19C6, 0xE820D27C,
    0x152183D0, 0xB9E566BC, 0x23424568, 0x85DBC8B0, 0xC5153E5E, 0xE8F5F946, 0x483F4440, 0x0581A591, 0x0AB6516C,
    0xAE87D568, 0xF8130B28, 0xBA683E7F, 0xEAFB407D, 0x092111AE, 0x8197090A, 0x360682AF, 0xA125B668, 0x75A25490,
    0x0EE2B292, 0xF8FACD20, 0x55588AB1, 0x28648A45, 0x229148A4, 0x92492492, 0x4D269349, 0xA4D28944, 0xA2512894,
    0x4AA552A9, 0x54AA552A, 0x964B2592, 0xC974BA5D, 0x2E974BA5, 0xD2E974BA, 0x5D2E974B, 0xA5D32994, 0xCA65349A,
    0x4DA6D369, 0xB4E27138, 0x9C4EA753, 0xA9D4EA75, 0x3A9E4F27, 0x93C9E4FA, 0x7D3E9F50, 0x28142A15, 0x0A8542A1,
    0x50A8544A, 0x25128944, 0xA25128A2, 0x0288D599, 0x027DC3D7, 0x607791CB, 0x34DC8491, 0x2190E7F8, 0x207D1276,
    0x068A2E0E, 0x5954DA5B, 0x17420460, 0x4A72EDAA, 0x00F656B4, 0x15762C3A, 0x86EB6755, 0xA1850885, 0xC8A2E416,
    0x87A1B118, 0x75F2B54E, 0xAB57FFCF, 0x512CBE48, 0x8D5DB951, 0x2B35F11D, 0x88B85C80, 0x04DF960C, 0x7986E46C,
    0xC4D08310, 0x0AD5C957, 0x425CC94C, 0x2A251289, 0x46A351A8, 0xD48A4522, 0x914AA552, 0xA954AA55, 0x2A994CA6,
    0x53A9D4EA, 0x753A9D4E, 0xA753A9D4, 0xEA753A9D, 0x4EA8542A, 0x150A8542, 0xA152A954, 0xAA552A95, 0x4AA552AA,
    0x552AD56A, 0xB55AAD56, 0xAB55AAD5, 0x6AB562B1, 0x58AD56AB, 0x55AAD56A, 0xB55AAD56, 0xAB55AAD5, 0x6AB55AAD,
    0x56AB55AA, 0xD56AB55A, 0xAD56FFD9, 0x269CBA39, 0x88CD3528, 0xD1E5D9A1, 0xAB3D7601, 0x1524AC05, 0xA814A82A,
    0xAC035082, 0xF5AA3D93, 0x8F5F3DD0, 0x8845DB24, 0x7360BADD, 0x4B005B69, 0xA6076D31, 0x5772F708, 0xAC36047F,
    0xAFD76DA9, 0xB815D8CD, 0x77FF9565, 0xE5897ABD, 0xCD03338B, 0xCB07A170, 0x8CBB5E05, 0xA941AB5C, 0xA42ABB62,
    0xAEA5D028, 0x19C4B4F4, 0x871ECB55, 0xAAD56AB5, 0x5AAD56AB, 0x55CAF57A, 0xBD5EAF57, 0xABD5EAF5, 0x7ABD5EAF,
    0x57AC160B, 0x0582C160, 0xB0582C16, 0x0B058AC5, 0x62B158AC, 0x562B158A, 0xC562B158, 0xAC964B25, 0x92C966B3,
    0x59ACD66B, 0x359ACD66, 0xB359AD16, 0x8B45A2D1, 0x68B45A2D, 0x168B45A2, 0xD168B45A, 0xAD56AB55, 0xAAD56AB5,
    0x5AAD56AB, 0x75BADD6E, 0xB7175A05, 0xD84AB204, 0xF6757CAB, 0xCF60459B, 0xD6080440, 0xDA07BFF3, 0x41A0D046,
    0x7614C994, 0xC7B8B862, 0x85470C57, 0xA84BFAE1, 0x08A941DD, 0x4FD70835, 0xC8767ACA, 0x7FF242BC, 0x9DD6A34A,
    0x29DAE97F, 0xF3ACD565, 0xFF458348, 0x470ACD9D, 0xF81F23FF, 0xE988E0FA, 0x895EAFAD, 0x2895EAF0, 0xFCD64D4C,
    0x513868A3, 0xB71C150D, 0x4CA62DD6, 0xEB75BAE1, 0x70B85C2E, 0x170B95CA, 0xE572B95C, 0xAE572B95, 0xCAE572B9,
    0x5CAE572B, 0x95CAE572, 0xBA5D2E97, 0x4BA5D2E9, 0x74BA5D2E, 0x974BA5D2, 0xED76BB5D, 0xAED76BC5, 0xE2F57ABD,
    0x5EAF57AB, 0xD5F2F97C, 0xBE5F2F97, 0xCBE5F2F9, 0x7CBE6030, 0x180C0603, 0x0180C060, 0x30582C16, 0x0B0582C2,
    0x6130984C, 0x26130984, 0xB7C7C965, 0x18FB8425, 0x32193184, 0xCFE2E894, 0x5EEE2639, 0x81DE859B, 0xAC3AB300,
    0x06836BA9, 0x9230340A, 0x131BD24A, 0xE579B375, 0xEC1E2ED7, 0xDA50A4B8, 0xBADAF217, 0x594A679C, 0x19B85B4A,
    0x11B1ABB5, 0xD60D77FE, 0xE2AB566C, 0xC8BBA9E5, 0x6428A631, 0x86F3442D, 0x151E21A5, 0x0BAA22D6, 0xD129B0F7,
    0x34AAC522, 0x344AA27A, 0x0F6130D8, 0x6C361B0D, 0x86C46231, 0x188C4623, 0x1188C462, 0x31188C56, 0x33198CC6,
    0x633198CC, 0x6633198C, 0xC6633198, 0xCC663B1D, 0x8EC86432, 0x190C8643, 0x2190C964, 0xB2592C96, 0x4B2592C9,
    0x64B2592C, 0x964B2994, 0xCA653299, 0x4CA65329, 0x96CB65B2, 0xD96CB65B, 0x2D98CC66, 0xB359ACD6, 0x6B359CCE,
    0x673399CC, 0xE67B417A, 0xF83823C6, 0x63B6D354, 0x89341C23, 0x8920D385, 0x6D8CD827, 0x0B97CEE2, 0x1009B13B,
    0xBCE562C4, 0xEAC2210A, 0x4C068A60, 0x5549BD0E, 0x519CB82C, 0x508F7B12, 0xE9DC2907, 0x9C1E4334, 0x397468B9,
    0x3ADC96B6, 0x90E7FC6A, 0xDD5888C9, 0xB61A3957, 0x28883E08, 0xFFF60951, 0x63303B4F, 0xB951C314, 0x798D5F52,
    0x8008C236, 0xA29D6EFA, 0xD068341A, 0x0D068341, 0xA0D06834, 0x1A0D0683, 0x41A0D168, 0xB45A4D26, 0x9349A4D2,
    0x69349A4D, 0x269349A4, 0xD269351A, 0x8D46A351, 0xA8D46AB5, 0x5AAD56AB, 0x59ACD66B, 0xB61B0D86, 0xC361B2DA,
    0x6D36DB8D, 0xD6EB75BA, 0xDD6EB75B, 0xADD6EB75, 0xBCDE6F37, 0x9BCDE6F3, 0x7DBEE070, 0x385C2E17, 0x0B85C2E1,
    0x7138DC6E, 0x371D7C1F, 0x6451A96D, 0x8B941DE9, 0x7D0ABEAE, 0xD777A815, 0x6CDAB336, 0xA2108621, 0x8039C263,
    0x43119156, 0x6A0D7C4D, 0x0CBB58D1, 0xC8DB1CC9, 0x1B0E9B50, 0x9FE7C361, 0xF6935E1E, 0x955DF412, 0xA8D172B4,
    0xAF1E8B29, 0xEFF976FC, 0x5956DD95, 0x1FF09B79, 0x1C804483, 0x9A046250, 0x204D700C, 0x2E07569A, 0x51047903,
    0x5CDC1088, 0x641C01C6, 0xE372391C, 0x8E472B95, 0xCAE573B9, 0xDCEE874B, 0xA9D4EC76, 0x3B1D8ED7, 0x73B9DCEE,
    0x773B9DCE, 0xF77BBDDE, 0xEF77BC1E, 0x0F0783C1, 0xE0F178BC, 0x5E2F178B, 0xC5E2F279, 0x3C9E4F27, 0x9BCDE6F3,
    0x79BCDE6F, 0x47A3D1E8, 0xF47A3D1E, 0x8F47ABD5, 0xECF67B3D, 0x9ECF67B3, 0xD9ECF67B, 0x3D9ECF67, 0xBBDDEEF7,
    0x7BBDDEEF, 0x75CAE451, 0x3C433F2D, 0x96C0CA10, 0x8F4A443D, 0xAE026651, 0x82CE7CC1, 0x9F255941, 0xBD620159,
    0x89172CE7, 0xD4821008, 0x316244CE, 0x902BADC2, 0x0AF72110, 0x90974055, 0xC1C6DD09, 0x84ACD6EA, 0xF9EB1649,
    0x23384F9F, 0xF63468D2, 0x0DAC02B0, 0x7944207F, 0xFF6931AB, 0x62A27165, 0x60EB8359, 0x5709E6E0, 0xF1A0DA88,
    0xBB0780AC, 0x3CABDDEE, 0xF77BBDDE, 0xEF77BBDD, 0xF0F87C3E, 0x1F2F97CB, 0xE5F4FA7D, 0xBEDF6FB7, 0xDBF1F8FC,
    0x7E3F1F8F, 0xC7E3F1FA, 0xFD7EBF5F, 0xAFD7EBF5, 0xFCFF7FBF, 0xDFEFF7FB, 0xFDFEFF7F, 0xBFDFEFF7, 0xFBFE0100,
    0x80402010, 0x08040201, 0x00804020, 0x10080402, 0x01008040, 0x20100804, 0x02010080, 0x40201008, 0x04020100,
    0x80402030, 0x2CB9FCBA, 0x5F1C8D11, 0x65301410, 0x5CF64509, 0xA719B1C8, 0x6AEC4BAC, 0x2B4945D8, 0x95C42979,
    0x950B4595, 0xC08574CD, 0x976866D0, 0x95384CB0, 0x58596459, 0x1162B48D, 0xB04A7312, 0xA16AF287, 0x24C6ACCA,
    0x44B5BFED, 0x2A7FFD86, 0x1E214289, 0x23152AE6, 0xB0E151BF, 0xEF662382, 0xF46036C6, 0xB1D5A098, 0x323E0C42,
    0x44A2A082, 0xE80C0605, 0x028140A0, 0x5028140A, 0x05028140, 0xA0502814, 0x0A050281, 0x40A05028, 0x1C0E0703,
    0x81C0E070, 0x38241209, 0x04824120, 0x90482412, 0x09048241, 0x2090582C, 0x160B0583, 0x41A0D068, 0x341A0D06,
    0x8341A0D0, 0x783C1E0F, 0x0783C1E0, 0xF0783C1E, 0x0F078442, 0x2130984C, 0x26130984, 0xC26150A8, 0x542A150A,
    0x85428CC7, 0xD4500AAE, 0x0CCB2196, 0x742A48F4, 0xF8761B8A, 0x4FE57534, 0xB51F7098, 0x878D81AC, 0x954D1A0D,
    0xB8323FEF, 0x323A212F, 0x60AB23AE, 0xC0A57DA1, 0xAC1AAD8D, 0xE620E620, 0x0AE48352, 0x21D957FC, 0x523A2D5D,
    0x997FC050, 0xA4317574, 0x862C1E8F, 0x47BB653F, 0x068B64A0, 0x25E5FCB2, 0x1AB013AC, 0x210996E4, 0x8C2E0482,
    0x9B29F090, 0xA8542A15, 0x0A85C2E1, 0x70B85C2E, 0x170B85C2, 0xE170C864, 0x32190C86, 0x432190D8, 0x6C3A1D0E,
    0x8743E1F0, 0xF87C3E21, 0x10884462, 0x3128944A, 0x25128944, 0xA2512894, 0x4E27148A, 0xC562B158, 0xAC562B15,
    0x8AC562D1, 0x68B45E2F, 0x178BC5E2, 0xF178BC5E, 0x2F198CC6, 0xA351A8DC, 0x6E391C8E, 0xC763B1E8, 0xF47A3D1F,
    0x8FDBAEEC, 0x6BCCE334, 0x6C875A7F, 0xE50BA206, 0xE3361BCD, 0xAF3926A2, 0xB6187F56, 0xA3ABA319, 0xC53D6A83,
    0x2240908F, 0xD12DDC63, 0x7678BFDA, 0x95D2C5E6, 0x381864CA, 0xD93275AD, 0x74D2A82F, 0x89686BEB, 0x45B8DD84,
    0xFF9BF154, 0xA0D3D3FF, 0x34542D08, 0x54A62534, 0x62025787, 0xDF85D450, 0xDD1358A8, 0x866ED704, 0x70357214,
    0xC72AE3F1, 0xF9048241, 0x2190C864, 0x3229148A, 0x472496CB, 0x65B2D96C, 0xB65B2D96, 0xCBA5D2F9, 0x7CBE5F2F,
    0x97CBE5F2, 0xF97CBE5F, 0x2F97CBE5, 0xF30984C2, 0x6130984C, 0x2613198C, 0xC6633198, 0xCC663319, 0x8CC66532,
    0x994CA653, 0x2994CA65, 0x32994CA6, 0x9349A4D2, 0x69349A4D, 0x269349A4, 0xD269349A, 0x4D26B359, 0xACD66B35,
    0x43B0AD8B, 0x44203CDE, 0x73210866, 0x53021208, 0x262710C7, 0xED07C023, 0x251D9509, 0xA1D92357, 0x02051F71,
    0x435C4E02, 0xC3E4B539, 0x0260062F, 0xEADAC212, 0x0535643B, 0x8504447A, 0xAEEC8818, 0x9F50CC1B, 0xC826EBFF,
    0x5CC40A14, 0x82BA40A9, 0x172BA7E7, 0xD6BB3974, 0x795C24C9, 0x6C35D5BD, 0x66628695, 0xAD2ED5E9, 0x2B96D159,
    0xBB4D66B3, 0x59ACD66D, 0x369B4DA6, 0xD369B4DA, 0x6D369B4D, 0xA6D369B4, 0xDA6D369B, 0x4DA6D369, 0xB4DA6D36,
    0x9B4DA6D3, 0x69B4DA6D, 0x369B4DA6, 0xD369B4DA, 0x6D369B4D, 0xA6D369B4, 0xDE6F379B, 0xCDE6F379, 0xBCDE6F38,
    0x9C4E2713, 0x89C4E271, 0x389C4E27, 0x1389C4E2, 0x71389C4E, 0x271389C4, 0xE271389C, 0x4E271389, 0xC4E2715D,
    0x3A805028, 0x14207AC0, 0xBB662B10, 0xE179A40D, 0x5E97BB8E, 0x69143C6C, 0xAD285523, 0xD88D3384, 0x31D63B6A,
    0xB70189AF, 0xBAC38C60, 0xC17C87AF, 0xC2CC914D, 0xBB720F9D, 0x60054435, 0x9D440E21, 0x3254E8A8, 0x4417FFFF,
    0x814A1757, 0x0B3D8AE0, 0xA555A208, 0x594052F1, 0xA07F0788, 0x28551844, 0x12B0B540, 0xBB8C5590, 0x4AB67031,
    0x9C4E6733, 0xA9D4EA75, 0x3B9DCF27, 0x93C9ECF6, 0x7B3D9F4F, 0xA7D3E9FC, 0xFE7F3F92, 0xC964B259, 0x2C964B25,
    0x92C964B2, 0x592C964B, 0x259349A4, 0xD269349A, 0x4D2693C9, 0xE4F27944, 0xA2512894, 0x4A251289, 0x44A25128,
    0x94CA6532, 0xA954AA55, 0x2A954AA5, 0x52A954AA, 0x572B95CB, 0x2592C964, 0xB2592C96, 0x5028140A, 0x050002B3,
    0xB44194D5, 0x32846A34, 0x845CCA2A, 0x2C3ACBEE, 0xED6A4223, 0x2D109942, 0x30B20D6B, 0xDC2BF764, 0x72BD5F71,
    0x81DC96F4, 0xE3EDE169, 0x6E631CCD, 0xCA7420F1, 0x84AB559F, 0x4B394AC2, 0x88FCAD42, 0x2ACFCBE4, 0x27FD44B9,
    0x437FE8EA, 0xB85D86E0, 0xBB638424, 0xB61189F2, 0xCE252ED9, 0xD727C3A9, 0xD51C09B6, 0x6371AA20, 0x8C8A7140,
    0xA0502814, 0x1A0D0683, 0x41A0D068, 0x341A150A, 0x8542A150, 0xA8542A15, 0x0A8542A1, 0x50A8542A, 0x150A8743,
    0xA1D0E874, 0x3A1D0E87, 0x43A1D0E8, 0x744A2512, 0x8944A251, 0x28944A25, 0x128B47A3, 0xD1E8F48A, 0x45229148,
    0xA4522914, 0x8A452291, 0x48A45229, 0x349A4D26, 0x9349A4D2, 0x6954AA55, 0x2A954BA5, 0xD2E994CA, 0x60F6122D,
    0xFFA43213, 0x2BB18307, 0x60041400, 0xA2E81566, 0xF17848C0, 0x29B00AB2, 0x41030280, 0x655A5572, 0xC160E85D,
    0x87025BA3, 0xA7E0B91C, 0xAD2EE2CD, 0x0F709D7C, 0x8A100963, 0x69669B91, 0x8C3C8104, 0x1756570F, 0xFD7D5B67,
    0x7E226657, 0x0ABB41BA, 0x6E842A6C, 0x88984A16, 0xA22B051C, 0xED1342ED, 0x7D500DB4, 0x5D5123B2, 0x2206994C,
    0xA6532994, 0xCA65369B, 0x4DA6D369, 0xB4DA6D36, 0x9B4DA6D3, 0x69D4EA75, 0x3A9F4FA7, 0xD3E9F4FA, 0x7D3E9F4F,
    0xA7D42A15, 0x1A8D46A3, 0x51A8D4AA, 0x552A9D4E, 0xA753A9D4, 0xEA753A9D, 0x4EA754AA, 0x552A954A, 0xA552AB55,
    0xAB55AAD5, 0x6AB55AAD, 0x56AB55AA, 0xD56AB55A, 0xAD56AB55, 0xEAF57ABD, 0x5EAF57AB, 0xD5EAF589, 0x323A0176,
    0x48C957AA, 0xD2351146, 0x7339820A, 0xF58275DE, 0x59028D37, 0x69AB0249, 0x400E42AB, 0x85D93FF5, 0x2A1298C4,
    0xB132912A, 0xDB45B1B1, 0x582EDDD8, 0xD588CD88, 0xE3729B0B, 0xE8797C20, 0xBAEEC852, 0x8EA13FF5, 0x69C0090A,
    0xB921C0F2, 0x50F402B4, 0xAF03C550, 0x95CB31CE, 0x4A0D3EDC, 0x096D53B1, 0xF0DCC0B8, 0x566E545C, 0xAD62B158,
    0xAC562B15, 0x8AC562B1, 0x58AC562B, 0x158AC562, 0xB158AC56, 0x2B158AC5, 0x62B158AC, 0x562B158A, 0xC566B359,
    0xACD66B35, 0x9ACD66B3, 0x5AAD56AB, 0x75BADD6E, 0xB75BADD6, 0xEB75CAE5, 0x72B95CAE, 0x572B95CA, 0xE572B95C,
    0xAE572B95, 0xCAE572B9, 0x5CAE572B, 0x95CAE572, 0xB95CAED7, 0x6BB5DAED, 0x76BB5DAE, 0xD76BA18F, 0xFC029530,
    0x1D2E6B04, 0x616239EF, 0x76142E20, 0xD7143D66, 0xC2C2C864, 0x18070588, 0x7D5AC2B0, 0x8A5A1889, 0x2C268B94,
    0x7B222141, 0x0589BABA, 0x84CD02D5, 0x290485A8, 0x50886C58, 0x5A22FB54, 0x94622D1E, 0x2B7FE284, 0x222C7284,
    0x0F58265F, 0xFB909D5B, 0x80B465EF, 0xF6261D8A, 0x0115431D, 0x73C89089, 0xD8AAAB44, 0xA9594ADA, 0xED76BB5D,
    0xAED76BB5, 0xDAED76BB, 0x5DAED76B, 0xB5DAED76, 0xBB5DAED7, 0x6BB5DAF5, 0x7ABD5EAF, 0x57ABD5EA, 0xF57ABD5E,
    0xAF57EBF5, 0xFAFD7EBF, 0x5FAFD7EB, 0xF5FAFD7E, 0xBF5FAFD7, 0xEBF5FAFD, 0x7EBF5FAF, 0xD7EBF60B, 0x0582C160,
    0xB0582C16, 0x0B0582C1, 0x60B0582C, 0x160B0582, 0xC161B0D8, 0x6C361B0D, 0x86C361B0, 0xD8612E15, 0xC92EC231,
    0x5BAB56EF, 0x2B7BDDAE, 0x69B94E2B, 0xA17851FC, 0x2EC244CE, 0x33C80741, 0x732AC129, 0xA49995D4, 0xA5DE14B4,
    0xB44B892B, 0x7AF9F2B0, 0x3D17D607, 0xB9D305DA, 0xE05D2C22, 0x72A3BB86, 0x551300B1, 0x7FE1D944, 0x889D030E,
    0xA9AD0136, 0xEC503662, 0x893B5A72, 0x5537784C, 0x845D37E5, 0x3290EB85, 0x4D2068B4, 0x0A21561B, 0x0D86C361,
    0xB0D86C56, 0x2B158AC5, 0x62B158AC, 0x562B158A, 0xC562B158, 0xAC562B15, 0x8AC563B1, 0xD8EC763B, 0x1D8EC763,
    0xB1D92C96, 0x4B2592C9, 0x64B2592C, 0x964B2592, 0xC964B2D9, 0x6CB65B2D, 0x96CB66B3, 0x59ACD66B, 0x359ACD66,
    0xB3D9ECF6, 0x7B3D9ECF, 0x67B3D9EC, 0xF67B3D9E, 0xCF67B3D9, 0xECF68B45, 0xA2D168B4, 0x5D99213F, 0xF8B85C9D,
    0x8921D0C1, 0x34494E2F, 0x97375C52, 0x564FFA8D, 0xC13842A8, 0xD5A8F9A1, 0x8F24B542, 0x5C0299B9, 0xEC355A09,
    0x1428E897, 0x75A0B852, 0x305815CA, 0xE6F0112F, 0x2900421C, 0x13300A44, 0xD8BA2FFF, 0xD888CA32, 0x659ACD77,
    0x2ED3AA16, 0xC40BCC77, 0x59A01A0F, 0xD15BBB55, 0x182603C8, 0x1C172449, 0xF93AAF56, 0xCDAD168B, 0x45A2D369,
    0xB4DA6D36, 0x9B55AAD5, 0x6AB55AAD, 0x56AB55AA, 0xD56AB55A, 0xAD76BB5D, 0xAED76BB5, 0xDAED76BB, 0x5DAED76B,
    0xB5DAED96, 0xCB65B2D9, 0x6CB65B2D, 0x96CB65B2, 0xD96CB65B, 0x2D96CB65, 0xB2D96CB6, 0x5B2D96CB, 0x65B2D96C,
    0xB65B2D96, 0xDB6DB6DB, 0x6DB6DB6D, 0xB6DB6DB6, 0xDB6DB6DB, 0x6DB6DB75, 0xBADD6E5D, 0x3848D62A, 0xFD601E19,
    0x4248C120, 0xD2EA191E, 0x8611A105, 0x17A0984E, 0xC1630844, 0x184A7025, 0xC0DC1995, 0x39450281, 0xE12E840D,
    0x5397729F, 0xF25D526C, 0x06B104C5, 0x8A65BD76, 0x5EA7C80E, 0x91C229B2, 0x1AE1FF53, 0xDAEBA072, 0xE9680A76,
    0x422110C6, 0xC075B0DC, 0x887C3119, 0x2C9664DA, 0x4A28C922, 0x1934A57D, 0xBB2891AE, 0xDBADD6EB, 0x75BADD6E,
    0xB75BADD6, 0xEB7DBEDF, 0x6FB7DBED, 0xF6FB7DBE, 0xDF6FB7DB, 0xEDF70B85, 0xC2E170B8, 0x5C2E170B, 0x85C2E170,
    0xB85C2E17, 0x0B85C2E1, 0x70B85C2E, 0x170B85C2, 0xE170B85C, 0x2E170B85, 0xC2E170B8, 0x5C2E170B, 0x85C2E170,
    0xB85C2E17, 0x0B85C2E1, 0x70B8DC6E, 0x371B8DC6, 0xE371B8DC, 0x6E371B8D, 0xC6E32FAC, 0x57693765, 0x39409703,
    0x792119D7, 0x23442B1A, 0x8A361041, 0xCBB8521A, 0xB088852F, 0x94F34211, 0xB2D94984, 0xA285B941, 0x52107642,
    0x3EC2CC73, 0x63722505, 0x09B23750, 0x8B91C836, 0xC93033E5, 0x0F831AC5, 0xC3FEAD48, 0x562D958B, 0x611CBA96,
    0x84A21085, 0x5B5114F4, 0x26A259D0, 0x83B895AA, 0xE32F8054, 0xD096AB89, 0x40236BB8, 0xDCAE572B, 0x95CAE572,
    0xB95CAE57, 0x2B95CAE5, 0x72B95CAE, 0x573BA5D2, 0xE974BA5D, 0x2E974BA5, 0xD2E974BA, 0x5D2E975B, 0xADD6EB75,
    0xBADD6EB7, 0x5BADD6EB, 0x75BADD6E, 0xB75BADD6, 0xEB76BB5D, 0xAED76BB5, 0xDAED76BB, 0x5DAED76B, 0xB5DAED76,
    0xBB5DAED7, 0x6BB5DAED, 0x76BB5DAE, 0xD76BB5DA, 0xED76BB5D, 0xAED76BB5, 0xDADD269A, 0x22ABA906, 0xA3645975,
    0xCA594AD6, 0x3154CAD9, 0x1DCE9F2E, 0x170940B8, 0xED343B59, 0xF2597C99, 0xA3062B34, 0x9750C465, 0xA10ADAD4,
    0x78E58C17, 0x0475BB16, 0x4F1D42B1, 0xEFC06D94, 0x62051CE1, 0xA89970F7, 0xFF2174B3, 0xDAAE0803, 0x1CD84D61,
    0x9B1E04C6, 0x83742D02, 0x893E97EC, 0x1589A0C0, 0x92C96714, 0x1036CB29, 0xA85D76BB, 0x5DAED76B, 0xB5DEEF77,
    0xBBDDEEF7, 0x7BBDDEEF, 0x77BBDDEE, 0xF77BBDDE, 0xEF77BBDE, 0x2F178BC5, 0xE2F178BC, 0x5E2F179B, 0xCDE6F379,
    0xBCDE6F37, 0x9BCDE6F3, 0x7ABD5EAF, 0x77BBDDEE, 0xF77BBDDF, 0x2F97CBE5, 0xF6FB7DBF, 0x5FAFD7EB, 0xF5FAFD7E,
    0xBF5FAFD7, 0xEBF5FAFF, 0x7FBFDFF0, 0x181C160B, 0x0582C5E2, 0xF178BC58, 0x488A2E55, 0xE5D429EA, 0xE2132912,
    0x10AA0A0A, 0x1AED3076, 0x0A145D53, 0x504834E4, 0x0576B08B, 0x5135FAE5, 0x70C5260A, 0x205173DC, 0x94F4967D,
    0x14CF5129, 0x74807EC3, 0x2AABD7CA, 0xE2EA05C1, 0xA9712282, 0xB3C28FF8, 0xB33A8480, 0x50B39584, 0x741C9393,
    0x12E5A059, 0xE5821862, 0x755EB841, 0xE7D7C5D8, 0x8D677C10, 0xAD136411, 0xAB178BC5, 0xE2F178BC, 0x5E2F178C,
    0xC6633198, 0xCC66371B, 0x8DC6E371, 0xB8DC6E37, 0x1B8DC6E3, 0x71B8DC6E, 0x371D8EC7, 0x63B1D8EC, 0x763B1D8E,
    0xC763B1D8, 0xEC763F1F, 0x8FC7E3F1, 0xF8FC7E3F, 0x1F90C864, 0x32190C86, 0x432190C8, 0x64B2592C, 0x964B2592,
    0xC964B259, 0x2C964B25, 0x92C964F2, 0x793C9E4F, 0x2793C9E4, 0xF2793286, 0x5485622E, 0xBFE98868, 0x053B079A,
    0x00A06E20, 0x23035858, 0x5918DB6D, 0x880B418D, 0xD90068DB, 0xEB164A38, 0xAA5EF326, 0xA0106633, 0xD3264EC9,
    0xAEC0C596, 0x992CA010, 0x2E814D90, 0xF0BB11DA, 0x896EB765, 0x2CFFF078, 0x7D5AD068, 0x4C2FECF4, 0x35FD12AF,
    0x5C05DDC6, 0xF15CE008, 0x04456405, 0xC7C43B08, 0x54733E8A, 0x2CF82916, 0x4F2793C9, 0xE532994C, 0xA6532994,
    0xCA653299, 0x4CA65329, 0x94CA6532, 0x994CA653, 0x2994CA65, 0x32994CA6, 0x532994CA, 0x6532994C, 0xA6532994,
    0xCA653299, 0x4CAE572B, 0x95CAE572, 0xB95CAE57, 0x2B96CB65, 0xB2D96CB6, 0x5B2D96CB, 0x65B2D96C, 0xB65F2F97,
    0xCBE5F2F9, 0x7CBE5F2F, 0x97CBE5F2, 0xF97CBE5F, 0x2F97CBE5, 0xF2F5DC59, 0x3726D853, 0x942E4904, 0x26251013,
    0x40C2DA08, 0x6C5CDA09, 0x42C0BFE6, 0xB68BF508, 0x792AAFA1, 0x110AF6BD, 0xC0038D40, 0x9F6E1709, 0x7C3DCD02,
    0x26D00F83, 0x03A806E4, 0x86BB2190, 0x24ABFA3E, 0xF8AB9A56, 0x3FE2856D, 0x441D90B6, 0x14061581, 0x85B8510F,
    0xB8A9C516, 0x2709FEF9, 0x701E636D, 0x84BA9C4A, 0xCB65068C, 0x26967CBE, 0x5F2F97CC, 0x663339AC, 0xD66B359A,
    0xCD66F379, 0xBCDE6F37, 0x9BCE6733, 0x99CCE673, 0x3B9DCF67, 0xB3D9ECF6, 0x7B3D9ECF, 0x67B3D83C, 0x1E0F0783,
    0xC1E0F078, 0x3C1E0F07, 0x83C1E0F0, 0x984C2613, 0x0984C261, 0x70B85C2E, 0x1B0D86C3, 0x61B0D86C, 0x361F0F88,
    0xC4623118, 0x9C4E2B15, 0x8AC562B1, 0x58AC57FF, 0xFFFFFFFF, 0xE047AAF2, 0x10F4733D, 0x212BAB13, 0x012D6E93,
    0x2C9041B3, 0x8AF96729, 0x94B65B06, 0x281A95C2, 0xE086029E, 0xCA031432, 0x64BE8E2E, 0xD7423974, 0x2962BA13,
    0xAC9FC858, 0x42C5C004, 0xF76A3DCD, 0x04FBAB42, 0x4A7F4CFF, 0xCEC0256B, 0x741B7642, 0xD41895DB, 0x82386342,
    0x3FA40159, 0x2BB9742C, 0x67A2DC0E, 0x9567DA0C, 0xAB42365F, 0xF2831425, 0x70BEDE8E, 0xBDCCA2D3, 0x1B60A138,
    0xBB3E81B5, 0x3B75BB28, 0x42B1DC54, 0x57631510, 0x88846AB3, 0x10900648, 0x2A4469BF, 0xCC84B6C4, 0x8496DF6C,
    0x853F4DCA, 0x2075FCD5, 0x7556DC2B, 0x28B4E9B9, 0x26A5425B, 0x2AC9F7CA, 0x420883B8, 0x536AE3B2, 0x3E39551D,
    0x31B4A257, 0x67BDAEA9, 0x5C148612, 0xB9771A4A, 0xEB703414, 0xF2F3606E, 0x0CA66E7C, 0x039823A9, 0xAA841B4B,
    0xB80B9887, 0x605AE566, 0x812FBE30, 0x669B3E01, 0x105FBEA1, 0xAE56AC94, 0xB4221184, 0xCB4697DC, 0xB29AF81E,
    0x164C292F, 0x43357D82, 0x86951768, 0x41F0FE51, 0x098EFF92, 0xD14CD1BD, 0xE4137B53, 0x16430849, 0xA807345D,
    0x3447AFEB, 0x1B801859, 0x56CA6701, 0xE11C10EE, 0xF96C7F8E, 0xE9B536EA, 0x150853BA, 0xA792997B, 0x85284E88,
    0x72B44616, 0xC56C255B, 0x767E5D20, 0x05981471, 0xE19E9C2F, 0xAB60DA41, 0xB1368E2C, 0x5B2C484A, 0xC6117143,
    0x08BB05D5, 0xD45A1910, 0x8DCDDA07, 0x74DA94CA, 0x0586BC08, 0x8855DB51, 0xE8E02851, 0x025FE7A2, 0xE9765125,
    0xACDB0266, 0xF6258976, 0xFE095C97, 0xCAB581F1, 0x655FAB5C, 0x91460AFD, 0xF41A4B9C, 0x5B3FF685, 0xB982FB77,
    0x06E58B21, 0x1AED36BA, 0x2D16D7A8, 0x78556CBE, 0x1106AF87, 0x8DD06170, 0x78584621, 0x5771A8E4, 0x20B8626A,
    0x175289E6, 0x096086BA, 0x45945C51, 0xC86420A8, 0x47FF5C8F, 0x04383A40, 0x805C6D15, 0x411117EA, 0x414EF89D,
    0x4B9B8585, 0x6BC01508, 0x2EB80B16, 0x8C64E87A, 0x03974749, 0x9F995675, 0xB1127A97, 0xBB91CD93, 0x49D8858F,
    0x855C142A, 0xB3521103, 0x343442F2, 0x682B3C10, 0xC4A12861, 0x73D58BB4, 0xD0512A16, 0x21AD36F2, 0x85DAD002,
    0x2160DF0D, 0x01E4A26C, 0xC9C821B0, 0x304485B3, 0x1A2C1DA2, 0xB155C812, 0x2C0E44C5, 0x02AC85FC, 0xA3870A36,
    0x7BD6100A, 0x2AE9CE10, 0xA161D70A, 0xC127B82A, 0xDE4603A3, 0x9BB70420, 0xB89E3185, 0xCDAC02E0, 0x66510A16,
    0x1CA38603, 0x818A2DC3, 0x040A091A, 0x53844413, 0xFE864246, 0x84289423, 0x851CE15E, 0xAE45B564, 0x78860A84,
    0x10E11E39, 0x31893869, 0x741762C5, 0x86A98037, 0xFF866A09, 0xAA303141, 0x1084845A, 0x85C1A2F5, 0xCAC6863A,
    0x94575448, 0x4CA40C84, 0xB0C22BEF, 0xCDEA8A3A, 0xBE2F2150, 0x50B94CBA, 0x7E0A7FBC, 0xAB6E462A, 0xE975EF42,
    0xB623ED97, 0x1C73F65F, 0x855A1646, 0x27F60C2A, 0x627631B2, 0x2CF6293D, 0x89208697, 0x8F053250, 0x702E120B,
    0x28152708, 0x4BA1DAB1, 0x5C31E494, 0x2F7B82B6, 0x0007302D, 0xC88B9159, 0x0AA6DD69, 0x012D6462, 0x4A4ED930,
    0x6C17EE22, 0xD9B1C2D4, 0xB2BBE500, 0x5707BB78, 0x2621482C, 0xE8104442, 0xC49C6C1C, 0x8341A8E8, 0x21386084,
    0xAE521BD9, 0x456E5062, 0x4CAC2DD6, 0x75FAC29E, 0x1F1D70D0, 0x21484110, 0x96BAA248, 0x2CC7658A, 0x413CCEA8,
    0x892F8028, 0x44726FFF, 0x6C632561, 0x4B854FFC, 0x9F94B652, 0x07B72BB0, 0xACBC6E48, 0xDE2BE3A3, 0x9956252F,
    0x50CE2A42, 0xC1D141A9, 0x00624654, 0x302CD1E8, 0xF8F6A7C8, 0x4749D235, 0xC5587B31, 0xDDD85745, 0x80BAC6F7,
    0xB806510D, 0x525C0909, 0x56B2C02C, 0x05DB65E4, 0xAE845694, 0x11CF7CA4, 0x6ABE290F, 0xC1AB9028, 0x04BC1CE3,
    0x4E5C1A06, 0x07D2DC0A, 0xD24743A0, 0xE2E2EAD1, 0xC171625C, 0xA10CD98C, 0x0AE11006, 0x8791D4D4, 0x0E5E9904,
    0x2EC4AC90, 0xB40DA99C, 0x84440BD0, 0xEBEB21A1, 0x422E5A0E, 0x809922AA, 0x86DAF605, 0x1A4D2F3C, 0xB974A005,
    0xCB6508A9, 0x72341E6C, 0xF62999D1, 0xC88369D9, 0x2637CB5E, 0xF2932585, 0xDA63753F, 0xC3721562, 0xEC1F2CDD,
    0x566431AB, 0x0C1A06AE, 0x3838252E, 0x0F6FFC08, 0xDEDE7B1B, 0x014BD782, 0xC0A71642, 0x5B528341, 0x00DCA175,
    0x3D4E0298, 0x32ED6416, 0xDEBB5652, 0x869C91DA, 0x04654530, 0x6567ACB2, 0x501B36AD, 0xDD4A0C6B, 0xAAB69F5F,
    0x2ECAAEA4, 0x29A55951, 0x721BA2E0, 0x15D93229, 0xAB0002CE, 0x0534BBB1, 0xFC1A5DA7, 0x8EC476CC, 0x30F10D56,
    0xB91A4E70, 0x12CCD2C1, 0x581424E0, 0x0A2AE940, 0x12EFA62E, 0x1E16842E, 0x4A6D1768, 0x144155A3, 0xAA115A08,
    0x434FD517, 0x2BB4A190, 0x4AAEABC4, 0x2B3BBAE5, 0x102ACD56, 0x10569C82, 0x231A1454, 0x960AAB33, 0x1C89287F,
    0xB8213385, 0x3BB218F4, 0xAB7A2B55, 0xAB9598EB, 0x2CB0AC87, 0xB100E528, 0x7AD20703, 0xFFC0E1E0, 0x701DCAE5,
    0xC90E2E11, 0x32ACDA2E, 0x28305DAA, 0x7FF8062C, 0xDB4FCE8E, 0x4E839286, 0x54562E17, 0x0B2AF44A, 0x9FFD0249,
    0xBAB56E08, 0x9595A89C, 0x8CBAC248, 0x48B92C29, 0x396758A0, 0x6D4908D6, 0x2108C82A, 0xC00F5623, 0xD562E15A,
    0x93834EB4, 0x18BDAABE, 0x6256A0E1, 0x4792AB85, 0x92E5B828, 0x55E39B85, 0x7736F3AB, 0xAC4BC60A, 0x431EA02C,
    0x2EBC4088, 0x9445EAE0, 0xBA48D26D, 0xE016A210, 0xE006473F, 0x96502361, 0x1B176B83, 0x5D805680, 0x928AEF38,
    0x288CD0D3, 0xFC6BB240, 0xBEB9650E, 0x76CAE2BE, 0x588134A9, 0x81625480, 0x32EB9645, 0x5D871481, 0xCDDDD83C,
    0x950085D4, 0x89B64AEB, 0x79281C07, 0x2816B5B8, 0x616AA00E, 0x85D77947, 0xFCD98E21, 0x0545D282, 0x70E9702E,
    0x12C42053, 0x9BB4A8A0, 0xB19B307F, 0xE72C6D1C, 0xA60E070B, 0xAEF755F2, 0xB6990097, 0xDD8BB562, 0xE9D02363,
    0x9A5DC488, 0x3042381B, 0x54509BA6, 0xC9DC8589, 0x73891118, 0x0FEF7B26, 0x7907876B, 0xDC28A3A9, 0xB0505C84,
    0x4E0F5558, 0xB005B8BA, 0xD2B80E95, 0xA5006828, 0xE106B8DE, 0x9255E34A, 0xD092E327, 0xB62EB255, 0x0A126881,
    0x1CACAE16, 0x106E0CDA, 0x81B35C1E, 0x09F27A11, 0x98C9C5B9, 0x4CAD1600, 0xB95266AE, 0x62E597EA, 0xEE290859,
    0xBFBB196B, 0x3CD65A88, 0x7C11CB4B, 0xE76421EC, 0xCD5D3717, 0x5516C169, 0x29745DAE, 0x2A10A660, 0x9D751C04,
    0x8041F2C8, 0xE7E299BA, 0x360A5811, 0xD74825C1, 0x8D1C054E, 0x2ED793DA, 0x8AC16093, 0xD0D9D5D8, 0xB8C7068E,
    0xB7D72C17, 0x93ADD188, 0x2A2EFFD6, 0x39A3E411, 0x8504B390, 0x41B6A06E, 0x0AB19362, 0x2CC76C8B, 0x78653E59,
    0x642855F7, 0xC145D509, 0x6C14094F, 0xF731D84C, 0x8EA856CE, 0x470461CB, 0x595AA244, 0xDD1448D9, 0x3DC45C89,
    0x5C275DA8, 0x18301250, 0x4B4BB84E, 0xC2C9618C, 0x00513A90, 0xC0201961, 0xCA9A2E7A, 0x2AC32F98, 0x05C81927,
    0x21325EC9, 0x058BFF14, 0x8876C197, 0x21D209D5, 0x1490B847, 0x9EF170AA, 0x0DAF5843, 0x3597A7C5, 0xA5D6ED07,
    0xBB1FEB19, 0x47A50C61, 0x7F385744, 0xAADBB5B3, 0x10C41D92, 0xB25772ED, 0x2602FD18, 0x5EC7175B, 0x8BFCBA72,
    0xAC2E54E0, 0x3A263477, 0x9C4312E8, 0x4301BDE4, 0xA897938C, 0x04B79BA0, 0x0F16877C, 0x8A1DCADB, 0xF5C10F42,
    0x2A3966C8, 0x600B7E2E, 0x30FFDB16, 0x8C964B7E, 0xC68856B2, 0x6D80E9B4, 0xD94C8A2F, 0x5C1623DC, 0x791DFB09,
    0x02E4B280, 0x55D975AA, 0x4597A22B, 0x15B61638, 0xBA554240, 0x20500855, 0xAEBE040E, 0x29C0A7C4, 0xB9250B66,
    0x1D1A188C, 0xDB812511, 0x6AC9AA54, 0xD26B61A6, 0xC2704DA4, 0x22B6EAC5, 0xEEB17612, 0xAE306C69, 0xAC99098E,
    0x59904237, 0x0220B9E4, 0x21B55B4F, 0x6A6AE8A5, 0x016EC9A2, 0x2151F2AC, 0x24046D60, 0x392F35E7, 0x995E2A9F,
    0x9BCAC1A8, 0xF56DDABF, 0x714E0D30, 0x6553E9F4, 0xC0618030, 0xD0C4292D, 0x76E0269B, 0x53EBAE88, 0x14250CF7,
    0xB5A280A5, 0x61621895, 0x78811742, 0x8D483141, 0x204E345C, 0x4E6078EC, 0x4854302C, 0x136E1060, 0x69C0F571,
    0x48916E19, 0x5AE97E29, 0xFF41D052, 0xB775CFFE, 0xB24FC1B7, 0x69F36669, 0xA52EB409, 0x078D2137, 0xBDDA4B8A,
    0x0A5D4886, 0x3C94DA6D, 0x4B474A6E, 0x0705F376, 0x6421649F, 0x04D58AC3, 0x19B18E45, 0xA416362B, 0x51FC6883,
    0x95DC4933, 0x6B254ABB, 0x12BB0BAE, 0x16009DD9, 0x042693B4, 0x2CC8A8FE, 0x69AEF7AE, 0x1B9E766B, 0x054C0576,
    0x06998088, 0xA1458967, 0x729C0F44, 0x828AE651, 0xDC2FAE24, 0xC5235930, 0x39C87C18, 0xBD8736DC, 0x5374BA2A,
    0xB85C29B6, 0xC0D24ED4, 0x289B4DAD, 0x18F049D8, 0x1B3518CD, 0x82797175, 0xE9FB4D01, 0x17718B58, 0x11755B78,
    0x7BDB40E1, 0x3449A271, 0x9369375C, 0x24242B4A, 0x847FB849, 0x54292055, 0x36C87A44, 0x0B8A6630, 0x94D98863,
    0xB8A472C2, 0xF46537FE, 0xD055A124, 0xA8189627, 0x292F1757, 0x50D0B7BD, 0x2F2E7B67, 0x27A086AA, 0xFD992226,
    0x54A11EF1, 0x764DC2E2, 0x6D4BDE41, 0x52681289, 0x4770A442, 0xE0B642B8, 0xA6AE303E, 0x08EF2A22, 0x82B33904,
    0x06CA2057, 0x445C105E, 0x3159B229, 0x2819DDB2, 0xB07A66A5, 0x680BA51A, 0x35517614, 0xD76B282B, 0x642A1876,
    0xA4C31299, 0xB78C0E3F, 0x0092898B, 0x37769328, 0x9CC93483, 0xAB274AC2, 0xA8C1385B, 0xAE6DB252, 0x7AD188BE,
    0xB43C6A67, 0xA66A2C04, 0x48BAC892, 0xC8692FFC, 0x8A7326CD, 0x93509B0B, 0x86CD7DA4, 0x094D467B, 0xA12974C6,
    0x5421AC69, 0x1054A2EC, 0x282384CE, 0x6853D088, 0xB228AB65, 0x24A8F3E5, 0x7294A11C, 0x2F1168A9, 0xA1CD796F,
    0x18E091D5, 0xF287FD86, 0xFF56BC49, 0xA2D312B6, 0x8A12CBE4, 0xA9EB570A, 0x38535643, 0x1848B441, 0x4960E0B4,
    0x7BAE55B0, 0x32EA3D9A, 0x7FAC2C90, 0xB92B8A07, 0x2E84B3A0, 0x6896A43A, 0xD4F96A8B, 0xCA2B8A6A, 0xC6791E1C,
    0x045758C7, 0xFCBC02BB, 0x2625E79E, 0xF353015C, 0x3F34362E, 0x67762B63, 0x29112740, 0x59DEA86B, 0x456D8D6C,
    0x8325E64C, 0x3B93FD5B, 0x17A02081, 0xB662ED0D, 0xE4CE405C, 0xAC2A70C9, 0xF17C7F57, 0xE5EE0B9B, 0x41827125,
    0x97CC69A2, 0x85361818, 0x0205182D, 0x79C55801, 0x37403792, 0xDB436C1E, 0x4C16E1C2, 0x0DE84478, 0x02187084,
    0xBB228D8C, 0x414D2690, 0x86229A44, 0x338C92E5, 0x90B93E83, 0xCBCA64C9, 0x5AB8D543, 0x1F07D5FF, 0xFA0D6054,
    0x63A26DA2, 0xEFFA18E1, 0x5F25D3EB, 0x1562EC59, 0x0850488B, 0x2918B3E5, 0xB4995EBB, 0x26A6A80A, 0xC1771E26,
    0x82CD8F4A, 0x27641254, 0xADA10A15, 0xF177F834, 0xEB9E39D8, 0xAE5782C1, 0xD40A0937, 0x0F193751, 0x638E0502,
    0xAE2C6047, 0xF4321B0B, 0x6BAE232F, 0xF7029A15, 0x163A3DBC, 0x828AD84D, 0x86910D51, 0x560FEB91, 0xA202135E,
    0x021A280B, 0x5AFACD1D, 0x6265CA94, 0xB6940D43, 0x2896CA21, 0x0A017AEA, 0x38508B73, 0xB24BA0DB, 0xB0C67E57,
    0xB6572EC0, 0xD821EE9D, 0x843FD899, 0xA862621A, 0x4AA23E5A, 0x09689810, 0x3B2B83B3, 0x5BD8CF00, 0x097E04C6,
    0x130E4115, 0xE57C8927, 0x6E319D6B, 0x515A1CB0, 0x5A639F8D, 0x826F11C8, 0x364061C1, 0xD711880A, 0x52D5272B,
    0x9149D0DF, 0xF3152692, 0xA8B85DE8, 0x6E1AEA14, 0xC6C047C9, 0xB0D2CFF9, 0x66B2D45C, 0xCB13838A, 0x8598D968,
    0x57CDD84D, 0x05F22B06, 0x6E725DA4, 0xA39CB4BE, 0x0B6B884E, 0x176887D8, 0x995AFCAA, 0x57E5842A, 0xC141160F,
    0x448A41A2, 0x873812EF, 0x4CAE1A1A, 0x0F700BEC, 0x5CADB640, 0xDF22955E, 0x3ABB2F06, 0xB81813C2, 0xF178BAE7,
    0xC1A25200, 0x9BEC94BB, 0x85B839C7, 0x5613EBE1, 0x5B004BE7, 0x02F94AE0, 0x116B2F07, 0x87C5084B, 0x0222ED96,
    0x31D59420, 0xDAC2C484, 0x17C25C00, 0x89A8188E, 0x0029A1B0, 0xAE8282CA, 0x2C1F385C, 0x5983EB7B, 0xE21832AD,
    0xAF5752B3, 0xC0663A04, 0x2D5C9F50, 0x8FF40C0D, 0xFAB39159, 0xA3A2D514, 0x956AD840, 0x3EA54558, 0x242EDB43,
    0xB0243FE8, 0x8C4AC60A, 0xA926D8EF, 0x88443654, 0x836BB913, 0x52075A43, 0xFC8DFFC7, 0x11E5E934, 0x315E54B9,
    0x47A06ECA, 0xFBCBDE70, 0x60B11772, 0xC5D188E9, 0x3A744399, 0xAC2425A4, 0x00AF3037, 0x93E6EB58, 0x5D5B0697,
    0xB0521968, 0x192838D1, 0x9C66A2B2, 0x517312B6, 0xE08608BE, 0x584AB65C, 0x86C4B1C1, 0x21E05043, 0xFE1EDC84,
    0x1A5EEE84, 0x74256022, 0xCD4825D6, 0xE441D3F5, 0x9A852999, 0xECF6B3CD, 0xB97D5D40, 0xABE01728, 0x01F1476C,
    0x0FD5B3C1, 0x9434E156, 0x0A231FEC, 0x44F380B5, 0x1C0B1CDC, 0x00384B51, 0x172E79CE, 0x211BA764, 0x1C1C2372,
    0x5138E2C8, 0x6434084D, 0x9464AB55, 0x684C3A86, 0x60F65292, 0xD5A385D0, 0x3C12B9AF, 0xA816E505, 0xCA194E13,
    0x437FEDC2, 0x887A1ABA, 0x6C0C3855, 0x622853C5, 0x7D875DDF, 0x9C290A1E, 0x5D4F1DB6, 0xA1813646, 0x1DAF286A,
    0xAE400522, 0xC47312ED, 0x77AF3600, 0x34345202, 0xE4230FDA, 0x31CFF0BC, 0x29720DBE, 0x566B179A, 0x25726300,
    0x133015AF, 0x765DBA34, 0x86188B43, 0xF612B3BF, 0x2ED5CA64, 0x16E8D7E2, 0xE6BD61BA, 0xE52A7945, 0xA1A084AD,
    0x278B52CA, 0x9B5C4329, 0x9236C029, 0x86A469F4, 0xF26E44AE, 0xD1E02B39, 0x54D25D48, 0x60E58B41, 0x89609702,
    0xC7E52E48, 0x0C184E87, 0x15062C4F, 0xEA5140A4, 0x528D0211, 0x920B164B, 0x1D813B97, 0xA0D8F6C0, 0x68341B2F,
    0x49A54187, 0xA8DC7EBE, 0x8643336B, 0xD3D2518D, 0xB18D7B14, 0x1680E06C, 0x6C026C31, 0x98CA8313, 0xD1B99BFF,
    0xFFA8D50B, 0xAA64B51D, 0x78BC0A21, 0x4B314CB5, 0x476CACDB, 0x0A082BB5, 0x64F4093D, 0x42ADD590, 0x380AB171,
    0x522417C3, 0x6581C10C, 0x42470826, 0x8D6C5ABD, 0x4E847DA3, 0xA124C1B0, 0xB1742647, 0x5A18D72C, 0x915E812B,
    0xB1188466, 0x29F8462B, 0x97B122A0, 0x70018D0F, 0x2E7C305E, 0x20F53484, 0x120CB9C4, 0xD751D775, 0x5DB16613,
    0x135D408D, 0x010CC293, 0x7957BE47, 0x68408DC2, 0x245034A5, 0xD7394B86, 0x48F8ADB7, 0x4DB290B5, 0xCE41BD57,
    0x5392E17F, 0xFA4B8680, 0x933B2405, 0x86C25401, 0x4429363E, 0x4E722408, 0xA1EE3C3F, 0xD02B3FF0, 0x6A4C9681,
    0xA01FD556, 0x32FD4EE3, 0x6D250066, 0xAF430DB3, 0x28F71680, 0x614425A5, 0x4C244F9C, 0x13CA66EB, 0xB24609FF,
    0x458DCBB5, 0xE97CD429, 0x92AF8F4A, 0xF7026AF4, 0x048E162D, 0x66B5FB89, 0x2EDA53AF, 0x0BED8029, 0xC10AB0E1,
    0x268E3062, 0x05CACEB0, 0x8681A150, 0x8844A104, 0xBE86BEBB, 0x96814066, 0x09EEFD2F, 0x294C075A, 0x118AFF63,
    0xBC9B8ED7, 0xC625D852, 0xDD804D6D, 0xE2AB6204, 0x2873375A, 0x14401675, 0x4AD56EAE, 0xB5C17365, 0x0DC32983,
    0x2FA2B24A, 0x684A1076, 0x5D14212B, 0xA42BB1A1, 0x150A4321, 0xDF6C434D, 0x70D28447, 0x219F0968, 0x2C740C02,
    0x44806D84, 0xFBBD7286, 0x841E812B, 0xB718EC41, 0x675120BD, 0xE5576431, 0x61BA5342, 0x0F6E3945, 0xBD755AAD,
    0x3B20EE10, 0x6449FCD0, 0x8F3E5EAE, 0xC30951CD, 0x073C360C, 0x6F574421, 0xB96A2E6B, 0x5A6F4844, 0x2353FE5C,
    0x91348B05, 0x6BC8BADA, 0x02641107, 0x87C22B48, 0x591D5A40, 0x32C7AC6D, 0xC72F525A, 0x126DAC85, 0xA2D0F571,
    0x3184D88D, 0x211A1A3F, 0x3814AE5F, 0xF0A7D0F6, 0xBE3424DA, 0xEE297BC9, 0x545C8825, 0x91AEB773, 0x85E2B715,
    0x4022E334, 0x133E75A9, 0x6E812DC9, 0x2925CA16, 0x6996C51A, 0xB250ACA2, 0x2CDA49B6, 0x27E3A727, 0xC6499352,
    0x5F095E75, 0x67022C00, 0x57BB6108, 0xE8610359, 0x9554284E, 0x05B7231A, 0xE82347CA, 0x0CCD2C89, 0x0CBD82C1,
    0xBCAD5901, 0x16456149, 0x5DB80EE8, 0xF765B8E9, 0x08F2B6D6, 0x3FF5D423, 0x1190AB56, 0xA0C02571, 0xD2D16801,
    0x2CAB4127, 0x63B1D824, 0x8BA4E485, 0xA8B45A2E, 0x92576502, 0x59481B61, 0x1C4C7389, 0x108975C8, 0x97FE0CE4,
    0xB8C75A8D, 0x0C301EE1, 0x6EA20191, 0x27A7984A, 0xE263A221, 0x0047833C, 0x06980E95, 0x5291E9B0, 0x650260AF,
    0x59DDABB0, 0x096D8E64, 0x0F8EA3A4, 0xE0F07CE0, 0xD0693E15, 0xD08A7BB3, 0xD1898D45, 0xB756B70B, 0x6D609D03,
    0x9B1F32F6, 0x8A0DBEDB, 0x5C39B1F3, 0xD6C3E5DA, 0xB04C04DA, 0x01D515AB, 0x0A6176B8, 0x5D8AB2AA, 0xFA404525,
    0xA259EBAA, 0xD3E230F8, 0x579B496B, 0xF94851F0, 0xBB8A64E5, 0x03D92A54, 0x00515DCF, 0x5761F45A, 0x103548A5,
    0x23020A50, 0x9849DA08, 0xD14310BF, 0xF44A0589, 0xE26306A9, 0x286B8372, 0x42D28443, 0x21C50393, 0xE57E044B,
    0xAA2194E8, 0x1891758C, 0x8F31D620, 0x87314A92, 0x2D799956, 0x0C606A21, 0xA2B26206, 0xD61024BF, 0xFD50965D,
    0x46D7EC55, 0xF425E954, 0xF6405CAF, 0x2F6015C6, 0xC07CB111, 0xD44A2B04, 0xF80567B8, 0x59CD3155, 0x12649A85,
    0x40BA1B76, 0xDC1C3204, 0xCD6EC009, 0xAC463986, 0xED761CDA, 0x59684300, 0xF0FA2B27, 0x5AF3C0E2, 0xC95002AD,
    0x5BE2E9A4, 0x252D4CBB, 0x6461D7A0, 0x98C24B60, 0xC75B8013, 0x41447166, 0x591242B4, 0x03B206F9, 0x041E144E,
    0x20A1C2AC, 0x809A5328, 0x5D2ED9D9, 0x49C2732C, 0x7735BBDC, 0x25583173, 0x454C8621, 0x4B2D6DD3, 0x0DD94607,
    0x2590876F, 0x17BAD056, 0x8B5598E0, 0x80228561, 0x0AA49A5C, 0x2E072268, 0x39F8AB2E, 0xA169C815, 0x12157D4C,
    0x16A2EF27, 0xC3999AA3, 0x5108A9AA, 0x383C18D8, 0x8EA6979C, 0xE049711A, 0x320D708F, 0x108A1FF2, 0x85B10494,
    0xBA66AD75, 0xF7BDC2EF, 0x20221110, 0xE9E55AA5, 0xF3556108, 0x60875821, 0xA6D47340, 0x8A22EC80, 0x8CA9EF1A,
    0x93A89889, 0x7673E45A, 0x94599A48, 0xE0D85D24, 0xAB929955, 0xAA05D309, 0xA55B6C7B, 0xA9D5A84C, 0x11D8D88F,
    0x4517AE0F, 0xDC7AC69E, 0x3497B1C4, 0xEE80A505, 0x1C078115, 0x92B4E418, 0x16ED9334, 0xA5DFA140, 0x9DE1A542,
    0x224FE6D6, 0x8A0035BA, 0xF727A595, 0x253BA8B5, 0x0AD8B78F, 0x08B7149E, 0x5E98483E, 0xC2CE35F7, 0xDAE54EE1,
    0x85D3118F, 0xE45DD156, 0x59229A8B, 0xB5EC683D, 0x5A05A0AC, 0x8D56898A, 0x381F25AC, 0x5B6DD274, 0x9C84AAB5,
    0xAEAC5F2F, 0x95A83C1E, 0x0F5883E4, 0x459B35B7, 0x1B25B72D, 0x4AE552BC, 0xD82E8423, 0xC97FF533, 0x054A2576,
    0x478BAE25, 0x52A85EE3, 0x4E92DFC1, 0xA89A2024, 0x3D4B9282, 0x45C4F394, 0x4A92883B, 0x04ADD4D9, 0x69172722,
    0x17D0C051, 0x754A9A8A, 0x9AC12B4C, 0x45012AF1, 0x6A93432A, 0x20C8E004, 0x0DD80B1F, 0x25D46694, 0x1BD11F42,
    0xC1C15272, 0x52809A4E, 0x7F00AE20, 0x65763340, 0xC68F6A2D, 0x6E085088, 0x3E86C25F, 0x5D30D682, 0x10A120FF,
    0x5C9354EF, 0xF1140C82, 0x83CF5C04, 0xC0FCACD0, 0x4B9406E0, 0xDA1385D2, 0x10BAA84B, 0xC483D60B, 0x6A3CA6AA,
    0xAE84DB45, 0x00A24495, 0x28B7CDAD, 0xC82380B9, 0x0D9C0925, 0x0296F1D9, 0x5F1CDA36, 0x141D2823, 0xE2010286,
    0x3D806865, 0x8AC1A44D, 0x26A184CC, 0x55D512D6, 0x4F44B7D6, 0x5A143610, 0x36ED6645, 0x7FE3EA2B, 0x44BC5C3B,
    0x28A12202, 0xDAC5831A, 0x5839322D, 0x8D014581, 0x7D7C6B91, 0xEA64F3B2, 0xAABA4A48, 0x9C0D3924, 0x2489BC5D,
    0x879B9107, 0x5AEBF48C, 0x7CBA236E, 0xE09C91A4, 0x92B9850B, 0xA4A53CA1, 0xAACCBB09, 0xAB4D376A, 0xFD22B8CB,
    0x010286E7, 0xC280798D, 0x5CB721AE, 0x5905AAC5, 0x108DBB1F, 0x1726C091, 0x1D12AD97, 0xAB6EA604, 0xB8EF16F3,
    0xCBDA10B6, 0xBB865153, 0x5C12D7E5, 0xB972B9A6, 0xB176BB0E, 0xD4B703D8, 0x9D708590, 0xDBC26580, 0x9B741A13,
    0xA79CCAE8, 0x601006BF, 0x5B2C3EEC, 0x6C0BB164, 0xE6421D54, 0xC5D6ACBC, 0xD9E88A8A, 0x476F359C, 0xA0ED7575,
    0x09825203, 0xAB8429FF, 0x0A463F71, 0xF777A659, 0x1D9773A3, 0x9EF7D42A, 0xD3243AFF, 0x976DB360, 0x6D4EA725,
    0x5AB01F14, 0x4CA4568E, 0x49B442E6, 0x88C299C8, 0x2797B8A1, 0x72C3B392, 0xD51D2683, 0x30C5CD00, 0x3A11000F,
    0x5F5CB18B, 0x7B88C00E, 0xA6B8111E, 0xE44855C2, 0x4D5D8467, 0x41D6EA51, 0x292F76B8, 0xA3AED701, 0x3352248A,
    0x633C4788, 0x531A655E, 0x2D57A181, 0xE31A4035, 0x1C4F1C82, 0x812BA072, 0x9C5D9081, 0xC5DE2F7B, 0x3A44486C,
    0x55E0C552, 0x541AA686, 0xEE5C21DC, 0xCD02311C, 0x76B4719C, 0x14404831, 0xCE007454, 0x1CE9F68A, 0x8A44A02D,
    0xB2005739, 0xC24CC9F0, 0xA3A229B0, 0x89742402, 0xD85790DB, 0x0C76EAE3, 0xE03EF881, 0x15D01024, 0x1DDA910B,
    0xAF611211, 0x6929AAA6, 0x6E93A185, 0xB945A822, 0x8F5D0C92, 0xED977854, 0x865FFF80, 0x0BA78B9A, 0xEAFB1CC0,
    0x0205C1E1, 0xF8503729, 0x76B39F42, 0x728B0ACF, 0x1A4E5AD4, 0xC3A44445, 0x2ED8BEC6, 0xA24C7724, 0xB9CCA19A,
    0x70B0A407, 0x58BBECF9, 0x0284A104, 0xE8131B20, 0xBAF78D57, 0xCEA89339, 0x2AE22E39, 0x9A4ECADB, 0xAC3B1709,
    0x5A0B6EB0, 0x842B6329, 0x25855314, 0x900445B5, 0xA334C84C, 0x6B8AD189, 0x76070780, 0x576EC573, 0x81C2E0F7,
    0xA542EACA, 0x8640DE2A, 0xD62EA892, 0xE5D93DDA, 0xEAB88483, 0x98906023, 0x09868BB8, 0x5BEA6FBC, 0xB5B16EBA,
    0xA3D81093, 0xC47574FE, 0x2E07C52E, 0x20FB241B, 0x0928484F, 0x2AD56AB5, 0xD8C17001, 0x824141EA, 0x42213D51,
    0x333E2ED2, 0xA09D8410, 0x130F3416, 0x2B8B0DF6, 0x9011502E, 0x4C5044B4, 0x13FEA990, 0xA8C8456B, 0x343876A3,
    0x08951EE5, 0x4A40241A, 0xC42B94CA, 0x70A33A91, 0xED9898CB, 0x290AD089, 0x09ED2660, 0x5DEBA2EA, 0x1BCA6C80,
    0x0CBE6875, 0xDB06571D, 0x3A623D90, 0x2F197A0D, 0x902857B3, 0x15A4B851, 0x72E507AF, 0x4DB2F764, 0x212D0886,
    0xC7E0CF90, 0x87E8E66B, 0x7F342B64, 0xB4A42838, 0x5C9C06D7, 0xED90BC9A, 0x466C6177, 0xCC6C307B, 0xFC172F1C,
    0x8154C1A3, 0xB4DDDEC3, 0x9251200F, 0x6682BAB4, 0x1A2E9433, 0x094B9261, 0xBB27849F, 0x2186C7C5, 0x2C015F92,
    0x7B3023EC, 0x261492CE, 0xB281409A, 0xE9F71845, 0xC64A2536, 0x0F476251, 0xCC944A46, 0xDDAED6C2, 0xEC18DD82,
    0x5A9BA60C, 0x642400BD, 0x67418DA0, 0x0B0303E4, 0x1B00B38C, 0x2D98DBB7, 0xFC7B1242, 0x014CF532, 0x1212CE50,
    0x284B4E95, 0x26822668, 0x07AB0357, 0x3593E2E6, 0x6C562C35, 0x2EAF8681, 0x8EBC44BE, 0x10426A6C, 0xB5DAEC2F,
    0xAEB85D03, 0x497DC01B, 0x9503958C, 0x6B9CBDFE, 0xBB31AC32, 0x26E1917B, 0x220CE042, 0xC265A0D2, 0x140E5889,
    0xA1D76BEC, 0x902AB695, 0x5DC185D6, 0x7848F9EE, 0xF81EB3C5, 0xA128732A, 0x12E0B4AE, 0xE5CAE867, 0xC1DAE0C9,
    0xCA4020F6, 0xE1E97614, 0x8D472CB0, 0x77C6B641, 0x0E2E2398, 0x32D7034C, 0x28E6F759, 0xD4C0B097, 0xE1741A1E,
    0xAC1A08A0, 0x5BA9BD1C, 0xDEB25041, 0x25DC5A38, 0xD336248C, 0x08C899C1, 0xEEC05301, 0x5631F97B, 0x8AC8C74D,
    0xA44001B5, 0x844274DD, 0x5F31A055, 0x25D4B598, 0x9E91A432, 0xA638BFFC, 0xB20D766D, 0x640DE669, 0x4572132F,
    0x0A1FC60A, 0xD96CB52C, 0xC816AB70, 0xB5DBA4D3, 0x070083D8, 0x1B437421, 0x144353AF, 0xB3B296C9, 0x70B69EAB,
    0x51BD0F94, 0x8B39CA86, 0xA90A222B, 0xA8E56DAA, 0x6C252742, 0x2D221080, 0x2680862E, 0xC0F285D9, 0x7AB6A685,
    0x09D05450, 0x406D7EBE, 0x84442C10, 0x8383F0BB, 0x284409E5, 0x10C4619E, 0x551C4F12, 0xBE22CE17, 0x8C006290,
    0x7F954439, 0x7598A165, 0x87B16508, 0xAD0B3341, 0xEE7C484C, 0x0D383829, 0xA72C4953, 0x15DBB705, 0x1AE40229,
    0x45AF5698, 0x556B2308, 0x846F1F2E, 0xC429B05C, 0xFF483DD9, 0x32EA5C22, 0x101C0E3F, 0xC2F0158A, 0xC5D86F16,
    0x232015F6, 0xC84C250C, 0x0D285B4B, 0xB1E3057A, 0xA67C9B47, 0x2D1FFACA, 0x18EB5C2B, 0x4856AC09, 0xB4D8D983,
    0xA391ADC5, 0x0BA40A01, 0x598E4D15, 0xE0455205, 0x9A84A542, 0x90C17611, 0x9E5194C1, 0xC1D17765, 0x6D669884,
    0x7A15E5B7, 0x100C7D82, 0x2C470269, 0x5834CDD8, 0x715B66DD, 0xEA62395A, 0x3D1CBE85, 0x0C210BBA, 0xE5F1A204,
    0x5A82AC77, 0x52B015F8, 0xDE5CCA0B, 0xA7BA09B9, 0x135829A1, 0x11160B51, 0x995AAF43, 0x4DA946F9, 0x69FD0907,
    0x5A614AEA, 0x3149A5BA, 0xDE22CDB0, 0x65823142, 0x125D4003, 0xA435D848, 0x3D0884CB, 0xA1E12AFB, 0xA6392B69,
    0x085DA156, 0x009A22D5, 0x28406265, 0xF2F2A9B9, 0x676A65D7, 0x705602C1, 0xB0F69FC0, 0x4865E603, 0x73215A29,
    0x55CE0031, 0x74259CF9, 0x3856A955, 0xACCC9580, 0xA0B9362B, 0x7FF5F1EA, 0x12A40531, 0xDD716054, 0x725A9B80,
    0x3DA7F169, 0x1BA4002E, 0x0D14D22B, 0x35885A1C, 0xAC86AC57, 0x4F860024, 0x02806CB7, 0x2A81F696, 0x1336E86E,
    0x97E255A3, 0x9B68E608, 0xC24323A2, 0xC6805226, 0x9C9D3490, 0x8F6634B8, 0x35710150, 0x04496C60, 0x2DB16161,
    0xAB8BAC16, 0xCA5D12E8, 0x0F51B121, 0xD4A4260E, 0xCD0B4684, 0x4FEB262A, 0x05928448, 0xE5D93000, 0x24C9663A,
    0x18DD6BD7, 0x08512D5B, 0x070B808B, 0x175AE5B2, 0xBB0939E2, 0xE5E6C1ED, 0xC0BAAD46, 0x852D85D2, 0x2A10B317,
    0x304D8B2C, 0xE04DDC5C, 0x7C831740, 0xF59434DA, 0xEC5C021B, 0x8DCF73FE, 0x48136CB5, 0xE4CAC59A, 0xCBB87463,
    0x8BAD01A5, 0xDA9B355A, 0x0ECA18EE, 0xE1E34584, 0x5C3B477F, 0xC0869CAD, 0xDADB76B5, 0x9F2ED49B, 0x9136B853,
    0x35007280, 0x23CD850A, 0xB2CBD829, 0x07A5CC5D, 0xA2638922, 0x2CDFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFF91, 0x45C633CB, 0x78A0BB42, 0xA129E6CA, 0x9852B88F,
    0xBB04D229, 0x106D7522, 0x8EA7A2E9, 0x05028284, 0xD35C9A0B, 0x910F15CB, 0xDE705D01, 0x678B3098, 0x10288AB9,
    0x862191D4, 0xFB5DDE00, 0xADB7E713, 0x64F51CD6, 0x008BFFDC, 0x2E08BC1A, 0x9893001B, 0x9991C90B, 0x86250938,
    0xFF8B9971, 0x6014245C, 0x7C171411, 0x2C4068DE, 0x9F6C3B5D, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFF0728, 0xD8C7CB90, 0xD2B88E24, 0x860AC76B, 0x95DEBF5A,
    0x9B1D8634, 0x3AF4716A, 0x8434A1A5, 0x6730F07A, 0xE16EB621, 0x15B494E5, 0x224B70A7, 0xB02C262A, 0x48B10950,
    0xC8012C37, 0x0770BB20, 0xB5BA2E81, 0xB3CCF5DA, 0xB9FF485C, 0x68525445, 0xC0FA0DB9, 0x4A100554, 0x42C6D862,
    0x46D7EBF4, 0xF60E2671, 0x725CD42B, 0xF69B83DC, 0x62BEAEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF70425F, 0xEED8DB7D, 0xB41AE33E, 0x326E4C32, 0x15E2ECAB,
    0x0A2E4ECB, 0x79E5E2E4, 0x6C342B57, 0x7360C585, 0x69693C91, 0x6B8A3811, 0x9AEF283B, 0x426E15A5, 0xAA12E170,
    0x3FE35873, 0xC5CA2968, 0x86430950, 0xC86B65D7, 0xFE210788, 0x5E621433, 0x26ECB516, 0x24566DD4, 0x6A4516AD,
    0xB057D0AC, 0x956E3917, 0x005A5B04, 0x2C13B0A8, 0xBACAFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFD, 0x945D79C2, 0xA14D12ED, 0x7D4CCA17, 0x16614CA6, 0x03430AEB,
    0x2C201146, 0xDA4D38FA, 0xA13D0B8E, 0xF701DD76, 0xA4D04311, 0x2D8C6B65, 0xBC5B6C43, 0x5B0776C1, 0xD05EA8C6,
    0x1DDB096B, 0x92C322EE, 0x21850AAA, 0x997CA7FD, 0x90040854, 0xC1A2A649, 0x1F066924, 0x962EE293, 0x1066EF43,
    0xA3CE0AF5, 0x902916A7, 0x95854D66, 0xD36A6239, 0x17FFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFA09, 0x1D6CA7C9, 0x6BEABB5A, 0x05027BB1, 0x142CD5AC, 0x5B95AE84,
    0xC6211088, 0x4420B858, 0x2C3B5AED, 0x96204DFE, 0x6C27175B, 0x11D4A5A2, 0xD0630B9B, 0x265C28DB, 0x70E2F35C,
    0x18C01BA1, 0xA1C42AF3, 0x6C77142B, 0x770FF87B, 0x0A4418A2, 0x8A076B62, 0xDDE4675B, 0xDB16EB73, 0x3A5072B4,
    0x1C9BA121, 0x01B1D921, 0x62BC7FFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};


/*
**  Total 580 DuoYinZi included.      (580 * 9) / 32 + 1 = 164
*/
JUINT DYZCODETOYJ[] = {
    0x285C2A8E, 0xF7784DE2, 0x1378BC9E, 0x40C0984C, 0x28FF7FBD, 0xC14F87C0, 0x19FA130E, 0x4D2FB25C, 0x65FF161E,
    0x138542F2, 0xFC6E3805, 0x8FC7A385, 0x935208B2, 0x6C2B84D9, 0xB359B156, 0x28740197, 0x8A25F421, 0xF90B183E,
    0x1F526959, 0x3A6D3494, 0x4A278909, 0xA4BA954D, 0x0370AE3C, 0x5FAFC2EB, 0xDC1AFF31, 0x9D4BC843, 0x8A12EC02,
    0x48C251C0, 0xB0025CF8, 0x7C4198CE, 0xAD039341, 0x0E67AF1F, 0x902F7392, 0x7ED47D80, 0x403185E4, 0x49A51294,
    0xAFC0EC10, 0x4485B920, 0x90CF0A91, 0xD624217D, 0x1666C41A, 0x1117947D, 0xA8BD0131, 0xAF912618, 0x21C8E86E,
    0x409AB175, 0xD692F957, 0x78552D16, 0x0A9552E5, 0x6AB85ACE, 0x9726C52A, 0xA552C268, 0x55990D06, 0x8302DCD0,
    0x673198C0, 0xD06D59A4, 0xC0603497, 0xED56CB69, 0xB2D96D3B, 0x1A8D46EB, 0x808B2A5B, 0xB62DC507, 0x7BC41209,
    0xB5BEC241, 0x3A9BC028, 0xF97E8241, 0x284AEA11, 0x0884B141, 0x6D860432, 0x510F3142, 0xA3A0EEE4, 0x7DA0DD04,
    0x88C8A5D2, 0xC134B453, 0x21B85905, 0xA3B9A497, 0x28A4CA4D, 0xF2F979F8, 0x8E673DBC, 0x4783D36B, 0x34A07330,
    0x14DB8855, 0x2CE93E80, 0xD0B85DAE, 0xD9838342, 0xBF5F421F, 0x0E32D3B4, 0x08E96902, 0x2210B6F3, 0xA1E61536,
    0x18D8ADF7, 0x1B1666B0, 0x63B60BE7, 0x167B9DE6, 0xDD6EBD08, 0xB158C0ED, 0xE84C5EB5, 0xCBEF57F6, 0xF4C66591,
    0xC1CDA6C2, 0xF17DDB1F, 0x6FCCE1C6, 0xD8AC7E40, 0x3D7BC108, 0x716AD803, 0x84268597, 0xDC058462, 0xF4060AD5,
    0x92A2574B, 0xE44DB1EE, 0xFDAC5AAC, 0xF7117534, 0x140DBB97, 0x6140DCBD, 0x2ABB48C1, 0xC02E4F93, 0x62C01576,
    0x895F6EAF, 0xB725F17C, 0x6BA35468, 0x8BFA0BDC, 0x0C6A0F44, 0x71E33C5D, 0x01215B96, 0xB4EE0771, 0x9E645B69,
    0x1335AEE3, 0xDA6C12AA, 0x56CA50E0, 0xD9556C14, 0xE6F8CD4F, 0x1FA9FB3B, 0x2AE309C9, 0x5007628A, 0x0BE4ED48,
    0x7C33DA32, 0x1BF160E8, 0x825103F0, 0x88EBC54D, 0x6AA440E4, 0x84C12C42, 0x301B0296, 0xCB0276CB, 0x8576B82A,
    0xBC8F5BB0, 0x097B8A8B, 0x9BA059D7, 0xCB6A63BE, 0x93531691, 0xEDCB5A15, 0x8C9CBEBB, 0x1F07225A, 0xF5AA0397,
    0xAEBDE716, 0xB4541A85, 0x623B25EC, 0x375C55E6, 0x6900CB5D, 0x60B8A9B0, 0x4C8D5DC4, 0x2C2BF716, 0x5673267C,
    0x97C09A10, 0xD0000000
};

/*
**  High Frequence HANZI
*/
UCHAR HIFREQHANZI[26][14] = {
    "",
    "ȰѲ걨",
    "Ӵ˲ɲŲĴδ",
    "ɳ",
    "ĵصôֶԶ",
    "",
    "ַǷɷŷ",
    "ĸù",
    "ͻϺ",
    "ͽݼӼ",
    "ɿտڿƿ˿",
    "",
    "ÿû",
    "ũŮ",
    "ŷżŹźŻŽ",
    "ƷƽƬ",
    "ȫǰ",
    "Ȼ",
    "ɫ˹˾",
    "ʹ˵ʮʱ",
    "̨ͬ",
    "Ϊλ",
    "ѧϵ",
    "һҪ",
    "",
    "֮"
};

/* µΪ: ǰ, ڷִʱͬ */
UCHAR NONLINKHZ[2 * NUM_NONLINKHZ + 2] = 
    "ǵ˲Ҳͺͻ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* µΪ: ֻǰ, . */
UCHAR PRELINKHZ[2 * NUM_PRELINKHZ + 2] = 
    "Ա⻯߼Ҷʱ·";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/* µΪ: ֻ, ǰ. */
UCHAR SUFLINKHZ[2 * NUM_SUFLINKHZ + 2] = 
    "ӵĵڸÿĳܵΪʹָڵӦôȫܶԼ";
/*    1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */

/*
** UdCiku.dat, ְNONLINKHZUDSINGLEHZ, 
** UDSINGLEHZPRELINKHZSUFLINKHZнѡ!!ҪǸ, ʺͽ
*/

/****************   ZiRanMa ShuangPin Keyboard Layout    ***************
                NOTES:  No "er" in this Keyboard Layout

                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang           ng    
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo                  ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

:;     ===>  
'"     ===> 
,.     ===>  
[{     ===>      PageUp 
]}     ===>      PageDown
"'     ===>          
/      ===> 
\      ===> 

Ӧ ׷Ь ѽ  ż Լ   
***********************************************************************/


JINT    GbkHz2244ToYj(JINT nHzcode);
JINT    GbkHz2244ToYjSM(JINT nHzcode);
JINT    GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode);
JINT    EncodeDyzTo2244(JINT nHzcode, JINT nYjcode);
JINT    FastMatchYinJieStr(CHAR* szPystr);
UCHAR*  RecovDyz2244(UCHAR *szDyz2244);
JWORD   RecovDyzWord2244(JWORD wDyz2244);
JWORD*  RecovDyzNWord2244(JWORD* pwDyz2244, JINT nMaxLen);

CHAR    LastChar (JINT nYinjieCode);
CHAR    FirstChar(JINT nYinjieCode);
JINT    ValidButLastChar (JINT nYinjieCode);
JINT    ValidButFirstChar(JINT nYinjieCode);
JINT    ValidAddChar(CHAR ch, JINT nYinjieCode);

VOID    UnifOrgSpStr(CHAR* pszOrgSp, CHAR* pszUnifSp);
JINT    Sp2QpStr(CHAR* pszOrgSp, CHAR* pszUnifSp, CHAR* pszQp, JINT nKeyLayMode);

JINT    Sp2QpStr_Better(CHAR* pszOrgSp, CHAR* pszQp, JINT nKeyLayMode, JINT nSpCaretPos, JINT* pnQpCaretPos);
JINT    IsValidSpSuite(CHAR chSM, CHAR chYM, JINT nKeyLayMode);

JINT    TypeOfSpChar(CHAR *pszOrgSp, JINT nPos, JINT nKeyLayMode);
JINT    IsLower(CHAR ch);
JINT    IsUpper(CHAR ch);
CHAR    Lower(CHAR ch);
CHAR    Upper(CHAR ch);


/*
**  nHzcode range: [0x8140 ~ 0xA0FE] || [0xAA40 ~ 0xFEFE] || [0x2001 ~ 0x2244]
**                 [0x2001 ~ 0x2244] contains 580 DuoYinZi.
**  Lookup table GBKHZCODETOYJ[] and DYZCODETOYJ[] to return
**  an integer Yinjie code 0~414.
*/
JINT GbkHz2244ToYj(JINT nHzcode)
{
	JINT    hi, low;
	JINT    res;
	JINT    t1, t2, t3, t4;
	
	hi  = (nHzcode >> 8) & 0x00FF;
	low = nHzcode & 0x00FF;
	t1  = t2 = t3 = t4 = 0;
	
	res = 0xFFFF;
	if ((hi >= 0x81) && (hi <= 0xA0) && (low >= 0x40) && (low <= 0xFE))
	{
		t1 = (hi - 0x81) * 191 + (low - 0x40) + 1;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;

		if (t2 > t3)
			res = (JINT)( (GBKHZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) + 
			      (JINT)( (GBKHZCODETOYJ[t3] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (JINT)( GBKHZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
	}
	else if ((hi >= 0xAA) && (hi <= 0xFE) && (low >= 0x40) && (low <= 0xFE))
	{
		t1 = (hi - 0xAA) * 191 + (low - 0x40) + 1;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;

		if (t2 > t3)
			res = (JINT)( (GBKHZCODETOYJ[t2 + (9 * 191)] >> (32 - t4)) & 0x01FF ) + 
			      (JINT)( (GBKHZCODETOYJ[t3 + (9 * 191)] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (JINT)( GBKHZCODETOYJ[t2 + (9 * 191)] >> (32 - t4) ) & 0x01FF;
	}
	else if ((nHzcode >= 0x2001) && (nHzcode <= 0x2244))
	{
		t1 = nHzcode - 0x2000;
		t2 = (t1 * 9 - 1) / 32;
		t3 = ((t1 - 1) * 9 - 1) / 32;
		t4 = (t1 * 9) % 32;
			
		if (t2 > t3)
			res = (JINT)( (DYZCODETOYJ[t2] >> (32 - t4)) & 0x01FF ) + 
			      (JINT)( (DYZCODETOYJ[t3] << t4) & 0x01FF );
		else if (t2 == t3)
			res = (JINT)( DYZCODETOYJ[t2] >> (32 - t4) ) & 0x01FF;
	}
	else
		res = 0xFFFF;

	if (res == 0x01FF)
		res = 0xFFFF;
		
	return (res);
}


/*
**  nHzcode range: [0xB0A1 ~ 0xF7FE] || [0x2001 ~ 0x2244]
**  [0x2001 ~ 0x2244] contains 580 DuoYinZi.
**
**  Return ShengMu YinjieCode(450~475) of this Hanzi. If unNormal, return 0xFFFF
*/
JINT GbkHz2244ToYjSM(JINT nHzcode)
{
	JINT    nTmpRes;
	JINT    nRet;
	
	nTmpRes = GbkHz2244ToYj(nHzcode);

	if (nTmpRes != 0xFFFF)
	{
		if ((nTmpRes >= 38) && (nTmpRes < 57 ))        /* "ch" */
			nRet =  3 + 450;
		else if ((nTmpRes >= 301) && (nTmpRes < 320))  /* "sh" */
			nRet = 19 + 450;
		else if ((nTmpRes >= 395) && (nTmpRes < 415))  /* "zh" */
			nRet = 25 + 450;
		else
			nRet = INDEXMAGIC[(JINT)(YINJIESTR_CSZ[nTmpRes][0] - 'a')] + 450;
			
		return nRet;
	}

	return 0xFFFF;
}


/*
**  Lookup the DYZLIST[580] to see if this nHzcode is a DuoYinZi.
**  index of DYZLIST by High Byte is placed in INDEXOFDYZLIST
**  return: JINT           number of DuoYin, for example: 1, 2, 3  else, 0
**          pnDyzYjCode    yinjiecode include yinjie code
**
**  ACCORDING TO CURRENT DATA, ONLY <GB> Hanzi [0xB0?? ~ 0xF7??] may have DuoYinZi.
*/
JINT GetDyzInfo(JINT nHzcode, JINT* pnDyzYjCode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i, j;
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xB0;
	nLowHz   = nHzcode & 0x00FF;
	
	j = 0;
	if ((nHiHzPos < 0) || (nHiHzPos > (0xF7 - 0xB0)))
		return j;

	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if( (DYZLIST[i] & 0x00FF) == nLowHz )
		{
			pnDyzYjCode[j] = DYZYJCODE[i];
			j++;
		}
	}
	return j;
}


/*
**  nHzcode is Normal Hanzi Code defined in GB or GBK.
**  If nHzcode indicates a DYZ, return 0x2001 ~ (TOTAL_DYZYINJIE - 1 + 0x2001) [0x2001 + 0x2244]
**  Else, return 0xFFFF.
**  ONLY Normal GB may have DYZ.
*/
JINT EncodeDyzTo2244(JINT nHzcode, JINT nYjcode)
{
	JINT    nHiHzPos, nLowHz;
	JINT    i;
	
	nHiHzPos = ((nHzcode & 0xFF00) >> 8) - 0xB0;
	if ((nHiHzPos < 0) || (nHiHzPos > (0xF7 - 0xB0)))
		return 0xFFFF;

	nLowHz = nHzcode & 0x00FF;
	
	for (i = INDEXOFDYZLIST[nHiHzPos]; i < INDEXOFDYZLIST[nHiHzPos + 1]; i++)
	{
		if ( ((DYZLIST[i] & 0x00FF) == nLowHz) && (DYZYJCODE[i] == nYjcode) )
			return (i + 0x2001);
	}
	
	return 0xFFFF;
}


/*
**  Lookup the equal string of szPystr in YINJIESTR_CSZ[415].
**  if successfully, return 0~414; otherwise, return -1
*/
JINT FastMatchYinJieStr(CHAR* szPystr)
{
	JINT    i, j, nLen;
	CHAR    chFirst;
	JINT    nFromYJStr, nToYJStr, nShengmuIndex;	
	
	i = 0;
	nLen = (JINT)strlen(szPystr);
	
	j = 0;
	if (nLen > 0)
	{
		chFirst    = szPystr[0];
		nFromYJStr = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] ];
		nToYJStr   = INDEXSMTOYINJIE[ INDEXMAGIC[(JINT)(chFirst - 'a')] + 1];
		nShengmuIndex = INDEXMAGIC[(JINT)(chFirst - 'a')];
		
		if ((chFirst == 'c') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[3];
			nToYJStr   = INDEXSMTOYINJIE[4];
			nShengmuIndex = 3;
		}
		else if ((chFirst == 's') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[19];
			nToYJStr   = INDEXSMTOYINJIE[20];
			nShengmuIndex = 19;
		}
		else if ((chFirst == 'z') && (nLen > 1) && (szPystr[1] == 'h'))
		{
			nFromYJStr = INDEXSMTOYINJIE[25];
			nToYJStr   = INDEXSMTOYINJIE[26];
			nShengmuIndex = 25;
		}

		i = nFromYJStr;
		do {
			j = strcmp (YINJIESTR_CSZ[i], szPystr);
			i++;
		} while ((i < nToYJStr) && (j != 0));
	}
	
	if (j == 0)
		return (i - 1);
	else
		return (-1);
}


/*
**  nYinjieCode Valid from 0 to 414. Return the last
**  character of this YinJie String.
*/
CHAR LastChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	JINT   i = 0;
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		while (YINJIESTR_CSZ[nYinjieCode][i] != '\0')
			i++;
		res = YINJIESTR_CSZ[nYinjieCode][i-1];
	}
	return res;
}


/*
**  nYinjieCode Valid from 0 to 414
*/
CHAR FirstChar(JINT nYinjieCode)
{
	CHAR   res = ' ';		/* SPACE */
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
		res = YINJIESTR_CSZ[nYinjieCode][0];
	return res;
}


/*
**  Valid but the end CHARacter?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButLastChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	return 0xFFFF;
}


/*
** Valid add a new CHARacter before it?
** return 0~414 if valid, else return 0xFFFF
*/
JINT ValidAddChar(CHAR ch, JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';

	szStr[0] = ch;
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i])
		{
			szStr[i + 1] = YINJIESTR_CSZ[nYinjieCode][i];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Valid but first CHARacter ?
**  return 0~414 if valid, else return 0xFFFF
*/
JINT ValidButFirstChar(JINT nYinjieCode)
{
	JINT    i, nTmpRes;
	CHAR    szStr[7];
	
	for (i = 0; i < 7; i++)
		szStr[i] = '\0';
	
	if ((nYinjieCode >= 0) && (nYinjieCode <= 414))
	{
		i = 0;	
		while (YINJIESTR_CSZ[nYinjieCode][i+1])
		{
			szStr[i] = YINJIESTR_CSZ[nYinjieCode][i+1];
			i++;
		}
			
		nTmpRes = FastMatchYinJieStr(szStr);
		if(nTmpRes != -1)
			return nTmpRes;
	}
	
	return 0xFFFF;
}


/*
**  Recover these Hanzi String which encode by GBK&Dyz2244 to normal GBK.
**  Length of returned string is determined by the length of szDyz2244
**
**  This function must be rewritten to process failure of malloc()!!!
*/
UCHAR* RecovDyz2244(UCHAR *szDyz2244)
{
	JINT    i, j, nLen, nHlfLen;
	JINT    nDyzCode, nNormCode;
	static  UCHAR*  szNorm = NULL; 
   
	nLen = strlen((CHAR*)szDyz2244);
	nHlfLen = nLen / 2;

	if(szNorm != NULL)
		free(szNorm);

	szNorm = (UCHAR*)malloc(nLen + MALIGN);
	if (szNorm == NULL)
	{
		fprintf(stderr, "Failed to alloc Memory in function RecovDyz2244()\n");
		return (szNorm);
	}
	memset(szNorm, '\0', (nLen + MALIGN));
	
	j = 0;
	for (i = 0; i < nHlfLen; i++)
	{
		nDyzCode = szDyz2244[(2 * i) + 1] + ((JINT)szDyz2244[2 * i] << 8);
		if ((nDyzCode >= 0x2001) && (nDyzCode <= 0x2244))
		{
			nNormCode         = DYZLIST[nDyzCode - 0x2001];
			szNorm[2 * i]     = (UCHAR)((nNormCode & 0xFF00) >> 8);
			szNorm[2 * i + 1] = (UCHAR)(nNormCode & 0x00FF);
		}
		else
		{
			szNorm[2 * i]      = szDyz2244[2 * i];
			szNorm[2 * i + 1]  = szDyz2244[2 * i + 1];
		}
	}
	
	return (szNorm);
}


/*
**  Convert a DyzJword to a GBK Code.
*/
JWORD RecovDyzWord2244(JWORD wDyz2244)
{
	JWORD    wRet;
	
	wRet = wDyz2244;
	
	if ((wDyz2244 >= 0x2001) && (wDyz2244 <= 0x2244))
		wRet  = (JWORD)DYZLIST[wDyz2244 - 0x2001];
	
	return wRet;
}


/*
**  Convert a DyzJword String to a GBK-encoded String.
*/
JWORD* RecovDyzNWord2244(JWORD* pwDyz2244, JINT nMaxLen)
{
	static JWORD*  pwRet = NULL;
	JINT    i;

	free (pwRet);
	pwRet = (JWORD*)malloc((nMaxLen + MALIGN) * sizeof(JWORD));
	if (pwRet == NULL)
	{
		fprintf(stderr, "Failed in malloc() of RecovDyzNWord2244().\n");
		return pwRet;
	}
	memset(pwRet, '\0', sizeof(JWORD) * (nMaxLen + MALIGN));

	for (i = 0; (i < nMaxLen) && (pwDyz2244[i] != 0x0000); i++)
	{
		if ((pwDyz2244[i] >= 0x2001) && (pwDyz2244[i] <= 0x2244))
			pwRet[i]  = (JWORD)DYZLIST[pwDyz2244[i] - 0x2001];
		else
			pwRet[i]  = pwDyz2244[i];
	}

	return pwRet;
}


/*
**  EXAMPLE: (KEYLAYMODE_ZRM)
**  zhong hua ren min gong he guo   ru guo mei you tian shang de yu shui a hai tang hua er
**  vs hw rf mn gs he go            ru go mz yb tm uh de yu uv aa hl th hw er
**  v'h'r'm'g'h'g'                  r'g'm'y't'u'd'y'u'a'h't'h'e
**
**  Uniformed: Means contain only [a~z] and ['], [A~Z] was converted to be [a'~z']
**
**************   ZiRanMa ShuangPin Keyboard Layout    ************
      NOTES:  No "er" in this ZRM KeyLayout, ASSUME it's R
                 ch [i]     sh [u]     zh [v]
__________________________________________________________________
  A    B    C    D    E    F    G    H    I    J    K    L    M  
  a    ou   iao  uang e    en   eng  ang  i    an   ao   ai   ian
                 iang               
__________________________________________________________________
  N    O    P    Q    R    S    T    U    V    W    X    Y    Z   
  in   o    un   iu   uan  iong ue   u    v    ua   ie   uai  ei
       uo             er   ong            ui   ia        ing
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
**
*/
JINT Sp2QpStr(CHAR* pszOrgSp, CHAR* pszUnifSp, CHAR* pszQp, JINT nKeyLayMode)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;

#ifdef _DEBUG
	if ((nKeyLayMode < 0) || (nKeyLayMode >= 3))
	{
		fprintf (stderr, "Error nKeyLayMode [%d] in Sp2QpStr().\n", nKeyLayMode);
		return FALSE;
	}
#endif

	UnifOrgSpStr(pszOrgSp, pszUnifSp);

	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	nLen = strlen(pszUnifSp);

	for (i = 0; i < nLen; )
	{
		if (pszUnifSp[i] == '\'')
		{
			pszQp[j++] = '\'';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
		}
		else if (nfStartSM == TRUE)
		{
			/* To "ch" "sh" "zh" */
			if ((pszUnifSp[i] == 'i') || (pszUnifSp[i] == 'u') || (pszUnifSp[i] == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] >> 16;
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				pszQp[j++]  = szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = pszUnifSp[i];
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			i++;
			nfStartSM  = FALSE;
			nfStartYM  = TRUE;
		}
		else if (nfStartYM == TRUE)
		{
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszUnifSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszUnifSp[i - 1] == 'a') || (pszUnifSp[i - 1] == 'e') || (pszUnifSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				for (k = m; szYjTmp1[k] != '\0'; k++)
					pszQp[j++] = szYjTmp1[k];
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					for (k = m; szYjTmp2[k] != '\0'; k++)
						pszQp[j++] = szYjTmp2[k];
					i++;
				}
			}

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}

	pszQp[j] = '\0';
	return TRUE;
}


/*
**  Convert pszOrgSp to pszUnifSp.
*/
VOID UnifOrgSpStr(CHAR* pszOrgSp, CHAR* pszUnifSp)
{
	JINT    nLen, i, j;

	nLen = strlen(pszOrgSp);

	i = j = 0;
	for (i = 0; i < nLen; i++)
	{
		if ((pszOrgSp[i] >= 'A') && (pszOrgSp[i] <= 'Z'))
		{
			pszUnifSp[j++] = pszOrgSp[i] + 'a' - 'A';
			pszUnifSp[j++] = '\'';
		}
		else if (pszOrgSp[i] == '\'')
		{
			if ((j > 0) && (pszUnifSp[j - 1] != '\''))
				pszUnifSp[j++] = '\'';
		}
		else if ((pszOrgSp[i] >= 'a') && (pszOrgSp[i] <= 'z'))
			pszUnifSp[j++] = pszOrgSp[i];
		else
		{
#ifdef _DEBUG
			fprintf (stderr, "Error in UnifOrgSpStr(): Unexpected char: [%d]%c\n", i, pszOrgSp[i]);
#endif
		}
	}

	pszUnifSp[j] = '\0';
}


/*
**  Additional [aoe] process added!!    Scott Ma  98-03-07
**
**  [#] and [$]-support is added!
**  THERE are TWO conditions: I.   There is [$] in ShuangPin String already.
**                            II.  Add automatically [#] to QuanPin String.
**  For Example, OrgSp is [ruguo], should be converted to [ru#gu#o] instead of [ruguo]
**                            III. There is not connected ['][#][$].
**
**  Requirement of pszOrgSp:  contains only [a] ~ [z], ['] & [$]  MXL 98-03-13
**
**  Normal nSpCaretPos is between [0, strlen(pszOrgSp)]
**  IF nSpCaretPos = [0 ~ (strlen(pszOrgSp) - 1)],   *pnQpCaretPos = strlen(pszQp);
**  ELSE if nSpCaretPos = strlen(pszOrgSp), After for( ; ; ) reclycle, *pnQpCaretPos = strlen(pszQp);
*/
JINT Sp2QpStr_Better(CHAR* pszOrgSp, CHAR* pszQp, JINT nKeyLayMode, JINT nSpCaretPos, JINT* pnQpCaretPos)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	
#ifdef _DEBUG
	if ((nKeyLayMode < 0) || (nKeyLayMode >= 3))
	{
		fprintf (stderr, "Error nKeyLayMode [%d] in Sp2QpStr().\n", nKeyLayMode);
		return FALSE;
	}
#endif

	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	nLen = strlen(pszOrgSp);

	for (i = 0; i < nLen; )
	{
		/* Cacluates Caret Position */
		if ( nSpCaretPos == i)
			*pnQpCaretPos = strlen (pszQp);
		
		if (pszOrgSp[i] == '\'')
		{
			if (!((j > 0) && (pszQp[j - 1] == '\'')))
				pszQp[j++] = '\'';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '$')
		{
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$'))
				pszQp[j++] = '$';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '#')
		{
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$') && (pszQp[j - 1] != '#'))
				pszQp[j++] = '#';
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			i++;
			
			continue;
		}

		/* For a UpperCase [A], it was treated as ShengMu and was replaced with [#a#] */
		if (nfStartSM == TRUE)
		{
			if (IsUpper(pszOrgSp[i]))
			{
				if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '$') && (pszQp[j - 1] != '#'))
					pszQp[j++] = '#';
			}
			
			/* To "ch" "sh" "zh" */
			if ((Lower(pszOrgSp[i]) == 'i') || (Lower(pszOrgSp[i]) == 'u') || (Lower(pszOrgSp[i]) == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(pszOrgSp[i]) - 'a'] >> 16;
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				pszQp[j++]  = szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				pszQp[j++]  = szYjTmp1[0] = szYjTmp2[0] = Lower(pszOrgSp[i]);
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			
			if (IsUpper(pszOrgSp[i]))
			{
				pszQp[j++] = '#';          /* Add a [#] ??? MXL ????? Necessary!! Indeed!!! */
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
			}
			else
			{
				nfStartSM  = FALSE;
				nfStartYM  = TRUE;
			}
			i++;

		}
		else if (nfStartYM == TRUE)
		{
			/* If it is in Upper Case, treat it as ShengMu */
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
				continue;
			}
			
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszOrgSp[i - 1] == 'a') || (pszOrgSp[i - 1] == 'e') || (pszOrgSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';
				
			/* To Process 'aa' 'ee' 'oo' ......????? */

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				for (k = m; szYjTmp1[k] != '\0'; k++)
					pszQp[j++] = szYjTmp1[k];
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					for (k = m; szYjTmp2[k] != '\0'; k++)
						pszQp[j++] = szYjTmp2[k];
					i++;
				}
			}
			
			if ((j > 0) && (pszQp[j - 1] != '\'') && (pszQp[j - 1] != '#'))
				pszQp[j++] = '#';

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}
	
	if ((j > 0) && (pszQp[j - 1] == 0x23))           /* [#] */
		pszQp[j - 1] = '\0';
	
	if (nLen == nSpCaretPos)
		*pnQpCaretPos = strlen (pszQp);

	pszQp[j] = '\0';
	
	return TRUE;
}


/*
**  To avoid any affection of LC_CTYPE, rewrite the following functions myself.
*/
CHAR Upper(CHAR ch)
{
	if ((ch >= 'a') && (ch <= 'z'))
		return (CHAR)(ch + 'A' - 'a');
		
	return (ch);
}

CHAR Lower(CHAR ch)
{
	if ((ch >= 'A') && (ch <= 'Z'))
		return (CHAR)(ch + 'a' - 'A');
		
	return (ch);
}

JINT IsUpper(CHAR ch)
{
	if ((ch >= 'A') && (ch <= 'Z'))
		return TRUE;
		
	return FALSE;
}

JINT IsLower(CHAR ch)
{
	if ((ch >= 'a') && (ch <= 'z'))
		return TRUE;
		
	return FALSE;
}

/*
**  Get the type of a specified character in a given ShuangPin String.
**  nPos specifies the position of a char, which is between [0 ~ strlen(pszOrgSp)).
**
**  #define SPYJ_SHENGMU     1
**  #define SPYJ_YUNMU       2
**  #define SPYJ_QUOTE       3
**  #define SPYJ_NUMSIGN     4
**  #define SPYJ_DOLLAR      5
**  #define SPYJ_INVALID     8
*/
JINT TypeOfSpChar(CHAR *pszOrgSp, JINT nPos, JINT nKeyLayMode)
{
	JINT    nLen, i, j, k, m, nRes;
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nfStartSM, nfStartYM;
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	
	memset (szYjTmp1, '\0', 10);
	memset (szYjTmp2, '\0', 10);
	nfStartSM = TRUE;
	nfStartYM = FALSE;
	i = j = 0;
	
	nLen = strlen(pszOrgSp);

	if ((nPos < 0) || (nPos >= nLen))
		return SPYJ_INVALID;
		
	/* Valid nPos is  [0 ~ (nLen - 1)] */
	for (i = 0; i <= nPos; )
	{
		if (pszOrgSp[i] == '\'')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_QUOTE;
			else
				i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '#')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_NUMSIGN;
			else
				i++;
			
			continue;
		}
		
		if (pszOrgSp[i] == '$')
		{
			nfStartSM  = TRUE;
			nfStartYM  = FALSE;

			if (nPos == i)
				return SPYJ_DOLLAR;
			else
				i++;
			
			continue;
		}

		/* For a UpperCase [A], it was treated as ShengMu and was replaced with ['a'] */
		if (nfStartSM == TRUE)
		{
			/* To "ch" "sh" "zh" */
			if ((Lower(pszOrgSp[i]) == 'i') || (Lower(pszOrgSp[i]) == 'u') || (Lower(pszOrgSp[i]) == 'v'))
			{
				nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(pszOrgSp[i]) - 'a'] >> 16;
				szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
				szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
				szYjTmp1[2] = szYjTmp2[2] = '\0';
				m = 2;    /* length of ShengMu */
			}
			else
			{
				szYjTmp1[0] = szYjTmp2[0] = Lower(pszOrgSp[i]);
				szYjTmp1[1] = szYjTmp2[1] = '\0';
				m = 1;    /* length of ShengMu */
			}
			
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
			}
			else
			{
				nfStartSM  = FALSE;
				nfStartYM  = TRUE;
			}

			if (nPos == i)
				return SPYJ_SHENGMU;
			
			i++;

		}
		else if (nfStartYM == TRUE)
		{
			/* If it is in Upper Case, treat it as ShengMu */
			if (IsUpper(pszOrgSp[i]))
			{
				nfStartSM  = TRUE;
				nfStartYM  = FALSE;
				continue;
			}
			
			nKeyLayYM1 = KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x0000FF;
			nKeyLayYM2 = (KEYLAYMODE[nKeyLayMode][pszOrgSp[i] - 'a'] & 0x00FF00) >> 8;

			/* ShengMu just before it is [aeo] */
			if ((pszOrgSp[i - 1] == 'a') || (pszOrgSp[i - 1] == 'e') || (pszOrgSp[i - 1] == 'o'))
				szYjTmp1[0]  = szYjTmp2[0] = '\0';

			strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
			nRes = FastMatchYinJieStr(szYjTmp1);
			if ((nRes >= 0) && (nRes < NUM_YINJIE))
			{
				if (nPos == i)
					return SPYJ_YUNMU;
				i++;
			}

			if ((nRes == -1) && (nKeyLayYM2 != 0))
			{
				strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
				nRes = FastMatchYinJieStr(szYjTmp2);
				if ((nRes >= 0) && (nRes < NUM_YINJIE))
				{
					if (nPos == i)
						return SPYJ_YUNMU;
					i++;
				}
			}

			nfStartSM  = TRUE;
			nfStartYM  = FALSE;
			memset (szYjTmp1, '\0', 10);
			memset (szYjTmp2, '\0', 10);
		}
	}
	
	return SPYJ_INVALID;
}


/*
**  Return TRUE or FALSE to indicates whether this chSM and chYM
**  is a valid composition under given nKeyLayMode.
*/

/*  Following Yinjie has no Chinese in GB2312 Area. - Scott Ma 98-05-13
    [   cei]   0      27
    [  chua]   0      50
    [   den]   0      64
    [   eng]   0      82
    [  fiao]   0      90
    [   kei]   0     152
    [   nun]   0     235
    [   rua]   0     285
************************************/
JINT IsValidSpSuite(CHAR chSM, CHAR chYM, JINT nKeyLayMode)
{
	CHAR    szYjTmp1[10], szYjTmp2[10];
	JINT    nKeyLayYM1, nKeyLayYM2, nKeyLaySM;
	JINT    i, m, nRes;
	JINT    nNullYj[8] = {27, 50, 64, 82, 90, 152, 235, 285};

	assert(((chSM >= 'a') && (chSM <= 'z')) || ((chSM >= 'A') && (chSM <= 'Z')));
	assert(((chYM >= 'a') && (chYM <= 'z')) || ((chYM >= 'A') && (chYM <= 'Z')));

	if ((Lower(chSM) == 'i') || (Lower(chSM) == 'u') || (Lower(chSM) == 'v'))
	{
		nKeyLaySM   = KEYLAYMODE[nKeyLayMode][Lower(chSM) - 'a'] >> 16;
		szYjTmp1[0] = szYjTmp2[0] = YUNMUSTR[nKeyLaySM][0];
		szYjTmp1[1] = szYjTmp2[1] = YUNMUSTR[nKeyLaySM][1];
		szYjTmp1[2] = szYjTmp2[2] = '\0';
		m = 2;    /* length of ShengMu */
	}
	else
	{
		szYjTmp1[0] = szYjTmp2[0] = Lower(chSM);
		szYjTmp1[1] = szYjTmp2[1] = '\0';
		m = 1;    /* length of ShengMu */
	}

	nKeyLayYM1  =  KEYLAYMODE[nKeyLayMode][Lower(chYM) - 'a'] & 0x0000FF;
	nKeyLayYM2  = (KEYLAYMODE[nKeyLayMode][Lower(chYM) - 'a'] & 0x00FF00) >> 8;

	/* ShengMu just before it is [aeo] */
	if ((chSM == 'a') || (chSM == 'e') || (chSM == 'o'))
		szYjTmp1[0]  = szYjTmp2[0] = '\0';

	strcat(szYjTmp1, YUNMUSTR[nKeyLayYM1]);
	nRes = FastMatchYinJieStr(szYjTmp1);

	/* Process for Null Yinjie in "zh" locale. Scott Ma 98-05-13 */
#ifndef _DRAW_IM_WIN_H
	if (strcmp(szLocale, "zh") == 0)
	{
		for (i = 0; i < 8; i++)
		{
			if (nRes == nNullYj[i])
			{
				nRes = -1;
				break;
			}
		}
	}
#endif

	if ((nRes >= 0) && (nRes < NUM_YINJIE))
		return TRUE;

	if ((nRes == -1) && (nKeyLayYM2 != 0))
	{
		strcat(szYjTmp2, YUNMUSTR[nKeyLayYM2]);
		nRes = FastMatchYinJieStr(szYjTmp2);

		/* Process for Null Yinjie in "zh" locale. Scott Ma 98-05-13 */
#ifndef _DRAW_IM_WIN_H
		if (strcmp(szLocale, "zh") == 0)
		{
			for (i = 0; i < 8; i++)
			{
				if (nRes == nNullYj[i])
				{
					nRes = -1;
					break;
				}
			}
		}
#endif

		if ((nRes >= 0) && (nRes < NUM_YINJIE))
			return TRUE;
	}
	
	return FALSE;
}

