#include <stdio.h>

#include "le_desktop.h"

/****************************************************************************/
/*                         LE Desktop Context                               */
/****************************************************************************/
LeDesktopContextRec *le_desktop_context_new()
{
    LeDesktopContextRec *le_desktop_context = NULL;

    le_desktop_context =
	(LeDesktopContextRec *) calloc(1, sizeof(LeDesktopContextRec));
    if (le_desktop_context == NULL)
	return NULL;

    le_desktop_context->locale = NULL;

    le_desktop_context->current_session = NULL;

    return le_desktop_context;
}

LeResult le_desktop_context_destroy(LeDesktopContextRec *le_desktop_context)
{
    if (le_desktop_context == NULL)
	return LE_FAIL;

    if (le_desktop_context->locale)
	free((char *) le_desktop_context->locale);

    free((char *) le_desktop_context);

    return LE_OK;
}

LeResult le_desktop_context_print(LeDesktopContextRec * le_desktop_context)
{
    DEBUG_printf("le_desktop_context_print ==========\n");

    if (le_desktop_context == NULL)
	return LE_FAIL;

    return LE_OK;
}

LeResult le_desktop_context_set_current_session(LeDesktopContextRec *
						le_desktop_context,
						iml_session_t * s)
{
    if (le_desktop_context == NULL)
	return LE_FAIL;

    le_desktop_context->current_session = s;
    return LE_OK;
}

iml_session_t *le_desktop_context_get_current_session(LeDesktopContextRec *
						      le_desktop_context)
{
    if (le_desktop_context == NULL)
	return NULL;

    return (le_desktop_context->current_session);
}

LeResult le_desktop_context_set_locale(LeDesktopContextRec *
					le_desktop_context,
					char *locale)
{
    if (le_desktop_context == NULL || locale == NULL)
	return LE_FAIL;

    le_desktop_context->locale = (char *)strdup(locale);
    return LE_OK;
}

char *le_desktop_context_get_locale(LeDesktopContextRec *
				    le_desktop_context)
{
    if (le_desktop_context == NULL)
	return NULL;

    return (le_desktop_context->locale);
}

/****************************************************************************/
/*                         LE Desktop                                       */
/****************************************************************************/
LeResult le_desktop_create(iml_desktop_t * desktop)
{
    LeDesktopContextRec *le_desktop_context = NULL;

    le_desktop_context = (LeDesktopContextRec *) le_desktop_context_new();
    DEBUG_printf("le_desktop_create ===== %p\n", le_desktop_context);

    le_desktop_context_print(le_desktop_context);

    desktop->specific_data = (void *) le_desktop_context;

    return LE_OK;
}

LeResult le_desktop_destroy(iml_desktop_t * desktop)
{
    LeDesktopContextRec *le_desktop_context =
	(LeDesktopContextRec *) desktop->specific_data;

    le_desktop_context_destroy(le_desktop_context);

    desktop->specific_data = NULL;

    return LE_OK;
}
