#ifndef _LE_INFO_H_
#define _LE_INFO_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "SunIM.h"
#include "ime_module.h"
#include "le_keybinding.h"

#include <time.h>

typedef enum {
    LE_FAIL = 0,
    LE_OK,
} LeResult;

typedef enum {
    LE_FALSE = 0,
    LE_TRUE,
} LeBoolean;

/* define the status for conversion/hanja/qjbjuation */
typedef enum {
    CONVERSION_OFF = 0,
    CONVERSION_ON,
} ConversionStatus;

typedef enum {
    HANJA_HALFWIDTH = 0,
    HANJA_FULLWIDTH,
} HanJaStatus;

typedef struct {
    char ch;
    unsigned char *full_char;
} FullCharItem;

typedef struct {
    int num_fullchars;
    FullCharItem *fullchars;
} FullChars;

typedef enum {
    QJBJ_ENGLISH = 0,
    QJBJ_KOREAN,
} PunctStatus;

typedef struct {
    char ch;
    unsigned char *full_qjbj;
} PunctCharItem;

typedef struct {
    int num_qjbjs;
    PunctCharItem *qjbjs;
} PunctChars;

typedef struct {

    /* base info */
    char *base_dir;
    time_t time_stamp;

    /* ime info */
    int num_ime_modules;
    ImeModuleContextRec **ime_modules;

    /* keybinding info */
    int num_imm_keybindings;
    ImmKeybindingRec **imm_keybindings;

    FullChars full_chars;
    PunctChars qjbj_chars;

} LeInfoRec;

#endif	/* _LE_INFO_H_ */
