/* 
 * Copyright (C) 2008 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Aijin Kim <Aijin.Kim@Sun.COM>
 */

#include <stdio.h>
#include <string.h>

#include "debug.h"
#include "ime.h"
#include "hangul_properties.h"
#include <hangul.h>

char **KeymappingOptions = NULL;
char **hanjaOptions = NULL;

#define HANGUL_KEYBOARD_ID          0
#define HANGUL_KEYBOARD_STR         "키보드 배열"

#define HANGUL_COMMIT_ID            1
#define HANGUL_COMMIT_STR           "단어별 커밋"

#define HANGUL_HANJA_ID             2
#define HANGUL_HANJA_STR            "한글-한자 변환 형식"

#define keyboard_1                  "두벌식"
#define keyboard_2                  "세벌식 최종"
#define keyboard_3                  "세벌식 390"
#define keyboard_4                  "세벌식 순아래"

#define CONVERSION_HANJA            "漢字"
#define CONVERSION_HANGUL_HANJA     "한글(漢字)"
#define CONVERSION_HANJA_HANGUL     "漢字(한글)"

ImePropertyRec hangul_options[] = {
    {HANGUL_KEYBOARD_ID, ENCODE_UTF8, "/keyboardSelect", HANGUL_KEYBOARD_STR, NULL, ImeProperty_Selection, {0, 0}, 0},
    {HANGUL_COMMIT_ID, ENCODE_UTF8, "/commitMethodselect", HANGUL_COMMIT_STR, NULL, ImeProperty_Toggle, {0, 0}, 0},
    {HANGUL_HANJA_ID, ENCODE_UTF8, "/hanjaSelect", HANGUL_HANJA_STR, NULL, ImeProperty_Selection, {0, 0}, 0},
};

ImePropertyListRec hangul_optionlist = {
     sizeof(hangul_options)/sizeof(ImePropertyRec),
     hangul_options
};

extern ImmServices imm_services;

char *get_keymapping_string(int idx){
    int buf_len = 0;
    char *keymapping_str = NULL;

    switch (idx) {
    case(0):
        buf_len = strlen (keyboard_1);
        keymapping_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(keymapping_str, buf_len+1, "%s", keyboard_1); 
        break;
    case(1):
        buf_len = strlen (keyboard_2);
        keymapping_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(keymapping_str, buf_len+1, "%s", keyboard_2); 
        break;
    case(2):
        buf_len = strlen (keyboard_3);
        keymapping_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(keymapping_str, buf_len+1, "%s", keyboard_3);
        break;
    case(3):
        buf_len = strlen (keyboard_4);
        keymapping_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(keymapping_str, buf_len+1, "%s", keyboard_4); 
        break;
    }
        
    DEBUG_printf("keymapping_str fun end: %s\n", keymapping_str);
    
    return keymapping_str;
}

char *get_hanja_string(int idx){
    int buf_len = 0;
    char *hanja_str = NULL;

    switch (idx) {
    case(0):
        buf_len = strlen (CONVERSION_HANJA);
        hanja_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(hanja_str, buf_len+1, "%s", CONVERSION_HANJA); 
        break;
    case(1):
        buf_len = strlen (CONVERSION_HANGUL_HANJA);
        hanja_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(hanja_str, buf_len+1, "%s", CONVERSION_HANGUL_HANJA); 
        break;
    case(2):
        buf_len = strlen (CONVERSION_HANJA_HANGUL);
        hanja_str = (char *)calloc (buf_len+1, sizeof (char));
        snprintf(hanja_str, buf_len+1, "%s", CONVERSION_HANJA_HANGUL);
        break;
    }
        
    DEBUG_printf("conversion fun end: %s\n", hanja_str);
    
    return hanja_str;
}

ImeResult hangul_Init_Ime_Properties(ImeInfoRec * hangul_info)
{
    int num_keymappings, num_hanja;
    int i;
    int idx;

    if (hangul_info == NULL)
        return (IME_FAIL);
    
    if(KeymappingOptions == NULL){
        num_keymappings = 4;
        KeymappingOptions = (char **)calloc (num_keymappings + 1, sizeof (char *));
        int idx = 0;
        for (i = 0; i < num_keymappings; i++) {
            char *keymapping_str;
            keymapping_str = (char *)get_keymapping_string(i);
            if (keymapping_str){
                KeymappingOptions[idx++] = keymapping_str;
            }
        }
    }
    hangul_options[HANGUL_KEYBOARD_ID].range.multiString_range = KeymappingOptions;

    if(hanjaOptions == NULL){
        num_hanja = 3;
        hanjaOptions = (char **)calloc (num_hanja + 1, sizeof (char *));
        int idx = 0;
        for (i = 0; i < num_hanja; i++) {
            char *hanja_str;
            hanja_str = (char *)get_hanja_string(i);
            if (hanja_str){
                hanjaOptions[idx++] = hanja_str;
            }
        }
    }
    hangul_options[HANGUL_HANJA_ID].range.multiString_range = hanjaOptions;

    hangul_info->pl = (ImePropertyListRec *)(&hangul_optionlist);

    return (IME_OK);
}

ImeResult hangul_Destroy_Ime_Properties(ImeInfoRec * hangul_info)
{
    int i;
    if (KeymappingOptions != NULL) {
        for (i = 0; KeymappingOptions[i]; i++) {
            free ((char *) KeymappingOptions[i]);
        }
        free ((char *)KeymappingOptions);
    }
    if (hanjaOptions != NULL) {
        for (i = 0; hanjaOptions[i]; i++) {
            free ((char *) hanjaOptions[i]);
        }
        free ((char *)hanjaOptions);
    }

    return (IME_OK);
}

ImeResult hangul_set_commitMethod(hangul_session_t *hangul_session, int commitMethod)
{
    DEBUG_printf("++++++++++++set commit method : %d \n", commitMethod);
    if(commitMethod)
        hangul_session->commit_by_word = true;
    else
        hangul_session->commit_by_word = false;

    return (IME_OK);
}

ImeResult hangul_set_keyboard(hangul_session_t *hangul_session, int keyboardValue)
{
    DEBUG_printf("++++++++++++set Keyboard id: %d \n", keyboardValue); 
    switch(keyboardValue) {
    case 0:
        hangul_ic_select_keyboard(hangul_session->hic, "2");
        break;
    case 1:
        hangul_ic_select_keyboard(hangul_session->hic, "3f");
        break;
    case 2:
        hangul_ic_select_keyboard(hangul_session->hic, "39");
        break;
    case 3:
        hangul_ic_select_keyboard(hangul_session->hic, "3s");
        break;
    }

    return (IME_OK);
}

ImeResult hangul_set_hanja_conversion(hangul_session_t *hangul_session, int hanja_conversion)
{
    DEBUG_printf("++++++++++++set hanja conversion method : %d \n", hanja_conversion);
    switch(hanja_conversion) {
    case HANJA_CONVERSION_HANJA:
    case HANJA_CONVERSION_HANGUL_HANJA:
    case HANJA_CONVERSION_HANJA_HANGUL:
        hangul_session->hanja_conversion = hanja_conversion;
        break;
    default:
        hangul_session->hanja_conversion = HANJA_CONVERSION_HANJA;
        break;
    }

    return (IME_OK);
}

ImeResult hangul_Set_Ime_Properties(ImeInputContext ic,
                     hangul_session_t * hangul_session)
{
    int i;
    ImePropertyListRec *pl;
    ImePropertyRec *pi;

    DEBUG_printf("chewing_Set_Ime_Properties\n");

    if (hangul_session == NULL)
        return (IME_FAIL);

    pl = imm_services->ImmGetPropertyList(ic);
    if (pl != NULL && pl->count > 0 && pl->properties != NULL) {
        for (i = 0; i < pl->count; i++) {
            pi = &(pl->properties[i]);
            switch (pi->id) {
            case HANGUL_KEYBOARD_ID:
                hangul_set_keyboard( hangul_session, pi->value.int_value);
                break;
            case HANGUL_COMMIT_ID:
                hangul_set_commitMethod( hangul_session, pi->value.int_value);
                break;
            case HANGUL_HANJA_ID:
                hangul_set_hanja_conversion( hangul_session, pi->value.int_value);
                break;
            }
        }
    }

    return (IME_OK);
}
