/* 
 * Copyright (C) 2008 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Aijin Kim <Aijin.Kim@Sun.COM>
 */

#ifndef _HANGUL_IM_H_
#define _HANGUL_IM_H_

#include <hangul.h>
#include "SunIM.h"

#define MAX_STR_LEN     256

typedef enum {
    HANGUL_STATE_NONE,
    HANGUL_STATE_ENGLISH,
    HANGUL_STATE_HANGUL,
    HANGUL_STATE_HANJA,
} HangulState;

typedef enum {
    HANJA_CONVERSION_HANJA,
    HANJA_CONVERSION_HANGUL_HANJA,
    HANJA_CONVERSION_HANJA_HANGUL
} HanjaConversion;

typedef struct _hangul_session_t {
    HangulState     state;
    HangulInputContext* hic;

	char preedit[MAX_STR_LEN];

    /* candidate */
    char*        candidate_key;
    HanjaList*      candidates;
    int         candidate_n_per_page;
    int         candidate_page;
    int         candidate_cur;
    int         hanja_conversion;
	bool		commit_by_word;
} hangul_session_t;

#endif /* _HANGUL_IM_H_ */
