/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef IM_INPUT_H
#define	IM_INPUT_H

#include "imdef.h"

#ifdef	__cplusplus
extern "C" {
#endif

enum IM_INPUT_LETTER_TYPE {
	IM_INPUT_LETTER_TYPE_MIN = 0,

 	IM_INPUT_LETTER_TYPE_ALPHA = IM_INPUT_LETTER_TYPE_MIN,
	IM_INPUT_LETTER_TYPE_HIRAGANA,
	IM_INPUT_LETTER_TYPE_KATAKANA,
 	IM_INPUT_LETTER_TYPE_HW_KATAKANA,
 	IM_INPUT_LETTER_TYPE_FW_ALPHA,

	IM_INPUT_LETTER_TYPE_MAX = IM_INPUT_LETTER_TYPE_FW_ALPHA,

	N_IM_INPUT_LETTER_TYPE,
};

extern Bool im_input_init(const char *dict_dir);
extern void im_input_term(void);

extern im_input_t im_input_create(void);
extern void im_input_free(im_input_t input);

extern Bool im_input_empty_p(im_input_t input);
extern Bool im_input_wide_p(im_input_t input);
extern UTFCHAR im_input_get_status_char(im_input_t input);

extern enum IM_INPUT_LETTER_TYPE im_input_get_input_letter_type(im_input_t input);
extern void im_input_set_input_letter_type(im_input_t input, enum IM_INPUT_LETTER_TYPE new_type);

extern void im_input_convert_letter_type(im_input_t input, enum IM_INPUT_LETTER_TYPE type);

extern void im_input_clear(im_input_t input);

extern void im_input_add_char(im_input_t input, int ch);

extern void im_input_break(im_input_t input);
extern void im_input_reinit(im_input_t input);

extern void im_input_delete_prev(im_input_t input);
extern void im_input_delete_next(im_input_t input);

extern int im_input_cur_pos(im_input_t input);
extern Bool im_input_cur_move_to_head(im_input_t input);
extern Bool im_input_cur_move_to_tail(im_input_t input);
extern Bool im_input_cur_move_prev(im_input_t input);
extern Bool im_input_cur_move_next(im_input_t input);

extern IMText *im_input_make_preedit_text(im_input_t input, iml_session_t *session, int deco);
extern IMText *im_input_make_commit_text(im_input_t input, iml_session_t *session);

extern UTFCHAR *im_input_get_string(im_input_t input, iml_session_t *session, int *length);
extern UTFCHAR *im_input_get_converted_range_strig(
    im_input_t input,
    iml_session_t *session,
    int start,
    int end,
    enum IM_INPUT_LETTER_TYPE type,
    int *length
);
extern UTFCHAR *im_input_get_raw_range_string(
    im_input_t input,
    iml_session_t *session,
    int start,
    int end,
    int *length
);

#ifdef __cplusplus
}
#endif

#endif /* IM_INPUT_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
