/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef IM_EVENT_HANDLER_H
#define	IM_EVENT_HANDLER_H

#ifdef	__cplusplus
extern "C" {
#endif

typedef Bool (*KeyEventHandler)(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);

extern KeyEventHandler lookup_key_event_handler(iml_session_t *session, IMKeyEventStruct *key_event);

extern Bool handle_noop(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_send_back_key(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_input_space(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_conversion_off(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_convert(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_predict(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_cancel(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);
extern Bool handle_step_back(iml_session_t *session, IMKeyEventStruct *key_event, iml_inst **inst_list);


#ifdef __cplusplus
}
#endif

#endif /* IM_EVENT_HANDLER_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
