/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include <stdlib.h>
#include <string.h>

#include "convdef.h"
#include "imcommit.h"
#include "imconv.h"
#include "imeventhandler.h"
#include "iminput.h"
#include "imlookup.h"
#include "impreedit.h"


Bool
handle_commit(
    iml_session_t *session,
    IMKeyEventStruct *key_event,
    iml_inst **inst_list
)
{
    PrivateSessionData *psd = SESSION_DATA(session);
    IMText *im_txt = NULL;
    switch (psd->im_state) {
      case IM_STATE_OFF:
      case IM_STATE_EDIT_EMPTY:
       return handle_send_back_key(session, key_event, inst_list);

      case IM_STATE_EDITING:
      case IM_STATE_LETTER_TYPE_CONVERSION:
       im_txt = im_input_make_commit_text(psd->im_input, session);
       break;

      case IM_STATE_CONVERSION:
      case IM_STATE_PREDICTION:
       end_lookup_choice(session, inst_list);
       /* not break, but fall-through. */
      case IM_STATE_CHANGE_SEG:
       im_txt = im_conv_commit(psd->im_conv, session);
       break;

      default:
       ASSERT(0); /* cannot happen */
       return False;
    }

    im_input_clear(psd->im_input);

    make_preedit_erase_inst(session, inst_list);

    ASSERT(im_txt);
    make_commit_inst_from_text(session, im_txt, inst_list);

    change_im_state(session, IM_STATE_EDIT_EMPTY, inst_list, False);

    return True;
}

void
make_commit_inst_from_text(
    iml_session_t *session,
    IMText *im_txt,
    iml_inst **inst_list
)
{
    if (im_txt && im_txt->char_length > 0) {
	iml_methods_t *mtbl = METHODS_TBL(session);
	iml_inst *inst = mtbl->iml_make_commit_inst(session, im_txt);
	mtbl->iml_link_inst_tail(inst_list, inst);
    }
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
