/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#ifndef DYN_BUFF_H
#define	DYN_BUFF_H

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct {
    size_t capacity;
    void *p;
} dyn_buffer, *dyn_buffer_t;

extern dyn_buffer_t dyn_buffer_create(void);
extern void dyn_buffer_free(dyn_buffer_t buff);

extern int dyn_buffer_ensure_size(dyn_buffer_t buff, size_t size);

#define DYN_BUFFER_GET_SIZE(buff, type) ((buff)->capacity / sizeof(type))
#define DYN_BUFFER_ENSURE_SIZE(buff, type, size) dyn_buffer_ensure_size((buff), sizeof(type) * (size))
#define DYN_BUFFER_GET_BUFFER(buff, type) ((type*)((buff)->p))

#ifdef __cplusplus
}
#endif

#endif /* DYN_BUFF_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
