/*

Copyright (c) 2006 Kenji ABE <abek@terre-sys.com>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "SunIM.h"
#include "SunIMMMan.h"
#include "SunIMProt.h"
#include "SunIMMthd.h"
#include "SunIMPriv.h"
#include "SunIMCore.h"
#include "SunIMPub.h"

#include "IMCharSubsets.h"

#include "imdef.h"
#include "impreedit.h"
#include "imstatus.h"
#include "imtext.h"


Bool if_anthy_OpenIF(iml_if_t *);
Bool if_anthy_CloseIF(iml_if_t *);
Bool if_anthy_GetIFValues(iml_if_t *, IMArgList, int);
Bool if_anthy_SetIFValues(iml_if_t *, IMArgList, int);
Bool if_anthy_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_anthy_CloseDesktop(iml_desktop_t *);
Bool if_anthy_CreateSC(iml_session_t*, IMArgList, int);
Bool if_anthy_DestroySC(iml_session_t *);
Bool if_anthy_GetSCValues(iml_session_t *, IMArgList, int);
Bool if_anthy_SetSCValues(iml_session_t *, IMArgList, int);
IMText *if_anthy_ResetSC(iml_session_t *);
void if_anthy_SetSCFocus(iml_session_t *);
void if_anthy_UnsetSCFocus(iml_session_t *);
void if_anthy_SendEvent(iml_session_t *, IMInputEvent * ev);


static if_methods_t if_methods = {
	if_anthy_OpenIF,
	if_anthy_CloseIF,

	if_anthy_GetIFValues,
	if_anthy_SetIFValues,

	if_anthy_OpenDesktop,
	if_anthy_CloseDesktop,

	if_anthy_CreateSC,
	if_anthy_DestroySC,
	if_anthy_GetSCValues,
	if_anthy_SetSCValues,
	if_anthy_ResetSC,

	if_anthy_SetSCFocus,
	if_anthy_UnsetSCFocus,

	if_anthy_SendEvent
};

/*
 * define Human Readable Name as UTFCHAR for LE
 */
UTFCHAR LE_NAME[] = {'A', 'n', 't', 'h', 'y', 0x00};

static IMLEName lename = {
	"anthyLE",	/* LE id */
	LE_NAME		/* LE HRN */
};

/*
 * define Human Readable Name as UTFCHAR for language
 */
UTFCHAR LOCALE_NAME[] = {0x65e5, 0x672c, 0x8a9e, 0x0000};

static IMLocale locales[] = {
	{
		"ja",			/* locale id */
		LOCALE_NAME		/* locale HRN */
	},
	{NULL, NULL},
};

#ifdef WIN32
#define EXPORT extern __declspec(dllexport)
#else
#define EXPORT
#endif

EXPORT void
if_GetIfInfo(
    IMArgList args,
    int num_args
)
{
    int i;
    for (i = 0; i < num_args; i++, args++) {
	switch (args->id) {
	  case IF_VERSION:
	   args->value = (IMArgVal)"0.1";
	   break;

	  case IF_METHOD_TABLE:
	   args->value = (IMArgVal)&if_methods;
	   break;

	  case IF_LE_NAME:
	   args->value = (IMArgVal)&lename;
	   break;

	  case IF_SUPPORTED_LOCALES:
	   args->value = (IMArgVal)&locales;
	   break;

	  case IF_SUPPORTED_OBJECTS:
	   break;

	  case IF_NEED_THREAD_LOCK:
	   args->value = (IMArgVal) True;/*False;*/
	   break;

	  default:
	   break;
	}
    }
}

Bool
if_anthy_OpenIF(
    iml_if_t * If
)
{
#ifdef	DEBUG
    printf("if_anthy_OpenIF()\n");
#endif

    return init_im();
}

Bool
if_anthy_CloseIF(
    iml_if_t * If
)
{
#ifdef	DEBUG
    printf("if_anthy_CloseIF()\n");
#endif

    term_im();
    return True;
}



Bool
if_anthy_GetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf("if_anthy_GetIFValues()\n");
#endif

    return True;
}

Bool
if_anthy_SetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf("if_anthy_SetIFValues()\n");
#endif

    return True;
}

Bool
if_anthy_OpenDesktop(
    iml_desktop_t * desktop,
    IMArgList args,
    int num_args
)
{
#ifdef DEBUG
    printf("if_anthy_OpenDesktop()\n");
#endif

    return create_desktop_data(desktop);
}

Bool
if_anthy_CloseDesktop(
    iml_desktop_t *desktop
)
{
#ifdef DEBUG
    printf("if_anthy_CloseDesktop()\n");
#endif

    free_desktop_data(desktop);
    return True;
}

Bool
if_anthy_CreateSC(
    iml_session_t *s,
    IMArgList args,
    int num_args
)
{
#ifdef DEBUG
    printf("if_anthy_CreateSC()\n");
#endif

    return create_session_data(s);
}

Bool
if_anthy_DestroySC(
    iml_session_t * s
)
{
#ifdef DEBUG
    printf("if_anthy_DestroySC()\n");
#endif

    free_session_data(s);
    return True;
}

Bool
if_anthy_GetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    static int CHAR_SUBSET[] = {
	    IMCS_LATIN,
	    IMCS_HIRAGANA,
	    IMCS_KATAKANA,
	    IMCS_KANJI,
	    0,
    };

    int i;
    IMArg *p = args;

#ifdef DEBUG
    printf("if_anthy_GetSCValues\n");
#endif

    for (i = 0; i < num_args; ++i, ++p) {
	switch (p->id) {
	  case SC_SUPPORTED_CHARACTER_SUBSETS:
	   p->value = (IMArgVal)CHAR_SUBSET;
	   break;

	  default:
	   break;
	}
    }
    return True;
}

Bool
if_anthy_SetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p = args;

#ifdef DEBUG
    printf("if_anthy_SetSCValues\n");
#endif

    for (i = 0; i < num_args; ++i, ++p) {
	switch (p->id) {
	  case SC_TRIGGER_ON_NOTIFY:
	   set_conversion_on(s);
	   break;

	  case SC_TRIGGER_OFF_NOTIFY:
	   set_conversion_off(s);
	   break;

	  case SC_REALIZE:
	   break;

	  default:
	   break;
	}
    }
    return True;
}

IMText *
if_anthy_ResetSC(
    iml_session_t * s
)
{
    IMText *im_txt = make_preedit_text(s);

#ifdef DEBUG
    printf("if_anthy_ResetSC\n");
#endif

    reset_session(s);

    return im_txt;
}

void
if_anthy_SetSCFocus(
    iml_session_t * s
)
{
#ifdef DEBUG
    printf("if_anthy_SetSCFocus\n");
#endif

    draw_status(s);
}

void
if_anthy_UnsetSCFocus(
    iml_session_t * s
)
{
#ifdef DEBUG
    printf("if_anthy_UnsetSCFocus\n");
#endif
}

void
if_anthy_SendEvent(
    iml_session_t * s,
    IMInputEvent * ev
)
{
#ifdef DEBUG
    printf("if_anthy_SendEvent\n");
#endif

    if (ev &&
	ev->type == IM_EventKeyList) {
	key_list_event_handler(s, (IMKeyListEvent *)ev);
    }
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
