/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "iiimpReq.h"
#include "iiimpIM.h"
#include "iiimpUtil.h"
#include "KeyMap.h"

/* Utility functions */
static char *
IMToString(
    CARD16 *chars,
    int char_length
)
{
    char *ptr;
    int i;
    int total_size;
    unsigned char *data;

    if (char_length & 0x01) {
	total_size = (2 + (2 * char_length));
    } else {
	total_size = (2 + (2 * char_length) + 2);	/* padding */
    }

    data = (unsigned char *)Xmalloc(total_size);
    if (!data) {
	return NULL;
    }

    ptr = (char *)data;
    req_put16(ptr, (2 * char_length));
    for (i = 0; i < char_length; i++) {
	req_put16(ptr, *(chars + i));
    }
    if (0x00 == (char_length & 0x01)) {
	req_put16(ptr, 0);
    }

    return (char*)data;
}

/********************************************************************************
 				Trigger keys
 ********************************************************************************/

static unsigned int
str_to_mod(
    char *str
)
{
    if(!strcmp("Ctrl", str))
        return ControlMask;
    else if(!strcmp("Shift", str))
        return ShiftMask;
    else if(!strcmp("Meta", str))
        return Mod4Mask;
    else if(!strcmp("Alt", str))
        return Mod1Mask;
    else
        return 0;
}

static void
add_conversion_keys_from_resource(
    XrmDatabase rdb,
    IIIMCF_keyevent **ppkev,
    int* pnum
)
{
    char *buf = NULL;
    char *dummy = NULL;
    char *p;
    Bool is_modmask;
    unsigned int mod, mod_mask, tmp_mask;
    char *ret_type;
    XrmValue rmvalue;
    char *names = NULL;
    int num = *pnum;
    IIIMCF_keyevent *pkev = *ppkev;
    IIIMCF_keyevent kev;
    int code;

    if (!XrmGetResource(rdb, "conversionOnKeys", "ConversionOnKeys",
			&ret_type, &rmvalue))
	return;

    names = (char *) malloc(rmvalue.size + 1);
    if (!names) goto err;
    strncpy(names, rmvalue.addr, rmvalue.size);
    names[rmvalue.size] = '\0';

    dummy = buf = (char *) malloc(strlen(names) + 1);
    if (!dummy) goto err;
    strcpy(buf, names);

    is_modmask = False;
    mod = 0;
    while (*buf) {
        switch(*buf) {
          case '~':
	   if (is_modmask)
	       goto err;
	   is_modmask = True;
	   buf += 1;
	   break;
          case '<':
	   p = strchr(buf+1, '>');
	   if (!p)
	       goto err;
	   *p = 0;
	   if ((tmp_mask = str_to_mod(buf + 1)) == 0)
	       goto err;
	   if (is_modmask) {
	       mod_mask |= tmp_mask;
	       is_modmask = False;
	   } else {
	       mod |= tmp_mask;
	   }
	   buf = p + 1;
	   if (!*buf)
	       goto err;
	   break;
          default:
	   p = strchr(buf, ' ');
	   if (p) *p = 0;

	   code = XStringToKeysym(buf);
	   if (XKeysym_To_IIIMCF_keyevent(code, mod, &kev)) {
	       pkev = (IIIMCF_keyevent*) realloc(pkev, sizeof(IIIMCF_keyevent) * (num + 1));
	       if (!pkev) goto err;
	       pkev[num] = kev;
	       num++;
	       *ppkev = pkev;
	       *pnum = num;
	   }

	   mod = 0;
	   if (p) {
	       buf = p + 1;
	       break;
	   } else {
	       goto done;
	   }
        }
    }

done:
err:
    if (names) free(names);
    if (dummy) free(dummy);
    return;
}

static void
register_conversion_keys_from_resource(
    XimCommon im
)
{
    XrmDatabase rdb = im->core.rdb;

    if (!rdb) return;
    add_conversion_keys_from_resource(rdb, &XIM_IIIMP(im, pkev_on),
				      &XIM_IIIMP(im, on_keys_num));
    add_conversion_keys_from_resource(rdb, &XIM_IIIMP(im, pkev_off),
				      &XIM_IIIMP(im, off_keys_num));

    return;
}

void
RegisterTriggerKeys(
    XimCommon im
)
{
    int on_num, off_num;
    const IIIMCF_keyevent *pkev_on, *pkev_off;

    if (!XIM_IS_IIIMP(im)) return;

    if (XIM_IIIMP(im, pkev_on)) {
	Xfree(XIM_IIIMP(im, pkev_on));
	XIM_IIIMP(im, on_keys_num) = 0;
    }
    if (XIM_IIIMP(im, pkev_off)) {
	Xfree(XIM_IIIMP(im, pkev_off));
	XIM_IIIMP(im, off_keys_num) = 0;
    }

    if (iiimcf_get_trigger_keys(XIM_IIIMP(im, handle),
				&on_num, &pkev_on,
				&off_num, &pkev_off)
	== IIIMF_STATUS_SUCCESS) {
	IIIMCF_keyevent *pkev;

	pkev = (IIIMCF_keyevent*) Xmalloc(sizeof(*pkev) * on_num);
	if (pkev) {
	    memcpy(pkev, pkev_on, sizeof(*pkev) * on_num);
	    XIM_IIIMP(im, on_keys_num) = on_num;
	    XIM_IIIMP(im, pkev_on) = pkev;
	}
	pkev = (IIIMCF_keyevent*) Xmalloc(sizeof(*pkev) * off_num);
	if (pkev) {
	    memcpy(pkev, pkev_off, sizeof(*pkev) * off_num);
	    XIM_IIIMP(im, off_keys_num) = off_num;
	    XIM_IIIMP(im, pkev_off) = pkev;
	}
    }

    register_conversion_keys_from_resource(im);

    return;
}

static Bool
isMatchKey(
    XEvent *ev,
    const IIIMCF_keyevent *pkev,
    int num
)
{
    int i;
    IIIMCF_keyevent kev;

    if (ev->type != KeyPress) return False;
    if (ev->xkey.keycode == XIM_COMPOSE_KEYCODE) return False;
    if (!XKeyEvent_To_IIIMCF_keyevent((XKeyEvent*)ev, &kev)) return False;

    for (i = 0; i < num; i++, pkev++) {
	if ((kev.keycode == pkev->keycode)
	    /* && (kev.keychar == pkev->keychar )*/
	    && ((kev.modifier & ~(0x40000020)) == pkev->modifier)) {
	  /*
	   * 0x40000020 is AND of CAPS and KANA locks
	   * these locks should not afffect trigger keys definition
	   */
	    return True;
	}
    }

    return False;
}

static Bool
isMatchKey_LRMod(
    IIIMCF_context ctx,
    XEvent *ev,
    const IIIMCF_keyevent *pkev,
    int num
)
{
    int i;
    IIIMCF_keyevent kev;
    int eval_mode = 0;

    if (ev->type != KeyPress) return False;
    if (ev->xkey.keycode == XIM_COMPOSE_KEYCODE) return False;
    if (!XKeyEvent_To_IIIMCF_keyevent((XKeyEvent*)ev, &kev)) return False;

    for (i = 0; i < num; i++, pkev++) {
        if (iiimcf_lr_modifier_equal_check(ctx, &kev, pkev))
	    return True;
    }
    return False;
}

Bool
isConversionOnKey(
    XimCommon im,
    XEvent *ev
)
{
    if (!XIM_IS_IIIMP(im)) return False;
    return isMatchKey(ev, XIM_IIIMP(im, pkev_on), XIM_IIIMP(im, on_keys_num));
}

Bool
isConversionOnKey_LRMod(
    XicCommon ic,
    XEvent *ev
)
{
    XimCommon im = (XimCommon)ic->core.im;
    IIIMCF_context context = XIC_IIIMP (ic, context);
    return isMatchKey_LRMod(context, ev, XIM_IIIMP(im, pkev_on),
			    XIM_IIIMP(im, on_keys_num));
}

Bool
isConversionOffKey(
    XimCommon im,
    XEvent *ev
)
{
    if (!XIM_IS_IIIMP(im)) return False;
    return isMatchKey(ev, XIM_IIIMP(im, pkev_off), XIM_IIIMP(im, off_keys_num));
}

Bool
isConversionOffKey_LRMod(
    XicCommon ic,
    XEvent *ev
)
{
    XimCommon im = (XimCommon)ic->core.im;
    IIIMCF_context context = XIC_IIIMP (ic, context);
    return isMatchKey_LRMod(context, ev, XIM_IIIMP(im, pkev_off),
			    XIM_IIIMP(im, off_keys_num));
}

#ifdef HAS_IIIM_PROPERTIES
Bool
isSuperHotkey(
    XimCommon im,
    XEvent *ev,    
    SuperHotkeyKind *shk
)
{
  if (!XIM_IS_IIIMP(im)) return False;

  if (isMatchKey (ev, XIM_IIIMP (im, pkev_le_select),
		  XIM_IIIMP (im, le_select_keys_num))) {
    *shk = LE_SELECT;
    return True;
  }

  if (isMatchKey (ev, XIM_IIIMP (im, pkev_le_cycle),
		  XIM_IIIMP (im, le_cycle_keys_num))) {
    *shk = LE_CYCLE;
    return True;
  }

  if (isMatchKey (ev, XIM_IIIMP (im, pkev_le_reverse_cycle),
		  XIM_IIIMP (im, le_reverse_cycle_keys_num))) {
    *shk = LE_REVERSE_CYCLE;
    return True;
  }

  return False;
}
#endif /* HAS_IIIM_PROPERTIES */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
