#if !defined(_IIIMP_AUX_PROXY_H)
#define _IIIMP_AUX_PROXY_H


#include <X11/Xlib.h>
#include <iiimp-opcode.h>
#include <iiimcf.h>
#include "commonIM.h"


Bool	xaux_proxy_setup_client(Display *	d,
				int		server_id,
				int		im_id,
				int		ic_id,
				XicCommon	ic);
Bool	xaux_proxy_setup_server(Display * d);
void	xaux_proxy_finalize(Display * d);
Bool	xaux_proxy_client_setup(Display * d);
void	xaux_proxy_client_finalize(Display * d);
Bool	xaux_proxy_server_setup(Display * d);
void	xaux_proxy_server_finalize(Display * d);
int	xaux_proxy_role(XicCommon ic);
void	xaux_proxy_ic_destroy(XicCommon xic);
void	xaux_proxy_destroy(Display * d);
void	xaux_proxy_aux_simple(XicCommon		xic,
			      int		type,
			      int		server_id,
			      int		im_id,
			      int		ic_id,
			      IIIMCF_event	ev);
void	xaux_proxy_aux_value(XicCommon		xic,
			     int		type, 
			     int		server_id,
			     int		im_id,
			     int		ic_id,
			     IIIMCF_event	ev);

#define xaux_proxy_aux_start(xic, sv, im, ic, ev) \
	xaux_proxy_aux_simple((xic), IM_AUX_START, (sv), (im), (ic), (ev))
#define xaux_proxy_aux_done(xic, sv, im, ic, ev) \
	xaux_proxy_aux_simple((xic), IM_AUX_DONE, (sv), (im), (ic), (ev))
#define xaux_proxy_aux_draw(xic, sv, im, ic, ev) \
	xaux_proxy_aux_value((xic), IM_AUX_DRAW, (sv), (im), (ic), (ev))
#define xaux_proxy_aux_setvalues(xic, sv, im, ic, ev) \
	xaux_proxy_aux_value((xic), IM_AUX_SETVALUES, (sv), (im), (ic), (ev))
#define xaux_proxy_aux_getvalues(xic, sv, im, ic, ev) \
	xaux_proxy_aux_value((xic), IM_AUX_GETVALUES, (sv), (im), (ic), (ev))


/* XAUX PROXY ROLE type */
#define XAUX_PROXY_ROLE_UNKNOWN			(0)
#define XAUX_PROXY_ROLE_CLIENT			(1)
#define XAUX_PROXY_ROLE_SERVER			(2)


#endif /* !_IIIMP_AUX_PROXY_H */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
