/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#if !defined(USE_FRAMEMGR_ALWAYS)
#include <stddef.h>
#include <string.h>
#include <stdlib.h>
#else /* USE_FRAMEMGR_ALWAYS */
#include "FrameMgr.h"
#endif /* USE_FRAMEMGR_ALWAYS */
#include "IIIMPClient.hh"
#include "IMProtoHandler.hh"
#include "IIIMPInputContext.hh"
#include "ICAttribute.hh"
#include "IIIMProtocol.hh"
#include "IMProtocolStructP.hh"

#if !defined(USE_FRAMEMGR_ALWAYS)
int
IIIMPClient::icattr_list_count(char * p) {
  char *ptr;
  CARD32 icattr_list_size; 
  int num;
  CARD16 icattr_size;

  num = 0;
  ptr = p;
  if (False == need_swap) {
    req_get16(ptr, icattr_list_size);
    if (icattr_list_size & 0x03) {
      icattr_list_size = ((icattr_list_size & (~0x03)) + 4);
    }

    while (4 <= icattr_list_size) {
      ptr += 2;				/* skip attribute id */
      req_get16(ptr, icattr_size);
      icattr_list_size -= 4;
      if (icattr_size & 0x03) {		/* padding */
	icattr_size = ((icattr_size & (~0x03)) + 4);
      }
      if (icattr_list_size < icattr_size) {
	icattr_size = icattr_list_size;
      }

      ptr += icattr_size;
      icattr_list_size -= icattr_size;
      num += 1;
    }
  } else {
    req_get16s(ptr, icattr_list_size);
    if (icattr_list_size & 0x03) {
      icattr_list_size = ((icattr_list_size & (~0x03)) + 4);
    }

    while (4 <= icattr_list_size) {
      ptr += 2;				/* skip attribute id */
      req_get16s(ptr, icattr_size);
      icattr_list_size -= 4;
      if (icattr_size & 0x03) {		/* padding */
	icattr_size = ((icattr_size & (~0x03)) + 4);
      }
      if (icattr_list_size < icattr_size) {
	icattr_size = icattr_list_size;
      }

      ptr += icattr_size;
      icattr_list_size -= icattr_size;
      num += 1;
    }
  }
  return num;
}

int
IIIMPClient::icattr_size(ICAttribute * icattr) {
  int size;
  size = 2;		/* attribute id */
  size += 2;		/* byte length of value */
  if (NULL != icattr) {
    size += icattr->value_length;
  }
  if (size & 0x03) {	/* padding */
    size = ((size & (~0x03)) + 4);
  }
  return size;
}

char *
IIIMPClient::req_put_icattr_list(char * ptr, ICAttribute * icattr, int num) {
  int i;
  for (i = 0; i < num; i++, icattr++) {
    req_put16(ptr, icattr->attribute_id);
    req_put16(ptr, icattr->value_length);
    memcpy(ptr, icattr->value, icattr->value_length);
    if (icattr->value_length & 0x03) {
      ptr += ((icattr->value_length & (~0x03)) + 4);
    } else {
      ptr += icattr->value_length;
    }
  }
  return ptr;
}

char *
IIIMPClient::req_put_icattr_list_s(char * ptr, ICAttribute * icattr, int num) {
  int i;
  for (i = 0; i < num; i++, icattr++) {
    req_put16s(ptr, icattr->attribute_id);
    req_put16s(ptr, icattr->value_length);
    memcpy(ptr, icattr->value, icattr->value_length);
    if (icattr->value_length & 0x03) {
      ptr += ((icattr->value_length & (~0x03)) + 4);
    } else {
      ptr += icattr->value_length;
    }
  }
  return ptr;
}

#else /* USE_FRAMEMGR_ALWAYS */
#endif /* USE_FRAMEMGR_ALWAYS */

/* Set IC values */
void
IIIMPClient::set_card(ICAttribute *value_ret, char *p, IMAttr *ic_attr,
		      int value_length) {
  char *buf, *bufp;
#if !defined(USE_FRAMEMGR_ALWAYS)
  char *ptr;
  char *ptr_end;
  char *data;
  int data_length;
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgr fm;
  FmStatus status;
  extern XimFrameRec string_fr[];
  extern XimFrameRec worddata_fr[];
  extern XimFrameRec longdata_fr[];
#endif /* USE_FRAMEMGR_ALWAYS */
  short value16;
  int value32;
  int byte_length;
  int value_type = ic_attr->type;
  ICAttribute temp_value;
  IMAttr temp_attr;
  int len, left;

  buf = new char[value_length];

  switch (value_type) {
  case IIIMProtocol::XimType_LISTOF_UTF16_STRING:
#if !defined(USE_FRAMEMGR_ALWAYS)
    ptr = (char *)p;
    ptr_end = (ptr + value_length);
    bufp = buf;
    left = value_length;
    if (False == need_swap) {
      while ((ptr < ptr_end) && (0 < left)) {
	ptr = req_get_ascii_string(ptr, &data, &byte_length, &data_length);
	memcpy(bufp, data, data_length);
	delete [] data;
	bufp += data_length;
	left -= data_length;
      }
    } else {
      while ((ptr < ptr_end) && (0 < left)) {
	ptr = req_get_ascii_string_s(ptr, &data, &byte_length, &data_length);
	memcpy(bufp, data, data_length);
	delete [] data;
	bufp += data_length;
	left -= data_length;
      }
    }
    value_length = (bufp - buf);
#else /* USE_FRAMEMGR_ALWAYS */
    bufp = buf;
    temp_attr.attribute_id = 0;
    temp_attr.length = 0;
    temp_attr.name = NULL;
    temp_attr.type = IIIMProtocol::XimType_UTF16_STRING;
    left = value_length;
    while (left > 0) {
      set_card(&temp_value, (char*)p, &temp_attr, left);
      len = 2 + temp_value.value_length * 2 +
	((2 + temp_value.value_length * 2) % 4); // evil
      p += len;
      memmove(bufp, temp_value.value, temp_value.value_length);
      free(temp_value.value);
      bufp += temp_value.value_length;
      *bufp++ = (char)0;
      left -= len;
    }
#endif /* USE_FRAMEMGR_ALWAYS */
    break;
  case IIIMProtocol::XimType_UTF16_STRING:
#if !defined(USE_FRAMEMGR_ALWAYS)
    ptr = (char *)p;
    delete [] buf;
    if (False == need_swap) {
      ptr = req_get_ascii_string(ptr, &buf, NULL, &value_length);
    } else {
      ptr = req_get_ascii_string_s(ptr, &buf, NULL, &value_length);
    }
    value_type = IIIMProtocol::XimType_CARD8;
#else /* USE_FRAMEMGR_ALWAYS */
    /* create FrameMgr */
    fm = FrameMgrInit(string_fr, (char *)p, need_swap);
    /* get data */
    FrameMgrGetToken(fm, byte_length);
    bufp = buf;
    value_length = byte_length/2;
    // assume that all the 16bit Unicode characters are ASCII characters
    while (FrameMgrIsIterLoopEnd(fm, &status) == False) {
      CARD16 str;
      CARD8 byte_data;
      FrameMgrGetToken(fm, byte_data);
      str = (byte_data << 8) & 0xff00;
      FrameMgrGetToken(fm, byte_data);
      str += byte_data & 0x00ff;
      if (str != 0 && str != 0xff && str != 0xfe)
	*bufp++ = (char)str;
      else
	value_length--;
    }
    *bufp = (char)0;
    value_type = IIIMProtocol::XimType_CARD8;
    FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */
    break;
  case IIIMProtocol::XimType_CARD8:
    memmove(buf, p, value_length);
    break;
  case IIIMProtocol::XimType_CARD16:
#if !defined(USE_FRAMEMGR_ALWAYS)
    ptr = (char *)p;
    if (False == need_swap) {
      req_get16(ptr, value16);
    } else {
      req_get16s(ptr, value16);
    }
#else /* USE_FRAMEMGR_ALWAYS */
    /* create FrameMgr */
    fm = FrameMgrInit(worddata_fr, (char *)p, need_swap);
    /* get data */
    FrameMgrGetToken(fm, value16);
    /* free FrameMgr */
    FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */
    memmove(buf, &value16, value_length);
    break;
  case IIIMProtocol::XimType_CARD32:
#if !defined(USE_FRAMEMGR_ALWAYS)
    ptr = (char *)p;
    if (False == need_swap) {
      req_get32(ptr, value16);
    } else {
      req_get32s(ptr, value16);
    }
#else /* USE_FRAMEMGR_ALWAYS */
    /* create FrameMgr */
    fm = FrameMgrInit(longdata_fr, (char *)p, need_swap);
    /* get data */
    FrameMgrGetToken(fm, value32);
    /* free FrameMgr */
    FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */
    memmove(buf, &value32, value_length);
    break;
  }

  value_ret->attribute_id = ic_attr->attribute_id;
  value_ret->name = ic_attr->name;
  value_ret->name_length = ic_attr->length;
  value_ret->value_length = value_length;
  value_ret->type = value_type;
  value_ret->value = buf;

  return;
}

int
IIIMPClient::read_icvalue(CARD16 icvalue_id, int value_length, void *p,
			  ICAttribute *value_ret) {
  IMAttr *ic_attr = iiim_protocol->get_icattr();
  for (IMAttr *attrp = ic_attr;
       attrp < &ic_attr[iiim_protocol->count_icattr()]; attrp++) {
    if (attrp->attribute_id == icvalue_id) {
      set_card(value_ret, (char*)p, attrp, value_length);
      return(0);
    }
  }
  return(-1);
}

int
IIIMPClient::read_imvalue(CARD16 imvalue_id, int value_length, void *p,
			  ICAttribute *value_ret) {
  IMAttr *im_attr = iiim_protocol->get_imattr();
  for (IMAttr *attrp = im_attr;
       attrp < &im_attr[iiim_protocol->count_imattr()]; attrp++) {
    if (attrp->attribute_id == imvalue_id) {
      set_card(value_ret, (char*)p, attrp, value_length);
      return(0);
    }
  }
  return(-1);
}

void
IIIMPClient::change_icvalues(
#if !defined(USE_FRAMEMGR_ALWAYS)
	char *ptr,
#else /* USE_FRAMEMGR_ALWAYS */
	FrameMgr fm,
	int byte_length,
#endif /* USE_FRAMEMGR_ALWAYS */
	IMProtocolStruct *call_data) {
#if !defined(USE_FRAMEMGR_ALWAYS)
  int attrnum;
  int byte_length;
#else /* USE_FRAMEMGR_ALWAYS */
  FmStatus status;
  int max_attrnum = IIIMPClient::MAX_ATTRNUM;
#endif /* USE_FRAMEMGR_ALWAYS */
  IMChangeICStruct *changeic = (IMChangeICStruct*)&call_data->changeic;
  ICAttribute *icAttribute_list;
  int number;
  int first_ic_index = 0;

#if !defined(USE_FRAMEMGR_ALWAYS)
  attrnum = icattr_list_count(ptr);
  icAttribute_list = new ICAttribute[attrnum];
  if (False == need_swap) {
    req_get16(ptr, byte_length);
  } else {
    req_get16s(ptr, byte_length);
  }
#else /* USE_FRAMEMGR_ALWAYS */
  icAttribute_list = new ICAttribute[max_attrnum];
#endif /* USE_FRAMEMGR_ALWAYS */

  /* Set InputStyle to Callbacks */
  number = 0;
  if (byte_length != 0) {
#if !defined(USE_FRAMEMGR_ALWAYS)
    if (False == need_swap) {
      for (number = 0; number < attrnum; number++) {
	req_get16(ptr, icAttribute_list[number].attribute_id);
	req_get16(ptr, icAttribute_list[number].value_length);
	icAttribute_list[number].value =
		new char[icAttribute_list[number].value_length];
	memcpy(icAttribute_list[number].value, ptr,
	       icAttribute_list[number].value_length);
	if (icAttribute_list[number].value_length & 0x03) {
	  ptr += ((icAttribute_list[number].value_length & (~0x03)) + 4);
	} else {
	  ptr += icAttribute_list[number].value_length;
	}
      }
    } else {
      for (number = 0; number < attrnum; number++) {
	req_get16s(ptr, icAttribute_list[number].attribute_id);
	req_get16s(ptr, icAttribute_list[number].value_length);
	icAttribute_list[number].value =
		new char[icAttribute_list[number].value_length];
	memcpy(icAttribute_list[number].value, ptr,
	       icAttribute_list[number].value_length);
	if (icAttribute_list[number].value_length & 0x03) {
	  ptr += ((icAttribute_list[number].value_length & (~0x03)) + 4);
	} else {
	  ptr += icAttribute_list[number].value_length;
	}
      }
    }
#else /* USE_FRAMEMGR_ALWAYS */
    while (FrameMgrIsIterLoopEnd(fm, &status) == False) {
      void *value;
      int value_length;
      if (number == max_attrnum) {
	max_attrnum += IIIMPClient::MAX_ATTRNUM;
	ICAttribute *temp = icAttribute_list;
	icAttribute_list = new ICAttribute[max_attrnum];
	memmove(icAttribute_list, temp, sizeof(ICAttribute) * number);
	delete [] temp;
      }
      FrameMgrGetToken(fm, icAttribute_list[number].attribute_id);
      FrameMgrGetToken(fm, value_length);
      FrameMgrSetSize(fm, value_length);
      icAttribute_list[number].value_length = value_length;
      FrameMgrGetToken(fm, value);
      icAttribute_list[number].value = new char[value_length];
      memmove(icAttribute_list[number].value, value, value_length);
      number++;
    }
#endif /* USE_FRAMEMGR_ALWAYS */
  }
  /* The value from the protocol may need to be byte-swapped */
  for (ICAttribute *icp = &icAttribute_list[first_ic_index];
       icp < &icAttribute_list[number]; icp++) {
    void *dummy = icp->value;

    if (read_icvalue(icp->attribute_id,
		     icp->value_length,
		     icp->value,
		     icp) == 0) {
      delete dummy;
    }
  }

  changeic->preedit_attr_num = 0;
  changeic->status_attr_num = 0;
  changeic->preedit_attr = 0;
  changeic->status_attr = 0;
  changeic->ic_attr_num = (CARD16)number;
  changeic->ic_attr = icAttribute_list;

  return;
  /* to CreateICMessageProc or SetICValuesProc */
}

void
IIIMPClient::free_icvalues(IMProtocolStruct *call_data) {
  IMChangeICStruct *changeic = (IMChangeICStruct*)&call_data->changeic;

  for (ICAttribute *icp = changeic->ic_attr;
       icp < &changeic->ic_attr[changeic->ic_attr_num]; icp++) {
    delete icp->value;
  }
  delete [] changeic->ic_attr;
  return;
}

void
IIIMPClient::create_ic(IMProtocolStruct *call_data, unsigned char *p) {
#if !defined(USE_FRAMEMGR_ALWAYS)
  char *ptr;
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgr fm;
  extern XimFrameRec im_createic_fr[], im_createic_reply_fr[];
  XimFrameRec *input_fr = im_createic_fr;
  XimFrameRec *output_fr = im_createic_reply_fr;
#endif /* USE_FRAMEMGR_ALWAYS */
  IMChangeICStruct *changeic = (IMChangeICStruct*)&call_data->changeic;
  CARD16 input_method_id;
  CARD16 byte_length;
  const int IM_OUTPUT_REPLY = IM_CREATEIC_REPLY;

#ifndef IIIMP_KEEP_ALIVE_PROTOCOL
  /*
    fix for 4108572:
    When JavaOS is booted, it creates a new connection for the dummy
    user name "nobody@<hostname>". If there were any old connection
    done under the same user name, we close it here. It was left unclosed
    when the JavaOS was powered off.
  */
  if (!respond_keepalive) {
    char *at_hostname = strstr(username, "@");
    if (!strncmp((char*)username, "nobody", 6)) {
       IIIMPClient *cl = &(iiim_protocol->iiimp_client_list.getFirstItem());
       while (cl) {
         if (cl != this) {
	    CompoundString user = cl->getUser();
	    if (strstr(user, at_hostname)) {
	      // to close the client
	      if (!cl->respond_keepalive) {
	        // call destory_ic methods for all input contexts
	        InputContext *ic = &(cl->input_context_list.getFirstItem());
	        while(ic){
	          if (ic && ((IIIMPInputContext*)ic)->is_active()) {
		    cl->input_context_list.remove(ic);
		    ((IIIMPInputContext*)ic)->unrealize();
		    iiim_protocol->proto_handler->DestroyIC((InputContext*)ic);
	          }
	          ic = &(cl->input_context_list.getNextItem());
	        }

	        // mark it to be killed later
	        cl->being_deleted = 1;
	      }
	    }
	 }
	 cl = &(iiim_protocol->iiimp_client_list.getNextItem());
       }
    }
  }
#endif

#if !defined(USE_FRAMEMGR_ALWAYS)
  ptr = (char *)p;
  if (False == need_swap) {
    req_get16(ptr, input_method_id);
    change_icvalues(ptr, call_data);
  } else {
    req_get16s(ptr, input_method_id);
    change_icvalues(ptr, call_data);
  }
#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(input_fr, (char *)p, need_swap);

  /* get data */
  FrameMgrGetToken(fm, input_method_id);
  FrameMgrGetToken(fm, byte_length);

  change_icvalues(fm, byte_length, call_data);

  /* free FrameMgr */
  FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */

  IIIMPInputContext *ic = new IIIMPInputContext(this);
  input_context_list.addItem(ic);
  CARD16 input_context_id = input_context_list.getIndex(ic);

  // set some icattributes to this new ic
  for (ICAttribute *icp = changeic->ic_attr;
       icp < &changeic->ic_attr[changeic->ic_attr_num]; icp++) {
    if (icp->name == iiim_protocol->ICLocaleName) {
      ic->setLocaleName((char*)icp->value);
    } else if (icp->name == iiim_protocol->ICEngineName) {
      ic->setEngineName((char*)icp->value);
    }
  }

  iiim_protocol->proto_handler->CreateIC((InputContext*)ic);
  iiim_protocol->proto_handler->RealizeIC((InputContext*)ic);

  free_icvalues(call_data);

#if !defined(USE_FRAMEMGR_ALWAYS)
  send_message(input_method_id, input_context_id, IM_OUTPUT_REPLY);
#else /* USE_FRAMEMGR_ALWAYS */
  send_message(input_method_id, input_context_id,
	       output_fr, IM_OUTPUT_REPLY);
#endif /* USE_FRAMEMGR_ALWAYS */
  ic->realize();
  return;
}

void
IIIMPClient::set_icvalues(IMProtocolStruct *call_data, unsigned char *p) {
#if !defined(USE_FRAMEMGR_ALWAYS)
  char *ptr;
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgr fm;
  extern XimFrameRec im_seticvalues_fr[], im_seticvalues_reply_fr[];
  XimFrameRec *input_fr = im_seticvalues_fr;
  XimFrameRec *output_fr = im_seticvalues_reply_fr;
#endif /* USE_FRAMEMGR_ALWAYS */
  IMChangeICStruct *changeic =
    (IMChangeICStruct*)&call_data->changeic;
  CARD16 input_method_id, input_context_id;
  CARD16 byte_length;

  const int IM_OUTPUT_REPLY = IM_SETICVALUES_REPLY;

#if !defined(USE_FRAMEMGR_ALWAYS)
  ptr = (char *)p;
  if (False == need_swap) {
    req_get16(ptr, input_method_id);
    req_get16(ptr, input_context_id);
    change_icvalues(ptr, call_data);
  } else {
    req_get16s(ptr, input_method_id);
    req_get16s(ptr, input_context_id);
    change_icvalues(ptr, call_data);
  }
#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(input_fr, (char *)p, need_swap);
		    
  /* get data */
  FrameMgrGetToken(fm, input_method_id);
  FrameMgrGetToken(fm, input_context_id);
  FrameMgrGetToken(fm, byte_length);

  change_icvalues(fm, byte_length, call_data);

  /* free FrameMgr */
  FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */

  InputContext *ic = &(input_context_list.getItem(input_context_id));
  if (ic) {
    IIIMPInputContext *iiimp_ic = (IIIMPInputContext*)ic;
    // set some icattributes to this new ic
    for (ICAttribute *icp = changeic->ic_attr;
	 icp < &changeic->ic_attr[changeic->ic_attr_num]; icp++) {
      if (icp->name == iiim_protocol->ICLocaleName) {
	iiimp_ic->setLocaleName((char*)icp->value);
      } else if (icp->name == iiim_protocol->ICEngineName) {
	iiimp_ic->setEngineName((char*)icp->value);
      }
    }
    iiim_protocol->proto_handler->SetICValues((InputContext*)ic, 0, 0);
  } else {
    // need to treate as an error
  }

  free_icvalues(call_data);

#if !defined(USE_FRAMEMGR_ALWAYS)
  send_message(input_method_id, input_context_id, IM_OUTPUT_REPLY);
#else /* USE_FRAMEMGR_ALWAYS */
  send_message(input_method_id, input_context_id,
	       output_fr, IM_OUTPUT_REPLY);
#endif /* USE_FRAMEMGR_ALWAYS */
  return;
}

ICAttribute*
IIIMPClient::get_icattr(CARD16 *attrID_list, int number) {
  ICAttribute *attr_list;
  IMAttr *ic_attr = iiim_protocol->get_icattr();

  attr_list = new ICAttribute[number];
  if (attr_list = NULL)
    return NULL;
  memset(attr_list, 0, sizeof(ICAttribute) * number);

  ICAttribute *attrp;
  CARD16 *idp;
  for (attrp = attr_list, idp = attrID_list;
       attrp < &attr_list[number] && idp < &attrID_list[number];
       attrp++, idp++) {
    for (IMAttr *icp = ic_attr;
	 icp < &ic_attr[iiim_protocol->count_icattr()]; icp++) {
      if (icp->attribute_id == *idp) {
	attrp->attribute_id = icp->attribute_id;
	attrp->name_length = icp->length;
	attrp->name = icp->name;
	attrp->type = icp->type;
      }
    }
  }
  return attr_list;
}

void
IIIMPClient::get_icvalues(IMProtocolStruct *call_data, unsigned char *p) {
#if !defined(USE_FRAMEMGR_ALWAYS)
  char *ptr;
  char *data;
  int total_size;
  int attr_size;
  int i;
#else /* USE_FRAMEMGR_ALWAYS */
  FrameMgr fm;
  FmStatus status;
#endif /* USE_FRAMEMGR_ALWAYS */
  IMChangeICStruct *getic = (IMChangeICStruct*)&call_data->changeic;
  CARD16 input_method_id, input_context_id;
  CARD16 byte_length;
  CARD16 *attrID_list = NULL;
  int number;
  int iter_count;
  ICAttribute *ic_attr = NULL;

#if !defined(USE_FRAMEMGR_ALWAYS)
#else /* USE_FRAMEMGR_ALWAYS */
  extern XimFrameRec im_geticvalues_fr[], im_geticvalues_reply_fr[];
  XimFrameRec *input_fr = im_geticvalues_fr;
  XimFrameRec *output_fr = im_geticvalues_reply_fr;
#endif /* USE_FRAMEMGR_ALWAYS */
  const int IM_OUTPUT_REPLY = IM_GETICVALUES_REPLY;

#if !defined(USE_FRAMEMGR_ALWAYS)
  ptr = (char *)p;
  if (False == need_swap) {
    req_get16(ptr, input_method_id);
    req_get16(ptr, input_context_id);
    req_get16(ptr, byte_length);
    if (byte_length != 0) {
      attrID_list = (CARD16*)new char[byte_length];
      number = (byte_length / 2);
      for (i = 0; i < number; i++) {
	req_get16(ptr, *(attrID_list + i));
      }
      ic_attr = get_icattr(attrID_list, number);
      if (ic_attr == NULL) {
	delete [] attrID_list;
	return;
      }
    }
  } else {
    req_get16s(ptr, input_method_id);
    req_get16s(ptr, input_context_id);
    req_get16s(ptr, byte_length);
    if (byte_length != 0) {
      attrID_list = (CARD16*)new char[byte_length];
      number = (byte_length / 2);
      for (i = 0; i < number; i++) {
	req_get16s(ptr, *(attrID_list + i));
      }
      ic_attr = get_icattr(attrID_list, number);
      if (ic_attr == NULL) {
	delete [] attrID_list;
	return;
      }
    }
  }
#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(input_fr, (char *)p, need_swap);

  /* get data */
  FrameMgrGetToken(fm, input_method_id);
  FrameMgrGetToken(fm, input_context_id);
  FrameMgrGetToken(fm, byte_length);

  if (byte_length != 0) {
    attrID_list = (CARD16*)new char[byte_length];

    number = 0;
    while (FrameMgrIsIterLoopEnd(fm, &status) == False) {
      FrameMgrGetToken(fm, attrID_list[number]);
      number++;
    }
    /* free FrameMgr */
    FrameMgrFree(fm);

    ic_attr = get_icattr(attrID_list, number);
    if (ic_attr == NULL) {
      return;
    }
  }
#endif /* USE_FRAMEMGR_ALWAYS */
  getic->preedit_attr_num = 0; /* no preedit attributes */
  getic->status_attr_num = 0;	/* no status attributes */
  getic->ic_attr_num = (CARD16)number;
  getic->preedit_attr = NULL;
  getic->status_attr = NULL;
  getic->ic_attr = ic_attr;

  InputContext *ic = &(input_context_list.getItem(input_context_id));
  if (ic) {
    iiim_protocol->proto_handler->GetICValues((InputContext*)ic, 0, 0);
  } else {
    // need to treate as an error
  }

  iter_count = getic->ic_attr_num;

#if !defined(USE_FRAMEMGR_ALWAYS)
  total_size = 4;
  total_size += (2 + 2);
  total_size += 2;
  attr_size = 0;
  for (i = 0; i < iter_count; i++) {
    attr_size += icattr_size(ic_attr + i);
  }
  total_size += 2; /* padding */
  data = new char[total_size];
  ptr = (data + 4);
  if (False == need_swap) {
    req_put16(ptr, input_method_id);
    req_put16(ptr, input_context_id);
    ptr = req_put_icattr_list(ptr, ic_attr, number);
    req_put16(ptr, 0);
  } else {
    req_put16s(ptr, input_method_id);
    req_put16s(ptr, input_context_id);
    ptr = req_put_icattr_list_s(ptr, ic_attr, number);
    req_put16s(ptr, 0);
  }

  send_message(IM_OUTPUT_REPLY, data, total_size);

  delete [] data;
  delete [] ic_attr;
#else /* USE_FRAMEMGR_ALWAYS */
  /* create FrameMgr */
  fm = FrameMgrInit(output_fr, NULL, need_swap);
	
  /* set iteration count for list of ic_attribute */
  FrameMgrSetIterCount(fm, iter_count);

  /* set length of BARRAY item in xicattribute_fr*/
  ICAttribute *attrp;
  for (attrp = ic_attr;
       attrp < &ic_attr[getic->ic_attr_num]; attrp++) {
    FrameMgrSetSize(fm, attrp->value_length);
  }

  const int total_size = FrameMgrGetTotalSize(fm);
  CompoundString reply = CompoundString(total_size);
  memset(reply, 0, total_size);
  FrameMgrSetBuffer(fm, reply);

  FrameMgrPutToken(fm, input_method_id);
  FrameMgrPutToken(fm, input_context_id);

  for (attrp = ic_attr;
       attrp < &ic_attr[getic->ic_attr_num]; attrp++) {
    FrameMgrPutToken(fm, attrp->attribute_id);
    FrameMgrPutToken(fm, attrp->value_length);
    FrameMgrPutToken(fm, attrp->value);
  }

  send_message(IM_OUTPUT_REPLY, reply, total_size);

  delete [] ic_attr;

  /* free FrameMgr */
  FrameMgrFree(fm);
#endif /* USE_FRAMEMGR_ALWAYS */
  return;
}
