#include <config.h>
#include <stdio.h>
#include "IMConnection.hh"
#include "IMInputContext.hh"
#include "IMUser.hh"
#include "IMDesktop.hh"
#include "LEMgr.hh"

IMDesktop*
IMConnection::get_desktop()
{
    if (pdesktop) return pdesktop;

    IMDesktop::IMDesktopAttr a;
    a[IMDesktop::CLIENT_HOST] = u16string(get_hostname());
    pdesktop = puser->request_desktop(a);
    return pdesktop;
}

/******************************************************************************
                   IMHandler implementation.
******************************************************************************/

bool
IMConnection::
set_client_info(
    const IMHandler::ClientAttrList& attrlist
)
{
    IMDesktop::IMDesktopAttr a;
    IMHandler::ClientAttrList::const_iterator it;

    a[IMDesktop::CLIENT_HOST] = u16string(get_hostname());
    for (it = attrlist.begin(); it != attrlist.end(); it++) {
	switch (it->attr) {
	  case IMHandler::CLIENT_NAME:
	   a[IMDesktop::CLIENT_NAME] = it->val;
	   break;
	  case IMHandler::OS_NAME:
	   a[IMDesktop::OS_NAME] = it->val;
	   break;
	  case IMHandler::OS_ARCH:
	   a[IMDesktop::OS_ARCH] = it->val;
	   break;
	  case IMHandler::OS_VERSION:
	   a[IMDesktop::OS_VERSION] = it->val;
	   break;
	  case IMHandler::X_DISPLAY_NAME:
	   a[IMDesktop::X_DISPLAY_NAME] = it->val;
	   break;
	  case IMHandler::X_SERVER_VENDOR:
	   a[IMDesktop::X_SERVER_VENDOR] = it->val;
	   break;
	  case IMHandler::CLIENT_GROUP:
	   a[IMDesktop::CLIENT_GROUP] = it->val;
	   break;
	  default:
	   // simply ignore it.
	   break;
	}
    }
    pdesktop = puser->request_desktop(a);

    return true;
}

bool
IMConnection::get_triggerkeys(
    IMKeySpecList &onkeys,
    IMKeySpecList &offkeys
)
{
    IMKeySpec default_key(' ', ' ', 2, 0);

    const IMKeySpecList& ckeys = get_imsvr()->get_conversionkeys();
    if (ckeys.size() > 0) {
        for (IMKeySpecList::const_iterator it = ckeys.begin();
             it != ckeys.end();
             ++it) {
            onkeys.push_back(*it);
            /* get_imsvr()->get_conversionkeys() now handles
             * only onkeys, so set offkeys is not right thing to do here
             */
            // offkeys.push_back(*it);
        }
    } else {
	onkeys.push_back(default_key);
	offkeys.push_back(default_key);
    }

    return true;
}

const IMLangList*
IMConnection::get_langlist(
    iml_desktop_t *curr_desktop
)
{
    return get_lemgr()->get_all_langlist(curr_desktop);
}

const IMObjectWithDescList*
IMConnection::get_imobjectdesclist()
{
    return get_lemgr()->get_all_imobjectdesclist();
}

IMHotkeyProfileStruct*
IMConnection::get_hotkey_profiles(int *count_profiles)
{
  return get_lemgr()->get_hotkey_profiles(count_profiles);
}

const IMDescriptorList*
IMConnection::get_imdesclist(
    iml_desktop_t *curr_desktop
)
{
    return get_lemgr()->get_all_imdesclist(curr_desktop);
}

const bool
IMConnection::update_imdesclist(
    IMLEName *LEname,
    IMLocale *Locales,
    int nLocales
)
{
    return get_lemgr()->update_imdesclist(LEname, Locales, nLocales);
}

const IMObject*
IMConnection::get_imobject(
    int attribid
)
{
    return NULL;
}

ICHandler*
IMConnection::createic(
    ICAttribute &icattr
)
{
    IMInputContext *pic = new IMInputContext(this, icattr);

    // memory error.
    if (!pic) return NULL;

    return pic;
}

IMConnection::
IMConnection(
    IMSvr *x_pimsvr,
    IMUser *x_puser,
    const string &x_hostname
)
{
    pimsvr = x_pimsvr;
    pdesktop = NULL;
    puser = x_puser;
    hostname = x_hostname;
    pdesktop = NULL;
}

IMConnection::~IMConnection()
{
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
