#ifndef IIIMP_HOTKEY_HH_
#define IIIMP_HOTKEY_HH_
#include "IIIMP_ICState.hh"

#define EVENT_FORWARDING_ON 1
#define EVENT_FORWARDING_OFF 0

class LangIM
{
    int index;
    const char *lang_id;
    u16string imname;
    u16string hrn;
    const IMHotkeyProfileStruct *hotkey_profile;

  public:
    int get_index() const
    { return index; }
    const char* get_id() const
    { return lang_id; }
    const u16string& get_imname() const
    { return imname; } 
    const u16string& get_hrn() const
    { return hrn; } 
    const IMHotkeyProfileStruct* get_hotkey_profile () const
    { return hotkey_profile; } 

    LangIM(
	int x_index,
	const char *x_langid,
	u16string x_imname,
	u16string x_hrn,
	const IMHotkeyProfileStruct *hkps
	) : index(x_index), lang_id(x_langid), imname(x_imname), hrn(x_hrn),
	    hotkey_profile(hkps)
    {}
};
typedef list<LangIM> LangIMList;

class IIIMP_ICState;
class IIIMP_hotkey_state
{
    bool hotkey_mode;
    bool lang_selection;
    bool forward_event;
    int first_candidate;
    int last_candidate;
    int current;
    int curr_hotkeyid;
    unsigned int curr_langid;

  public:
    IIIMP_hotkey_state(
	IIIMP_ICState *hics
    );
    ~IIIMP_hotkey_state();
    bool process_hotkey(
        IIIMP_ICState *hics,
        int hotkey_id,
        int index
    );
    int check_for_hotkey( 
        IIIMP_ICState *hics,
        IIIMP_keyevent *kev
    );
    void set_hotkey_mode(bool flag) { hotkey_mode = flag; }
    bool get_hotkey_mode() const { return hotkey_mode; }
    void set_lang_selection(bool flag) { lang_selection = flag; }
    bool get_lang_selection() const { return lang_selection; }
    void set_forward_event(bool flag) { forward_event = flag; }
    bool get_forward_event() const { return forward_event; }
    void set_current_lang_id(int id) { curr_langid = id; }
    int  get_current_lang_id() const { return curr_langid; }
    bool
    send_hotkey_reply(IIIMP_ICState *hics);
    int
    UTFCHARLen(UTFCHAR *);
    int
    UTFCHARLen(const char *);
    int
    UTFCHARCpy(UTFCHAR *, const char *);
    int
    UTFCHARCpy(UTFCHAR *, UTFCHAR *);
    int
    UTFCHARCat(UTFCHAR *, UTFCHAR *, UTFCHAR *);
    int
    UTFCHARCat(UTFCHAR *, const char *, const char *, const char *, const char *);
    IMFeedbackList *
    create_feedback(int);
    void
    free_feedback(IMFeedbackList *, int);
    bool 
    forward_hotkey_to_LE(IIIMP_ICState *hics, int hotkey_id, int index);
    bool
    switch_language(IIIMP_ICState *hics, int index, int hotkey_id);
    bool
    start_lang_selection_window(IIIMP_ICState *hics);
    void print_LangIMList(IIIMP_ICState *hics);
    bool
    process_lang_selection_window(
	IIIMP_ICState *hics,
	IIIMP_message *pmes
    );
    bool
    draw_lang_selection_window(
	IIIMP_ICState *hics,
	int keycode
    );
    bool
    stop_lang_selection_window(IIIMP_ICState *hics);
    bool
    do_cycle_lang_selection(IIIMP_ICState *hics, int orientation);
};

#endif /* not IIIMP_HOTKEY_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
