/*
  iiimqccontext.h
  Copyright (C) 2003 Free Standards Group

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL OPENI18N WG OR FREE STANDARDS GROUP. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

  Except as contained in this notice, the names of OpenI18N WG and/or
  Free Standards Group shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from OpenI18N WG and/or Free Standards Group
  as applicable.

  Author: ILGYOUNG PARK <Karl.Park@Sun.COM>
	  TuBo	<Gavin.Tu@Sun.COM>

*/

#ifndef __IIIM_QC_CONTEXT_H__
#define __IIIM_QC_CONTEXT_H__

#include <qobject.h>
#include <qinputcontext.h>
#include <qvaluelist.h>
#include <iiimcf.h>
#include "keymapper.h"


class IIIMInputContextPrivate;
class IIIMQCFLookup;

class Q_EXPORT IIIMInputContext : public QInputContext
{
 public:
  IIIMInputContext ();
  virtual ~IIIMInputContext ();

  virtual QString identifierName ();
  virtual QString language ();
  virtual bool filterEvent (const QEvent *event);
  virtual void reset(); 
  virtual void setFocus ();
  virtual void unsetFocus ();
  virtual void setMicroFocus( int x, int y, int w, int h, QFont *f = 0 );
  virtual void mouseHandler( int x, QEvent::Type type,
			     Qt::ButtonState button, Qt::ButtonState state );

  virtual bool isPreeditRelocationEnabled(); 

  IIIMCF_handle get_iiimcf_handle();
  void im_context_aux_set_values (IIIMCF_context , IIIMCF_event);
  void im_context_change_conversion_mode(IIIMCF_context, char *); 
  QWidget*  get_focus_widget();
  
  struct  _aux *aux;
  IIIMCF_context cur_context; 
  int cursor_x;
  int cursor_y;
  int cursor_h;

 protected:
  virtual bool isPreeditPreservationEnabled();
  class IIIMInputContextID;
  typedef QValueList<IIIMInputContextID> IIIMICLIST;
  typedef IIIMICLIST::iterator IIIMICLISTITR;

 protected:
  IIIMCF_handle iiimqcf_init_iiim (void);

  bool forwardEvent (QWidget *, IIIMCF_event, IIIMF_status *);
  IIIMCF_keyevent *get_iiimcf_keyevent_from (QKeyEvent *kev);
  
  bool set_current_iiimcf_session_context (QWidget *widget);
  IIIMICLISTITR get_iiimcf_session_context (QWidget *widget, bool doCreate = TRUE);
  bool iiimqcf_event_dispatch (QWidget *);

  bool get_preedit_data (QWidget *w, QString &text, int *cursor);
  bool get_committed_text (QWidget *w, QString &text);
  
 
 private:

  /*to handle iiimcf related low level operations*/
  friend class IIIMInputContextPrivate;
  IIIMInputContextPrivate *d;
  
  IIIMICLISTITR search_iiimiclist_for (QWidget *widget);
  IIIMICLISTITR create_iiimcf_session_context (QWidget *widget);

  bool iiimcfIsInitialized;
  
  IIIMCF_handle _h;
  
  static int counter;

  IIIMICLISTITR _curic;
  IIIMICLIST _iclist;
  KeyMapper *keymapper;
  IIIMQCFLookup *iiimlookup;

};

class IIIMInputContext::IIIMInputContextID {
public:
  QWidget *_w;
  IIIMCF_context _c;    

  IIIMInputContextID (QWidget * w = 0, IIIMCF_context ic = 0)
    : _w (w), _c (ic) {}
  bool operator==(const IIIMInputContextID &obj) const {
    return (_w == obj._w) ? TRUE : FALSE;
  }
  bool operator!=(const IIIMInputContextID &obj) const {
    return (_w != obj._w) ? TRUE : FALSE;
  }
    
};


#endif // __IIIM_QC_CONTEXT_H__
