/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.io.IOException;

class IIIMPClientDescripter implements IIIMProtocol {

    /* LISTofIMATTRIBUTE
     *
     *  IMATTRIBUTE
     *  2 : ATTRIBID - CLIENTDESCRIPTOR(0x1011)
     *  2 : length of CLIENTDESCRIPTER
     *  n : LISTofSTRING (applicationName, osName, osArck, osVersion)  
     */
    
    static final String version = System.getProperty("java.version");
    static final String osName = System.getProperty("os.name");
    static final String osArch = System.getProperty("os.arch");
    static final String osVersion = System.getProperty("os.version");

    private String applicationName;

    ProtocolData cData;

    IIIMPClientDescripter() throws IOException {

	applicationName = "JDK" + version;

	// make CLIENTDESCRIPTER
	ProtocolData value = new ProtocolData();
	value.writeString(applicationName);
	value.writeString(osName);
	value.writeString(osArch);
	value.writeString(osVersion);

	cData = new ProtocolData();
	cData.write2(CLIENT_DESCRIPTER);
	cData.write2(0);
	cData.write4(value.count);
	cData.writeBytes(value.buf, value.count);
    }

    ProtocolData getData() {
	return cData;
    }
}
