/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.font.*;
import com.sun.iiim.*;

// If the style for Window is mixture window
// Then we will mix StatusWindow with LookupChoiceWindow
class CompositeWindow extends IIIMWindow implements IIIMLookupListener , 
IIIMStatusListener {
    private String style;

    int columHeight, columWidth;
    FontMetrics fm;    
    
    LookupPane lookupPane;
    StatusPane statusPane;
    
    int offset = 24;
    
    // Default, no-arg constructor
    public CompositeWindow() {
       // Add the LookupChoiceWindow and StatusWindow
       style = Manager.getProperty("iiimf.preedit.style");
       
       init();
    }
    
    void init() {
        window = new Dialog(new Frame(""));
        ((Dialog)window).setResizable(true);
        ((Dialog)window).setTitle("Input Window");
        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
	fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);
        
        lookupPane = new LookupPane();
        window.add(lookupPane);
        statusPane = new StatusPane();
        window.add(statusPane);
        
        window.pack();        
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
        
    public void setLocation(int x, int y) {
        window.setLocation(x,y);
    }
    
    public void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        Insets inset = window.getInsets();
        
        while(!(frame instanceof Frame)) frame = frame.getParent();
        
        if(style.equals("BELOWSPOT") 
            && component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.x + (int)rect.getHeight() + offset;
                // Leave space for Preedit window
                point.y += (inset.top + inset.bottom + fm.getHeight());
                window.setLocation(point);                 
        }
        else {
            // For "ROOTWINDOW" style and component isn't InputMethodRequests
            // Place the window on the left-corner of client component
            
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     

            double x = point.getX();
            // It must leave the position for PreeditWindow
            double y = point.getY() + size.getHeight() 
                + inset.top + inset.bottom + fm.getHeight();
            
            window.setLocation((int)x, (int)y);        
        }                
    }
    
    // Listener method
    public void lookupStart(IIIMLookupEvent e) {}
    public void lookupDone(IIIMLookupEvent e) {}
    public void lookupDraw(IIIMLookupEvent e) {}
    public void lookupProcess(IIIMLookupEvent e) {}

    public void dispatchEvent(IIIMLookupEvent e) {
        lookupPane.handleEvent(e);
        window.doLayout();
        window.show();
    }
    
    public void statusStart(IIIMStatusEvent e) {}
    public void statusDone(IIIMStatusEvent e) {}
    public void statusDraw(IIIMStatusEvent e) {}

    public void dispatchEvent(IIIMStatusEvent e) {
        statusPane.handleEvent(e);
        window.doLayout();
        window.show();
    }

}
