/* GIMLET: GNOME Input Method Language Enabing Tool
 *
 * Copyright (C) 2004 Red Hat, Inc.
 * Copyright (C) 2003 Sun Microsystems
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <string.h>

#include "status-placement.h"

#define PANEL_PLACEMENT "panel"       /* XIMStatusNothing */
#define APPL_PLACEMENT "application"  /* XIMStatusCallbacks */

IMStatusPlacement
gimlet_status_placement (char *str)
{
  if (str && (strcmp (str, PANEL_PLACEMENT) == 0))
    return ON_DESKTOP_PANEL;
  else if (str && (strcmp (str, APPL_PLACEMENT) == 0))
    return ATTACH_TO_APP_FRAME;
  else /* make "On Desktop Panel as default setting */
    return ON_DESKTOP_PANEL;
}

char *
gimlet_status_placement_name (IMStatusPlacement placement)
{
  switch (placement)
    {
    case ON_DESKTOP_PANEL:
      return PANEL_PLACEMENT;
      break;
    case ATTACH_TO_APP_FRAME:
      return APPL_PLACEMENT;
      break;
    }
  g_return_val_if_reached("placement name error");
}
